/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.test.DataTypeConditions;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DataTypeUtilsTest {
    DataTypeUtilsTest() {
    }

    @Test
    void testAppendRowFields() {
        TableAssertions.assertThat(DataTypeUtils.appendRowFields((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a2", (DataType)DataTypes.INT())}), Arrays.asList(DataTypes.FIELD((String)"a3", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"a4", (DataType)DataTypes.TIMESTAMP((int)3))))).isEqualTo(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a3", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"a4", (DataType)DataTypes.TIMESTAMP((int)3))}));
        TableAssertions.assertThat(DataTypeUtils.appendRowFields((DataType)DataTypes.ROW(), Arrays.asList(DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT())))).isEqualTo(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT())}));
    }

    @Test
    void testIsInternalClass() {
        TableAssertions.assertThat(DataTypes.INT()).is(DataTypeConditions.INTERNAL);
        TableAssertions.assertThat((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)).is(DataTypeConditions.INTERNAL);
        TableAssertions.assertThat((DataType)DataTypes.ROW().bridgedTo(RowData.class)).is(DataTypeConditions.INTERNAL);
        TableAssertions.assertThat(DataTypes.ROW()).isNot(DataTypeConditions.INTERNAL);
    }

    @Test
    void testFlattenToDataTypes() {
        Assertions.assertThat((List)DataTypeUtils.flattenToDataTypes((DataType)DataTypes.INT())).containsOnly((Object[])new DataType[]{DataTypes.INT()});
        Assertions.assertThat((List)DataTypeUtils.flattenToDataTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))).containsExactly((Object[])new DataType[]{DataTypes.INT(), DataTypes.BOOLEAN()});
    }

    @Test
    void testFlattenToNames() {
        Assertions.assertThat((List)DataTypeUtils.flattenToNames((DataType)DataTypes.INT(), Collections.emptyList())).containsOnly((Object[])new String[]{"f0"});
        Assertions.assertThat((List)DataTypeUtils.flattenToNames((DataType)DataTypes.INT(), Collections.singletonList("f0"))).containsOnly((Object[])new String[]{"f0_0"});
        Assertions.assertThat((List)DataTypeUtils.flattenToNames((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}), Collections.emptyList())).containsExactly((Object[])new String[]{"a", "b"});
    }

    @Test
    void testExpandRowType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        ResolvedSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assertions.assertThat((Object)schema).isEqualTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.INT()), Column.physical((String)"f1", (DataType)DataTypes.STRING()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), Column.physical((String)"f3", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)))}));
    }

    @Test
    void testExpandLegacyCompositeType() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)new TupleTypeInfo(new TypeInformation[]{Types.STRING, Types.INT, Types.SQL_TIMESTAMP}));
        ResolvedSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assertions.assertThat((Object)schema).isEqualTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.STRING()), Column.physical((String)"f1", (DataType)DataTypes.INT()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)))}));
    }

    @Test
    void testExpandStructuredType() {
        StructuredType logicalType = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", DataTypes.INT().getLogicalType()), new StructuredType.StructuredAttribute("f1", DataTypes.STRING().getLogicalType()), new StructuredType.StructuredAttribute("f2", DataTypes.TIMESTAMP((int)5).getLogicalType()), new StructuredType.StructuredAttribute("f3", DataTypes.TIMESTAMP((int)3).getLogicalType()))).build();
        List<DataType> dataTypes = Arrays.asList(DataTypes.INT(), DataTypes.STRING(), (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class), DataTypes.TIMESTAMP((int)3));
        FieldsDataType dataType = new FieldsDataType((LogicalType)logicalType, dataTypes);
        ResolvedSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assertions.assertThat((Object)schema).isEqualTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.INT()), Column.physical((String)"f1", (DataType)DataTypes.STRING()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), Column.physical((String)"f3", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)))}));
    }

    @Test
    void testExpandDistinctType() {
        FieldsDataType dataType = (FieldsDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        LogicalType originalLogicalType = dataType.getLogicalType();
        DistinctType distinctLogicalType = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type"), (LogicalType)originalLogicalType).build();
        FieldsDataType distinctDataType = new FieldsDataType((LogicalType)distinctLogicalType, dataType.getChildren());
        ResolvedSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)distinctDataType);
        Assertions.assertThat((Object)schema).isEqualTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0", (DataType)DataTypes.INT()), Column.physical((String)"f1", (DataType)DataTypes.STRING()), Column.physical((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), Column.physical((String)"f3", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)))}));
    }

    @Test
    void testExpandThrowExceptionOnAtomicType() {
        Assertions.assertThatThrownBy(() -> DataTypeUtils.expandCompositeTypeToSchema((DataType)DataTypes.TIMESTAMP())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDataTypeValidation() {
        DataType validDataType = DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING());
        DataTypeUtils.validateInputDataType((DataType)validDataType);
        DataTypeUtils.validateOutputDataType((DataType)validDataType);
        DataType inputOnlyDataType = (DataType)validDataType.bridgedTo(HashMap.class);
        DataTypeUtils.validateInputDataType((DataType)inputOnlyDataType);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DataTypeUtils.validateOutputDataType((DataType)inputOnlyDataType)).isInstanceOf(ValidationException.class)).hasMessage("Data type 'MAP<INT, STRING>' does not support an output conversion to class '" + HashMap.class.getName() + "'.");
    }
}

