/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableSchemaUtilsTest {
    TableSchemaUtilsTest() {
    }

    @Test
    void testBuilderWithGivenSchema() {
        TableSchema oriSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.builderWithGivenSchema((TableSchema)oriSchema).build();
        Assertions.assertThat((Object)newSchema).isEqualTo((Object)oriSchema);
    }

    @Test
    void testDropConstraint() {
        TableSchema originalSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).primaryKey("ct1", new String[]{"a"}).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        TableSchema newSchema = TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct1");
        TableSchema expectedSchema = TableSchema.builder().field("a", (DataType)DataTypes.INT().notNull()).field("b", DataTypes.STRING()).field("c", DataTypes.INT(), "a + 1").field("t", DataTypes.TIMESTAMP((int)3)).watermark("t", "t", DataTypes.TIMESTAMP((int)3)).build();
        Assertions.assertThat((Object)newSchema).isEqualTo((Object)expectedSchema);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableSchemaUtils.dropConstraint((TableSchema)originalSchema, (String)"ct2")).isInstanceOf(ValidationException.class)).hasMessage("Constraint ct2 to drop does not exist");
    }
}

