/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.shaded.guava30.com.google.common.base.Joiner;
import org.apache.flink.table.data.RowData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheLoader
extends AbstractRichFunction
implements Runnable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheLoader.class);
    protected volatile transient ConcurrentHashMap<RowData, Collection<RowData>> cache;
    private final ReentrantLock reloadLock = new ReentrantLock();
    private CountDownLatch firstLoadLatch;
    private transient Counter loadCounter;
    private transient Counter loadFailuresCounter;
    private volatile transient long latestLoadTimeMs = -1L;

    protected abstract void reloadCache() throws Exception;

    public void open(Configuration parameters) throws Exception {
        this.firstLoadLatch = new CountDownLatch(1);
    }

    public void open(CacheMetricGroup cacheMetricGroup) {
        if (this.loadCounter == null) {
            this.loadCounter = new ThreadSafeSimpleCounter();
        }
        if (this.loadFailuresCounter == null) {
            this.loadFailuresCounter = new ThreadSafeSimpleCounter();
        }
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        cacheMetricGroup.loadCounter(this.loadCounter);
        cacheMetricGroup.numLoadFailuresCounter(this.loadFailuresCounter);
        cacheMetricGroup.numCachedRecordsGauge(() -> this.cache.size());
        cacheMetricGroup.latestLoadTimeGauge(() -> this.latestLoadTimeMs);
    }

    public ConcurrentHashMap<RowData, Collection<RowData>> getCache() {
        return this.cache;
    }

    public void awaitFirstLoad() throws InterruptedException {
        this.firstLoadLatch.await();
    }

    @Override
    public void run() {
        this.reloadLock.lock();
        try {
            LOG.info("Lookup 'FULL' cache loading triggered.");
            long start = System.currentTimeMillis();
            this.reloadCache();
            this.latestLoadTimeMs = System.currentTimeMillis() - start;
            this.loadCounter.inc();
            LOG.info("Lookup 'FULL' cache loading finished. Time elapsed - {} ms. Number of records - {}.", (Object)this.latestLoadTimeMs, (Object)this.cache.size());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache content: \n{\n\t{}\n}", (Object)Joiner.on((String)",\n\t").withKeyValueSeparator(" = ").join(this.cache));
            }
        }
        catch (Exception e) {
            this.loadFailuresCounter.inc();
            throw new RuntimeException("Failed to reload lookup 'FULL' cache.", e);
        }
        finally {
            this.reloadLock.unlock();
            this.firstLoadLatch.countDown();
        }
    }

    public void close() throws Exception {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

