/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.dynamicfiltering;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.RecreateOnResetOperatorCoordinator;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.table.connector.source.DynamicFilteringData;
import org.apache.flink.table.connector.source.DynamicFilteringEvent;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFilteringDataCollectorOperatorCoordinator
implements OperatorCoordinator,
CoordinationRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicFilteringDataCollectorOperatorCoordinator.class);
    private final CoordinatorStore coordinatorStore;
    private final List<String> dynamicFilteringDataListenerIDs;
    private DynamicFilteringData receivedFilteringData;

    public DynamicFilteringDataCollectorOperatorCoordinator(OperatorCoordinator.Context context, List<String> dynamicFilteringDataListenerIDs) {
        this.coordinatorStore = (CoordinatorStore)Preconditions.checkNotNull((Object)context.getCoordinatorStore());
        this.dynamicFilteringDataListenerIDs = (List)Preconditions.checkNotNull(dynamicFilteringDataListenerIDs);
    }

    public void start() throws Exception {
    }

    public void close() throws Exception {
    }

    public void handleEventFromOperator(int subtask, int attemptNumber, OperatorEvent event) throws Exception {
        DynamicFilteringData currentData = ((DynamicFilteringEvent)((SourceEventWrapper)event).getSourceEvent()).getData();
        if (this.receivedFilteringData != null) {
            if (DynamicFilteringData.isEqual((DynamicFilteringData)this.receivedFilteringData, (DynamicFilteringData)currentData)) {
                return;
            }
            throw new IllegalStateException("DynamicFilteringData is recomputed but not equal. Triggering global failover in case the result is incorrect.  It's recommended to re-run the job with dynamic filtering disabled.");
        }
        this.receivedFilteringData = currentData;
        for (String listenerID : this.dynamicFilteringDataListenerIDs) {
            OperatorCoordinator listener = (OperatorCoordinator)this.coordinatorStore.get((Object)listenerID);
            if (listener == null) {
                throw new IllegalStateException("Dynamic filtering data listener is missing: " + listenerID);
            }
            LOG.info("Distributing event {} to source coordinator with ID {}", (Object)event, (Object)listenerID);
            listener.handleEventFromOperator(0, 0, event);
        }
    }

    public CompletableFuture<CoordinationResponse> handleCoordinationRequest(CoordinationRequest request) {
        throw new UnsupportedOperationException();
    }

    public void subtaskReset(int subtask, long checkpointId) {
    }

    public void executionAttemptFailed(int subtask, int attemptNumber, @Nullable Throwable reason) {
    }

    public void executionAttemptReady(int subtask, int attemptNumber, OperatorCoordinator.SubtaskGateway gateway) {
    }

    public void checkpointCoordinator(long checkpointId, CompletableFuture<byte[]> result) throws Exception {
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void resetToCheckpoint(long checkpointId, @Nullable byte[] checkpointData) throws Exception {
    }

    public static class Provider
    extends RecreateOnResetOperatorCoordinator.Provider {
        private final List<String> dynamicFilteringDataListenerIDs;

        public Provider(OperatorID operatorID, List<String> dynamicFilteringDataListenerIDs) {
            super(operatorID);
            this.dynamicFilteringDataListenerIDs = (List)Preconditions.checkNotNull(dynamicFilteringDataListenerIDs);
        }

        protected OperatorCoordinator getCoordinator(OperatorCoordinator.Context context) throws Exception {
            return new DynamicFilteringDataCollectorOperatorCoordinator(context, this.dynamicFilteringDataListenerIDs);
        }
    }
}

