/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testutils.PseudoRandomValueSelector;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.test.util.MiniClusterPipelineExecutorServiceLoader;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    private static final String STATE_CHANGE_LOG_CONFIG_ON = "on";
    private static final String STATE_CHANGE_LOG_CONFIG_UNSET = "unset";
    private static final String STATE_CHANGE_LOG_CONFIG_RAND = "random";
    private static final boolean RANDOMIZE_CHECKPOINTING_CONFIG = Boolean.parseBoolean(System.getProperty("checkpointing.randomization", "false"));
    private static final String STATE_CHANGE_LOG_CONFIG = System.getProperty("checkpointing.changelog", "unset").trim();

    public TestStreamEnvironment(MiniCluster miniCluster, Configuration config, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        super((PipelineExecutorServiceLoader)new MiniClusterPipelineExecutorServiceLoader(miniCluster), MiniClusterPipelineExecutorServiceLoader.updateConfigurationForMiniCluster(config, jarFiles, classPaths), null);
        this.setParallelism(parallelism);
    }

    public TestStreamEnvironment(MiniCluster miniCluster, int parallelism) {
        this(miniCluster, new Configuration(), parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classpaths) {
        StreamExecutionEnvironmentFactory factory = conf -> {
            TestStreamEnvironment env = new TestStreamEnvironment(miniCluster, conf, parallelism, jarFiles, classpaths);
            TestStreamEnvironment.randomizeConfiguration(miniCluster, conf);
            env.configure((ReadableConfig)conf, env.getUserClassloader());
            return env;
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    private static void randomizeConfiguration(MiniCluster miniCluster, Configuration conf) {
        if (RANDOMIZE_CHECKPOINTING_CONFIG) {
            PseudoRandomValueSelector.randomize((Configuration)conf, (ConfigOption)ExecutionCheckpointingOptions.ENABLE_UNALIGNED, (Object[])new Boolean[]{true, false});
            PseudoRandomValueSelector.randomize((Configuration)conf, (ConfigOption)ExecutionCheckpointingOptions.ALIGNED_CHECKPOINT_TIMEOUT, (Object[])new Duration[]{Duration.ofSeconds(0L), Duration.ofMillis(100L), Duration.ofSeconds(2L)});
        }
        if (TestStreamEnvironment.isConfigurationSupportedByChangelog(miniCluster.getConfiguration())) {
            boolean enabled;
            if (STATE_CHANGE_LOG_CONFIG.equalsIgnoreCase(STATE_CHANGE_LOG_CONFIG_ON)) {
                if (!conf.contains(StateChangelogOptions.ENABLE_STATE_CHANGE_LOG)) {
                    conf.set(StateChangelogOptions.ENABLE_STATE_CHANGE_LOG, (Object)true);
                    miniCluster.overrideRestoreModeForChangelogStateBackend();
                }
            } else if (STATE_CHANGE_LOG_CONFIG.equalsIgnoreCase(STATE_CHANGE_LOG_CONFIG_RAND) && (enabled = ((Boolean)PseudoRandomValueSelector.randomize((Configuration)conf, (ConfigOption)StateChangelogOptions.ENABLE_STATE_CHANGE_LOG, (Object[])new Boolean[]{true, false})).booleanValue())) {
                PseudoRandomValueSelector.randomize((Configuration)conf, (ConfigOption)StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL, (Object[])new Duration[]{Duration.ofMillis(100L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(5L), Duration.ofSeconds(-1L)});
                miniCluster.overrideRestoreModeForChangelogStateBackend();
            }
        }
    }

    private static boolean isConfigurationSupportedByChangelog(Configuration configuration) {
        return (Boolean)configuration.get(CheckpointingOptions.LOCAL_RECOVERY) == false;
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism) {
        TestStreamEnvironment.setAsContext(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

