/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.Options;

public final class InternalConstants {
    public static final boolean DELETE_CONSIDERED_IDEMPOTENT = true;
    public static final int DRAIN_BUFFER_SIZE = 16384;
    public static final int RENAME_PARALLEL_LIMIT = 10;
    public static final int MAX_ENTRIES_TO_DELETE = 1000;
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    @InterfaceStability.Unstable
    public static final Set<String> S3A_OPENFILE_KEYS;
    public static final int SC_403 = 403;
    public static final int SC_404 = 404;
    public static final String THROTTLE_LOG_NAME = "org.apache.hadoop.fs.s3a.throttled";
    public static final String SDK_V2_UPGRADE_LOG_NAME = "org.apache.hadoop.fs.s3a.SDKV2Upgrade";
    public static final String X_DIRECTORY = "application/x-directory";
    @VisibleForTesting
    public static final String UPLOAD_PART_COUNT_LIMIT = "fs.s3a.internal.upload.part.count.limit";
    public static final int DEFAULT_UPLOAD_PART_COUNT_LIMIT = 10000;
    public static final String AWS_REGION_SYSPROP = "aws.region";
    public static final int CSE_PADDING_LENGTH = 16;
    public static final String AP_REQUIRED_EXCEPTION = "Access Points usage is required but not configured for the bucket.";
    public static final String AP_INACCESSIBLE = "Could not access through this access point";
    public static final String ARN_BUCKET_OPTION = "fs.s3a.bucket.%s.accesspoint.arn";
    public static final Set<String> CREATE_FILE_KEYS;

    private InternalConstants() {
    }

    static {
        Set keys = Stream.of("fs.s3a.input.async.drain.threshold", "fs.s3a.experimental.input.fadvise", "fs.s3a.readahead.range").collect(Collectors.toSet());
        keys.addAll(Options.OpenFileOptions.FS_OPTION_OPENFILE_STANDARD_OPTIONS);
        S3A_OPENFILE_KEYS = Collections.unmodifiableSet(keys);
        CREATE_FILE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("fs.s3a.create.performance")));
    }
}

