/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.prefetch.S3ACachingInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3AInMemoryInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteInputStream;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3APrefetchingInputStream
extends FSInputStream
implements CanSetReadahead,
StreamCapabilities,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(S3APrefetchingInputStream.class);
    private S3ARemoteInputStream inputStream;

    public S3APrefetchingInputStream(S3AReadOpContext context, S3ObjectAttributes s3Attributes, S3AInputStream.InputStreamCallbacks client, S3AInputStreamStatistics streamStatistics) {
        Validate.checkNotNull((Object)context, (String)"context");
        Validate.checkNotNull((Object)s3Attributes, (String)"s3Attributes");
        Validate.checkNotNullAndNotEmpty((String)s3Attributes.getBucket(), (String)"s3Attributes.getBucket()");
        Validate.checkNotNullAndNotEmpty((String)s3Attributes.getKey(), (String)"s3Attributes.getKey()");
        Validate.checkNotNegative((long)s3Attributes.getLen(), (String)"s3Attributes.getLen()");
        Validate.checkNotNull((Object)client, (String)"client");
        Validate.checkNotNull((Object)streamStatistics, (String)"streamStatistics");
        long fileSize = s3Attributes.getLen();
        if (fileSize <= (long)context.getPrefetchBlockSize()) {
            LOG.debug("Creating in memory input stream for {}", (Object)context.getPath());
            this.inputStream = new S3AInMemoryInputStream(context, s3Attributes, client, streamStatistics);
        } else {
            LOG.debug("Creating in caching input stream for {}", (Object)context.getPath());
            this.inputStream = new S3ACachingInputStream(context, s3Attributes, client, streamStatistics);
        }
    }

    public synchronized int available() throws IOException {
        this.throwIfClosed();
        return this.inputStream.available();
    }

    public synchronized long getPos() throws IOException {
        return this.isClosed() ? 0L : this.inputStream.getPos();
    }

    public synchronized int read() throws IOException {
        this.throwIfClosed();
        return this.inputStream.read();
    }

    public synchronized int read(byte[] buffer, int offset, int len) throws IOException {
        this.throwIfClosed();
        return this.inputStream.read(buffer, offset, len);
    }

    public synchronized void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
            super.close();
        }
    }

    public synchronized void seek(long pos) throws IOException {
        this.throwIfClosed();
        this.inputStream.seek(pos);
    }

    public synchronized void setReadahead(Long readahead) {
        if (!this.isClosed()) {
            this.inputStream.setReadahead(readahead);
        }
    }

    public boolean hasCapability(String capability) {
        if (!this.isClosed()) {
            return this.inputStream.hasCapability(capability);
        }
        return false;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public S3AInputStreamStatistics getS3AStreamStatistics() {
        if (this.isClosed()) {
            return null;
        }
        return this.inputStream.getS3AStreamStatistics();
    }

    public IOStatistics getIOStatistics() {
        if (this.isClosed()) {
            return null;
        }
        return this.inputStream.getIOStatistics();
    }

    protected boolean isClosed() {
        return this.inputStream == null;
    }

    protected void throwIfClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream is closed!");
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.throwIfClosed();
        return false;
    }

    public boolean markSupported() {
        return false;
    }
}

