/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkBaseException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.s3a.AWSBadRequestException;
import org.apache.hadoop.fs.s3a.AWSClientIOException;
import org.apache.hadoop.fs.s3a.AWSNoResponseException;
import org.apache.hadoop.fs.s3a.AWSRedirectException;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.apache.hadoop.fs.s3a.AWSServiceIOException;
import org.apache.hadoop.fs.s3a.AWSServiceThrottledException;
import org.apache.hadoop.fs.s3a.AWSStatus500Exception;
import org.apache.hadoop.fs.s3a.NoVersionAttributeException;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.UnknownStoreException;
import org.apache.hadoop.fs.s3a.api.UnsupportedRequestException;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ARetryPolicy
implements RetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(S3ARetryPolicy.class);
    private final Configuration configuration;
    private final RetryPolicy retryPolicy;
    protected final RetryPolicy baseExponentialRetry;
    protected final RetryPolicy retryIdempotentCalls;
    protected final RetryPolicy throttlePolicy;
    protected final RetryPolicy fail = RetryPolicies.TRY_ONCE_THEN_FAIL;
    protected final RetryPolicy connectivityFailure;

    public S3ARetryPolicy(Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        this.configuration = conf;
        int limit = conf.getInt("fs.s3a.retry.limit", 7);
        long interval = conf.getTimeDuration("fs.s3a.retry.interval", "500ms", TimeUnit.MILLISECONDS);
        this.baseExponentialRetry = RetryPolicies.exponentialBackoffRetry((int)limit, (long)interval, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.debug("Retrying on recoverable AWS failures {} times with an initial interval of {}ms", (Object)limit, (Object)interval);
        this.retryIdempotentCalls = new FailNonIOEs(new IdempotencyRetryFilter(this.baseExponentialRetry));
        this.throttlePolicy = this.createThrottleRetryPolicy(conf);
        this.connectivityFailure = this.baseExponentialRetry;
        Map<Class<? extends Exception>, RetryPolicy> policyMap = this.createExceptionMap();
        this.retryPolicy = RetryPolicies.retryByException((RetryPolicy)this.retryIdempotentCalls, policyMap);
    }

    protected RetryPolicy createThrottleRetryPolicy(Configuration conf) {
        return RetryPolicies.exponentialBackoffRetry((int)conf.getInt("fs.s3a.retry.throttle.limit", 20), (long)conf.getTimeDuration("fs.s3a.retry.throttle.interval", "500ms", TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected Map<Class<? extends Exception>, RetryPolicy> createExceptionMap() {
        HashMap<Class<? extends Exception>, RetryPolicy> policyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        policyMap.put(UnknownHostException.class, this.fail);
        policyMap.put(NoRouteToHostException.class, this.fail);
        policyMap.put(InterruptedException.class, this.fail);
        policyMap.put(InterruptedIOException.class, this.fail);
        policyMap.put(AccessDeniedException.class, this.fail);
        policyMap.put(NoAuthWithAWSException.class, this.fail);
        policyMap.put(FileNotFoundException.class, this.fail);
        policyMap.put(UnknownStoreException.class, this.fail);
        policyMap.put(InvalidRequestException.class, this.fail);
        policyMap.put(RemoteFileChangedException.class, this.fail);
        policyMap.put(NoVersionAttributeException.class, this.fail);
        policyMap.put(AWSRedirectException.class, this.fail);
        policyMap.put(AWSServiceThrottledException.class, this.throttlePolicy);
        policyMap.put(ConnectTimeoutException.class, this.connectivityFailure);
        policyMap.put(EOFException.class, this.retryIdempotentCalls);
        policyMap.put(AWSBadRequestException.class, this.fail);
        policyMap.put(AWSStatus500Exception.class, this.connectivityFailure);
        policyMap.put(AWSNoResponseException.class, this.retryIdempotentCalls);
        policyMap.put(AWSClientIOException.class, this.retryIdempotentCalls);
        policyMap.put(AWSServiceIOException.class, this.retryIdempotentCalls);
        policyMap.put(AWSS3IOException.class, this.retryIdempotentCalls);
        policyMap.put(SocketTimeoutException.class, this.retryIdempotentCalls);
        policyMap.put(UnsupportedRequestException.class, this.fail);
        return policyMap;
    }

    public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean idempotent) throws Exception {
        Preconditions.checkArgument((exception != null ? 1 : 0) != 0, (Object)"Null exception");
        Exception ex = exception;
        if (exception instanceof AmazonClientException) {
            ex = S3AUtils.translateException("", "", (SdkBaseException)((AmazonClientException)exception));
        }
        return this.retryPolicy.shouldRetry(ex, retries, failovers, idempotent);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    private static final class FailNonIOEs
    implements RetryPolicy {
        private final RetryPolicy next;

        private FailNonIOEs(RetryPolicy next) {
            this.next = next;
        }

        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
            return e instanceof IOException ? this.next.shouldRetry(e, retries, failovers, true) : RetryPolicy.RetryAction.FAIL;
        }
    }

    private static final class IdempotencyRetryFilter
    implements RetryPolicy {
        private final RetryPolicy next;

        IdempotencyRetryFilter(RetryPolicy next) {
            this.next = next;
        }

        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean idempotent) throws Exception {
            return idempotent ? this.next.shouldRetry(e, retries, failovers, true) : RetryPolicy.RetryAction.FAIL;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IdempotencyRetryFilter{");
            sb.append("next=").append(this.next);
            sb.append('}');
            return sb.toString();
        }
    }
}

