/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.InconsistentAmazonS3Client;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureInjectionPolicy {
    public static final String DEFAULT_DELAY_KEY_SUBSTRING = "DELAY_LISTING_ME";
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private float throttleProbability;
    private int failureLimit = 0;

    public FailureInjectionPolicy(Configuration conf) {
        this.setThrottleProbability(conf.getFloat("fs.s3a.failinject.throttle.probability", 0.0f));
    }

    public float getThrottleProbability() {
        return this.throttleProbability;
    }

    public int getFailureLimit() {
        return this.failureLimit;
    }

    public void setFailureLimit(int failureLimit) {
        this.failureLimit = failureLimit;
    }

    public void setThrottleProbability(float throttleProbability) {
        this.throttleProbability = FailureInjectionPolicy.validProbability(throttleProbability);
    }

    public static boolean trueWithProbability(float p) {
        return Math.random() < (double)p;
    }

    public String toString() {
        return String.format("FailureInjectionPolicy: throttle probability %s; failure limit %d", Float.valueOf(this.throttleProbability), this.failureLimit);
    }

    private static float validProbability(float p) {
        Preconditions.checkArgument((p >= 0.0f && p <= 1.0f ? 1 : 0) != 0, (String)"Probability out of range 0 to 1 %s", (Object[])new Object[]{Float.valueOf(p)});
        return p;
    }
}

