/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.FailureInjectionPolicy;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InconsistentAmazonS3Client
extends AmazonS3Client {
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private FailureInjectionPolicy policy;
    private final AtomicLong failureCounter = new AtomicLong(0L);

    public InconsistentAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration, Configuration conf) {
        super(credentials, clientConfiguration);
        this.policy = new FailureInjectionPolicy(conf);
    }

    public static void setFailureInjectionPolicy(S3AFileSystem fs, FailureInjectionPolicy policy) throws Exception {
        AmazonS3 s3 = fs.getAmazonS3ClientForTesting("s3guard");
        InconsistentAmazonS3Client ic = InconsistentAmazonS3Client.castFrom(s3);
        ic.replacePolicy(policy);
    }

    private void replacePolicy(FailureInjectionPolicy pol) {
        this.policy = pol;
    }

    public String toString() {
        return String.format("Inconsistent S3 Client: %s; failure count %d", this.policy, this.failureCounter.get());
    }

    public static InconsistentAmazonS3Client castFrom(AmazonS3 c) throws Exception {
        InconsistentAmazonS3Client ic = null;
        if (c instanceof InconsistentAmazonS3Client) {
            ic = (InconsistentAmazonS3Client)c;
        }
        Preconditions.checkNotNull((Object)((Object)ic), (Object)"Not an instance of InconsistentAmazonS3Client");
        return ic;
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        return super.deleteObjects(deleteObjectsRequest);
    }

    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        String key = deleteObjectRequest.getKey();
        LOG.debug("key {}", (Object)key);
        this.maybeFail();
        super.deleteObject(deleteObjectRequest);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("key {}", (Object)putObjectRequest.getKey());
        this.maybeFail();
        return super.putObject(putObjectRequest);
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        return super.listObjects(listObjectsRequest);
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        return super.listObjectsV2(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.completeMultipartUpload(completeMultipartUploadRequest);
    }

    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.uploadPart(uploadPartRequest);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.listMultipartUploads(listMultipartUploadsRequest);
    }

    public void setThrottleProbability(float throttleProbability) {
        this.policy.setThrottleProbability(throttleProbability);
    }

    private void maybeFail(String errorMsg, int statusCode) throws AmazonClientException {
        AmazonServiceException ex = null;
        if (FailureInjectionPolicy.trueWithProbability(this.policy.getThrottleProbability())) {
            ex = new AmazonServiceException(errorMsg + " count = " + (this.failureCounter.get() + 1L), null);
            ex.setStatusCode(statusCode);
        }
        int failureLimit = this.policy.getFailureLimit();
        if (ex != null) {
            long count = this.failureCounter.incrementAndGet();
            if (failureLimit == 0 || failureLimit > 0 && count < (long)failureLimit) {
                throw ex;
            }
        }
    }

    private void maybeFail() {
        this.maybeFail("throttled", 503);
    }

    public void setFailureLimit(int limit) {
        this.policy.setFailureLimit(limit);
        this.failureCounter.set(0L);
    }

    public S3Object getObject(GetObjectRequest var1) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.getObject(var1);
    }

    public S3Object getObject(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.getObject(bucketName, key);
    }

    private static class CustomListObjectsV2Result
    extends ListObjectsV2Result {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomListObjectsV2Result(ListObjectsV2Result raw, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(raw.getBucketName());
            this.setCommonPrefixes(raw.getCommonPrefixes());
            this.setDelimiter(raw.getDelimiter());
            this.setEncodingType(raw.getEncodingType());
            this.setStartAfter(raw.getStartAfter());
            this.setMaxKeys(raw.getMaxKeys());
            this.setContinuationToken(raw.getContinuationToken());
            this.setPrefix(raw.getPrefix());
            this.setTruncated(raw.isTruncated());
        }

        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class CustomObjectListing
    extends ObjectListing {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomObjectListing(ObjectListing rawListing, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(rawListing.getBucketName());
            this.setCommonPrefixes(rawListing.getCommonPrefixes());
            this.setDelimiter(rawListing.getDelimiter());
            this.setEncodingType(rawListing.getEncodingType());
            this.setMarker(rawListing.getMarker());
            this.setMaxKeys(rawListing.getMaxKeys());
            this.setNextMarker(rawListing.getNextMarker());
            this.setPrefix(rawListing.getPrefix());
            this.setTruncated(rawListing.isTruncated());
        }

        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }
}

