/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.OperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOperation
extends ExecutingStoreOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteOperation.class);
    private final S3AFileStatus status;
    private final boolean recursive;
    private final OperationCallbacks callbacks;
    private final int pageSize;
    private final ListeningExecutorService executor;
    private List<DeleteEntry> keys;
    private CompletableFuture<Void> deleteFuture;
    private long filesDeleted;

    public DeleteOperation(StoreContext context, S3AFileStatus status, boolean recursive, OperationCallbacks callbacks, int pageSize) {
        super(context);
        this.status = status;
        this.recursive = recursive;
        this.callbacks = callbacks;
        Preconditions.checkArgument((pageSize > 0 && pageSize <= 1000 ? 1 : 0) != 0, (String)"page size out of range: %s", (Object[])new Object[]{pageSize});
        this.pageSize = pageSize;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)context.createThrottledExecutor(1));
    }

    public long getFilesDeleted() {
        return this.filesDeleted;
    }

    @Override
    public Boolean execute() throws IOException {
        this.executeOnlyOnce();
        StoreContext context = this.getStoreContext();
        Path path = this.status.getPath();
        LOG.debug("Delete path {} - recursive {}", (Object)path, (Object)this.recursive);
        LOG.debug("Type = {}", (Object)(this.status.isFile() ? "File" : (this.status.isEmptyDirectory() == Tristate.TRUE ? "Empty Directory" : "Directory")));
        String key = context.pathToKey(path);
        if (this.status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)path);
            Preconditions.checkArgument((this.status.isEmptyDirectory() != Tristate.UNKNOWN ? 1 : 0) != 0, (Object)"File status must have directory emptiness computed");
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if ("/".equals(key)) {
                LOG.error("S3A: Cannot delete the root directory. Path: {}. Recursive: {}", (Object)this.status.getPath(), (Object)this.recursive);
                return false;
            }
            if (!this.recursive && this.status.isEmptyDirectory() == Tristate.FALSE) {
                throw new PathIsNotEmptyDirectoryException(path.toString());
            }
            if (this.status.isEmptyDirectory() == Tristate.TRUE) {
                LOG.debug("deleting empty directory {}", (Object)path);
                this.deleteObjectAtPath(path, key, false);
            } else {
                this.deleteDirectoryTree(path, key);
            }
        } else {
            LOG.debug("deleting simple file {}", (Object)path);
            this.deleteObjectAtPath(path, key, true);
        }
        LOG.debug("Deleted {} objects", (Object)this.filesDeleted);
        return true;
    }

    protected void deleteDirectoryTree(Path path, String dirKey) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "deleting %s", new Object[]{dirKey});){
            this.resetDeleteList();
            this.deleteFuture = null;
            LOG.debug("Getting objects for directory prefix {} to delete", (Object)dirKey);
            RemoteIterator<S3ALocatedFileStatus> locatedFiles = this.callbacks.listFilesAndDirectoryMarkers(path, this.status, true);
            while (locatedFiles.hasNext()) {
                S3AFileStatus child = ((S3ALocatedFileStatus)((Object)locatedFiles.next())).toS3AFileStatus();
                this.queueForDeletion(child);
            }
            LOG.debug("Deleting final batch of listed files");
            this.submitNextBatch();
            CallableSupplier.maybeAwaitCompletion(this.deleteFuture);
        }
        LOG.debug("Delete \"{}\" completed; deleted {} objects", (Object)path, (Object)this.filesDeleted);
    }

    private String deletionKey(S3AFileStatus stat) {
        return this.getStoreContext().fullKey(stat);
    }

    private void queueForDeletion(S3AFileStatus stat) throws IOException {
        this.queueForDeletion(this.deletionKey(stat), stat.isDirectory());
    }

    private void queueForDeletion(String key, boolean isDirMarker) throws IOException {
        LOG.debug("Adding object to delete: \"{}\"", (Object)key);
        this.keys.add(new DeleteEntry(key, isDirMarker));
        if (this.keys.size() == this.pageSize) {
            this.submitNextBatch();
        }
    }

    private void submitNextBatch() throws IOException {
        CallableSupplier.maybeAwaitCompletion(this.deleteFuture);
        this.deleteFuture = this.submitDelete(this.keys);
        this.resetDeleteList();
    }

    private void resetDeleteList() {
        this.keys = new ArrayList<DeleteEntry>(this.pageSize);
    }

    private void deleteObjectAtPath(Path path, String key, boolean isFile) throws IOException {
        LOG.debug("delete: {} {}", (Object)(isFile ? "file" : "dir marker"), (Object)key);
        ++this.filesDeleted;
        this.callbacks.deleteObjectAtPath(path, key, isFile);
    }

    private CompletableFuture<Void> submitDelete(List<DeleteEntry> keyList) {
        if (keyList.isEmpty()) {
            return null;
        }
        this.filesDeleted += (long)keyList.size();
        return CallableSupplier.submit((Executor)this.executor, AuditingFunctions.callableWithinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            this.asyncDeleteAction(keyList);
            return null;
        }));
    }

    private void asyncDeleteAction(List<DeleteEntry> keyList) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Delete page of %d keys", new Object[]{keyList.size()});){
            if (!keyList.isEmpty()) {
                List files = keyList.stream().filter(e -> !((DeleteEntry)e).isDirMarker).map(e -> ((DeleteEntry)e).keyVersion).collect(Collectors.toList());
                LOG.debug("Deleting of {} file objects", (Object)files.size());
                Invoker.once("Remove S3 Files", this.status.getPath().toString(), () -> this.callbacks.removeKeys(files, false));
                List dirs = keyList.stream().filter(e -> ((DeleteEntry)e).isDirMarker).map(e -> ((DeleteEntry)e).keyVersion).collect(Collectors.toList());
                LOG.debug("Deleting of {} directory markers", (Object)dirs.size());
                Invoker.once("Remove S3 Dir Markers", this.status.getPath().toString(), () -> this.callbacks.removeKeys(dirs, true));
            }
        }
    }

    private static final class DeleteEntry {
        private final DeleteObjectsRequest.KeyVersion keyVersion;
        private final boolean isDirMarker;

        private DeleteEntry(String key, boolean isDirMarker) {
            this.keyVersion = new DeleteObjectsRequest.KeyVersion(key);
            this.isDirMarker = isDirMarker;
        }

        public String getKey() {
            return this.keyVersion.getKey();
        }

        public String toString() {
            return "DeleteEntry{key='" + this.getKey() + '\'' + ", isDirMarker=" + this.isDirMarker + '}';
        }
    }
}

