/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Sets;
import org.slf4j.Logger;

@InterfaceAudience.Private
class BlockPoolManager {
    private static final Logger LOG = DataNode.LOG;
    private final Map<String, BPOfferService> bpByNameserviceId = Maps.newHashMap();
    private final Map<String, BPOfferService> bpByBlockPoolId = Maps.newHashMap();
    private final List<BPOfferService> offerServices = new CopyOnWriteArrayList<BPOfferService>();
    private final DataNode dn;
    private final Object refreshNamenodesLock = new Object();

    BlockPoolManager(DataNode dn) {
        this.dn = dn;
    }

    synchronized void addBlockPool(BPOfferService bpos) {
        Preconditions.checkArgument((boolean)this.offerServices.contains(bpos), (String)"Unknown BPOS: %s", (Object[])new Object[]{bpos});
        if (bpos.getBlockPoolId() == null) {
            throw new IllegalArgumentException("Null blockpool id");
        }
        this.bpByBlockPoolId.put(bpos.getBlockPoolId(), bpos);
    }

    synchronized List<BPOfferService> getAllNamenodeThreads() {
        return Collections.unmodifiableList(this.offerServices);
    }

    synchronized BPOfferService get(String bpid) {
        return this.bpByBlockPoolId.get(bpid);
    }

    synchronized void remove(BPOfferService t) {
        this.offerServices.remove(t);
        if (t.hasBlockPoolId()) {
            this.bpByBlockPoolId.remove(t.getBlockPoolId());
        }
        boolean removed = false;
        Iterator<BPOfferService> it = this.bpByNameserviceId.values().iterator();
        while (it.hasNext() && !removed) {
            BPOfferService bpos = it.next();
            if (bpos != t) continue;
            it.remove();
            LOG.info("Removed " + bpos);
            removed = true;
        }
        if (!removed) {
            LOG.warn("Couldn't remove BPOS " + t + " from bpByNameserviceId map");
        }
    }

    void shutDownAll(List<BPOfferService> bposList) throws InterruptedException {
        for (BPOfferService bpos : bposList) {
            bpos.stop();
        }
        for (BPOfferService bpos : bposList) {
            bpos.join();
        }
    }

    synchronized void startAll() throws IOException {
        try {
            UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    for (BPOfferService bpos : BlockPoolManager.this.offerServices) {
                        bpos.start();
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex.getCause());
            throw ioe;
        }
    }

    void joinAll() {
        for (BPOfferService bpos : this.getAllNamenodeThreads()) {
            bpos.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNamenodes(Configuration conf) throws IOException {
        LOG.info("Refresh request received for nameservices: " + conf.get("dfs.nameservices"));
        Map<String, Map<String, InetSocketAddress>> newAddressMap = null;
        Map<String, Map<String, InetSocketAddress>> newLifelineAddressMap = null;
        try {
            newAddressMap = DFSUtil.getNNServiceRpcAddressesForCluster(conf);
            newLifelineAddressMap = DFSUtil.getNNLifelineRpcAddressesForCluster(conf);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to get NameNode addresses.", (Throwable)ioe);
        }
        if (newAddressMap == null || newAddressMap.isEmpty()) {
            throw new IOException("No services to connect, missing NameNode address.");
        }
        Object object = this.refreshNamenodesLock;
        synchronized (object) {
            this.doRefreshNamenodes(newAddressMap, newLifelineAddressMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshNamenodes(Map<String, Map<String, InetSocketAddress>> addrMap, Map<String, Map<String, InetSocketAddress>> lifelineAddrMap) throws IOException {
        BPOfferService bpos;
        ArrayList addrs;
        Map<String, InetSocketAddress> nnIdToLifelineAddr;
        Map<String, InetSocketAddress> nnIdToAddr;
        Set toRemove;
        assert (Thread.holdsLock(this.refreshNamenodesLock));
        LinkedHashSet<String> toRefresh = new LinkedHashSet<String>();
        LinkedHashSet<String> toAdd = new LinkedHashSet<String>();
        Iterator iterator = this;
        synchronized (iterator) {
            for (String nameserviceId : addrMap.keySet()) {
                if (this.bpByNameserviceId.containsKey(nameserviceId)) {
                    toRefresh.add(nameserviceId);
                    continue;
                }
                toAdd.add(nameserviceId);
            }
            toRemove = Sets.difference(this.bpByNameserviceId.keySet(), addrMap.keySet());
            assert (toRefresh.size() + toAdd.size() == addrMap.size()) : "toAdd: " + Joiner.on((String)",").useForNull("<default>").join(toAdd) + "  toRemove: " + Joiner.on((String)",").useForNull("<default>").join((Iterable)toRemove) + "  toRefresh: " + Joiner.on((String)",").useForNull("<default>").join(toRefresh);
            if (!toAdd.isEmpty()) {
                LOG.info("Starting BPOfferServices for nameservices: " + Joiner.on((String)",").useForNull("<default>").join(toAdd));
                for (String nsToAdd : toAdd) {
                    nnIdToAddr = addrMap.get(nsToAdd);
                    nnIdToLifelineAddr = lifelineAddrMap.get(nsToAdd);
                    addrs = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                    ArrayList nnIds = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                    ArrayList lifelineAddrs = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                    for (String nnId : nnIdToAddr.keySet()) {
                        addrs.add(nnIdToAddr.get(nnId));
                        nnIds.add(nnId);
                        lifelineAddrs.add(nnIdToLifelineAddr != null ? nnIdToLifelineAddr.get(nnId) : null);
                    }
                    BPOfferService bpos2 = this.createBPOS(nsToAdd, nnIds, addrs, lifelineAddrs);
                    this.bpByNameserviceId.put(nsToAdd, bpos2);
                    this.offerServices.add(bpos2);
                }
            }
            this.startAll();
        }
        if (!toRemove.isEmpty()) {
            LOG.info("Stopping BPOfferServices for nameservices: " + Joiner.on((String)",").useForNull("<default>").join((Iterable)toRemove));
            for (String nsToRemove : toRemove) {
                bpos = this.bpByNameserviceId.get(nsToRemove);
                bpos.stop();
                bpos.join();
            }
        }
        if (!toRefresh.isEmpty()) {
            LOG.info("Refreshing list of NNs for nameservices: " + Joiner.on((String)",").useForNull("<default>").join(toRefresh));
            for (final String nsToRefresh : toRefresh) {
                bpos = this.bpByNameserviceId.get(nsToRefresh);
                nnIdToAddr = addrMap.get(nsToRefresh);
                nnIdToLifelineAddr = lifelineAddrMap.get(nsToRefresh);
                addrs = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                final ArrayList lifelineAddrs = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                final ArrayList nnIds = Lists.newArrayListWithCapacity((int)nnIdToAddr.size());
                for (String nnId : nnIdToAddr.keySet()) {
                    addrs.add(nnIdToAddr.get(nnId));
                    lifelineAddrs.add(nnIdToLifelineAddr != null ? nnIdToLifelineAddr.get(nnId) : null);
                    nnIds.add(nnId);
                }
                try {
                    UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            bpos.refreshNNList(nsToRefresh, nnIds, addrs, lifelineAddrs);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ex) {
                    IOException ioe = new IOException();
                    ioe.initCause(ex.getCause());
                    throw ioe;
                }
            }
        }
    }

    protected BPOfferService createBPOS(String nameserviceId, List<String> nnIds, List<InetSocketAddress> nnAddrs, List<InetSocketAddress> lifelineNnAddrs) {
        return new BPOfferService(nameserviceId, nnIds, nnAddrs, lifelineNnAddrs, this.dn);
    }

    @VisibleForTesting
    Map<String, BPOfferService> getBpByNameserviceId() {
        return this.bpByNameserviceId;
    }

    boolean isSlownodeByNameserviceId(String nsId) {
        if (this.bpByNameserviceId.containsKey(nsId)) {
            return this.bpByNameserviceId.get(nsId).isSlownode();
        }
        return false;
    }

    boolean isSlownodeByBlockPoolId(String bpId) {
        if (this.bpByBlockPoolId.containsKey(bpId)) {
            return this.bpByBlockPoolId.get(bpId).isSlownode();
        }
        return false;
    }

    boolean isSlownode() {
        for (BPOfferService bpOfferService : this.bpByBlockPoolId.values()) {
            if (!bpOfferService.isSlownode()) continue;
            return true;
        }
        return false;
    }
}

