/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.Matcher;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.mover.MoverMetrics;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.hadoop.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.shaded.org.apache.commons.cli.OptionGroup;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Mover {
    static final Logger LOG = LoggerFactory.getLogger(Mover.class);
    private final Dispatcher dispatcher;
    private final StorageMap storages;
    private final List<Path> targetPaths;
    private final int retryMaxAttempts;
    private final AtomicInteger retryCount;
    private final Map<Long, Set<DatanodeInfo>> excludedPinnedBlocks;
    private final MoverMetrics metrics;
    private final NameNodeConnector nnc;
    private final BlockStoragePolicy[] blockStoragePolicies;

    Mover(NameNodeConnector nnc, Configuration conf, AtomicInteger retryCount, Map<Long, Set<DatanodeInfo>> excludedPinnedBlocks) {
        long movedWinWidth = conf.getLong("dfs.mover.movedWinWidth", 5400000L);
        int moverThreads = conf.getInt("dfs.mover.moverThreads", 1000);
        int maxConcurrentMovesPerNode = conf.getInt("dfs.datanode.balance.max.concurrent.moves", 100);
        int maxNoMoveInterval = conf.getInt("dfs.mover.max-no-move-interval", 60000);
        int maxAttempts = conf.getInt("dfs.mover.retry.max.attempts", 10);
        if (maxAttempts >= 0) {
            this.retryMaxAttempts = maxAttempts;
        } else {
            LOG.warn("dfs.mover.retry.max.attempts is configured with a negative value, using default value of 10");
            this.retryMaxAttempts = 10;
        }
        this.retryCount = retryCount;
        this.dispatcher = new Dispatcher(nnc, Collections.emptySet(), Collections.emptySet(), movedWinWidth, moverThreads, 0, maxConcurrentMovesPerNode, maxNoMoveInterval, conf);
        this.storages = new StorageMap();
        this.targetPaths = nnc.getTargetPaths();
        this.blockStoragePolicies = new BlockStoragePolicy[16];
        this.excludedPinnedBlocks = excludedPinnedBlocks;
        this.nnc = nnc;
        this.metrics = MoverMetrics.create(this);
    }

    void init() throws IOException {
        this.initStoragePolicies();
        List<DatanodeStorageReport> reports = this.dispatcher.init();
        for (DatanodeStorageReport r : reports) {
            Dispatcher.DDatanode dn = this.dispatcher.newDatanode(r.getDatanodeInfo());
            for (StorageType t : StorageType.getMovableTypes()) {
                Dispatcher.Source source = dn.addSource(t, Long.MAX_VALUE, this.dispatcher);
                long maxRemaining = Mover.getMaxRemaining(r, t);
                Dispatcher.DDatanode.StorageGroup target = maxRemaining > 0L ? dn.addTarget(t, maxRemaining) : null;
                this.storages.add(source, target);
            }
        }
    }

    private void initStoragePolicies() throws IOException {
        Collection policies = this.dispatcher.getDistributedFileSystem().getAllStoragePolicies();
        Iterator iterator = policies.iterator();
        while (iterator.hasNext()) {
            BlockStoragePolicy policy;
            this.blockStoragePolicies[policy.getId()] = policy = (BlockStoragePolicy)iterator.next();
        }
    }

    private ExitStatus run() {
        try {
            this.init();
            ExitStatus exitStatus = new Processor().processNamespace().getExitStatus();
            return exitStatus;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + ".  Exiting ...");
            ExitStatus exitStatus = ExitStatus.ILLEGAL_ARGUMENTS;
            return exitStatus;
        }
        catch (IOException e) {
            System.out.println(e + ".  Exiting ...");
            LOG.error(e + ".  Exiting ...");
            ExitStatus exitStatus = ExitStatus.IO_EXCEPTION;
            return exitStatus;
        }
        finally {
            this.dispatcher.shutdownNow();
        }
    }

    public NameNodeConnector getNnc() {
        return this.nnc;
    }

    Dispatcher.DBlock newDBlock(LocatedBlock lb, List<MLocation> locations, ErasureCodingPolicy ecPolicy) {
        Dispatcher.DBlock db;
        Block blk = lb.getBlock().getLocalBlock();
        if (lb.isStriped()) {
            LocatedStripedBlock lsb = (LocatedStripedBlock)lb;
            byte[] indices = new byte[lsb.getBlockIndices().length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = lsb.getBlockIndices()[i];
            }
            db = new Dispatcher.DBlockStriped(blk, indices, (short)ecPolicy.getNumDataUnits(), ecPolicy.getCellSize());
        } else {
            db = new Dispatcher.DBlock(blk);
        }
        for (MLocation ml : locations) {
            Dispatcher.Source source = this.storages.getSource(ml);
            if (source == null) continue;
            db.addLocation(source);
        }
        return db;
    }

    private static long getMaxRemaining(DatanodeStorageReport report, StorageType t) {
        long max = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t || r.getRemaining() <= max) continue;
            max = r.getRemaining();
        }
        return max;
    }

    private static String convertSnapshotPath(String[] pathComponents) {
        StringBuilder sb = new StringBuilder("/");
        for (int i = 0; i < pathComponents.length; ++i) {
            if (pathComponents[i].equals(".snapshot")) {
                ++i;
                continue;
            }
            sb.append(pathComponents[i]);
        }
        return sb.toString();
    }

    private static void checkKeytabAndInit(Configuration conf) throws IOException {
        if (conf.getBoolean("dfs.mover.keytab.enabled", false)) {
            LOG.info("Keytab is configured, will login using keytab.");
            UserGroupInformation.setConfiguration((Configuration)conf);
            String addr = conf.get("dfs.mover.address", "0.0.0.0:0");
            InetSocketAddress socAddr = NetUtils.createSocketAddr((String)addr, (int)0, (String)"dfs.mover.address");
            SecurityUtil.login((Configuration)conf, (String)"dfs.mover.keytab.file", (String)"dfs.mover.kerberos.principal", (String)socAddr.getHostName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int run(Map<URI, List<Path>> namenodes, Configuration conf) throws IOException, InterruptedException {
        long sleeptime = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS) * 2L + conf.getTimeDuration("dfs.namenode.redundancy.interval.seconds", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        AtomicInteger retryCount = new AtomicInteger(0);
        HashMap<Long, Set<DatanodeInfo>> excludedPinnedBlocks = new HashMap<Long, Set<DatanodeInfo>>();
        LOG.info("namenodes = " + namenodes);
        DefaultMetricsSystem.initialize((String)"Mover");
        JvmMetrics.create((String)"Mover", (String)conf.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        Mover.checkKeytabAndInit(conf);
        List<Object> connectors = Collections.emptyList();
        try {
            connectors = NameNodeConnector.newNameNodeConnectors(namenodes, Mover.class.getSimpleName(), HdfsServerConstants.MOVER_ID_PATH, conf, 5);
            while (true) {
                Iterator<Object> iter;
                if (connectors.size() > 0) {
                    Collections.shuffle(connectors);
                    iter = connectors.iterator();
                } else {
                    System.out.println("Mover Successful: all blocks satisfy the specified storage policy. Exiting...");
                    int n = ExitStatus.SUCCESS.getExitCode();
                    Iterator<Object> iterator = connectors.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return n;
                        }
                        NameNodeConnector nameNodeConnector = (NameNodeConnector)iterator.next();
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{nameNodeConnector});
                    }
                }
                while (iter.hasNext()) {
                    NameNodeConnector nnc = (NameNodeConnector)iter.next();
                    Mover mover = new Mover(nnc, conf, retryCount, excludedPinnedBlocks);
                    ExitStatus r = mover.run();
                    if (r == ExitStatus.SUCCESS) {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{nnc});
                        iter.remove();
                        continue;
                    }
                    if (r == ExitStatus.IN_PROGRESS) continue;
                    if (r == ExitStatus.NO_MOVE_PROGRESS) {
                        System.err.println("Failed to move some blocks after " + mover.retryMaxAttempts + " retries. Exiting...");
                    } else if (r == ExitStatus.NO_MOVE_BLOCK) {
                        System.err.println("Some blocks can't be moved. Exiting...");
                    } else {
                        System.err.println("Mover failed. Exiting with status " + (Object)((Object)r) + "... ");
                    }
                    int n = r.getExitCode();
                    Iterator<Object> iterator = connectors.iterator();
                    while (iterator.hasNext()) {
                        NameNodeConnector nameNodeConnector = (NameNodeConnector)iterator.next();
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{nameNodeConnector});
                    }
                    return n;
                }
                Thread.sleep(sleeptime);
            }
        }
        catch (Throwable throwable) {
            Iterator iterator = connectors.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                NameNodeConnector nameNodeConnector = (NameNodeConnector)iterator.next();
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{nameNodeConnector});
            }
        }
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, "Usage: hdfs mover [-p <files/dirs> | -f <local file>]\n\t-p <files/dirs>\ta space separated list of HDFS files/dirs to migrate.\n\t-f <local file>\ta local file containing a list of HDFS files/dirs to migrate.", System.out, true)) {
            System.exit(0);
        }
        try {
            System.exit(ToolRunner.run((Configuration)new HdfsConfiguration(), (Tool)new Cli(), (String[])args));
        }
        catch (Throwable e) {
            LOG.error("Exiting " + Mover.class.getSimpleName() + " due to an exception", e);
            System.exit(-1);
        }
    }

    private static class Result {
        private boolean hasRemaining = false;
        private boolean noBlockMoved = true;
        private boolean retryFailed = false;

        Result() {
        }

        boolean isHasRemaining() {
            return this.hasRemaining;
        }

        boolean isNoBlockMoved() {
            return this.noBlockMoved;
        }

        void updateHasRemaining(boolean hasRemaining) {
            this.hasRemaining |= hasRemaining;
        }

        void setNoBlockMoved(boolean noBlockMoved) {
            this.noBlockMoved = noBlockMoved;
        }

        void setRetryFailed() {
            this.retryFailed = true;
        }

        ExitStatus getExitStatus() {
            if (this.retryFailed) {
                return ExitStatus.NO_MOVE_PROGRESS;
            }
            return !this.isHasRemaining() ? ExitStatus.SUCCESS : (this.isNoBlockMoved() ? ExitStatus.NO_MOVE_BLOCK : ExitStatus.IN_PROGRESS);
        }
    }

    public static class Cli
    extends Configured
    implements Tool {
        private static final String USAGE = "Usage: hdfs mover [-p <files/dirs> | -f <local file>]\n\t-p <files/dirs>\ta space separated list of HDFS files/dirs to migrate.\n\t-f <local file>\ta local file containing a list of HDFS files/dirs to migrate.";

        private static Options buildCliOptions() {
            Options opts = new Options();
            OptionBuilder.withArgName((String)"pathsFile");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"a local file containing files/dirs to migrate");
            Option file = OptionBuilder.create((String)"f");
            OptionBuilder.withArgName((String)"paths");
            OptionBuilder.hasArgs();
            OptionBuilder.withDescription((String)"specify space separated files/dirs to migrate");
            Option paths = OptionBuilder.create((String)"p");
            OptionGroup group = new OptionGroup();
            group.addOption(file);
            group.addOption(paths);
            opts.addOptionGroup(group);
            return opts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String[] readPathFile(String file) throws IOException {
            ArrayList list = Lists.newArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    list.add(line);
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
            return list.toArray(new String[list.size()]);
        }

        private static Map<URI, List<Path>> getNameNodePaths(CommandLine line, Configuration conf) throws Exception {
            HashMap map = Maps.newHashMap();
            String[] paths = null;
            if (line.hasOption("f")) {
                paths = Cli.readPathFile(line.getOptionValue("f"));
            } else if (line.hasOption("p")) {
                paths = line.getOptionValues("p");
            }
            Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
            if (paths == null || paths.length == 0) {
                for (URI namenode : namenodes) {
                    map.put(namenode, null);
                }
                return map;
            }
            URI singleNs = namenodes.size() == 1 ? namenodes.iterator().next() : null;
            for (String path : paths) {
                Path target = new Path(path);
                if (!target.isUriPathAbsolute()) {
                    throw new IllegalArgumentException("The path " + target + " is not absolute");
                }
                URI targetUri = target.toUri();
                if ((targetUri.getAuthority() == null || targetUri.getScheme() == null) && singleNs == null) {
                    throw new IllegalArgumentException("The path " + target + " does not contain scheme and authority thus cannot identify its name service");
                }
                URI key = singleNs;
                if (singleNs == null && !namenodes.contains(key = new URI(targetUri.getScheme(), targetUri.getAuthority(), null, null, null))) {
                    throw new IllegalArgumentException("Cannot resolve the path " + target + ". The namenode services specified in the configuration: " + namenodes);
                }
                List targets = (List)map.get(key);
                if (targets == null) {
                    targets = Lists.newArrayList();
                    map.put(key, targets);
                }
                targets.add(Path.getPathWithoutSchemeAndAuthority((Path)target));
            }
            return map;
        }

        @VisibleForTesting
        static Map<URI, List<Path>> getNameNodePathsToMove(Configuration conf, String ... args) throws Exception {
            Options opts = Cli.buildCliOptions();
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(opts, args, true);
            return Cli.getNameNodePaths(commandLine, conf);
        }

        /*
         * Exception decompiling
         */
        public int run(String[] args) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @VisibleForTesting
    static class StorageTypeDiff {
        final List<StorageType> expected;
        final List<StorageType> existing;

        StorageTypeDiff(List<StorageType> expected, StorageType[] existing) {
            this.expected = new LinkedList<StorageType>(expected);
            this.existing = new LinkedList<StorageType>(Arrays.asList(existing));
        }

        boolean removeOverlap(boolean ignoreNonMovable) {
            Iterator<StorageType> i = this.existing.iterator();
            while (i.hasNext()) {
                StorageType t = i.next();
                if (!this.expected.remove(t)) continue;
                i.remove();
            }
            if (ignoreNonMovable) {
                this.removeNonMovable(this.existing);
                this.removeNonMovable(this.expected);
            }
            return this.expected.isEmpty() || this.existing.isEmpty();
        }

        void removeNonMovable(List<StorageType> types) {
            Iterator<StorageType> i = types.iterator();
            while (i.hasNext()) {
                StorageType t = i.next();
                if (t.isMovable()) continue;
                i.remove();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{expected=" + this.expected + ", existing=" + this.existing + "}";
        }
    }

    static class MLocation {
        final DatanodeInfo datanode;
        final StorageType storageType;
        final long size;

        MLocation(DatanodeInfo datanode, StorageType storageType, long size) {
            this.datanode = datanode;
            this.storageType = storageType;
            this.size = size;
        }

        static List<MLocation> toLocations(LocatedBlock lb) {
            DatanodeInfoWithStorage[] datanodeInfos = lb.getLocations();
            StorageType[] storageTypes = lb.getStorageTypes();
            long size = lb.getBlockSize();
            LinkedList<MLocation> locations = new LinkedList<MLocation>();
            for (int i = 0; i < datanodeInfos.length; ++i) {
                locations.add(new MLocation((DatanodeInfo)datanodeInfos[i], storageTypes[i], size));
            }
            return locations;
        }
    }

    class Processor {
        private final DFSClient dfs;
        private final List<String> snapshottableDirs = new ArrayList<String>();

        Processor() {
            this.dfs = Mover.this.dispatcher.getDistributedFileSystem().getClient();
        }

        private void getSnapshottableDirs() {
            SnapshottableDirectoryStatus[] dirs = null;
            try {
                dirs = this.dfs.getSnapshottableDirListing();
            }
            catch (IOException e) {
                LOG.warn("Failed to get snapshottable directories. Ignore and continue.", (Throwable)e);
            }
            if (dirs != null) {
                for (SnapshottableDirectoryStatus dir : dirs) {
                    this.snapshottableDirs.add(dir.getFullPath().toString());
                }
            }
        }

        private boolean isSnapshotPathInCurrent(String path) throws IOException {
            if (path.contains("/.snapshot/")) {
                String[] pathComponents = INode.getPathNames(path);
                if (".snapshot".equals(pathComponents[pathComponents.length - 2])) {
                    return false;
                }
                String nonSnapshotPath = Mover.convertSnapshotPath(pathComponents);
                return this.dfs.getFileInfo(nonSnapshotPath) != null;
            }
            return false;
        }

        private Result processNamespace() throws IOException {
            Mover.this.metrics.setProcessingNamespace(true);
            this.getSnapshottableDirs();
            Result result = new Result();
            for (Path target : Mover.this.targetPaths) {
                this.processPath(target.toUri().getPath(), result);
            }
            boolean hasFailed = Dispatcher.waitForMoveCompletion(Mover.this.storages.targets.values());
            Dispatcher.checkForBlockPinningFailures(Mover.this.excludedPinnedBlocks, Mover.this.storages.targets.values());
            boolean hasSuccess = Dispatcher.checkForSuccess(Mover.this.storages.targets.values());
            if (hasFailed && !hasSuccess) {
                if (Mover.this.retryCount.get() == Mover.this.retryMaxAttempts) {
                    result.setRetryFailed();
                    LOG.error("Failed to move some block's after " + Mover.this.retryMaxAttempts + " retries.");
                    return result;
                }
                Mover.this.retryCount.incrementAndGet();
            } else {
                Mover.this.retryCount.set(0);
            }
            result.updateHasRemaining(hasFailed);
            Mover.this.metrics.setProcessingNamespace(false);
            return result;
        }

        private void processPath(String fullPath, Result result) {
            byte[] lastReturnedName = HdfsFileStatus.EMPTY_NAME;
            while (true) {
                DirectoryListing children;
                try {
                    children = this.dfs.listPaths(fullPath, lastReturnedName, true);
                }
                catch (IOException e) {
                    LOG.warn("Failed to list directory " + fullPath + ". Ignore the directory and continue.", (Throwable)e);
                    return;
                }
                if (children == null) {
                    return;
                }
                for (HdfsFileStatus child : children.getPartialListing()) {
                    this.processRecursively(fullPath, child, result);
                }
                if (!children.hasMore()) break;
                lastReturnedName = children.getLastName();
            }
        }

        private void processRecursively(String parent, HdfsFileStatus status, Result result) {
            String fullPath = status.getFullName(parent);
            if (status.isDirectory()) {
                if (!fullPath.endsWith("/")) {
                    fullPath = fullPath + "/";
                }
                this.processPath(fullPath, result);
                if (this.snapshottableDirs.contains(fullPath)) {
                    String dirSnapshot = fullPath + ".snapshot";
                    this.processPath(dirSnapshot, result);
                }
            } else if (!status.isSymlink()) {
                try {
                    if (!this.isSnapshotPathInCurrent(fullPath)) {
                        this.processFile(fullPath, (HdfsLocatedFileStatus)status, result);
                        Mover.this.metrics.incrFilesProcessed();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to check the status of " + parent + ". Ignore it and continue.", (Throwable)e);
                }
            }
        }

        private void processFile(String fullPath, HdfsLocatedFileStatus status, Result result) {
            BlockStoragePolicy policy;
            byte policyId = status.getStoragePolicy();
            if (policyId == 0) {
                try {
                    policyId = this.dfs.getServerDefaults().getDefaultStoragePolicyId();
                }
                catch (IOException e) {
                    LOG.warn("Failed to get default policy for " + fullPath, (Throwable)e);
                    return;
                }
            }
            if ((policy = Mover.this.blockStoragePolicies[policyId]) == null) {
                LOG.warn("Failed to get the storage policy of file " + fullPath);
                return;
            }
            List types = policy.chooseStorageTypes(status.getReplication());
            ErasureCodingPolicy ecPolicy = status.getErasureCodingPolicy();
            LocatedBlocks locatedBlocks = status.getLocatedBlocks();
            boolean lastBlkComplete = locatedBlocks.isLastBlockComplete();
            List lbs = locatedBlocks.getLocatedBlocks();
            for (int i = 0; i < lbs.size(); ++i) {
                StorageTypeDiff diff;
                if (i == lbs.size() - 1 && !lastBlkComplete) continue;
                LocatedBlock lb = (LocatedBlock)lbs.get(i);
                if (lb.isStriped()) {
                    if (ErasureCodingPolicyManager.checkStoragePolicySuitableForECStripedMode(policyId)) {
                        types = policy.chooseStorageTypes((short)lb.getLocations().length);
                    } else {
                        LOG.warn("The storage policy " + policy.getName() + " is not suitable for Striped EC files. So, Ignoring to move the blocks");
                        return;
                    }
                }
                if ((diff = new StorageTypeDiff(types, lb.getStorageTypes())).removeOverlap(true)) continue;
                if (this.scheduleMoves4Block(diff, lb, ecPolicy)) {
                    result.updateHasRemaining(diff.existing.size() > 1 && diff.expected.size() > 1);
                    result.setNoBlockMoved(false);
                    continue;
                }
                result.updateHasRemaining(true);
            }
        }

        boolean scheduleMoves4Block(StorageTypeDiff diff, LocatedBlock lb, ErasureCodingPolicy ecPolicy) {
            List<MLocation> locations = MLocation.toLocations(lb);
            if (!(lb instanceof LocatedStripedBlock)) {
                Collections.shuffle(locations);
            }
            Dispatcher.DBlock db = Mover.this.newDBlock(lb, locations, ecPolicy);
            for (StorageType t : diff.existing) {
                for (MLocation ml : locations) {
                    Dispatcher.Source source = Mover.this.storages.getSource(ml);
                    if (ml.storageType != t || source == null || !this.scheduleMoveReplica(db, source, diff.expected)) continue;
                    return true;
                }
            }
            return false;
        }

        @VisibleForTesting
        boolean scheduleMoveReplica(Dispatcher.DBlock db, MLocation ml, List<StorageType> targetTypes) {
            Dispatcher.Source source = Mover.this.storages.getSource(ml);
            return source == null ? false : this.scheduleMoveReplica(db, source, targetTypes);
        }

        boolean scheduleMoveReplica(Dispatcher.DBlock db, Dispatcher.Source source, List<StorageType> targetTypes) {
            if (this.chooseTargetInSameNode(db, source, targetTypes)) {
                return true;
            }
            long blockId = db.getBlock().getBlockId();
            if (Mover.this.excludedPinnedBlocks.containsKey(blockId)) {
                Set locs = (Set)Mover.this.excludedPinnedBlocks.get(blockId);
                for (DatanodeInfo dn : locs) {
                    if (!source.getDatanodeInfo().equals((Object)dn)) continue;
                    return false;
                }
            }
            if (Mover.this.dispatcher.getCluster().isNodeGroupAware() && this.chooseTarget(db, source, targetTypes, Matcher.SAME_NODE_GROUP)) {
                return true;
            }
            if (this.chooseTarget(db, source, targetTypes, Matcher.SAME_RACK)) {
                return true;
            }
            return this.chooseTarget(db, source, targetTypes, Matcher.ANY_OTHER);
        }

        boolean chooseTargetInSameNode(Dispatcher.DBlock db, Dispatcher.Source source, List<StorageType> targetTypes) {
            for (StorageType t : targetTypes) {
                Dispatcher.PendingMove pm;
                Dispatcher.DDatanode.StorageGroup target = Mover.this.storages.getTarget(source.getDatanodeInfo().getDatanodeUuid(), t);
                if (target == null || (pm = source.addPendingMove(db, target)) == null) continue;
                Mover.this.dispatcher.executePendingMove(pm);
                Mover.this.metrics.incrBlocksScheduled();
                return true;
            }
            return false;
        }

        boolean chooseTarget(Dispatcher.DBlock db, Dispatcher.Source source, List<StorageType> targetTypes, Matcher matcher) {
            NetworkTopology cluster = Mover.this.dispatcher.getCluster();
            for (StorageType t : targetTypes) {
                List targets = Mover.this.storages.getTargetStorages(t);
                Collections.shuffle(targets);
                for (Dispatcher.DDatanode.StorageGroup target : targets) {
                    Dispatcher.PendingMove pm;
                    if (!matcher.match(cluster, (Node)source.getDatanodeInfo(), (Node)target.getDatanodeInfo()) || (pm = source.addPendingMove(db, target)) == null) continue;
                    Mover.this.dispatcher.executePendingMove(pm);
                    Mover.this.metrics.incrBlocksScheduled();
                    return true;
                }
            }
            return false;
        }
    }

    private static class StorageMap {
        private final Dispatcher.StorageGroupMap<Dispatcher.Source> sources = new Dispatcher.StorageGroupMap();
        private final Dispatcher.StorageGroupMap<Dispatcher.DDatanode.StorageGroup> targets = new Dispatcher.StorageGroupMap();
        private final EnumMap<StorageType, List<Dispatcher.DDatanode.StorageGroup>> targetStorageTypeMap = new EnumMap(StorageType.class);

        private StorageMap() {
            for (StorageType t : StorageType.getMovableTypes()) {
                this.targetStorageTypeMap.put(t, new LinkedList());
            }
        }

        private void add(Dispatcher.Source source, Dispatcher.DDatanode.StorageGroup target) {
            this.sources.put(source);
            if (target != null) {
                this.targets.put(target);
                this.getTargetStorages(target.getStorageType()).add(target);
            }
        }

        private Dispatcher.Source getSource(MLocation ml) {
            return StorageMap.get(this.sources, ml);
        }

        private Dispatcher.DDatanode.StorageGroup getTarget(String uuid, StorageType storageType) {
            return this.targets.get(uuid, storageType);
        }

        private static <G extends Dispatcher.DDatanode.StorageGroup> G get(Dispatcher.StorageGroupMap<G> map, MLocation ml) {
            return map.get(ml.datanode.getDatanodeUuid(), ml.storageType);
        }

        private List<Dispatcher.DDatanode.StorageGroup> getTargetStorages(StorageType t) {
            return this.targetStorageTypeMap.get(t);
        }
    }
}

