/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationIdPBImpl;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ReservationHomeSubClusterPBImpl
extends ReservationHomeSubCluster {
    private YarnServerFederationProtos.ReservationHomeSubClusterProto proto = YarnServerFederationProtos.ReservationHomeSubClusterProto.getDefaultInstance();
    private YarnServerFederationProtos.ReservationHomeSubClusterProto.Builder builder = null;
    private boolean viaProto = false;
    private ReservationId reservationId = null;
    private SubClusterId homeSubCluster = null;

    public ReservationHomeSubClusterPBImpl() {
        this.builder = YarnServerFederationProtos.ReservationHomeSubClusterProto.newBuilder();
    }

    public ReservationHomeSubClusterPBImpl(YarnServerFederationProtos.ReservationHomeSubClusterProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerFederationProtos.ReservationHomeSubClusterProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerFederationProtos.ReservationHomeSubClusterProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.reservationId != null) {
            this.builder.setReservationId(this.convertToProtoFormat(this.reservationId));
        }
        if (this.homeSubCluster != null) {
            this.builder.setHomeSubCluster(this.convertToProtoFormat(this.homeSubCluster));
        }
    }

    @Override
    public int hashCode() {
        return this.getProto().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ReservationHomeSubClusterPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public ReservationId getReservationId() {
        YarnServerFederationProtos.ReservationHomeSubClusterProtoOrBuilder p;
        YarnServerFederationProtos.ReservationHomeSubClusterProtoOrBuilder reservationHomeSubClusterProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasReservationId()) {
            return null;
        }
        this.reservationId = this.convertFromProtoFormat(p.getReservationId());
        return this.reservationId;
    }

    @Override
    public void setReservationId(ReservationId resId) {
        this.maybeInitBuilder();
        if (resId == null) {
            this.builder.clearReservationId();
            return;
        }
        this.reservationId = resId;
    }

    @Override
    public SubClusterId getHomeSubCluster() {
        YarnServerFederationProtos.ReservationHomeSubClusterProtoOrBuilder p;
        YarnServerFederationProtos.ReservationHomeSubClusterProtoOrBuilder reservationHomeSubClusterProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.homeSubCluster != null) {
            return this.homeSubCluster;
        }
        if (!p.hasHomeSubCluster()) {
            return null;
        }
        this.homeSubCluster = this.convertFromProtoFormat(p.getHomeSubCluster());
        return this.homeSubCluster;
    }

    @Override
    public void setHomeSubCluster(SubClusterId subClusterId) {
        this.maybeInitBuilder();
        if (subClusterId == null) {
            this.builder.clearHomeSubCluster();
            return;
        }
        this.homeSubCluster = subClusterId;
    }

    private SubClusterId convertFromProtoFormat(YarnServerFederationProtos.SubClusterIdProto subClusterId) {
        return new SubClusterIdPBImpl(subClusterId);
    }

    private YarnServerFederationProtos.SubClusterIdProto convertToProtoFormat(SubClusterId subClusterId) {
        return ((SubClusterIdPBImpl)subClusterId).getProto();
    }

    private ReservationId convertFromProtoFormat(YarnProtos.ReservationIdProto appId) {
        return new ReservationIdPBImpl(appId);
    }

    private YarnProtos.ReservationIdProto convertToProtoFormat(ReservationId appId) {
        return ((ReservationIdPBImpl)appId).getProto();
    }
}

