/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceVector;

public class QueueCapacityVector
implements Iterable<QueueCapacityVectorEntry> {
    private static final String START_PARENTHESES = "[";
    private static final String END_PARENTHESES = "]";
    private static final String RESOURCE_DELIMITER = ",";
    private static final String VALUE_DELIMITER = "=";
    private final ResourceVector resource;
    private final Map<String, QueueCapacityType> capacityTypes = new HashMap<String, QueueCapacityType>();
    private final Map<QueueCapacityType, Set<String>> capacityTypePerResource = new HashMap<QueueCapacityType, Set<String>>();

    public QueueCapacityVector() {
        this.resource = new ResourceVector();
    }

    private QueueCapacityVector(ResourceVector resource) {
        this.resource = resource;
    }

    public static QueueCapacityVector newInstance() {
        QueueCapacityVector newCapacityVector = new QueueCapacityVector(ResourceVector.newInstance());
        for (Map.Entry<String, Float> resourceEntry : newCapacityVector.resource) {
            newCapacityVector.storeResourceType(resourceEntry.getKey(), QueueCapacityType.ABSOLUTE);
        }
        return newCapacityVector;
    }

    public static QueueCapacityVector of(float value, QueueCapacityType capacityType) {
        QueueCapacityVector newCapacityVector = new QueueCapacityVector(ResourceVector.of(value));
        for (Map.Entry<String, Float> resourceEntry : newCapacityVector.resource) {
            newCapacityVector.storeResourceType(resourceEntry.getKey(), capacityType);
        }
        return newCapacityVector;
    }

    public QueueCapacityVectorEntry getResource(String resourceName) {
        return new QueueCapacityVectorEntry(this.capacityTypes.get(resourceName), resourceName, this.resource.getValue(resourceName).floatValue());
    }

    public int getResourceCount() {
        return this.capacityTypes.size();
    }

    public void setResource(String resourceName, float value, QueueCapacityType capacityType) {
        String convertedResourceName = resourceName;
        if (resourceName.equals("memory")) {
            convertedResourceName = "memory-mb";
        }
        this.resource.setValue(convertedResourceName, value);
        this.storeResourceType(convertedResourceName, capacityType);
    }

    public float getMemory() {
        return this.resource.getValue("memory-mb").floatValue();
    }

    public Set<String> getResourceNamesByCapacityType(QueueCapacityType capacityType) {
        return this.capacityTypePerResource.getOrDefault((Object)capacityType, Collections.emptySet());
    }

    public boolean isResourceOfType(String resourceName, QueueCapacityType capacityType) {
        return this.capacityTypes.containsKey(resourceName) && this.capacityTypes.get(resourceName).equals((Object)capacityType);
    }

    @Override
    public Iterator<QueueCapacityVectorEntry> iterator() {
        return new Iterator<QueueCapacityVectorEntry>(){
            private final Iterator<Map.Entry<String, Float>> resources;
            private int i;
            {
                this.resources = QueueCapacityVector.this.resource.iterator();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.resources.hasNext() && QueueCapacityVector.this.capacityTypes.size() > this.i;
            }

            @Override
            public QueueCapacityVectorEntry next() {
                Map.Entry<String, Float> resourceInformation = this.resources.next();
                ++this.i;
                return new QueueCapacityVectorEntry((QueueCapacityType)((Object)QueueCapacityVector.this.capacityTypes.get(resourceInformation.getKey())), resourceInformation.getKey(), resourceInformation.getValue().floatValue());
            }
        };
    }

    public Set<QueueCapacityType> getDefinedCapacityTypes() {
        return this.capacityTypePerResource.keySet();
    }

    private void storeResourceType(String resourceName, QueueCapacityType resourceType) {
        if (this.capacityTypes.get(resourceName) != null && !this.capacityTypes.get(resourceName).equals((Object)resourceType)) {
            this.capacityTypePerResource.get((Object)this.capacityTypes.get(resourceName)).remove(resourceName);
        }
        this.capacityTypePerResource.putIfAbsent(resourceType, new HashSet());
        this.capacityTypePerResource.get((Object)resourceType).add(resourceName);
        this.capacityTypes.put(resourceName, resourceType);
    }

    public String toString() {
        StringBuilder stringVector = new StringBuilder();
        stringVector.append(START_PARENTHESES);
        int resourceCount = 0;
        for (Map.Entry<String, Float> resourceEntry : this.resource) {
            stringVector.append(resourceEntry.getKey()).append(VALUE_DELIMITER).append(resourceEntry.getValue()).append(this.capacityTypes.get(resourceEntry.getKey()).postfix);
            if (++resourceCount >= this.capacityTypes.size()) continue;
            stringVector.append(RESOURCE_DELIMITER);
        }
        stringVector.append(END_PARENTHESES);
        return stringVector.toString();
    }

    public static class QueueCapacityVectorEntry {
        private final QueueCapacityType vectorResourceType;
        private final float resourceValue;
        private final String resourceName;

        public QueueCapacityVectorEntry(QueueCapacityType vectorResourceType, String resourceName, float resourceValue) {
            this.vectorResourceType = vectorResourceType;
            this.resourceValue = resourceValue;
            this.resourceName = resourceName;
        }

        public QueueCapacityType getVectorResourceType() {
            return this.vectorResourceType;
        }

        public float getResourceValue() {
            return this.resourceValue;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }

    public static enum QueueCapacityType {
        PERCENTAGE("%"),
        ABSOLUTE(""),
        WEIGHT("w");

        private final String postfix;

        private QueueCapacityType(String postfix) {
            this.postfix = postfix;
        }

        public String getPostfix() {
            return this.postfix;
        }
    }
}

