/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollectorWithAgg;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PerNodeTimelineCollectorsAuxService
extends AuxiliaryService {
    private static final Logger LOG = LoggerFactory.getLogger(PerNodeTimelineCollectorsAuxService.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final NodeTimelineCollectorManager collectorManager;
    private long collectorLingerPeriod;
    private ScheduledExecutorService scheduler;
    private Map<ApplicationId, Set<ContainerId>> appIdToContainerId = new ConcurrentHashMap<ApplicationId, Set<ContainerId>>();

    public PerNodeTimelineCollectorsAuxService() {
        this(new NodeTimelineCollectorManager(true));
    }

    @VisibleForTesting
    PerNodeTimelineCollectorsAuxService(NodeTimelineCollectorManager collectorsManager) {
        super("timeline_collector");
        this.collectorManager = collectorsManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            throw new YarnException("Looks like timeline_collector is set as an auxillary service in yarn.nodemanager.aux-services. But Timeline service v2 is not enabled, so timeline_collector needs to be removed from that list of auxillary services.");
        }
        this.collectorLingerPeriod = conf.getLong("yarn.timeline-service.app-collector.linger-period.ms", 60000L);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.collectorManager.init(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.collectorManager.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(this.collectorLingerPeriod, TimeUnit.MILLISECONDS)) {
            LOG.warn("Scheduler terminated before removing the application collectors");
        }
        this.collectorManager.stop();
        super.serviceStop();
    }

    public boolean addApplicationIfAbsent(ApplicationId appId, String user) {
        AppLevelTimelineCollectorWithAgg collector = new AppLevelTimelineCollectorWithAgg(appId, user);
        return this.collectorManager.putIfAbsent(appId, collector) == collector;
    }

    public boolean removeApplication(ApplicationId appId) {
        return this.collectorManager.remove(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeContainer(ContainerInitializationContext context) {
        if (context.getContainerType() == ContainerType.APPLICATION_MASTER) {
            ApplicationId appId = context.getContainerId().getApplicationAttemptId().getApplicationId();
            Map<ApplicationId, Set<ContainerId>> map = this.appIdToContainerId;
            synchronized (map) {
                Set<ContainerId> masterContainers = this.appIdToContainerId.get(appId);
                if (masterContainers == null) {
                    masterContainers = new HashSet<ContainerId>();
                    this.appIdToContainerId.put(appId, masterContainers);
                }
                masterContainers.add(context.getContainerId());
            }
            this.addApplicationIfAbsent(appId, context.getUser());
        }
    }

    public void stopContainer(ContainerTerminationContext context) {
        if (context.getContainerType() == ContainerType.APPLICATION_MASTER) {
            ContainerId containerId = context.getContainerId();
            this.removeApplicationCollector(containerId);
        }
    }

    @VisibleForTesting
    protected Future removeApplicationCollector(final ContainerId containerId) {
        final ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        return this.scheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean shouldRemoveApplication = false;
                Map map = PerNodeTimelineCollectorsAuxService.this.appIdToContainerId;
                synchronized (map) {
                    Set masterContainers = (Set)PerNodeTimelineCollectorsAuxService.this.appIdToContainerId.get(appId);
                    if (masterContainers == null) {
                        LOG.info("Stop container for " + containerId + " is called before initializing container.");
                        return;
                    }
                    masterContainers.remove(containerId);
                    if (masterContainers.size() == 0) {
                        shouldRemoveApplication = true;
                        PerNodeTimelineCollectorsAuxService.this.appIdToContainerId.remove(appId);
                    }
                }
                if (shouldRemoveApplication) {
                    PerNodeTimelineCollectorsAuxService.this.removeApplication(appId);
                }
            }
        }, this.collectorLingerPeriod, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    boolean hasApplication(ApplicationId appId) {
        return this.collectorManager.containsTimelineCollector(appId);
    }

    public void initializeApplication(ApplicationInitializationContext context) {
    }

    public void stopApplication(ApplicationTerminationContext context) {
    }

    public ByteBuffer getMetaData() {
        return ByteBuffer.allocate(0);
    }

    @VisibleForTesting
    public static PerNodeTimelineCollectorsAuxService launchServer(String[] args, NodeTimelineCollectorManager collectorManager, Configuration conf) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(PerNodeTimelineCollectorsAuxService.class, (String[])args, (Logger)LOG);
        PerNodeTimelineCollectorsAuxService auxService = null;
        try {
            auxService = collectorManager == null ? new PerNodeTimelineCollectorsAuxService(new NodeTimelineCollectorManager(false)) : new PerNodeTimelineCollectorsAuxService(collectorManager);
            ShutdownHookManager.get().addShutdownHook((Runnable)new ShutdownHook(auxService), 30);
            auxService.init(conf);
            auxService.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting PerNodeTimelineCollectorServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting PerNodeTimelineCollectorServer");
        }
        return auxService;
    }

    public static void main(String[] args) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        PerNodeTimelineCollectorsAuxService.launchServer(args, null, (Configuration)conf);
    }

    private static class ShutdownHook
    implements Runnable {
        private final PerNodeTimelineCollectorsAuxService auxService;

        public ShutdownHook(PerNodeTimelineCollectorsAuxService auxService) {
            this.auxService = auxService;
        }

        @Override
        public void run() {
            this.auxService.stop();
        }
    }
}

