/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineCollectorManager
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollectorManager.class);
    private TimelineWriter writer;
    private ScheduledExecutorService writerFlusher;
    private int flushInterval;
    private boolean writerFlusherRunning;
    private final Map<ApplicationId, TimelineCollector> collectors = Collections.synchronizedMap(new HashMap());

    protected void serviceInit(Configuration conf) throws Exception {
        this.writer = this.createTimelineWriter(conf);
        this.writer.init(conf);
        this.writerFlusher = Executors.newSingleThreadScheduledExecutor();
        this.flushInterval = conf.getInt("yarn.timeline-service.writer.flush-interval-seconds", 60);
        super.serviceInit(conf);
    }

    private TimelineWriter createTimelineWriter(Configuration conf) {
        String timelineWriterClassName = conf.get("yarn.timeline-service.writer.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl");
        LOG.info("Using TimelineWriter: " + timelineWriterClassName);
        try {
            Class<?> timelineWriterClazz = Class.forName(timelineWriterClassName);
            if (TimelineWriter.class.isAssignableFrom(timelineWriterClazz)) {
                return (TimelineWriter)ReflectionUtils.newInstance(timelineWriterClazz, (Configuration)conf);
            }
            throw new YarnRuntimeException("Class: " + timelineWriterClassName + " not instance of " + TimelineWriter.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate TimelineWriter: " + timelineWriterClassName, (Throwable)e);
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        if (this.writer != null) {
            this.writer.start();
        }
        this.writerFlusher.scheduleAtFixedRate(new WriterFlushTask(this.writer), this.flushInterval, this.flushInterval, TimeUnit.SECONDS);
        this.writerFlusherRunning = true;
    }

    public TimelineCollectorManager(String name) {
        super(name);
    }

    protected TimelineWriter getWriter() {
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineCollector putIfAbsent(ApplicationId appId, TimelineCollector collector) {
        TimelineCollector collectorInTable = null;
        Map<ApplicationId, TimelineCollector> map = this.collectors;
        synchronized (map) {
            collectorInTable = this.collectors.get(appId);
            if (collectorInTable == null) {
                try {
                    collector.init(this.getConfig());
                    collector.setWriter(this.writer);
                    collector.start();
                    this.collectors.put(appId, collector);
                    LOG.info("the collector for " + appId + " was added");
                    collectorInTable = collector;
                    this.postPut(appId, collectorInTable);
                }
                catch (Exception e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            } else {
                LOG.info("the collector for " + appId + " already exists!");
            }
        }
        return collectorInTable;
    }

    public void postPut(ApplicationId appId, TimelineCollector collector) {
        this.doPostPut(appId, collector);
        collector.setReadyToAggregate();
    }

    protected void doPostPut(ApplicationId appId, TimelineCollector collector) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ApplicationId appId) {
        TimelineCollector collector = this.collectors.remove(appId);
        if (collector == null) {
            LOG.error("the collector for " + appId + " does not exist!");
        } else {
            TimelineCollector timelineCollector = collector;
            synchronized (timelineCollector) {
                this.postRemove(appId, collector);
                collector.stop();
            }
            LOG.info("The collector service for " + appId + " was removed");
        }
        return collector != null;
    }

    protected void postRemove(ApplicationId appId, TimelineCollector collector) {
    }

    public TimelineCollector get(ApplicationId appId) {
        return this.collectors.get(appId);
    }

    public boolean containsTimelineCollector(ApplicationId appId) {
        return this.collectors.containsKey(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        if (this.collectors != null && this.collectors.size() > 0) {
            Map<ApplicationId, TimelineCollector> map = this.collectors;
            synchronized (map) {
                for (TimelineCollector c : this.collectors.values()) {
                    c.serviceStop();
                }
            }
        }
        if (this.writerFlusher != null) {
            this.writerFlusher.shutdown();
            this.writerFlusherRunning = false;
            if (!this.writerFlusher.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.warn("failed to stop the flusher task in time. will still proceed to close the writer.");
            }
        }
        if (this.writer != null) {
            this.writer.close();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    boolean writerFlusherRunning() {
        return this.writerFlusherRunning;
    }

    private static class WriterFlushTask
    implements Runnable {
        private final TimelineWriter writer;

        public WriterFlushTask(TimelineWriter writer) {
            this.writer = writer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TimelineWriter timelineWriter = this.writer;
                synchronized (timelineWriter) {
                    this.writer.flush();
                }
            }
            catch (Throwable th) {
                LOG.error("exception during timeline writer flush!", th);
            }
        }
    }
}

