/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.uam;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.uam.UnmanagedApplicationManager;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class UnmanagedAMPoolManager
extends AbstractService {
    public static final Logger LOG = LoggerFactory.getLogger(UnmanagedAMPoolManager.class);
    private Map<String, UnmanagedApplicationManager> unmanagedAppMasterMap;
    private Map<String, ApplicationId> appIdMap;
    private ExecutorService threadpool;
    private String dispatcherThreadName = "UnmanagedAMPoolManager-Finish-Thread";
    private Thread finishApplicationThread;

    public UnmanagedAMPoolManager(ExecutorService threadpool) {
        super(UnmanagedAMPoolManager.class.getName());
        this.threadpool = threadpool;
    }

    protected void serviceStart() throws Exception {
        if (this.threadpool == null) {
            this.threadpool = Executors.newCachedThreadPool();
        }
        this.unmanagedAppMasterMap = new ConcurrentHashMap<String, UnmanagedApplicationManager>();
        this.appIdMap = new ConcurrentHashMap<String, ApplicationId>();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (!this.unmanagedAppMasterMap.isEmpty()) {
            this.finishApplicationThread = new Thread(this.createForceFinishApplicationThread());
            this.finishApplicationThread.setName(this.dispatcherThreadName);
            this.finishApplicationThread.start();
        }
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAndRegisterNewUAM(RegisterApplicationMasterRequest registerRequest, Configuration conf, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) throws YarnException, IOException {
        ApplicationClientProtocol rmClient;
        ApplicationId appId = null;
        try {
            UserGroupInformation appSubmitter = UserGroupInformation.createRemoteUser((String)submitter);
            rmClient = (ApplicationClientProtocol)AMRMClientUtils.createRMProxy((Configuration)conf, ApplicationClientProtocol.class, (UserGroupInformation)appSubmitter, null);
            GetNewApplicationResponse response = rmClient.getNewApplication(GetNewApplicationRequest.newInstance());
            if (response == null) {
                throw new YarnException("getNewApplication got null response");
            }
            appId = response.getApplicationId();
            LOG.info("Received new application ID {} from RM", (Object)appId);
        }
        finally {
            rmClient = null;
        }
        this.launchUAM(appId.toString(), conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
        this.registerApplicationMaster(appId.toString(), registerRequest);
        return appId.toString();
    }

    public Token<AMRMTokenIdentifier> launchUAM(String uamId, Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) throws YarnException, IOException {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " already exists");
        }
        UnmanagedApplicationManager uam = this.createUAM(conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
        this.unmanagedAppMasterMap.put(uamId, uam);
        Token<AMRMTokenIdentifier> amrmToken = null;
        try {
            LOG.info("Launching UAM id {} for application {}", (Object)uamId, (Object)appId);
            amrmToken = uam.launchUAM();
        }
        catch (Exception e) {
            this.unmanagedAppMasterMap.remove(uamId);
            throw e;
        }
        this.appIdMap.put(uamId, uam.getAppId());
        return amrmToken;
    }

    public void reAttachUAM(String uamId, Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, Token<AMRMTokenIdentifier> uamToken, String rmName) throws YarnException, IOException {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " already exists");
        }
        UnmanagedApplicationManager uam = this.createUAM(conf, appId, queueName, submitter, appNameSuffix, true, rmName);
        this.unmanagedAppMasterMap.put(uamId, uam);
        try {
            LOG.info("Reattaching UAM id {} for application {}", (Object)uamId, (Object)appId);
            uam.reAttachUAM(uamToken);
        }
        catch (Exception e) {
            this.unmanagedAppMasterMap.remove(uamId);
            throw e;
        }
        this.appIdMap.put(uamId, uam.getAppId());
    }

    @VisibleForTesting
    protected UnmanagedApplicationManager createUAM(Configuration conf, ApplicationId appId, String queueName, String submitter, String appNameSuffix, boolean keepContainersAcrossApplicationAttempts, String rmName) {
        return new UnmanagedApplicationManager(conf, appId, queueName, submitter, appNameSuffix, keepContainersAcrossApplicationAttempts, rmName);
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(String uamId, RegisterApplicationMasterRequest registerRequest) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Registering UAM id {} for application {}", (Object)uamId, (Object)this.appIdMap.get(uamId));
        return this.unmanagedAppMasterMap.get(uamId).registerApplicationMaster(registerRequest);
    }

    public void allocateAsync(String uamId, AllocateRequest request, AsyncCallback<AllocateResponse> callback) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        this.unmanagedAppMasterMap.get(uamId).allocateAsync(request, callback);
    }

    public FinishApplicationMasterResponse finishApplicationMaster(String uamId, FinishApplicationMasterRequest request) throws YarnException, IOException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Finishing UAM id {} for application {}", (Object)uamId, (Object)this.appIdMap.get(uamId));
        FinishApplicationMasterResponse response = this.unmanagedAppMasterMap.get(uamId).finishApplicationMaster(request);
        if (response.getIsUnregistered()) {
            this.unmanagedAppMasterMap.remove(uamId);
            this.appIdMap.remove(uamId);
            LOG.info("UAM id {} is unregistered", (Object)uamId);
        }
        return response;
    }

    public void shutDownConnections(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        LOG.info("Shutting down UAM id {} for application {} without killing the UAM", (Object)uamId, (Object)this.appIdMap.get(uamId));
        this.unmanagedAppMasterMap.remove(uamId).shutDownConnections();
    }

    public void shutDownConnections() throws YarnException {
        for (String uamId : this.unmanagedAppMasterMap.keySet()) {
            this.shutDownConnections(uamId);
        }
    }

    public Set<String> getAllUAMIds() {
        return new HashSet<String>(this.unmanagedAppMasterMap.keySet());
    }

    public boolean hasUAMId(String uamId) {
        return this.unmanagedAppMasterMap.containsKey(uamId);
    }

    public AMRMClientRelayer getAMRMClientRelayer(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        return this.unmanagedAppMasterMap.get(uamId).getAMRMClientRelayer();
    }

    @VisibleForTesting
    public int getRequestQueueSize(String uamId) throws YarnException {
        if (!this.unmanagedAppMasterMap.containsKey(uamId)) {
            throw new YarnException("UAM " + uamId + " does not exist");
        }
        return this.unmanagedAppMasterMap.get(uamId).getRequestQueueSize();
    }

    @VisibleForTesting
    public void drainUAMHeartbeats() {
        for (UnmanagedApplicationManager uam : this.unmanagedAppMasterMap.values()) {
            uam.drainHeartbeatThread();
        }
    }

    public Map<String, FinishApplicationMasterResponse> batchFinishApplicationMaster(FinishApplicationMasterRequest request, String appId) {
        HashMap<String, FinishApplicationMasterResponse> responseMap = new HashMap<String, FinishApplicationMasterResponse>();
        Set<String> subClusterIds = this.unmanagedAppMasterMap.keySet();
        if (subClusterIds != null && !subClusterIds.isEmpty()) {
            ExecutorCompletionService<Map> finishAppService = new ExecutorCompletionService<Map>(this.threadpool);
            LOG.info("Sending finish application request to {} sub-cluster RMs", (Object)subClusterIds.size());
            for (String subClusterId : subClusterIds) {
                finishAppService.submit(() -> {
                    LOG.info("Sending finish application request to RM {}", (Object)subClusterId);
                    try {
                        FinishApplicationMasterResponse uamResponse = this.finishApplicationMaster(subClusterId, request);
                        return Collections.singletonMap(subClusterId, uamResponse);
                    }
                    catch (Throwable e) {
                        LOG.warn("Failed to finish unmanaged application master:  RM address: {} ApplicationId: {}", new Object[]{subClusterId, appId, e});
                        return Collections.singletonMap(subClusterId, null);
                    }
                });
            }
            for (int i = 0; i < subClusterIds.size(); ++i) {
                try {
                    Future future = finishAppService.take();
                    Map uamResponse = (Map)future.get();
                    LOG.debug("Received finish application response from RM: {}", uamResponse.keySet());
                    responseMap.putAll(uamResponse);
                    continue;
                }
                catch (Throwable e) {
                    LOG.warn("Failed to finish unmanaged application master: ApplicationId: {}", (Object)appId, (Object)e);
                }
            }
        }
        return responseMap;
    }

    Runnable createForceFinishApplicationThread() {
        return () -> {
            ExecutorCompletionService<Pair> completionService = new ExecutorCompletionService<Pair>(this.threadpool);
            HashSet<String> addressList = new HashSet<String>(this.unmanagedAppMasterMap.keySet());
            LOG.warn("Abnormal shutdown of UAMPoolManager, still {} UAMs in map", (Object)addressList.size());
            for (String uamId : addressList) {
                completionService.submit(() -> {
                    try {
                        ApplicationId appId = this.appIdMap.get(uamId);
                        LOG.info("Force-killing UAM id {} for application {}", (Object)uamId, (Object)appId);
                        UnmanagedApplicationManager applicationManager = this.unmanagedAppMasterMap.remove(uamId);
                        KillApplicationResponse response = applicationManager.forceKillApplication();
                        return Pair.of((Object)uamId, (Object)response);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to kill unmanaged application master", (Throwable)e);
                        return Pair.of((Object)uamId, null);
                    }
                });
            }
            for (int i = 0; i < addressList.size(); ++i) {
                try {
                    Future future = completionService.take();
                    Pair pairs = (Pair)future.get();
                    String uamId = (String)pairs.getLeft();
                    ApplicationId appId = this.appIdMap.get(uamId);
                    KillApplicationResponse response = (KillApplicationResponse)pairs.getRight();
                    if (response == null) {
                        throw new YarnException("Failed Force-killing UAM id " + uamId + " for application " + appId);
                    }
                    LOG.info("Force-killing UAM id = {} for application {} KillCompleted {}.", new Object[]{uamId, appId, response.getIsKillCompleted()});
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Failed to kill unmanaged application master", (Throwable)e);
                }
            }
            this.appIdMap.clear();
        };
    }

    public void unAttachUAM(String uamId) {
        if (this.unmanagedAppMasterMap.containsKey(uamId)) {
            UnmanagedApplicationManager appManager = this.unmanagedAppMasterMap.get(uamId);
            appManager.shutDownConnections();
        }
        this.unmanagedAppMasterMap.remove(uamId);
        this.appIdMap.remove(uamId);
    }

    @VisibleForTesting
    protected Map<String, UnmanagedApplicationManager> getUnmanagedAppMasterMap() {
        return this.unmanagedAppMasterMap;
    }

    @VisibleForTesting
    protected Thread getFinishApplicationThread() {
        return this.finishApplicationThread;
    }
}

