/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataNodeDiskMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(DataNodeDiskMetrics.class);
    private DataNode dn;
    private final long detectionInterval;
    private volatile boolean shouldRun;
    private OutlierDetector slowDiskDetector;
    private Daemon slowDiskDetectionDaemon;
    private volatile Map<String, Map<SlowDiskReports.DiskOp, Double>> diskOutliersStats = Maps.newHashMap();
    private boolean overrideStatus = true;
    private volatile long minOutlierDetectionDisks;
    private volatile long lowThresholdMs;
    private int maxSlowDisksToExclude;
    private List<String> slowDisksToExclude = new ArrayList<String>();

    public DataNodeDiskMetrics(DataNode dn, long diskOutlierDetectionIntervalMs, Configuration conf) {
        this.dn = dn;
        this.detectionInterval = diskOutlierDetectionIntervalMs;
        this.minOutlierDetectionDisks = conf.getLong("dfs.datanode.min.outlier.detection.disks", 5L);
        this.lowThresholdMs = conf.getLong("dfs.datanode.slowdisk.low.threshold.ms", 20L);
        this.maxSlowDisksToExclude = conf.getInt("dfs.datanode.max.slowdisks.to.exclude", 0);
        this.slowDiskDetector = new OutlierDetector(this.minOutlierDetectionDisks, this.lowThresholdMs);
        this.shouldRun = true;
        this.startDiskOutlierDetectionThread();
    }

    private void startDiskOutlierDetectionThread() {
        this.slowDiskDetectionDaemon = new Daemon(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (DataNodeDiskMetrics.this.shouldRun) {
                    if (DataNodeDiskMetrics.this.dn.getFSDataset() != null) {
                        HashMap metadataOpStats = Maps.newHashMap();
                        HashMap readIoStats = Maps.newHashMap();
                        HashMap writeIoStats = Maps.newHashMap();
                        FsDatasetSpi.FsVolumeReferences fsVolumeReferences = null;
                        try {
                            fsVolumeReferences = DataNodeDiskMetrics.this.dn.getFSDataset().getFsVolumeReferences();
                            for (FsVolumeSpi volume : fsVolumeReferences) {
                                DataNodeVolumeMetrics metrics = volume.getMetrics();
                                String volumeName = volume.getBaseURI().getPath();
                                metadataOpStats.put(volumeName, metrics.getMetadataOperationMean());
                                readIoStats.put(volumeName, metrics.getReadIoMean());
                                writeIoStats.put(volumeName, metrics.getWriteIoMean());
                            }
                        }
                        finally {
                            if (fsVolumeReferences != null) {
                                try {
                                    fsVolumeReferences.close();
                                }
                                catch (IOException e) {
                                    LOG.error("Error in releasing FS Volume references", (Throwable)e);
                                }
                            }
                        }
                        if (metadataOpStats.isEmpty() && readIoStats.isEmpty() && writeIoStats.isEmpty()) {
                            LOG.debug("No disk stats available for detecting outliers.");
                            continue;
                        }
                        DataNodeDiskMetrics.this.detectAndUpdateDiskOutliers(metadataOpStats, readIoStats, writeIoStats);
                        if (DataNodeDiskMetrics.this.maxSlowDisksToExclude > 0) {
                            ArrayList<DiskLatency> diskLatencies = new ArrayList<DiskLatency>();
                            for (Map.Entry diskStats : DataNodeDiskMetrics.this.diskOutliersStats.entrySet()) {
                                diskLatencies.add(new DiskLatency((String)diskStats.getKey(), (Map)diskStats.getValue()));
                            }
                            Collections.sort(diskLatencies, (o1, o2) -> Double.compare(o2.getMaxLatency(), o1.getMaxLatency()));
                            DataNodeDiskMetrics.this.slowDisksToExclude = diskLatencies.stream().limit(DataNodeDiskMetrics.this.maxSlowDisksToExclude).map(DiskLatency::getSlowDisk).collect(Collectors.toList());
                        }
                    }
                    try {
                        Thread.sleep(DataNodeDiskMetrics.this.detectionInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Disk Outlier Detection thread interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        this.slowDiskDetectionDaemon.start();
    }

    private void detectAndUpdateDiskOutliers(Map<String, Double> metadataOpStats, Map<String, Double> readIoStats, Map<String, Double> writeIoStats) {
        HashMap diskStats = Maps.newHashMap();
        Map<String, Double> metadataOpOutliers = this.slowDiskDetector.getOutliers(metadataOpStats);
        for (Map.Entry<String, Double> entry : metadataOpOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.METADATA, entry.getValue());
        }
        Map<String, Double> readIoOutliers = this.slowDiskDetector.getOutliers(readIoStats);
        for (Map.Entry<String, Double> entry : readIoOutliers.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.READ, entry.getValue());
        }
        Map<String, Double> map = this.slowDiskDetector.getOutliers(writeIoStats);
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            this.addDiskStat(diskStats, entry.getKey(), SlowDiskReports.DiskOp.WRITE, entry.getValue());
        }
        if (this.overrideStatus) {
            this.diskOutliersStats = diskStats;
            LOG.debug("Updated disk outliers.");
        }
    }

    private void addDiskStat(Map<String, Map<SlowDiskReports.DiskOp, Double>> diskStats, String disk, SlowDiskReports.DiskOp diskOp, double latency) {
        if (!diskStats.containsKey(disk)) {
            diskStats.put(disk, new HashMap());
        }
        diskStats.get(disk).put(diskOp, latency);
    }

    public Map<String, Map<SlowDiskReports.DiskOp, Double>> getDiskOutliersStats() {
        return this.diskOutliersStats;
    }

    public void shutdownAndWait() {
        this.shouldRun = false;
        this.slowDiskDetectionDaemon.interrupt();
        try {
            this.slowDiskDetectionDaemon.join();
        }
        catch (InterruptedException e) {
            LOG.error("Disk Outlier Detection daemon did not shutdown", (Throwable)e);
        }
    }

    @VisibleForTesting
    public void addSlowDiskForTesting(String slowDiskPath, Map<SlowDiskReports.DiskOp, Double> latencies) {
        this.overrideStatus = false;
        if (latencies == null) {
            this.diskOutliersStats.put(slowDiskPath, (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of());
        } else {
            this.diskOutliersStats.put(slowDiskPath, latencies);
        }
    }

    public List<String> getSlowDisksToExclude() {
        return this.slowDisksToExclude;
    }

    public void setLowThresholdMs(long thresholdMs) {
        Preconditions.checkArgument((thresholdMs > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.slowdisk.low.threshold.ms should be larger than 0");
        this.lowThresholdMs = thresholdMs;
        this.slowDiskDetector.setLowThresholdMs(thresholdMs);
    }

    public long getLowThresholdMs() {
        return this.lowThresholdMs;
    }

    public void setMinOutlierDetectionDisks(long minDisks) {
        Preconditions.checkArgument((minDisks > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.min.outlier.detection.disks should be larger than 0");
        this.minOutlierDetectionDisks = minDisks;
        this.slowDiskDetector.setMinNumResources(minDisks);
    }

    public long getMinOutlierDetectionDisks() {
        return this.minOutlierDetectionDisks;
    }

    @VisibleForTesting
    public OutlierDetector getSlowDiskDetector() {
        return this.slowDiskDetector;
    }

    public static class DiskLatency {
        private final String slowDisk;
        private final Map<SlowDiskReports.DiskOp, Double> latencyMap;

        public DiskLatency(String slowDiskID, Map<SlowDiskReports.DiskOp, Double> latencyMap) {
            this.slowDisk = slowDiskID;
            this.latencyMap = latencyMap;
        }

        double getMaxLatency() {
            double maxLatency = 0.0;
            for (double latency : this.latencyMap.values()) {
                if (!(latency > maxLatency)) continue;
                maxLatency = latency;
            }
            return maxLatency;
        }

        public String getSlowDisk() {
            return this.slowDisk;
        }
    }
}

