/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatchers;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FSImageTestUtil {
    public static final Logger LOG = LoggerFactory.getLogger(FSImageTestUtil.class);
    private static final long IMAGE_TXID_POS = 24L;

    public static String getFileMD5(File file) throws IOException {
        return MD5FileUtils.computeMd5ForFile(file).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFileMD5IgnoringTxId(File imageFile) throws IOException {
        File tmpFile = File.createTempFile("hadoop_imagefile_tmp", "fsimage");
        tmpFile.deleteOnExit();
        try {
            Files.copy((File)imageFile, (File)tmpFile);
            RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
            try {
                raf.seek(24L);
                raf.writeLong(0L);
                raf.close();
                raf = null;
            }
            finally {
                IOUtils.closeStream((Closeable)raf);
            }
            String string = FSImageTestUtil.getFileMD5(tmpFile);
            return string;
        }
        finally {
            tmpFile.delete();
        }
    }

    public static Storage.StorageDirectory mockStorageDirectory(File currentDir, NNStorage.NameNodeDirType type) {
        Storage.StorageDirectory sd = Mockito.mock(Storage.StorageDirectory.class);
        Mockito.doReturn(type).when(sd).getStorageDirType();
        Mockito.doReturn(currentDir).when(sd).getCurrentDir();
        Mockito.doReturn(currentDir).when(sd).getRoot();
        Mockito.doReturn(FSImageTestUtil.mockFile(true)).when(sd).getVersionFile();
        Mockito.doReturn(FSImageTestUtil.mockFile(false)).when(sd).getPreviousDir();
        return sd;
    }

    static Storage.StorageDirectory mockStorageDirectory(Storage.StorageDirType type, boolean previousExists, String ... fileNames) {
        Storage.StorageDirectory sd = Mockito.mock(Storage.StorageDirectory.class);
        Mockito.doReturn(type).when(sd).getStorageDirType();
        Mockito.doReturn(FSImageTestUtil.mockFile(true)).when(sd).getVersionFile();
        Mockito.doReturn(FSImageTestUtil.mockFile(true)).when(sd).getRoot();
        Mockito.doReturn(FSImageTestUtil.mockFile(previousExists)).when(sd).getPreviousDir();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        File mockDir = Mockito.spy(new File("/dir/current"));
        Mockito.doReturn(files).when(mockDir).listFiles();
        Mockito.doReturn(mockDir).when(sd).getCurrentDir();
        return sd;
    }

    static File mockFile(boolean exists) {
        File mockFile = Mockito.mock(File.class);
        Mockito.doReturn(exists).when(mockFile).exists();
        return mockFile;
    }

    public static FSImageTransactionalStorageInspector inspectStorageDirectory(File dir, NNStorage.NameNodeDirType dirType) throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(FSImageTestUtil.mockStorageDirectory(dir, dirType));
        return inspector;
    }

    public static FSEditLog createStandaloneEditLog(File logDir) throws IOException {
        Assert.assertTrue((logDir.mkdirs() || logDir.exists() ? 1 : 0) != 0);
        if (!FileUtil.fullyDeleteContents((File)logDir)) {
            throw new IOException("Unable to delete contents of " + logDir);
        }
        NNStorage storage = Mockito.mock(NNStorage.class);
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory(logDir, NNStorage.NameNodeDirType.EDITS);
        ArrayList sds = Lists.newArrayList((Object[])new Storage.StorageDirectory[]{sd});
        Mockito.doReturn(sds).when(storage).dirIterable(NNStorage.NameNodeDirType.EDITS);
        Mockito.doReturn(sd).when(storage).getStorageDirectory((URI)ArgumentMatchers.any());
        FSEditLog editLog = new FSEditLog(new Configuration(), storage, (List<URI>)ImmutableList.of((Object)logDir.toURI()));
        editLog.initJournalsForWrite();
        return editLog;
    }

    public static INodeFile createEmptyInodeFile(long id, String name, PermissionStatus permissions, long mtime, long atime, short replication, long preferredBlockSize) {
        return new INodeFile(id, name.getBytes(StandardCharsets.UTF_8), permissions, mtime, atime, null, replication, preferredBlockSize);
    }

    public static FSEditLog createEditLogWithJournalManager(Configuration conf, NNStorage storage, URI editsUri, final JournalManager manager) {
        return new FSEditLog(conf, storage, (List)ImmutableList.of((Object)editsUri)){

            @Override
            protected JournalManager createJournal(URI uri) {
                return manager;
            }
        };
    }

    public static void createAbortedLogWithMkdirs(File editsLogDir, int numDirs, long firstTxId, long newInodeId) throws IOException {
        FSEditLog editLog = FSImageTestUtil.createStandaloneEditLog(editsLogDir);
        editLog.setNextTxId(firstTxId);
        editLog.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        PermissionStatus perms = PermissionStatus.createImmutable((String)"fakeuser", (String)"fakegroup", (FsPermission)FsPermission.createImmutable((short)493));
        for (int i = 1; i <= numDirs; ++i) {
            String dirName = "dir" + i;
            INodeDirectory dir = new INodeDirectory(newInodeId + (long)i - 1L, DFSUtil.string2Bytes(dirName), perms, 0L);
            editLog.logMkDir("/" + dirName, dir);
        }
        editLog.logSync();
        editLog.abortCurrentLogSegment();
    }

    public static EnumMap<FSEditLogOpCodes, Holder<Integer>> countEditLogOpTypes(File editLog) throws Exception {
        EditLogFileInputStream elis = new EditLogFileInputStream(editLog);
        try {
            EnumMap<FSEditLogOpCodes, Holder<Integer>> enumMap = FSImageTestUtil.countEditLogOpTypes(elis);
            return enumMap;
        }
        finally {
            IOUtils.closeStream((Closeable)elis);
        }
    }

    public static EnumMap<FSEditLogOpCodes, Holder<Integer>> countEditLogOpTypes(EditLogInputStream elis) throws IOException {
        FSEditLogOp op;
        EnumMap<FSEditLogOpCodes, Holder<Integer>> opCounts = new EnumMap<FSEditLogOpCodes, Holder<Integer>>(FSEditLogOpCodes.class);
        while ((op = elis.readOp()) != null) {
            Holder<Integer> i = opCounts.get((Object)op.opCode);
            if (i == null) {
                i = new Holder<Integer>(0);
                opCounts.put(op.opCode, i);
            }
            Holder<Integer> holder = i;
            Integer n = (Integer)holder.held;
            holder.held = (Integer)holder.held + 1;
            Integer n2 = holder.held;
        }
        return opCounts;
    }

    public static void assertSameNewestImage(List<File> dirs) throws Exception {
        if (dirs.size() < 2) {
            return;
        }
        long imageTxId = -1L;
        ArrayList<File> imageFiles = new ArrayList<File>();
        for (File dir : dirs) {
            FSImageTransactionalStorageInspector inspector = FSImageTestUtil.inspectStorageDirectory(dir, NNStorage.NameNodeDirType.IMAGE);
            List<FSImageStorageInspector.FSImageFile> latestImages = inspector.getLatestImages();
            assert (!latestImages.isEmpty());
            long thisTxId = latestImages.get(0).getCheckpointTxId();
            if (imageTxId != -1L && thisTxId != imageTxId) {
                Assert.fail((String)("Storage directory " + dir + " does not have the same last image index " + imageTxId + " as another"));
            }
            imageTxId = thisTxId;
            imageFiles.add(inspector.getLatestImages().get(0).getFile());
        }
        FSImageTestUtil.assertFileContentsSame(imageFiles.toArray(new File[0]));
    }

    public static void assertParallelFilesAreIdentical(List<File> dirs, Set<String> ignoredFileNames) throws Exception {
        HashMap<String, ArrayList<File>> groupedByName = new HashMap<String, ArrayList<File>>();
        for (File dir : dirs) {
            for (File f : dir.listFiles()) {
                if (ignoredFileNames.contains(f.getName())) continue;
                ArrayList<File> fileList = (ArrayList<File>)groupedByName.get(f.getName());
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    groupedByName.put(f.getName(), fileList);
                }
                fileList.add(f);
            }
        }
        HashSet<String> ignoredProperties = new HashSet<String>();
        ignoredProperties.add("storageID");
        for (List sameNameList : groupedByName.values()) {
            if (((File)sameNameList.get(0)).isDirectory()) {
                FSImageTestUtil.assertParallelFilesAreIdentical(sameNameList, ignoredFileNames);
                continue;
            }
            if ("VERSION".equals(((File)sameNameList.get(0)).getName())) {
                FSImageTestUtil.assertPropertiesFilesSame(sameNameList.toArray(new File[0]), ignoredProperties);
                continue;
            }
            FSImageTestUtil.assertFileContentsSame(sameNameList.toArray(new File[0]));
        }
    }

    public static void assertPropertiesFilesSame(File[] propFiles) throws IOException {
        FSImageTestUtil.assertPropertiesFilesSame(propFiles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertPropertiesFilesSame(File[] propFiles, Set<String> ignoredProperties) throws IOException {
        Set<Map.Entry<Object, Object>> prevProps = null;
        for (File f : propFiles) {
            Properties props;
            FileInputStream is = new FileInputStream(f);
            try {
                props = new Properties();
                props.load(is);
            }
            finally {
                IOUtils.closeStream((Closeable)is);
            }
            if (prevProps == null) {
                prevProps = props.entrySet();
                continue;
            }
            Set diff = Sets.symmetricDifference(prevProps, props.entrySet());
            for (Map.Entry entry : diff) {
                if (ignoredProperties != null && ignoredProperties.contains(entry.getKey())) continue;
                Assert.fail((String)("Properties file " + f + " differs from " + propFiles[0]));
            }
        }
    }

    public static void assertFileContentsSame(File ... files) throws Exception {
        if (files.length < 2) {
            return;
        }
        Map<File, String> md5s = FSImageTestUtil.getFileMD5s(files);
        if (new HashSet<String>(md5s.values()).size() > 1) {
            Assert.fail((String)("File contents differed:\n  " + Joiner.on((String)"\n  ").withKeyValueSeparator("=").join(md5s)));
        }
    }

    public static void assertFileContentsDifferent(int expectedUniqueHashes, File ... files) throws Exception {
        Map<File, String> md5s = FSImageTestUtil.getFileMD5s(files);
        int uniqueHashes = new HashSet<String>(md5s.values()).size();
        if (uniqueHashes != expectedUniqueHashes) {
            Assert.fail((String)("Expected " + expectedUniqueHashes + " different hashes, got:\n  " + Joiner.on((String)"\n  ").withKeyValueSeparator("=").join(md5s)));
        }
    }

    public static Map<File, String> getFileMD5s(File ... files) throws Exception {
        HashMap ret = Maps.newHashMap();
        for (File f : files) {
            Assert.assertTrue((String)("Must exist: " + f), (boolean)f.exists());
            ret.put(f, FSImageTestUtil.getFileMD5(f));
        }
        return ret;
    }

    public static List<File> getCurrentDirs(NNStorage storage, NNStorage.NameNodeDirType type) {
        ArrayList ret = Lists.newArrayList();
        for (Storage.StorageDirectory sd : storage.dirIterable(type)) {
            ret.add(sd.getCurrentDir());
        }
        return ret;
    }

    public static File findLatestImageFile(Storage.StorageDirectory sd) throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(sd);
        return inspector.getLatestImages().get(0).getFile();
    }

    public static File findNewestImageFile(String currentDirPath) throws IOException {
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory(new File(currentDirPath), NNStorage.NameNodeDirType.IMAGE);
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(sd);
        List<FSImageStorageInspector.FSImageFile> latestImages = inspector.getLatestImages();
        return latestImages.isEmpty() ? null : latestImages.get(0).getFile();
    }

    public static void assertNNHasCheckpoints(MiniDFSCluster cluster, List<Integer> txids) {
        FSImageTestUtil.assertNNHasCheckpoints(cluster, 0, txids);
    }

    public static void assertNNHasCheckpoints(MiniDFSCluster cluster, int nnIdx, List<Integer> txids) {
        for (File nameDir : FSImageTestUtil.getNameNodeCurrentDirs(cluster, nnIdx)) {
            LOG.info("examining name dir with files: " + Joiner.on((String)",").join((Object[])nameDir.listFiles()));
            LOG.info("Examining storage dir " + nameDir + " with contents: " + StringUtils.join((Object[])nameDir.listFiles(), (String)", "));
            Iterator<Integer> iterator = txids.iterator();
            while (iterator.hasNext()) {
                long checkpointTxId = iterator.next().intValue();
                File image = new File(nameDir, NNStorage.getImageFileName(checkpointTxId));
                Assert.assertTrue((String)("Expected non-empty " + image), (image.length() > 0L ? 1 : 0) != 0);
            }
        }
    }

    public static List<File> getNameNodeCurrentDirs(MiniDFSCluster cluster, int nnIdx) {
        ArrayList nameDirs = Lists.newArrayList();
        for (URI u : cluster.getNameDirs(nnIdx)) {
            nameDirs.add(new File(u.getPath(), "current"));
        }
        return nameDirs;
    }

    public static FileJournalManager.EditLogFile findLatestEditsLog(Storage.StorageDirectory sd) throws IOException {
        File currentDir = sd.getCurrentDir();
        ArrayList foundEditLogs = Lists.newArrayList(FileJournalManager.matchEditLogs(currentDir));
        return Collections.max(foundEditLogs, FileJournalManager.EditLogFile.COMPARE_BY_START_TXID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corruptVersionFile(File versionFile, String key, String value) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(versionFile);
        FileOutputStream out = null;
        try {
            props.load(fis);
            IOUtils.closeStream((Closeable)fis);
            if (value == null || value.isEmpty()) {
                props.remove(key);
            } else {
                props.setProperty(key, value);
            }
            out = new FileOutputStream(versionFile);
            props.store(out, null);
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream((Closeable)fis);
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fis);
        IOUtils.closeStream((Closeable)out);
    }

    public static void assertReasonableNameCurrentDir(File curDir) throws IOException {
        Assert.assertTrue((boolean)curDir.isDirectory());
        Assert.assertTrue((boolean)new File(curDir, "VERSION").isFile());
        Assert.assertTrue((boolean)new File(curDir, "seen_txid").isFile());
        File image = FSImageTestUtil.findNewestImageFile(curDir.toString());
        Assert.assertNotNull((Object)image);
    }

    public static void logStorageContents(Logger log, NNStorage storage) {
        log.info("current storages and corresponding sizes:");
        for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
            File curDir = sd.getCurrentDir();
            log.info("In directory " + curDir);
            Object[] files = curDir.listFiles();
            Arrays.sort(files);
            for (Object f : files) {
                log.info("  file " + ((File)f).getAbsolutePath() + "; len = " + ((File)f).length());
            }
        }
    }

    public static FSImage getFSImage(NameNode node) {
        return node.getFSImage();
    }

    public static long getNSQuota(FSNamesystem ns) {
        return ns.dir.rootDir.getQuotaCounts().getNameSpace();
    }

    public static void assertNNFilesMatch(MiniDFSCluster cluster) throws Exception {
        ArrayList curDirs = Lists.newArrayList();
        curDirs.addAll(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0));
        curDirs.addAll(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 1));
        ImmutableSet ignoredFiles = ImmutableSet.of((Object)"seen_txid");
        FSImageTestUtil.assertParallelFilesAreIdentical(curDirs, (Set<String>)ignoredFiles);
    }

    public static long getStorageTxId(NameNode node, URI storageUri) throws IOException {
        Storage.StorageDirectory sDir = FSImageTestUtil.getFSImage(node).getStorage().getStorageDirectory(storageUri);
        return NNStorage.readTransactionIdFile(sDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FsImageProto.FileSummary getLatestImageSummary(MiniDFSCluster cluster) throws IOException {
        try (RandomAccessFile raFile = null;){
            File image = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            raFile = new RandomAccessFile(image, "r");
            FsImageProto.FileSummary fileSummary = FSImageUtil.loadSummary(raFile);
            return fileSummary;
        }
    }
}

