/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.codehaus.jettison.mapped;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import org.apache.hadoop.shaded.org.codehaus.jettison.AbstractXMLStreamWriter;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONArray;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.NullNamespaceContext;
import org.apache.hadoop.shaded.org.codehaus.jettison.util.FastStack;

public class MappedXMLStreamWriter
extends AbstractXMLStreamWriter {
    MappedNamespaceConvention convention;
    JSONObject root;
    Object current;
    Writer writer;
    FastStack nodes = new FastStack();
    String currentKey;
    NamespaceContext ctx = new NullNamespaceContext();
    String valueKey = "$";

    public MappedXMLStreamWriter(MappedNamespaceConvention convention, Writer writer) {
        this.convention = convention;
        this.writer = writer;
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public NamespaceContext getNamespaceContext() {
        return this.ctx;
    }

    public String getPrefix(String arg0) throws XMLStreamException {
        return null;
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    public void setDefaultNamespace(String arg0) throws XMLStreamException {
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.ctx = context;
    }

    public void setPrefix(String arg0, String arg1) throws XMLStreamException {
    }

    public void writeAttribute(String p, String ns, String local, String value) throws XMLStreamException {
        if (this.convention.isElement(p, ns, local)) {
            this.writeStartElement(p, local, ns);
            this.writeCharacters(value);
            this.writeEndElement();
            return;
        }
        String key = this.convention.createAttributeKey(p, ns, local);
        try {
            Object o;
            if (this.current instanceof JSONArray) {
                JSONArray array = (JSONArray)this.current;
                this.current = array.get(array.length() - 1);
            }
            this.makeCurrentJSONObject();
            if (this.current instanceof JSONObject && (o = ((JSONObject)this.current).opt(key)) == null) {
                ((JSONObject)this.current).put(key, value);
            }
        }
        catch (JSONException e) {
            throw new XMLStreamException(e);
        }
    }

    private void makeCurrentJSONObject() throws JSONException {
        if (this.current.equals("")) {
            JSONObject newCurrent = new JSONObject();
            this.setNewValue(newCurrent);
            this.current = newCurrent;
            this.nodes.push(newCurrent);
        }
    }

    private void setNewValue(Object newCurrent) throws JSONException {
        if (this.isJsonPrimitive(this.current)) {
            this.setNewValue(newCurrent, this.nodes.peek());
        } else {
            this.setNewValue(newCurrent, this.current);
        }
    }

    private void setNewValue(Object newCurrent, Object node) throws JSONException {
        if (node instanceof JSONObject) {
            ((JSONObject)node).put(this.currentKey, newCurrent);
        } else if (node instanceof JSONArray) {
            JSONArray arr = (JSONArray)node;
            arr.put(arr.length() - 1, newCurrent);
        }
        this.current = newCurrent;
    }

    public void writeAttribute(String ns, String local, String value) throws XMLStreamException {
        this.writeAttribute(null, ns, local, value);
    }

    public void writeAttribute(String local, String value) throws XMLStreamException {
        this.writeAttribute(null, local, value);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        try {
            Object convertedPrimitive = this.convention.convertToJSONPrimitive(text);
            if (this.isJsonPrimitive(this.current)) {
                this.current = this.current instanceof String && convertedPrimitive instanceof String ? this.current + convertedPrimitive.toString() : convertedPrimitive;
                this.setNewValue(this.current);
            } else if (this.current instanceof JSONArray) {
                JSONArray arr = (JSONArray)this.current;
                if (arr.get(arr.length() - 1).equals("")) {
                    arr.put(arr.length() - 1, convertedPrimitive);
                } else {
                    arr.put(convertedPrimitive);
                }
                this.current = convertedPrimitive;
            } else if (this.current instanceof JSONObject && this.valueKey != null) {
                JSONObject obj = (JSONObject)this.current;
                obj.put(this.valueKey, text);
            }
        }
        catch (JSONException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeComment(String arg0) throws XMLStreamException {
    }

    public void writeDefaultNamespace(String ns) throws XMLStreamException {
    }

    public void writeDTD(String arg0) throws XMLStreamException {
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            this.root.write(this.writer);
            this.writer.flush();
        }
        catch (JSONException e) {
            throw new XMLStreamException(e);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.isJsonPrimitive(this.current)) {
            this.current = this.nodes.peek();
        } else if (this.nodes.size() > 1) {
            if (this.isEmptyArray(this.current)) {
                this.current = this.nodes.peek();
            } else {
                Object isArray = this.nodes.pop();
                this.current = this.nodes.peek();
                if (this.current instanceof JSONArray || isArray instanceof JSONArray) {
                    this.nodes.pop();
                    if (this.nodes.size() > 0) {
                        this.current = this.nodes.peek();
                    }
                }
            }
        }
    }

    public void writeEntityRef(String arg0) throws XMLStreamException {
    }

    public void writeNamespace(String arg0, String arg1) throws XMLStreamException {
    }

    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
    }

    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartElement(String prefix, String local, String ns) throws XMLStreamException {
        try {
            if (this.current == null) {
                this.root = new JSONObject();
                this.current = this.root;
                this.nodes.push(this.root);
            } else {
                this.makeCurrentJSONObject();
            }
            String previousKey = this.currentKey;
            this.currentKey = this.convention.createKey(prefix, ns, local);
            if (this.current instanceof JSONArray) {
                JSONArray array = (JSONArray)this.current;
                if (array.get(array.length() - 1).equals("")) {
                    if (this.getSerializedAsArrays().contains(this.currentKey)) {
                        JSONObject newNode = new JSONObject();
                        newNode.put(this.currentKey, "");
                        this.setNewValue(newNode);
                        this.nodes.push(newNode);
                        this.current = "";
                        JSONArray arr = new JSONArray();
                        arr.put("");
                        this.setNewValue(arr);
                    } else {
                        JSONObject newNode = new JSONObject();
                        newNode.put(this.currentKey, "");
                        this.setNewValue(newNode);
                        this.nodes.push(newNode);
                        this.current = "";
                    }
                } else if (array.get(array.length() - 1) instanceof JSONObject) {
                    array.put("");
                    this.nodes.push(array);
                } else if (!this.currentKey.equals(previousKey)) {
                    int i = 0;
                    while (!(this.current instanceof JSONObject)) {
                        if (i > 0) {
                            this.nodes.pop();
                        }
                        this.current = this.nodes.peek();
                        ++i;
                    }
                    this.setNewValue("");
                    this.current = "";
                }
            } else {
                JSONArray arr;
                Object maybe;
                Object next;
                Object o = ((JSONObject)this.current).opt(this.currentKey);
                if (o == null && this.nodes.size() > 2 && (next = this.nodes.get(this.nodes.size() - 2)) instanceof JSONObject && (maybe = ((JSONObject)next).opt(this.currentKey)) != null && maybe instanceof JSONObject) {
                    o = maybe;
                    this.nodes.pop();
                    this.current = this.nodes.pop();
                }
                if (o instanceof JSONObject || this.isJsonPrimitive(o)) {
                    arr = new JSONArray();
                    arr.put(o);
                    arr.put("");
                    this.setNewValue(arr);
                    this.current = arr;
                    this.nodes.push(arr);
                } else if (o instanceof JSONArray) {
                    this.current = "";
                    ((JSONArray)o).put("");
                    this.nodes.push(o);
                } else if (this.getSerializedAsArrays().contains(this.currentKey)) {
                    arr = new JSONArray();
                    arr.put("");
                    this.setNewValue(arr);
                } else {
                    this.setNewValue("");
                    this.current = "";
                }
            }
        }
        catch (JSONException e) {
            throw new XMLStreamException("Could not write start element!", e);
        }
    }

    private boolean isJsonPrimitive(Object o) {
        return o instanceof String || o instanceof Boolean || o instanceof Number;
    }

    private boolean isEmptyArray(Object o) throws XMLStreamException {
        JSONArray arr;
        if (o instanceof JSONArray && (arr = (JSONArray)o).length() == 1) {
            try {
                return arr.get(0).equals("");
            }
            catch (JSONException e) {
                throw new XMLStreamException("Could not read array value!", e);
            }
        }
        return false;
    }

    public void setValueKey(String valueKey) {
        this.valueKey = valueKey;
    }
}

