/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.shaded.org.mockito.AdditionalMatchers;
import org.apache.hadoop.shaded.org.mockito.ArgumentCaptor;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import org.apache.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.util.Preconditions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAsserts {
    static final Logger LOG = LoggerFactory.getLogger(MetricsAsserts.class);
    private static final double EPSILON = 1.0E-5;

    public static MetricsSystem mockMetricsSystem() {
        MetricsSystem ms = Mockito.mock(MetricsSystem.class);
        DefaultMetricsSystem.setInstance((MetricsSystem)ms);
        return ms;
    }

    public static MetricsRecordBuilder mockMetricsRecordBuilder() {
        final MetricsCollector mc = Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder rb = Mockito.mock(MetricsRecordBuilder.class, new Answer<Object>(){

            @Override
            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                StringBuilder sb = new StringBuilder();
                for (Object o : args) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(o));
                }
                String methodName = invocation.getMethod().getName();
                LOG.debug(methodName + ": " + sb);
                return methodName.equals("parent") || methodName.equals("endRecord") ? mc : invocation.getMock();
            }
        });
        Mockito.when(mc.addRecord(Mockito.anyString())).thenReturn(rb);
        Mockito.when(mc.addRecord(MetricsAsserts.anyInfo())).thenReturn(rb);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source, boolean all) {
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        MetricsCollector mc = rb.parent();
        source.getMetrics(mc, all);
        return rb;
    }

    public static MetricsRecordBuilder getMetrics(String name) {
        return MetricsAsserts.getMetrics(DefaultMetricsSystem.instance().getSource(name));
    }

    public static MetricsRecordBuilder getMetrics(MetricsSource source) {
        return MetricsAsserts.getMetrics(source, true);
    }

    public static MetricsInfo eqName(MetricsInfo info) {
        return Mockito.argThat(new InfoWithSameName(info));
    }

    public static MetricsInfo anyInfo() {
        return Mockito.argThat(new AnyInfo());
    }

    public static void assertGauge(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntGauge(name, rb));
    }

    public static int getIntGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Integer)captor.capture()).intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Integer)captor.getValue();
    }

    public static void assertCounter(String name, int expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getIntCounter(name, rb));
    }

    public static int getIntCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Integer)captor.capture()).intValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Integer)captor.getValue();
    }

    public static void assertGauge(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongGauge(name, rb));
    }

    public static long getLongGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Long)captor.capture()).longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Long)captor.getValue();
    }

    public static void assertGauge(String name, double expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getDoubleGauge(name, rb), (double)1.0E-5);
    }

    public static double getDoubleGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Double.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Double)captor.capture()).doubleValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Double)captor.getValue();
    }

    public static void assertCounter(String name, long expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (long)expected, (long)MetricsAsserts.getLongCounter(name, rb));
    }

    public static long getLongCounter(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Long)captor.capture()).longValue());
        MetricsAsserts.checkCaptured(captor, name);
        return (Long)captor.getValue();
    }

    public static long getLongCounterWithoutCheck(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addCounter(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Long)captor.capture()).longValue());
        return (Long)captor.getValue();
    }

    public static String getStringMetric(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        Mockito.verify(rb, Mockito.atLeast(0)).tag(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), (String)captor.capture());
        MetricsAsserts.checkCaptured(captor, name);
        return (String)captor.getValue();
    }

    public static void assertGauge(String name, float expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad value for metric " + name), (double)expected, (double)MetricsAsserts.getFloatGauge(name, rb), (double)1.0E-5);
    }

    public static float getFloatGauge(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Float.class);
        Mockito.verify(rb, Mockito.atLeast(0)).addGauge(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), ((Float)captor.capture()).floatValue());
        MetricsAsserts.checkCaptured(captor, name);
        return ((Float)captor.getValue()).floatValue();
    }

    private static void checkCaptured(ArgumentCaptor<?> captor, String name) {
        Assert.assertEquals((String)("Expected exactly one metric for name " + name), (long)1L, (long)captor.getAllValues().size());
    }

    public static void assertGauge(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, int expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertGauge(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertGauge(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounter(String name, long expected, MetricsSource source) {
        MetricsAsserts.assertCounter(name, expected, MetricsAsserts.getMetrics(source));
    }

    public static void assertCounterGt(String name, long greater, MetricsRecordBuilder rb) {
        Assert.assertTrue((String)("Bad value for metric " + name), (MetricsAsserts.getLongCounter(name, rb) > greater ? 1 : 0) != 0);
    }

    public static void assertCounterGt(String name, long greater, MetricsSource source) {
        MetricsAsserts.assertCounterGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertGaugeGt(String name, double greater, MetricsRecordBuilder rb) {
        Assert.assertTrue((String)("Bad value for metric " + name), (MetricsAsserts.getDoubleGauge(name, rb) > greater ? 1 : 0) != 0);
    }

    public static void assertGaugeGt(String name, double greater, MetricsSource source) {
        MetricsAsserts.assertGaugeGt(name, greater, MetricsAsserts.getMetrics(source));
    }

    public static void assertQuantileGauges(String prefix, MetricsRecordBuilder rb) {
        MetricsAsserts.assertQuantileGauges(prefix, rb, "Latency");
    }

    public static void assertQuantileGauges(String prefix, MetricsRecordBuilder rb, String valueName) {
        Mockito.verify(rb).addGauge(MetricsAsserts.eqName(Interns.info((String)(prefix + "NumOps"), (String)"")), AdditionalMatchers.geq(0L));
        for (Quantile q : MutableQuantiles.quantiles) {
            String nameTemplate = prefix + "%dthPercentile" + valueName;
            int percentile = (int)(100.0 * q.quantile);
            Mockito.verify(rb).addGauge(MetricsAsserts.eqName(Interns.info((String)String.format(nameTemplate, percentile), (String)"")), AdditionalMatchers.geq(0L));
        }
    }

    public static void assertTag(String name, String expected, MetricsRecordBuilder rb) {
        Assert.assertEquals((String)("Bad Tag for metric " + name), (Object)expected, (Object)MetricsAsserts.getStringTag(name, rb));
    }

    public static String getStringTag(String name, MetricsRecordBuilder rb) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        Mockito.verify(rb).tag(MetricsAsserts.eqName(Interns.info((String)name, (String)"")), (String)captor.capture());
        MetricsAsserts.checkCaptured(captor, name);
        return (String)captor.getValue();
    }

    private static class AnyInfo
    implements ArgumentMatcher<MetricsInfo> {
        private AnyInfo() {
        }

        @Override
        public boolean matches(MetricsInfo info) {
            return info != null;
        }
    }

    private static class InfoWithSameName
    implements ArgumentMatcher<MetricsInfo> {
        private final String expected;

        InfoWithSameName(MetricsInfo info) {
            this.expected = (String)Preconditions.checkNotNull((Object)info.name(), (Object)"info name");
        }

        @Override
        public boolean matches(MetricsInfo info) {
            return this.expected.equals(info.name());
        }

        public String toString() {
            return "Info with name=" + this.expected;
        }
    }
}

