/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.shaded.com.zaxxer.hikari.HikariDataSource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreRetriableException;
import org.apache.hadoop.yarn.server.federation.store.metrics.FederationStateStoreClientMetrics;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationStateStoreUtils {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreUtils.class);
    public static final String FEDERATION_STORE_URL = "url";

    private FederationStateStoreUtils() {
    }

    public static void returnToPool(Logger log, CallableStatement cstmt, Connection conn, ResultSet rs) throws YarnException {
        if (cstmt != null) {
            try {
                cstmt.close();
            }
            catch (SQLException e) {
                FederationStateStoreUtils.logAndThrowException(log, "Exception while trying to close Statement", e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
                FederationStateStoreClientMetrics.decrConnections();
            }
            catch (SQLException e) {
                FederationStateStoreUtils.logAndThrowException(log, "Exception while trying to close Connection", e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                FederationStateStoreUtils.logAndThrowException(log, "Exception while trying to close ResultSet", e);
            }
        }
    }

    public static void returnToPool(Logger log, CallableStatement cstmt, Connection conn) throws YarnException {
        FederationStateStoreUtils.returnToPool(log, cstmt, conn, null);
    }

    public static void returnToPool(Logger log, CallableStatement cstmt) throws YarnException {
        FederationStateStoreUtils.returnToPool(log, cstmt, null);
    }

    public static void logAndThrowException(Logger log, String errMsg, Throwable t) throws YarnException {
        if (t != null) {
            log.error(errMsg, t);
            throw new YarnException(errMsg, t);
        }
        log.error(errMsg);
        throw new YarnException(errMsg);
    }

    public static void logAndThrowStoreException(Logger log, String errMsg) throws YarnException {
        log.error(errMsg);
        throw new FederationStateStoreException(errMsg);
    }

    public static void logAndThrowStoreException(Logger log, String errMsgFormat, Object ... args) throws YarnException {
        String errMsg = String.format(errMsgFormat, args);
        log.error(errMsg);
        throw new FederationStateStoreException(errMsg);
    }

    public static void logAndThrowInvalidInputException(Logger log, String errMsg) throws YarnException {
        log.error(errMsg);
        throw new FederationStateStoreInvalidInputException(errMsg);
    }

    public static void logAndThrowRetriableException(Logger log, String errMsg, Throwable t) throws YarnException {
        if (t != null) {
            log.error(errMsg, t);
            throw new FederationStateStoreRetriableException(errMsg, t);
        }
        log.error(errMsg);
        throw new FederationStateStoreRetriableException(errMsg);
    }

    public static void logAndThrowRetriableException(Throwable t, Logger log, String errMsgFormat, Object ... args) throws YarnException {
        String errMsg = String.format(errMsgFormat, args);
        if (t != null) {
            log.error(errMsg, t);
            throw new FederationStateStoreRetriableException(errMsg, t);
        }
        log.error(errMsg);
        throw new FederationStateStoreRetriableException(errMsg);
    }

    public static void logAndThrowRetriableException(Logger log, String errMsgFormat, Object ... args) throws YarnException {
        String errMsg = String.format(errMsgFormat, args);
        log.error(errMsg);
        throw new FederationStateStoreRetriableException(errMsg);
    }

    public static void setProperty(HikariDataSource dataSource, String property, String value) {
        LOG.debug("Setting property {} with value {}", (Object)property, (Object)value);
        if (property != null && !property.isEmpty() && value != null) {
            dataSource.addDataSourceProperty(property, value);
        }
    }

    public static void setUsername(HikariDataSource dataSource, String userNameDB) {
        if (userNameDB != null) {
            dataSource.setUsername(userNameDB);
            LOG.debug("Setting non NULL Username for Store connection");
        } else {
            LOG.debug("NULL Username specified for Store connection, so ignoring");
        }
    }

    public static void setPassword(HikariDataSource dataSource, String password) {
        if (password != null) {
            dataSource.setPassword(password);
            LOG.debug("Setting non NULL Credentials for Store connection");
        } else {
            LOG.debug("NULL Credentials specified for Store connection, so ignoring");
        }
    }

    public static boolean filterHomeSubCluster(SubClusterId filterSubCluster, SubClusterId homeSubCluster) {
        if (filterSubCluster == null) {
            return true;
        }
        return filterSubCluster.equals(homeSubCluster);
    }
}

