/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.CSQueueMetricsForCustomResources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@Metrics(context="yarn")
public class CSQueueMetrics
extends QueueMetrics {
    @Metric(value={"AM memory limit in MB"})
    MutableGaugeLong AMResourceLimitMB;
    @Metric(value={"AM CPU limit in virtual cores"})
    MutableGaugeLong AMResourceLimitVCores;
    @Metric(value={"Used AM memory limit in MB"})
    MutableGaugeLong usedAMResourceMB;
    @Metric(value={"Used AM CPU limit in virtual cores"})
    MutableGaugeLong usedAMResourceVCores;
    @Metric(value={"Percent of Capacity Used"})
    MutableGaugeFloat usedCapacity;
    @Metric(value={"Percent of Absolute Capacity Used"})
    MutableGaugeFloat absoluteUsedCapacity;
    @Metric(value={"Guaranteed memory in MB"})
    MutableGaugeLong guaranteedMB;
    @Metric(value={"Guaranteed CPU in virtual cores"})
    MutableGaugeInt guaranteedVCores;
    @Metric(value={"Maximum memory in MB"})
    MutableGaugeLong maxCapacityMB;
    @Metric(value={"Maximum CPU in virtual cores"})
    MutableGaugeInt maxCapacityVCores;
    @Metric(value={"Guaranteed capacity in percentage relative to parent"})
    private MutableGaugeFloat guaranteedCapacity;
    @Metric(value={"Guaranteed capacity in percentage relative to total partition"})
    private MutableGaugeFloat guaranteedAbsoluteCapacity;
    @Metric(value={"Maximum capacity in percentage relative to parent"})
    private MutableGaugeFloat maxCapacity;
    @Metric(value={"Maximum capacity in percentage relative to total partition"})
    private MutableGaugeFloat maxAbsoluteCapacity;
    private static final String GUARANTEED_CAPACITY_METRIC_PREFIX = "GuaranteedCapacity.";
    private static final String GUARANTEED_CAPACITY_METRIC_DESC = "GuaranteedCapacity of NAME";
    private static final String MAX_CAPACITY_METRIC_PREFIX = "MaxCapacity.";
    private static final String MAX_CAPACITY_METRIC_DESC = "MaxCapacity of NAME";
    private CSQueueMetricsForCustomResources csQueueMetricsForCustomResources;

    CSQueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        super(ms, queueName, parent, enableUserMetrics, conf);
    }

    @Override
    protected void registerCustomResources() {
        Map customResources = this.csQueueMetricsForCustomResources.initAndGetCustomResources();
        this.csQueueMetricsForCustomResources.registerCustomResources(customResources, this.registry, GUARANTEED_CAPACITY_METRIC_PREFIX, GUARANTEED_CAPACITY_METRIC_DESC);
        this.csQueueMetricsForCustomResources.registerCustomResources(customResources, this.registry, MAX_CAPACITY_METRIC_PREFIX, MAX_CAPACITY_METRIC_DESC);
        super.registerCustomResources();
    }

    public long getAMResourceLimitMB() {
        return this.AMResourceLimitMB.value();
    }

    public long getAMResourceLimitVCores() {
        return this.AMResourceLimitVCores.value();
    }

    public long getUsedAMResourceMB() {
        return this.usedAMResourceMB.value();
    }

    public long getUsedAMResourceVCores() {
        return this.usedAMResourceVCores.value();
    }

    public void setAMResouceLimit(String partition, Resource res) {
        if (partition == null || partition.equals("")) {
            this.AMResourceLimitMB.set(res.getMemorySize());
            this.AMResourceLimitVCores.set((long)res.getVirtualCores());
        }
    }

    public void setAMResouceLimitForUser(String partition, String user, Resource res) {
        CSQueueMetrics userMetrics = (CSQueueMetrics)this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.setAMResouceLimit(partition, res);
        }
    }

    public void incAMUsed(String partition, String user, Resource res) {
        if (partition == null || partition.equals("")) {
            this.usedAMResourceMB.incr(res.getMemorySize());
            this.usedAMResourceVCores.incr((long)res.getVirtualCores());
            CSQueueMetrics userMetrics = (CSQueueMetrics)this.getUserMetrics(user);
            if (userMetrics != null) {
                userMetrics.incAMUsed(partition, user, res);
            }
        }
    }

    public void decAMUsed(String partition, String user, Resource res) {
        if (partition == null || partition.equals("")) {
            this.usedAMResourceMB.decr(res.getMemorySize());
            this.usedAMResourceVCores.decr((long)res.getVirtualCores());
            CSQueueMetrics userMetrics = (CSQueueMetrics)this.getUserMetrics(user);
            if (userMetrics != null) {
                userMetrics.decAMUsed(partition, user, res);
            }
        }
    }

    public float getUsedCapacity() {
        return this.usedCapacity.value();
    }

    public void setUsedCapacity(String partition, float usedCap) {
        if (partition == null || partition.equals("")) {
            this.usedCapacity.set(usedCap);
        }
    }

    public float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity.value();
    }

    public void setAbsoluteUsedCapacity(String partition, Float absoluteUsedCap) {
        if (partition == null || partition.equals("")) {
            this.absoluteUsedCapacity.set(absoluteUsedCap.floatValue());
        }
    }

    public long getGuaranteedMB() {
        return this.guaranteedMB.value();
    }

    public int getGuaranteedVCores() {
        return this.guaranteedVCores.value();
    }

    public void setGuaranteedResources(String partition, Resource res) {
        if (partition == null || partition.equals("")) {
            this.guaranteedMB.set(res.getMemorySize());
            this.guaranteedVCores.set(res.getVirtualCores());
            if (this.csQueueMetricsForCustomResources != null) {
                this.csQueueMetricsForCustomResources.setGuaranteedCapacity(res);
                this.csQueueMetricsForCustomResources.registerCustomResources(this.csQueueMetricsForCustomResources.getGuaranteedCapacity(), this.registry, GUARANTEED_CAPACITY_METRIC_PREFIX, GUARANTEED_CAPACITY_METRIC_DESC);
            }
        }
    }

    public long getMaxCapacityMB() {
        return this.maxCapacityMB.value();
    }

    public int getMaxCapacityVCores() {
        return this.maxCapacityVCores.value();
    }

    public void setMaxCapacityResources(String partition, Resource res) {
        if (partition == null || partition.equals("")) {
            this.maxCapacityMB.set(res.getMemorySize());
            this.maxCapacityVCores.set(res.getVirtualCores());
            if (this.csQueueMetricsForCustomResources != null) {
                this.csQueueMetricsForCustomResources.setMaxCapacity(res);
                this.csQueueMetricsForCustomResources.registerCustomResources(this.csQueueMetricsForCustomResources.getMaxCapacity(), this.registry, MAX_CAPACITY_METRIC_PREFIX, MAX_CAPACITY_METRIC_DESC);
            }
        }
    }

    @Override
    protected void createQueueMetricsForCustomResources() {
        if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
            this.csQueueMetricsForCustomResources = new CSQueueMetricsForCustomResources();
            this.setQueueMetricsForCustomResources(this.csQueueMetricsForCustomResources);
            this.registerCustomResources();
        }
    }

    public static synchronized CSQueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        QueueMetrics metrics = CSQueueMetrics.getQueueMetrics().get(queueName);
        if (metrics == null) {
            metrics = new CSQueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                MetricsSource source = ms.getSource(CSQueueMetrics.sourceName(queueName).toString());
                if (source != null) {
                    ms.unregisterSource(CSQueueMetrics.sourceName(queueName).toString());
                }
                metrics = (QueueMetrics)ms.register(CSQueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            CSQueueMetrics.getQueueMetrics().put(queueName, metrics);
        }
        return (CSQueueMetrics)metrics;
    }

    @Override
    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        CSQueueMetrics metrics = (CSQueueMetrics)this.users.get(userName);
        if (metrics == null) {
            metrics = new CSQueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf);
            this.users.put(userName, metrics);
            this.registerMetrics(CSQueueMetrics.sourceName(this.queueName).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", ((CSQueueMetrics)metrics.tag(QUEUE_INFO, this.queueName)).tag(USER_INFO, userName));
        }
        return metrics;
    }

    public float getGuaranteedCapacity() {
        return this.guaranteedCapacity.value();
    }

    public float getGuaranteedAbsoluteCapacity() {
        return this.guaranteedAbsoluteCapacity.value();
    }

    public void setGuaranteedCapacities(String partition, float capacity, float absoluteCapacity) {
        if (partition == null || partition.equals("")) {
            this.guaranteedCapacity.set(capacity);
            this.guaranteedAbsoluteCapacity.set(absoluteCapacity);
        }
    }

    public float getMaxCapacity() {
        return this.maxCapacity.value();
    }

    public float getMaxAbsoluteCapacity() {
        return this.maxAbsoluteCapacity.value();
    }

    public void setMaxCapacities(String partition, float capacity, float absoluteCapacity) {
        if (partition == null || partition.equals("")) {
            this.maxCapacity.set(capacity);
            this.maxAbsoluteCapacity.set(absoluteCapacity);
        }
    }
}

