/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class ResourceVector
implements Iterable<Map.Entry<String, Float>> {
    private final Map<String, Float> resourcesByName = new HashMap<String, Float>();

    public static ResourceVector newInstance() {
        ResourceVector zeroResourceVector = new ResourceVector();
        for (ResourceInformation resource : ResourceUtils.getResourceTypesArray()) {
            zeroResourceVector.setValue(resource.getName(), 0.0f);
        }
        return zeroResourceVector;
    }

    public static ResourceVector of(float value) {
        ResourceVector emptyResourceVector = new ResourceVector();
        for (ResourceInformation resource : ResourceUtils.getResourceTypesArray()) {
            emptyResourceVector.setValue(resource.getName(), value);
        }
        return emptyResourceVector;
    }

    public static ResourceVector of(Resource resource) {
        ResourceVector resourceVector = new ResourceVector();
        for (ResourceInformation resourceInformation : resource.getResources()) {
            resourceVector.setValue(resourceInformation.getName(), resourceInformation.getValue());
        }
        return resourceVector;
    }

    public void subtract(ResourceVector otherResourceVector) {
        for (Map.Entry<String, Float> resource : otherResourceVector) {
            this.setValue(resource.getKey(), this.getValue(resource.getKey()).floatValue() - resource.getValue().floatValue());
        }
    }

    public void increment(String resourceName, float value) {
        this.setValue(resourceName, this.getValue(resourceName).floatValue() + value);
    }

    public Float getValue(String resourceName) {
        return this.resourcesByName.get(resourceName);
    }

    public void setValue(String resourceName, float value) {
        this.resourcesByName.put(resourceName, Float.valueOf(value));
    }

    @Override
    public Iterator<Map.Entry<String, Float>> iterator() {
        return this.resourcesByName.entrySet().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.resourcesByName.equals(((ResourceVector)o).resourcesByName);
    }

    public int hashCode() {
        return this.resourcesByName.hashCode();
    }
}

