/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Shell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class TestWinUtils {
    private static final Log LOG = LogFactory.getLog(TestWinUtils.class);
    private static File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestWinUtils.class.getSimpleName());

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)Shell.WINDOWS);
        TEST_DIR.mkdirs();
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    private void writeFile(File file, String content) throws IOException {
        byte[] data = content.getBytes();
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
    }

    private String readFile(File file) throws IOException {
        FileInputStream fos = new FileInputStream(file);
        byte[] b = new byte[100];
        fos.read(b);
        return b.toString();
    }

    @Test(timeout=30000L)
    public void testLs() throws IOException {
        String content = "6bytes";
        int contentSize = "6bytes".length();
        File testFile = new File(TEST_DIR, "file1");
        this.writeFile(testFile, "6bytes");
        String output = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "ls", testFile.getCanonicalPath()});
        String[] outputArgs = output.split("[ \r\n]");
        Assert.assertTrue((boolean)outputArgs[0].equals("-rwx------"));
        Assert.assertTrue((boolean)outputArgs[outputArgs.length - 1].equals(testFile.getCanonicalPath()));
        output = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "ls", "-F", testFile.getCanonicalPath()});
        outputArgs = output.split("[|\r\n]");
        Assert.assertEquals((long)9L, (long)outputArgs.length);
        Assert.assertTrue((boolean)outputArgs[0].equals("-rwx------"));
        Assert.assertEquals((long)contentSize, (long)Long.parseLong(outputArgs[4]));
        Assert.assertTrue((boolean)outputArgs[8].equals(testFile.getCanonicalPath()));
        testFile.delete();
        Assert.assertFalse((boolean)testFile.exists());
    }

    @Test(timeout=30000L)
    public void testGroups() throws IOException {
        String currentUser = System.getProperty("user.name");
        String outputNoArgs = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "groups"}).trim();
        String output = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "groups", currentUser}).trim();
        Assert.assertEquals((Object)output, (Object)outputNoArgs);
        String outputFormat = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "groups", "-F", currentUser}).trim();
        outputFormat = outputFormat.replace("|", " ");
        Assert.assertEquals((Object)output, (Object)outputFormat);
    }

    private void chmod(String mask, File file) throws IOException {
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "chmod", mask, file.getCanonicalPath()});
    }

    private void chmodR(String mask, File file) throws IOException {
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "chmod", "-R", mask, file.getCanonicalPath()});
    }

    private String ls(File file) throws IOException {
        return Shell.execCommand((String[])new String[]{Shell.WINUTILS, "ls", file.getCanonicalPath()});
    }

    private String lsF(File file) throws IOException {
        return Shell.execCommand((String[])new String[]{Shell.WINUTILS, "ls", "-F", file.getCanonicalPath()});
    }

    private void assertPermissions(File file, String expected) throws IOException {
        String output = this.ls(file).split("[ \r\n]")[0];
        Assert.assertEquals((Object)expected, (Object)output);
    }

    private void testChmodInternal(String mode, String expectedPerm) throws IOException {
        File a = new File(TEST_DIR, "file1");
        Assert.assertTrue((boolean)a.createNewFile());
        this.chmod("700", a);
        this.chmod(mode, a);
        this.assertPermissions(a, expectedPerm);
        a.delete();
        Assert.assertFalse((boolean)a.exists());
    }

    private void testNewFileChmodInternal(String expectedPerm) throws IOException {
        File dir = new File(TEST_DIR, "dir1");
        Assert.assertTrue((boolean)dir.mkdir());
        this.chmod("755", dir);
        File child = new File(dir, "file1");
        Assert.assertTrue((boolean)child.createNewFile());
        this.assertPermissions(child, expectedPerm);
        child.delete();
        dir.delete();
        Assert.assertFalse((boolean)dir.exists());
    }

    private void testChmodInternalR(String mode, String expectedPerm, String expectedPermx) throws IOException {
        File a = new File(TEST_DIR, "a");
        Assert.assertTrue((boolean)a.mkdir());
        this.chmod("700", a);
        File aa = new File(a, "a");
        Assert.assertTrue((boolean)aa.createNewFile());
        this.chmod("600", aa);
        File ab = new File(a, "b");
        Assert.assertTrue((boolean)ab.mkdir());
        this.chmod("700", ab);
        File aba = new File(ab, "a");
        Assert.assertTrue((boolean)aba.mkdir());
        this.chmod("700", aba);
        File abb = new File(ab, "b");
        Assert.assertTrue((boolean)abb.createNewFile());
        this.chmod("600", abb);
        File abx = new File(ab, "x");
        Assert.assertTrue((boolean)abx.createNewFile());
        this.chmod("u+x", abx);
        this.chmodR(mode, a);
        this.assertPermissions(a, "d" + expectedPermx);
        this.assertPermissions(aa, "-" + expectedPerm);
        this.assertPermissions(ab, "d" + expectedPermx);
        this.assertPermissions(aba, "d" + expectedPermx);
        this.assertPermissions(abb, "-" + expectedPerm);
        this.assertPermissions(abx, "-" + expectedPermx);
        Assert.assertTrue((boolean)FileUtil.fullyDelete((File)a));
    }

    @Test(timeout=30000L)
    public void testBasicChmod() throws IOException {
        File a = new File(TEST_DIR, "a");
        a.createNewFile();
        this.chmod("377", a);
        try {
            this.readFile(a);
            Assert.assertFalse((String)"readFile should have failed!", (boolean)true);
        }
        catch (IOException ex) {
            LOG.info((Object)"Expected: Failed read from a file with permissions 377");
        }
        this.chmod("700", a);
        this.chmod("577", a);
        try {
            this.writeFile(a, "test");
            Assert.assertFalse((String)"writeFile should have failed!", (boolean)true);
        }
        catch (IOException ex) {
            LOG.info((Object)"Expected: Failed write to a file with permissions 577");
        }
        this.chmod("700", a);
        Assert.assertTrue((boolean)a.delete());
        File winutilsFile = new File(Shell.WINUTILS);
        File aExe = new File(TEST_DIR, "a.exe");
        FileUtils.copyFile((File)winutilsFile, (File)aExe);
        this.chmod("677", aExe);
        try {
            Shell.execCommand((String[])new String[]{aExe.getCanonicalPath(), "ls"});
            Assert.assertFalse((String)("executing " + aExe + " should have failed!"), (boolean)true);
        }
        catch (IOException ex) {
            LOG.info((Object)"Expected: Failed to execute a file with permissions 677");
        }
        Assert.assertTrue((boolean)aExe.delete());
    }

    @Test(timeout=30000L)
    public void testBasicChmodOnDir() throws IOException {
        File a = new File(TEST_DIR, "a");
        File b = new File(a, "b");
        a.mkdirs();
        Assert.assertTrue((boolean)b.createNewFile());
        this.chmod("300", a);
        String[] files = a.list();
        Assert.assertTrue((String)"Listing a directory without read permission should fail", (null == files ? 1 : 0) != 0);
        this.chmod("700", a);
        files = a.list();
        Assert.assertEquals((Object)"b", (Object)files[0]);
        this.chmod("500", a);
        File c = new File(a, "c");
        try {
            c.createNewFile();
            Assert.assertFalse((String)"writeFile should have failed!", (boolean)true);
        }
        catch (IOException ex) {
            LOG.info((Object)"Expected: Failed to create a file when directory permissions are 577");
        }
        Assert.assertTrue((String)"Special behavior: deleting a file will succeed on Windows even if a user does not have write permissions on the parent dir", (boolean)b.delete());
        Assert.assertFalse((String)"Renaming a file should fail on the dir where a user does not have write permissions", (boolean)b.renameTo(new File(a, "d")));
        this.chmod("700", a);
        Assert.assertTrue((boolean)c.createNewFile());
        File d = new File(a, "d");
        Assert.assertTrue((boolean)c.renameTo(d));
        this.chmod("600", a);
        files = a.list();
        Assert.assertEquals((Object)"d", (Object)files[0]);
        Assert.assertTrue((boolean)d.delete());
        File e = new File(a, "e");
        Assert.assertTrue((boolean)e.createNewFile());
        Assert.assertTrue((boolean)e.renameTo(new File(a, "f")));
        this.chmod("700", a);
    }

    @Test(timeout=30000L)
    public void testChmod() throws IOException {
        this.testChmodInternal("7", "-------rwx");
        this.testChmodInternal("70", "----rwx---");
        this.testChmodInternal("u-x,g+r,o=g", "-rw-r--r--");
        this.testChmodInternal("u-x,g+rw", "-rw-rw----");
        this.testChmodInternal("u-x,g+rwx-x,o=u", "-rw-rw-rw-");
        this.testChmodInternal("+", "-rwx------");
        this.testChmodInternalR("755", "rwxr-xr-x", "rwxr-xr-x");
        this.testChmodInternalR("u-x,g+r,o=g", "rw-r--r--", "rw-r--r--");
        this.testChmodInternalR("u-x,g+rw", "rw-rw----", "rw-rw----");
        this.testChmodInternalR("u-x,g+rwx-x,o=u", "rw-rw-rw-", "rw-rw-rw-");
        this.testChmodInternalR("a+rX", "rw-r--r--", "rwxr-xr-x");
        this.testNewFileChmodInternal("-rwxr-xr-x");
    }

    private void chown(String userGroup, File file) throws IOException {
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "chown", userGroup, file.getCanonicalPath()});
    }

    private void assertOwners(File file, String expectedUser, String expectedGroup) throws IOException {
        String[] args = this.lsF(file).trim().split("[\\|]");
        Assert.assertEquals((Object)expectedUser.toLowerCase(), (Object)args[2].toLowerCase());
        Assert.assertEquals((Object)expectedGroup.toLowerCase(), (Object)args[3].toLowerCase());
    }

    @Test(timeout=30000L)
    public void testChown() throws IOException {
        File a = new File(TEST_DIR, "a");
        Assert.assertTrue((boolean)a.createNewFile());
        String username = System.getProperty("user.name");
        String qualifiedUsername = Shell.execCommand((String[])new String[]{"whoami"}).trim();
        String admins = "Administrators";
        String qualifiedAdmins = "BUILTIN\\Administrators";
        this.chown(username + ":" + admins, a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        this.chown(username, a);
        this.chown(":" + admins, a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        this.chown(":" + admins, a);
        this.chown(username + ":", a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        Assert.assertTrue((boolean)a.delete());
        Assert.assertFalse((boolean)a.exists());
    }

    @Test(timeout=30000L)
    public void testSymlinkRejectsForwardSlashesInLink() throws IOException {
        File newFile = new File(TEST_DIR, "file");
        Assert.assertTrue((boolean)newFile.createNewFile());
        String target = newFile.getPath();
        String link = new File(TEST_DIR, "link").getPath().replaceAll("\\\\", "/");
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "symlink", link, target});
            Assert.fail((String)String.format("did not receive expected failure creating symlink with forward slashes in link: link = %s, target = %s", link, target));
        }
        catch (IOException e) {
            LOG.info((Object)"Expected: Failed to create symlink with forward slashes in target");
        }
    }

    @Test(timeout=30000L)
    public void testSymlinkRejectsForwardSlashesInTarget() throws IOException {
        File newFile = new File(TEST_DIR, "file");
        Assert.assertTrue((boolean)newFile.createNewFile());
        String target = newFile.getPath().replaceAll("\\\\", "/");
        String link = new File(TEST_DIR, "link").getPath();
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "symlink", link, target});
            Assert.fail((String)String.format("did not receive expected failure creating symlink with forward slashes in target: link = %s, target = %s", link, target));
        }
        catch (IOException e) {
            LOG.info((Object)"Expected: Failed to create symlink with forward slashes in target");
        }
    }

    @Test(timeout=30000L)
    public void testReadLink() throws IOException {
        File dir1 = new File(TEST_DIR, "dir1");
        Assert.assertTrue((boolean)dir1.mkdirs());
        File file1 = new File(dir1, "file1.txt");
        Assert.assertTrue((boolean)file1.createNewFile());
        File dirLink = new File(TEST_DIR, "dlink");
        File fileLink = new File(TEST_DIR, "flink");
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "symlink", dirLink.toString(), dir1.toString()});
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "symlink", fileLink.toString(), file1.toString()});
        String readLinkOutput = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", dirLink.toString()});
        Assert.assertThat((Object)readLinkOutput, (Matcher)CoreMatchers.equalTo((Object)dir1.toString()));
        readLinkOutput = Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", fileLink.toString()});
        Assert.assertThat((Object)readLinkOutput, (Matcher)CoreMatchers.equalTo((Object)file1.toString()));
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", ""});
            Assert.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assert.assertThat((Object)ece.getExitCode(), (Matcher)CoreMatchers.is((Object)1));
        }
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", "ThereIsNoSuchLink"});
            Assert.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assert.assertThat((Object)ece.getExitCode(), (Matcher)CoreMatchers.is((Object)1));
        }
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", dir1.toString()});
            Assert.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assert.assertThat((Object)ece.getExitCode(), (Matcher)CoreMatchers.is((Object)1));
        }
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", file1.toString()});
            Assert.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assert.assertThat((Object)ece.getExitCode(), (Matcher)CoreMatchers.is((Object)1));
        }
        try {
            Shell.execCommand((String[])new String[]{Shell.WINUTILS, "readlink", "a", "b"});
            Assert.fail((String)"Failed to get Shell.ExitCodeException with bad parameters");
        }
        catch (Shell.ExitCodeException ece) {
            Assert.assertThat((Object)ece.getExitCode(), (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test(timeout=10000L)
    public void testTaskCreate() throws IOException {
        File batch = new File(TEST_DIR, "testTaskCreate.cmd");
        File proof = new File(TEST_DIR, "testTaskCreate.out");
        FileWriter fw = new FileWriter(batch);
        String testNumber = String.format("%f", Math.random());
        fw.write(String.format("echo %s > \"%s\"", testNumber, proof.getAbsolutePath()));
        fw.close();
        Assert.assertFalse((boolean)proof.exists());
        Shell.execCommand((String[])new String[]{Shell.WINUTILS, "task", "create", "testTaskCreate" + testNumber, batch.getAbsolutePath()});
        Assert.assertTrue((boolean)proof.exists());
        String outNumber = FileUtils.readFileToString((File)proof);
        Assert.assertThat((Object)outNumber, (Matcher)JUnitMatchers.containsString((String)testNumber));
    }
}

