/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestCodec {
    private static final Log LOG = LogFactory.getLog(TestCodec.class);
    private Configuration conf = new Configuration();
    private int count = 10000;
    private int seed = new Random().nextInt();

    @Test
    public void testDefaultCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.DefaultCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.DefaultCodec");
    }

    @Test
    public void testGzipCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    @Test(timeout=20000L)
    public void testBZip2Codec() throws IOException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "java-builtin");
        TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
        TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    @Test(timeout=20000L)
    public void testBZip2NativeCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "system-native");
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            if (Bzip2Factory.isNativeBzip2Loaded((Configuration)conf)) {
                TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
                TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
                conf.set("io.compression.codec.bzip2.library", "java-builtin");
                TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
                TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
            } else {
                LOG.warn((Object)"Native hadoop library available but native bzip2 is not");
            }
        }
    }

    @Test
    public void testSnappyCodec() throws IOException {
        if (SnappyCodec.isNativeCodeLoaded()) {
            TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.SnappyCodec");
            TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.SnappyCodec");
        }
    }

    @Test
    public void testLz4Codec() throws IOException {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            if (Lz4Codec.isNativeCodeLoaded()) {
                this.conf.setBoolean("io.compression.codec.lz4.use.lz4hc", false);
                TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.Lz4Codec");
                TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.Lz4Codec");
                this.conf.setBoolean("io.compression.codec.lz4.use.lz4hc", true);
                TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.Lz4Codec");
                TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.Lz4Codec");
            } else {
                Assert.fail((String)"Native hadoop library available but lz4 not");
            }
        }
    }

    @Test
    public void testDeflateCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.DeflateCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.DeflateCodec");
    }

    @Test
    public void testGzipCodecWithParam() throws IOException {
        Configuration conf = new Configuration(this.conf);
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        ZlibFactory.setCompressionStrategy((Configuration)conf, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.HUFFMAN_ONLY);
        TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
        TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    private static void codecTest(Configuration conf, int seed, int count, String codecClass) throws IOException {
        Throwable throwable;
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        LOG.info((Object)("Created a Codec object of type: " + codecClass));
        DataOutputBuffer data = new DataOutputBuffer();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        LOG.info((Object)("Generated " + count + " records"));
        DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
        int leasedCompressorsBefore = codec.getCompressorType() == null ? -1 : CodecPool.getLeasedCompressorsCount((CompressionCodec)codec);
        try (CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)compressedDataBuffer);
             DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));){
            deflateOut.write(data.getData(), 0, data.getLength());
            deflateOut.flush();
            deflateFilter.finish();
        }
        if (leasedCompressorsBefore > -1) {
            Assert.assertEquals((String)"leased compressor not returned to the codec pool", (long)leasedCompressorsBefore, (long)CodecPool.getLeasedCompressorsCount((CompressionCodec)codec));
        }
        LOG.info((Object)"Finished compressing data");
        DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        DataInputBuffer originalData = new DataInputBuffer();
        int leasedDecompressorsBefore = CodecPool.getLeasedDecompressorsCount((CompressionCodec)codec);
        try (CompressionInputStream inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);){
            throwable = null;
            try (DataInputStream inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));){
                originalData.reset(data.getData(), 0, data.getLength());
                DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
                for (int i = 0; i < count; ++i) {
                    RandomDatum k1 = new RandomDatum();
                    RandomDatum v1 = new RandomDatum();
                    k1.readFields(originalIn);
                    v1.readFields(originalIn);
                    RandomDatum k2 = new RandomDatum();
                    RandomDatum v2 = new RandomDatum();
                    k2.readFields(inflateIn);
                    v2.readFields(inflateIn);
                    Assert.assertTrue((String)"original and compressed-then-decompressed-output not equal", (k1.equals(k2) && v1.equals(v2) ? 1 : 0) != 0);
                    HashMap<RandomDatum, String> m = new HashMap<RandomDatum, String>();
                    m.put(k1, k1.toString());
                    m.put(v1, v1.toString());
                    String result = (String)m.get(k2);
                    Assert.assertEquals((String)"k1 and k2 hashcode not equal", (Object)result, (Object)k1.toString());
                    result = (String)m.get(v2);
                    Assert.assertEquals((String)"v1 and v2 hashcode not equal", (Object)result, (Object)v1.toString());
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        Assert.assertEquals((String)"leased decompressor not returned to the codec pool", (long)leasedDecompressorsBefore, (long)CodecPool.getLeasedDecompressorsCount((CompressionCodec)codec));
        originalData.reset(data.getData(), 0, data.getLength());
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);
        var13_21 = null;
        try {
            throwable = null;
            try (DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));){
                int expected;
                do {
                    expected = originalIn.read();
                    Assert.assertEquals((String)"Inflated stream read by byte does not match", (long)expected, (long)inflateFilter.read());
                } while (expected != -1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var13_21 = throwable3;
            throw throwable3;
        }
        finally {
            if (inflateFilter != null) {
                if (var13_21 != null) {
                    try {
                        inflateFilter.close();
                    }
                    catch (Throwable x2) {
                        var13_21.addSuppressed(x2);
                    }
                } else {
                    inflateFilter.close();
                }
            }
        }
        LOG.info((Object)("SUCCESS! Completed checking " + count + " records"));
    }

    @Test
    public void testSplitableCodecs() throws Exception {
        this.testSplitableCodec(BZip2Codec.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitableCodec(Class<? extends SplittableCompressionCodec> codecClass) throws IOException {
        long DEFLBYTES = 0x200000L;
        Configuration conf = new Configuration();
        Random rand = new Random();
        long seed = rand.nextLong();
        LOG.info((Object)("seed: " + seed));
        rand.setSeed(seed);
        SplittableCompressionCodec codec = (SplittableCompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FileStatus infile = fs.getFileStatus(TestCodec.writeSplitTestFile((FileSystem)fs, rand, (CompressionCodec)codec, 0x200000L));
        if (infile.getLen() > Integer.MAX_VALUE) {
            Assert.fail((String)("Unexpected compression: 2097152 -> " + infile.getLen()));
        }
        int flen = (int)infile.getLen();
        Text line = new Text();
        Decompressor dcmp = CodecPool.getDecompressor((CompressionCodec)codec);
        try {
            int pos = 0;
            while ((long)pos < infile.getLen()) {
                SplitCompressionInputStream in = codec.createInputStream((InputStream)fs.open(infile.getPath()), dcmp, (long)pos, (long)flen, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                if (in.getAdjustedStart() >= (long)flen) {
                    break;
                }
                LOG.info((Object)("SAMPLE " + in.getAdjustedStart() + "," + in.getAdjustedEnd()));
                LineReader lreader = new LineReader((InputStream)in);
                lreader.readLine(line);
                if (in.getPos() >= (long)flen) {
                    break;
                }
                lreader.readLine(line);
                int seq1 = TestCodec.readLeadingInt(line);
                lreader.readLine(line);
                if (in.getPos() >= (long)flen) {
                    break;
                }
                int seq2 = TestCodec.readLeadingInt(line);
                Assert.assertEquals((String)"Mismatched lines", (long)(seq1 + 1), (long)seq2);
                pos += rand.nextInt(flen / 8);
            }
        }
        finally {
            CodecPool.returnDecompressor((Decompressor)dcmp);
        }
        fs.delete(infile.getPath().getParent(), true);
    }

    private static int readLeadingInt(Text txt) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(txt.getBytes()));
        return in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path writeSplitTestFile(FileSystem fs, Random rand, CompressionCodec codec, long infLen) throws IOException {
        int REC_SIZE = 1024;
        Path wd = new Path(GenericTestUtils.getTempPath(codec.getClass().getSimpleName())).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path file = new Path(wd, "test" + codec.getDefaultExtension());
        byte[] b = new byte[1024];
        Base64 b64 = new Base64(0, null);
        DataOutputStream fout = null;
        Compressor cmp = CodecPool.getCompressor((CompressionCodec)codec);
        try {
            fout = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(file, true), cmp));
            DataOutputBuffer dob = new DataOutputBuffer(1369);
            int seq = 0;
            while (infLen > 0L) {
                rand.nextBytes(b);
                byte[] b64enc = b64.encode(b);
                dob.reset();
                dob.writeInt(seq);
                System.arraycopy(dob.getData(), 0, b64enc, 0, dob.getLength());
                fout.write(b64enc);
                fout.write(10);
                ++seq;
                infLen -= (long)b64enc.length;
            }
            LOG.info((Object)("Wrote " + seq + " records to " + file));
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fout});
            CodecPool.returnCompressor((Compressor)cmp);
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fout});
        CodecPool.returnCompressor((Compressor)cmp);
        return file;
    }

    @Test
    public void testCodecPoolGzipReuse() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (!ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            LOG.warn((Object)"testCodecPoolGzipReuse skipped: native libs not loaded");
            return;
        }
        GzipCodec gzc = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        DefaultCodec dfc = (DefaultCodec)ReflectionUtils.newInstance(DefaultCodec.class, (Configuration)conf);
        Compressor c1 = CodecPool.getCompressor((CompressionCodec)gzc);
        Compressor c2 = CodecPool.getCompressor((CompressionCodec)dfc);
        CodecPool.returnCompressor((Compressor)c1);
        CodecPool.returnCompressor((Compressor)c2);
        Assert.assertTrue((String)"Got mismatched ZlibCompressor", (c2 != CodecPool.getCompressor((CompressionCodec)gzc) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipReinitTest(Configuration conf, CompressionCodec codec) throws IOException {
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        ZlibFactory.setCompressionStrategy((Configuration)conf, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY);
        Compressor c1 = CodecPool.getCompressor((CompressionCodec)codec);
        CodecPool.returnCompressor((Compressor)c1);
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.NO_COMPRESSION);
        Compressor c2 = CodecPool.getCompressor((CompressionCodec)codec, (Configuration)conf);
        Assert.assertTrue((String)"Got mismatched ZlibCompressor", (c1 == c2 ? 1 : 0) != 0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CompressionOutputStream cos = null;
        byte[] b = new byte[32768];
        Arrays.fill(b, (byte)43);
        try {
            cos = codec.createOutputStream((OutputStream)bos, c2);
            cos.write(b);
        }
        finally {
            if (cos != null) {
                cos.close();
            }
            CodecPool.returnCompressor((Compressor)c2);
        }
        byte[] outbytes = bos.toByteArray();
        Assert.assertTrue((String)"Compressed bytes contrary to configuration", (outbytes.length >= b.length ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void codecTestWithNOCompression(Configuration conf, String codecClass) throws IOException {
        CompressionCodec codec = null;
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.NO_COMPRESSION);
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        Compressor c = codec.createCompressor();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CompressionOutputStream cos = null;
        byte[] b = new byte[32768];
        Arrays.fill(b, (byte)43);
        try {
            cos = codec.createOutputStream((OutputStream)bos, c);
            cos.write(b);
        }
        finally {
            if (cos != null) {
                cos.close();
            }
        }
        byte[] outbytes = bos.toByteArray();
        Assert.assertTrue((String)"Compressed bytes contrary to configuration(NO_COMPRESSION)", (outbytes.length >= b.length ? 1 : 0) != 0);
    }

    @Test
    public void testCodecInitWithCompressionLevel() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            LOG.info((Object)"testCodecInitWithCompressionLevel with native");
            TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.GzipCodec");
            TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.DefaultCodec");
        } else {
            LOG.warn((Object)"testCodecInitWithCompressionLevel for native skipped: native libs not loaded");
        }
        conf = new Configuration();
        conf.setBoolean("io.native.lib.available", false);
        TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.DefaultCodec");
    }

    @Test
    public void testCodecPoolCompressorReinit() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            GzipCodec gzc = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
            TestCodec.gzipReinitTest(conf, (CompressionCodec)gzc);
        } else {
            LOG.warn((Object)"testCodecPoolCompressorReinit skipped: native libs not loaded");
        }
        conf.setBoolean("io.native.lib.available", false);
        DefaultCodec dfc = (DefaultCodec)ReflectionUtils.newInstance(DefaultCodec.class, (Configuration)conf);
        TestCodec.gzipReinitTest(conf, (CompressionCodec)dfc);
    }

    @Test
    public void testSequenceFileDefaultCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.DefaultCodec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.DefaultCodec", 1000000);
    }

    @Test(timeout=20000L)
    public void testSequenceFileBZip2Codec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "java-builtin");
        TestCodec.sequenceFileCodecTest(conf, 0, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.BZip2Codec", 1000000);
    }

    @Test(timeout=20000L)
    public void testSequenceFileBZip2NativeCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "system-native");
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            if (Bzip2Factory.isNativeBzip2Loaded((Configuration)conf)) {
                TestCodec.sequenceFileCodecTest(conf, 0, "org.apache.hadoop.io.compress.BZip2Codec", 100);
                TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.BZip2Codec", 100);
                TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.BZip2Codec", 1000000);
            } else {
                LOG.warn((Object)"Native hadoop library available but native bzip2 is not");
            }
        }
    }

    @Test
    public void testSequenceFileDeflateCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.DeflateCodec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.DeflateCodec", 1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequenceFileCodecTest(Configuration conf, int lines, String codecClass, int blockSize) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Writable value;
        Text key;
        Path filePath = new Path("SequenceFileCodecTest." + codecClass);
        conf.setInt("io.seqfile.compress.blocksize", blockSize);
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Creating SequenceFile with codec \"" + codecClass + "\""));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)filePath, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)((CompressionCodec)Class.forName(codecClass).newInstance()));
        LOG.info((Object)"Writing to SequenceFile...");
        for (int i = 0; i < lines; ++i) {
            key = new Text("key" + i);
            value = new Text("value" + i);
            writer.append((Writable)key, value);
        }
        writer.close();
        LOG.info((Object)"Reading from the SequenceFile...");
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, filePath, conf);
        key = (Writable)reader.getKeyClass().newInstance();
        value = (Writable)reader.getValueClass().newInstance();
        int lc = 0;
        try {
            while (reader.next((Writable)key, value)) {
                Assert.assertEquals((Object)("key" + lc), (Object)key.toString());
                Assert.assertEquals((Object)("value" + lc), (Object)value.toString());
                ++lc;
            }
        }
        finally {
            reader.close();
        }
        Assert.assertEquals((long)lines, (long)lc);
        fs.delete(filePath, false);
        LOG.info((Object)("SUCCESS! Completed SequenceFileCodecTest with codec \"" + codecClass + "\""));
    }

    @Test
    public void testSnappyMapFile() throws Exception {
        Assume.assumeTrue((boolean)SnappyCodec.isNativeCodeLoaded());
        this.codecTestMapFile(SnappyCodec.class, SequenceFile.CompressionType.BLOCK, 100);
    }

    private void codecTestMapFile(Class<? extends CompressionCodec> clazz, SequenceFile.CompressionType type, int records) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        LOG.info((Object)("Creating MapFiles with " + records + " records using codec " + clazz.getSimpleName()));
        Path path = new Path(GenericTestUtils.getTempPath(clazz.getSimpleName() + "-" + type + "-" + records));
        LOG.info((Object)("Writing " + path));
        TestCodec.createMapFile(this.conf, fs, path, clazz.newInstance(), type, records);
        MapFile.Reader reader = new MapFile.Reader(path, this.conf, new SequenceFile.Reader.Option[0]);
        Text key1 = new Text("002");
        Assert.assertNotNull((Object)reader.get((WritableComparable)key1, (Writable)new Text()));
        Text key2 = new Text("004");
        Assert.assertNotNull((Object)reader.get((WritableComparable)key2, (Writable)new Text()));
    }

    private static void createMapFile(Configuration conf, FileSystem fs, Path path, CompressionCodec codec, SequenceFile.CompressionType type, int records) throws IOException {
        MapFile.Writer writer = new MapFile.Writer(conf, path, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(Text.class), MapFile.Writer.valueClass(Text.class), MapFile.Writer.compression((SequenceFile.CompressionType)type, (CompressionCodec)codec)});
        Text key = new Text();
        for (int j = 0; j < records; ++j) {
            key.set(String.format("%03d", j));
            writer.append((WritableComparable)key, (Writable)key);
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        int count = 10000;
        String codecClass = "org.apache.hadoop.io.compress.DefaultCodec";
        String usage = "TestCodec [-count N] [-codec <codec class>]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-codec")) continue;
            codecClass = args[++i];
        }
        Configuration conf = new Configuration();
        int seed = 0;
        TestCodec.codecTest(conf, seed, count, codecClass);
    }

    @Test
    public void testGzipCompatibility() throws IOException {
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info((Object)("seed: " + seed));
        DataOutputBuffer dflbuf = new DataOutputBuffer();
        GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);
        byte[] b = new byte[r.nextInt(131073)];
        r.nextBytes(b);
        gzout.write(b);
        gzout.close();
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(dflbuf.getData(), dflbuf.getLength());
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", false);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        Decompressor decom = codec.createDecompressor();
        Assert.assertNotNull((Object)decom);
        Assert.assertEquals(BuiltInGzipDecompressor.class, decom.getClass());
        CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
        dflbuf.reset();
        IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
        byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
        Assert.assertArrayEquals((byte[])b, (byte[])dflchk);
    }

    void GzipConcatTest(Configuration conf, Class<? extends Decompressor> decomClass) throws IOException {
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info((Object)(decomClass + " seed: " + seed));
        int CONCAT = r.nextInt(4) + 3;
        int BUFLEN = 131072;
        DataOutputBuffer dflbuf = new DataOutputBuffer();
        DataOutputBuffer chkbuf = new DataOutputBuffer();
        byte[] b = new byte[131072];
        for (int i = 0; i < CONCAT; ++i) {
            GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);
            r.nextBytes(b);
            int len = r.nextInt(131072);
            int off = r.nextInt(131072 - len);
            chkbuf.write(b, off, len);
            gzout.write(b, off, len);
            gzout.close();
        }
        byte[] chk = Arrays.copyOf(chkbuf.getData(), chkbuf.getLength());
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        Decompressor decom = codec.createDecompressor();
        Assert.assertNotNull((Object)decom);
        Assert.assertEquals(decomClass, decom.getClass());
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(dflbuf.getData(), dflbuf.getLength());
        CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
        dflbuf.reset();
        IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
        byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
        Assert.assertArrayEquals((byte[])chk, (byte[])dflchk);
    }

    @Test
    public void testBuiltInGzipConcat() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", false);
        this.GzipConcatTest(conf, BuiltInGzipDecompressor.class);
    }

    @Test
    public void testNativeGzipConcat() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (!ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            LOG.warn((Object)"skipped: native libs not loaded");
            return;
        }
        this.GzipConcatTest(conf, GzipCodec.GzipZlibDecompressor.class);
    }

    @Test
    public void testGzipCodecRead() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", false);
        Assert.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        Assert.assertNotNull((String)"zlibDecompressor is null!", (Object)zlibDecompressor);
        Assert.assertTrue((String)"ZlibFactory returned unexpected inflator", (boolean)(zlibDecompressor instanceof BuiltInZlibInflater));
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        Path f = new Path(GenericTestUtils.getTempPath("testGzipCodecRead.txt.gz"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f.toString()))));
        String msg = "This is the message in the file!";
        bw.write("This is the message in the file!");
        bw.close();
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));
        String line = br.readLine();
        Assert.assertEquals((String)"Didn't get the same message back!", (Object)"This is the message in the file!", (Object)line);
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGzipFile(String filename, String msg) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        try {
            String line = r.readLine();
            Assert.assertEquals((String)("Got invalid line back from " + filename), (Object)msg, (Object)line);
        }
        finally {
            r.close();
            new File(filename).delete();
        }
    }

    @Test
    public void testGzipLongOverflow() throws IOException {
        int i;
        LOG.info((Object)"testGzipLongOverflow");
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", false);
        Assert.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        Assert.assertNotNull((String)"zlibDecompressor is null!", (Object)zlibDecompressor);
        Assert.assertTrue((String)"ZlibFactory returned unexpected inflator", (boolean)(zlibDecompressor instanceof BuiltInZlibInflater));
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        Path f = new Path(GenericTestUtils.getTempPath("testGzipLongOverflow.bin.gz"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f.toString()))));
        int NBUF = 4097;
        char[] buf = new char[0x100000];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = '\u0000';
        }
        for (i = 0; i < 4097; ++i) {
            bw.write(buf);
        }
        bw.close();
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));
        for (int j = 0; j < 4097; ++j) {
            int n = br.read(buf);
            Assert.assertEquals((String)"got wrong read length!", (long)n, (long)buf.length);
            for (int i2 = 0; i2 < buf.length; ++i2) {
                Assert.assertEquals((String)"got wrong byte!", (long)buf[i2], (long)0L);
            }
        }
        br.close();
    }

    private void testGzipCodecWrite(boolean useNative) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", useNative);
        if (useNative) {
            if (!ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
                LOG.warn((Object)"testGzipCodecWrite skipped: native libs not loaded");
                return;
            }
        } else {
            Assert.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        }
        Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
        Assert.assertNotNull((String)"zlibCompressor is null!", (Object)zlibCompressor);
        Assert.assertTrue((String)"ZlibFactory returned unexpected deflator", (boolean)(useNative ? zlibCompressor instanceof ZlibCompressor : zlibCompressor instanceof BuiltInZlibDeflater));
        CodecPool.returnCompressor((Compressor)zlibCompressor);
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        Assert.assertTrue((String)"Codec for .gz file is not GzipCodec", (boolean)(codec instanceof GzipCodec));
        String msg = "This is the message we are going to compress.";
        String fileName = new Path(GenericTestUtils.getTempPath("testGzipCodecWrite.txt.gz")).toString();
        BufferedWriter w = null;
        Compressor gzipCompressor = CodecPool.getCompressor((CompressionCodec)codec);
        if (null != gzipCompressor) {
            CompressorStream os = new CompressorStream((OutputStream)new FileOutputStream(fileName), gzipCompressor);
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
            w.write("This is the message we are going to compress.");
            w.close();
            CodecPool.returnCompressor((Compressor)gzipCompressor);
            this.verifyGzipFile(fileName, "This is the message we are going to compress.");
        }
        w = new BufferedWriter(new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(fileName))));
        w.write("This is the message we are going to compress.");
        w.close();
        this.verifyGzipFile(fileName, "This is the message we are going to compress.");
    }

    @Test
    public void testGzipCodecWriteJava() throws IOException {
        this.testGzipCodecWrite(false);
    }

    @Test
    public void testGzipNativeCodecWrite() throws IOException {
        this.testGzipCodecWrite(true);
    }

    @Test
    public void testCodecPoolAndGzipDecompressor() {
        Decompressor poolDecompressor;
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.native.lib", false);
        Assert.assertFalse((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        Assert.assertNotNull((String)"zlibDecompressor is null!", (Object)zlibDecompressor);
        Assert.assertTrue((String)"ZlibFactory returned unexpected inflator", (boolean)(zlibDecompressor instanceof BuiltInZlibInflater));
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        Assert.assertTrue((String)"Codec for .gz file is not GzipCodec", (boolean)(codec instanceof GzipCodec));
        Decompressor codecDecompressor = codec.createDecompressor();
        if (null == codecDecompressor) {
            Assert.fail((String)"Got null codecDecompressor");
        }
        if (null == (poolDecompressor = CodecPool.getDecompressor((CompressionCodec)codec))) {
            Assert.fail((String)"Got null poolDecompressor");
        }
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        CodecPool.returnDecompressor((Decompressor)poolDecompressor);
        Decompressor poolDecompressor2 = CodecPool.getDecompressor((CompressionCodec)codec);
        if (poolDecompressor.getClass() == BuiltInGzipDecompressor.class) {
            if (poolDecompressor == poolDecompressor2) {
                Assert.fail((String)"Reused java gzip decompressor in pool");
            }
        } else if (poolDecompressor != poolDecompressor2) {
            Assert.fail((String)"Did not reuse native gzip decompressor in pool");
        }
    }
}

