/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.tools.util.DistCpTestUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDistCpWithXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String name1 = "user.a1";
    private static final byte[] value1;
    private static final String name2 = "trusted.a2";
    private static final byte[] value2;
    private static final String name3 = "user.a3";
    private static final byte[] value3;
    private static final String name4 = "user.a4";
    private static final byte[] value4;
    private static final Path dir1;
    private static final Path subDir1;
    private static final Path file1;
    private static final Path dir2;
    private static final Path file2;
    private static final Path file3;
    private static final Path file4;
    private static final Path dstDir1;
    private static final Path dstSubDir1;
    private static final Path dstFile1;
    private static final Path dstDir2;
    private static final Path dstFile2;
    private static final Path dstFile3;
    private static final Path dstFile4;
    private static final String rootedSrcName = "/src";

    @BeforeClass
    public static void init() throws Exception {
        TestDistCpWithXAttrs.initCluster(true, true);
        fs.mkdirs(subDir1);
        fs.create(file1).close();
        fs.mkdirs(dir2);
        fs.create(file2).close();
        fs.create(file3).close();
        fs.create(file4).close();
        fs.setXAttr(dir1, name1, value1);
        fs.setXAttr(dir1, name2, value2);
        fs.setXAttr(subDir1, name1, value1);
        fs.setXAttr(subDir1, name3, value3);
        fs.setXAttr(file1, name1, value1);
        fs.setXAttr(file1, name2, value2);
        fs.setXAttr(file1, name3, value3);
        fs.setXAttr(dir2, name2, value2);
        fs.setXAttr(file2, name1, value1);
        fs.setXAttr(file2, name4, value4);
        fs.setXAttr(file3, name3, value3);
        fs.setXAttr(file3, name4, value4);
    }

    @AfterClass
    public static void shutdown() {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testPreserveXAttrs() throws Exception {
        DistCpTestUtils.assertRunDistCp(0, rootedSrcName, "/dstPreserveXAttrs", "-px", conf);
        HashMap xAttrs = Maps.newHashMap();
        xAttrs.put(name1, value1);
        xAttrs.put(name2, value2);
        DistCpTestUtils.assertXAttrs(dstDir1, fs, xAttrs);
        xAttrs.clear();
        xAttrs.put(name1, value1);
        xAttrs.put(name3, new byte[0]);
        DistCpTestUtils.assertXAttrs(dstSubDir1, fs, xAttrs);
        xAttrs.clear();
        xAttrs.put(name1, value1);
        xAttrs.put(name2, value2);
        xAttrs.put(name3, new byte[0]);
        DistCpTestUtils.assertXAttrs(dstFile1, fs, xAttrs);
        xAttrs.clear();
        xAttrs.put(name2, value2);
        DistCpTestUtils.assertXAttrs(dstDir2, fs, xAttrs);
        xAttrs.clear();
        xAttrs.put(name1, value1);
        xAttrs.put(name4, new byte[0]);
        DistCpTestUtils.assertXAttrs(dstFile2, fs, xAttrs);
        xAttrs.clear();
        xAttrs.put(name3, new byte[0]);
        xAttrs.put(name4, new byte[0]);
        DistCpTestUtils.assertXAttrs(dstFile3, fs, xAttrs);
        xAttrs.clear();
        DistCpTestUtils.assertXAttrs(dstFile4, fs, xAttrs);
    }

    @Test
    public void testXAttrsNotEnabled() throws Exception {
        try {
            TestDistCpWithXAttrs.restart(false);
            DistCpTestUtils.assertRunDistCp(-4, rootedSrcName, "/dstXAttrsNotEnabled", "-px", conf);
        }
        finally {
            TestDistCpWithXAttrs.restart(true);
        }
    }

    @Test
    public void testXAttrsNotImplemented() throws Exception {
        DistCpTestUtils.assertRunDistCp(-4, rootedSrcName, "stubfs://dstXAttrsNotImplemented", "-px", conf);
    }

    private static void initCluster(boolean format, boolean xAttrsEnabled) throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", xAttrsEnabled);
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    private static void restart(boolean xAttrsEnabled) throws Exception {
        TestDistCpWithXAttrs.shutdown();
        TestDistCpWithXAttrs.initCluster(false, xAttrsEnabled);
    }

    static {
        value1 = new byte[]{49, 50, 51};
        value2 = new byte[]{55, 56, 57};
        value3 = null;
        value4 = null;
        dir1 = new Path("/src/dir1");
        subDir1 = new Path(dir1, "subdir1");
        file1 = new Path("/src/file1");
        dir2 = new Path("/src/dir2");
        file2 = new Path(dir2, "file2");
        file3 = new Path(dir2, "file3");
        file4 = new Path(dir2, "file4");
        dstDir1 = new Path("/dstPreserveXAttrs/dir1");
        dstSubDir1 = new Path(dstDir1, "subdir1");
        dstFile1 = new Path("/dstPreserveXAttrs/file1");
        dstDir2 = new Path("/dstPreserveXAttrs/dir2");
        dstFile2 = new Path(dstDir2, "file2");
        dstFile3 = new Path(dstDir2, "file3");
        dstFile4 = new Path(dstDir2, "file4");
    }

    public static class StubFileSystem
    extends FileSystem {
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }

        public URI getUri() {
            return URI.create("stubfs:///");
        }

        public Path getWorkingDirectory() {
            return new Path("/");
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return new FileStatus[0];
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public void setWorkingDirectory(Path dir) {
        }
    }
}

