/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsFileStatus
extends FileStatus {
    private static final long serialVersionUID = 309245994L;
    private byte[] uPath;
    private byte[] uSymlink;
    private final long fileId;
    private final FileEncryptionInfo feInfo;
    private final ErasureCodingPolicy ecPolicy;
    private final int childrenNum;
    private final byte storagePolicy;
    public static final byte[] EMPTY_NAME = new byte[0];
    private final EnumSet<Flags> flags;

    protected HdfsFileStatus(long length, boolean isdir, int replication, long blocksize, long mtime, long atime, FsPermission permission, EnumSet<Flags> flags, String owner, String group, byte[] symlink, byte[] path, long fileId, int childrenNum, FileEncryptionInfo feInfo, byte storagePolicy, ErasureCodingPolicy ecPolicy) {
        super(length, isdir, replication, blocksize, mtime, atime, HdfsFileStatus.convert(isdir, symlink != null, permission, flags), owner, group, null, null, flags.contains((Object)Flags.HAS_ACL), flags.contains((Object)Flags.HAS_CRYPT), flags.contains((Object)Flags.HAS_EC));
        this.flags = flags;
        this.uSymlink = symlink;
        this.uPath = path;
        this.fileId = fileId;
        this.childrenNum = childrenNum;
        this.feInfo = feInfo;
        this.storagePolicy = storagePolicy;
        this.ecPolicy = ecPolicy;
    }

    protected static FsPermission convert(boolean isdir, boolean symlink, FsPermission p, EnumSet<Flags> f) {
        if (p instanceof FsPermissionExtension) {
            assert (p.getAclBit() == f.contains((Object)Flags.HAS_ACL));
            assert (p.getEncryptedBit() == f.contains((Object)Flags.HAS_CRYPT));
            assert (p.getErasureCodedBit() == f.contains((Object)Flags.HAS_EC));
            return p;
        }
        if (null == p) {
            p = isdir ? FsPermission.getDirDefault() : (symlink ? FsPermission.getDefault() : FsPermission.getFileDefault());
        }
        return new FsPermissionExtension(p, f.contains((Object)Flags.HAS_ACL), f.contains((Object)Flags.HAS_CRYPT), f.contains((Object)Flags.HAS_EC));
    }

    public boolean isSymlink() {
        return this.uSymlink != null;
    }

    public boolean hasAcl() {
        return this.flags.contains((Object)Flags.HAS_ACL);
    }

    public boolean isEncrypted() {
        return this.flags.contains((Object)Flags.HAS_CRYPT);
    }

    public boolean isErasureCoded() {
        return this.flags.contains((Object)Flags.HAS_EC);
    }

    public final boolean isEmptyLocalName() {
        return this.uPath.length == 0;
    }

    public final String getLocalName() {
        return DFSUtilClient.bytes2String(this.uPath);
    }

    public final byte[] getLocalNameInBytes() {
        return this.uPath;
    }

    public final String getFullName(String parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        StringBuilder fullName = new StringBuilder(parent);
        if (!parent.endsWith("/")) {
            fullName.append("/");
        }
        fullName.append(this.getLocalName());
        return fullName.toString();
    }

    public final Path getFullPath(Path parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        return new Path(parent, this.getLocalName());
    }

    public Path getSymlink() throws IOException {
        if (this.isSymlink()) {
            return new Path(DFSUtilClient.bytes2String(this.uSymlink));
        }
        throw new IOException("Path " + this.getPath() + " is not a symbolic link");
    }

    public void setSymlink(Path sym) {
        this.uSymlink = DFSUtilClient.string2Bytes(sym.toString());
    }

    public final byte[] getSymlinkInBytes() {
        return this.uSymlink;
    }

    public final long getFileId() {
        return this.fileId;
    }

    public final FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    public ErasureCodingPolicy getErasureCodingPolicy() {
        return this.ecPolicy;
    }

    public final int getChildrenNum() {
        return this.childrenNum;
    }

    public final byte getStoragePolicy() {
        return this.storagePolicy;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public final FileStatus makeQualified(URI defaultUri, Path parent) {
        this.setPath(this.getFullPath(parent).makeQualified(defaultUri, null));
        return this;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Builder {
        private long length = 0L;
        private boolean isdir = false;
        private int replication = 0;
        private long blocksize = 0L;
        private long mtime = 0L;
        private long atime = 0L;
        private FsPermission permission = null;
        private EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);
        private String owner = null;
        private String group = null;
        private byte[] symlink = null;
        private byte[] path = EMPTY_NAME;
        private long fileId = -1L;
        private int childrenNum = 0;
        private FileEncryptionInfo feInfo = null;
        private byte storagePolicy = 0;
        private ErasureCodingPolicy ecPolicy = null;

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder isdir(boolean isdir) {
            this.isdir = isdir;
            return this;
        }

        public Builder replication(int replication) {
            this.replication = replication;
            return this;
        }

        public Builder blocksize(long blocksize) {
            this.blocksize = blocksize;
            return this;
        }

        public Builder mtime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder atime(long atime) {
            this.atime = atime;
            return this;
        }

        public Builder perm(FsPermission permission) {
            this.permission = permission;
            return this;
        }

        public Builder flags(EnumSet<Flags> flags) {
            this.flags = flags;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder symlink(byte[] symlink) {
            this.symlink = null == symlink ? null : Arrays.copyOf(symlink, symlink.length);
            return this;
        }

        public Builder path(byte[] path) {
            this.path = null == path ? null : Arrays.copyOf(path, path.length);
            return this;
        }

        public Builder fileId(long fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder children(int childrenNum) {
            this.childrenNum = childrenNum;
            return this;
        }

        public Builder feInfo(FileEncryptionInfo feInfo) {
            this.feInfo = feInfo;
            return this;
        }

        public Builder storagePolicy(byte storagePolicy) {
            this.storagePolicy = storagePolicy;
            return this;
        }

        public Builder ecPolicy(ErasureCodingPolicy ecPolicy) {
            this.ecPolicy = ecPolicy;
            return this;
        }

        public HdfsFileStatus build() {
            return new HdfsFileStatus(this.length, this.isdir, this.replication, this.blocksize, this.mtime, this.atime, this.permission, this.flags, this.owner, this.group, this.symlink, this.path, this.fileId, this.childrenNum, this.feInfo, this.storagePolicy, this.ecPolicy);
        }
    }

    public static enum Flags {
        HAS_ACL,
        HAS_CRYPT,
        HAS_EC;

    }
}

