/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.util.FoldedTreeSet;
import org.apache.hadoop.util.AutoCloseableLock;

class ReplicaMap {
    private final AutoCloseableLock lock;
    private final Map<String, FoldedTreeSet<ReplicaInfo>> map = new HashMap<String, FoldedTreeSet<ReplicaInfo>>();
    private static final Comparator<Object> LONG_AND_BLOCK_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long stored;
            long lookup = (Long)o1;
            return lookup > (stored = ((Block)o2).getBlockId()) ? 1 : (lookup < stored ? -1 : 0);
        }
    };

    ReplicaMap(AutoCloseableLock lock) {
        if (lock == null) {
            throw new HadoopIllegalArgumentException("Lock to synchronize on cannot be null");
        }
        this.lock = lock;
    }

    String[] getBlockPoolList() {
        try (AutoCloseableLock l = this.lock.acquire();){
            String[] stringArray = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            return stringArray;
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                ReplicaInfo replicaInfo = null;
                return replicaInfo;
            }
            ReplicaInfo replicaInfo = set.get(blockId, LONG_AND_BLOCK_COMPARATOR);
            return replicaInfo;
        }
    }

    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.lock.acquire();){
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                set = new FoldedTreeSet();
                this.map.put(bpid, set);
            }
            ReplicaInfo replicaInfo2 = set.addOrReplace(replicaInfo);
            return replicaInfo2;
        }
    }

    ReplicaInfo addAndGet(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.lock.acquire();){
            ReplicaInfo oldReplicaInfo;
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                set = new FoldedTreeSet();
                this.map.put(bpid, set);
            }
            if ((oldReplicaInfo = set.get(replicaInfo.getBlockId(), LONG_AND_BLOCK_COMPARATOR)) != null) {
                ReplicaInfo replicaInfo2 = oldReplicaInfo;
                return replicaInfo2;
            }
            set.addOrReplace(replicaInfo);
            ReplicaInfo replicaInfo3 = replicaInfo;
            return replicaInfo3;
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        try (AutoCloseableLock l = this.lock.acquire();){
            ReplicaInfo replicaInfo;
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set != null && (replicaInfo = set.get(block.getBlockId(), LONG_AND_BLOCK_COMPARATOR)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                ReplicaInfo replicaInfo2 = set.removeAndGet(replicaInfo);
                return replicaInfo2;
            }
        }
        return null;
    }

    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set != null) {
                ReplicaInfo replicaInfo = set.removeAndGet(blockId, LONG_AND_BLOCK_COMPARATOR);
                return replicaInfo;
            }
        }
        return null;
    }

    int size(String bpid) {
        try (AutoCloseableLock l = this.lock.acquire();){
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            int n = set != null ? set.size() : 0;
            return n;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        return this.map.get(bpid);
    }

    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                set = new FoldedTreeSet();
                this.map.put(bpid, set);
            }
        }
    }

    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.lock.acquire();){
            this.map.remove(bpid);
        }
    }

    AutoCloseableLock getLock() {
        return this.lock;
    }
}

