/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaByStorageTypeEntry;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.XAttrFormat;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

@InterfaceAudience.Private
public final class FSImageFormatPBINode {
    public static final int ACL_ENTRY_NAME_MASK = 0xFFFFFF;
    public static final int ACL_ENTRY_NAME_OFFSET = 6;
    public static final int ACL_ENTRY_TYPE_OFFSET = 3;
    public static final int ACL_ENTRY_SCOPE_OFFSET = 5;
    public static final int ACL_ENTRY_PERM_MASK = 7;
    public static final int XATTR_NAMESPACE_MASK = 3;
    public static final int XATTR_NAMESPACE_OFFSET = 30;
    public static final int XATTR_NAME_MASK = 0xFFFFFF;
    public static final int XATTR_NAME_OFFSET = 6;
    public static final int XATTR_NAMESPACE_EXT_OFFSET = 5;
    public static final int XATTR_NAMESPACE_EXT_MASK = 1;
    private static final Log LOG = LogFactory.getLog(FSImageFormatPBINode.class);

    private FSImageFormatPBINode() {
    }

    public static final class Saver {
        private long numImageErrors;
        private final FSNamesystem fsn;
        private final FsImageProto.FileSummary.Builder summary;
        private final SaveNamespaceContext context;
        private final FSImageFormatProtobuf.Saver parent;

        private static long buildPermissionStatus(INodeAttributes n) {
            return n.getPermissionLong();
        }

        private static FsImageProto.INodeSection.AclFeatureProto.Builder buildAclEntries(AclFeature f) {
            FsImageProto.INodeSection.AclFeatureProto.Builder b = FsImageProto.INodeSection.AclFeatureProto.newBuilder();
            for (int pos = 0; pos < f.getEntriesSize(); ++pos) {
                int e = f.getEntryAt(pos);
                b.addEntries(e);
            }
            return b;
        }

        private static FsImageProto.INodeSection.XAttrFeatureProto.Builder buildXAttrs(XAttrFeature f) {
            FsImageProto.INodeSection.XAttrFeatureProto.Builder b = FsImageProto.INodeSection.XAttrFeatureProto.newBuilder();
            for (XAttr a : f.getXAttrs()) {
                FsImageProto.INodeSection.XAttrCompactProto.Builder xAttrCompactBuilder = FsImageProto.INodeSection.XAttrCompactProto.newBuilder();
                int v = XAttrFormat.toInt(a);
                xAttrCompactBuilder.setName(v);
                if (a.getValue() != null) {
                    xAttrCompactBuilder.setValue(PBHelperClient.getByteString((byte[])a.getValue()));
                }
                b.addXAttrs(xAttrCompactBuilder.build());
            }
            return b;
        }

        private static FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder buildQuotaByStorageTypeEntries(QuotaCounts q) {
            FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder b = FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.newBuilder();
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                if (q.getTypeSpace(t) < 0L) continue;
                FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.Builder eb = FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.newBuilder().setStorageType(PBHelperClient.convertStorageType((StorageType)t)).setQuota(q.getTypeSpace(t));
                b.addQuotas(eb);
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeFile.Builder buildINodeFile(INodeFileAttributes file, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            FsImageProto.INodeSection.INodeFile.Builder b = FsImageProto.INodeSection.INodeFile.newBuilder().setAccessTime(file.getAccessTime()).setModificationTime(file.getModificationTime()).setPermission(Saver.buildPermissionStatus(file)).setPreferredBlockSize(file.getPreferredBlockSize()).setStoragePolicyID(file.getLocalStoragePolicyID()).setBlockType(PBHelperClient.convert((BlockType)file.getBlockType()));
            if (file.isStriped()) {
                b.setErasureCodingPolicyID(file.getErasureCodingPolicyID());
            } else {
                b.setReplication(file.getFileReplication());
            }
            AclFeature f = file.getAclFeature();
            if (f != null) {
                b.setAcl(Saver.buildAclEntries(f));
            }
            if ((xAttrFeature = file.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature));
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeDirectory.Builder buildINodeDirectory(INodeDirectoryAttributes dir, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            AclFeature f;
            QuotaCounts quota = dir.getQuotaCounts();
            FsImageProto.INodeSection.INodeDirectory.Builder b = FsImageProto.INodeSection.INodeDirectory.newBuilder().setModificationTime(dir.getModificationTime()).setNsQuota(quota.getNameSpace()).setDsQuota(quota.getStorageSpace()).setPermission(Saver.buildPermissionStatus(dir));
            if (quota.getTypeSpaces().anyGreaterOrEqual(0L)) {
                b.setTypeQuotas(Saver.buildQuotaByStorageTypeEntries(quota));
            }
            if ((f = dir.getAclFeature()) != null) {
                b.setAcl(Saver.buildAclEntries(f));
            }
            if ((xAttrFeature = dir.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature));
            }
            return b;
        }

        Saver(FSImageFormatProtobuf.Saver parent, FsImageProto.FileSummary.Builder summary) {
            this.parent = parent;
            this.summary = summary;
            this.context = parent.getContext();
            this.fsn = this.context.getSourceNamesystem();
            this.numImageErrors = 0L;
        }

        void serializeINodeDirectorySection(OutputStream out) throws IOException {
            FSDirectory dir = this.fsn.getFSDirectory();
            Iterator<INodeWithAdditionalFields> iter = dir.getINodeMap().getMapIterator();
            ArrayList<INodeReference> refList = this.parent.getSaverContext().getRefList();
            int i = 0;
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                if (!n.isDirectory()) continue;
                ReadOnlyList<INode> children = n.asDirectory().getChildrenList(0x7FFFFFFE);
                if (children.size() > 0) {
                    FsImageProto.INodeDirectorySection.DirEntry.Builder b = FsImageProto.INodeDirectorySection.DirEntry.newBuilder().setParent(n.getId());
                    for (INode inode : children) {
                        if (dir.getInode(inode.getId()) == null) {
                            FSImage.LOG.error((Object)("FSImageFormatPBINode#serializeINodeDirectorySection: Dangling child pointer found. Missing INode in inodeMap: id=" + inode.getId() + "; path=" + inode.getFullPathName() + "; parent=" + (inode.getParent() == null ? "null" : inode.getParent().getFullPathName())));
                            ++this.numImageErrors;
                        }
                        if (!inode.isReference()) {
                            b.addChildren(inode.getId());
                            continue;
                        }
                        refList.add(inode.asReference());
                        b.addRefChildren(refList.size() - 1);
                    }
                    FsImageProto.INodeDirectorySection.DirEntry e = b.build();
                    e.writeDelimitedTo(out);
                }
                if (++i % 4096 != 0) continue;
                this.context.checkCancelled();
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.INODE_DIR);
        }

        void serializeINodeSection(OutputStream out) throws IOException {
            INodeMap inodesMap = this.fsn.dir.getINodeMap();
            FsImageProto.INodeSection.Builder b = FsImageProto.INodeSection.newBuilder().setLastInodeId(this.fsn.dir.getLastInodeId()).setNumInodes(inodesMap.size());
            FsImageProto.INodeSection s = b.build();
            s.writeDelimitedTo(out);
            int i = 0;
            Iterator<INodeWithAdditionalFields> iter = inodesMap.getMapIterator();
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                this.save(out, n);
                if (++i % 4096 != 0) continue;
                this.context.checkCancelled();
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.INODE);
        }

        void serializeFilesUCSection(OutputStream out) throws IOException {
            Collection<Long> filesWithUC = this.fsn.getLeaseManager().getINodeIdWithLeases();
            for (Long id : filesWithUC) {
                INode inode = this.fsn.getFSDirectory().getInode(id);
                if (inode == null) {
                    LOG.warn((Object)("Fail to find inode " + id + " when saving the leases."));
                    continue;
                }
                INodeFile file = inode.asFile();
                if (!file.isUnderConstruction()) {
                    LOG.warn((Object)("Fail to save the lease for inode id " + id + " as the file is not under construction"));
                    continue;
                }
                String path = file.getFullPathName();
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.Builder b = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.newBuilder().setInodeId(file.getId()).setFullPath(path);
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e = b.build();
                e.writeDelimitedTo(out);
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.FILES_UNDERCONSTRUCTION);
        }

        private void save(OutputStream out, INode n) throws IOException {
            if (n.isDirectory()) {
                this.save(out, n.asDirectory());
            } else if (n.isFile()) {
                this.save(out, n.asFile());
            } else if (n.isSymlink()) {
                this.save(out, n.asSymlink());
            }
        }

        private void save(OutputStream out, INodeDirectory n) throws IOException {
            FsImageProto.INodeSection.INodeDirectory.Builder b = Saver.buildINodeDirectory(n, this.parent.getSaverContext());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.DIRECTORY).setDirectory(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeFile n) throws IOException {
            FileUnderConstructionFeature uc;
            FsImageProto.INodeSection.INodeFile.Builder b = Saver.buildINodeFile(n, this.parent.getSaverContext());
            BlockInfo[] blocks = n.getBlocks();
            if (blocks != null) {
                for (BlockInfo block : n.getBlocks()) {
                    b.addBlocks(PBHelperClient.convert((Block)block));
                }
            }
            if ((uc = n.getFileUnderConstructionFeature()) != null) {
                FsImageProto.INodeSection.FileUnderConstructionFeature f = FsImageProto.INodeSection.FileUnderConstructionFeature.newBuilder().setClientName(uc.getClientName()).setClientMachine(uc.getClientMachine()).build();
                b.setFileUC(f);
            }
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.FILE).setFile(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeSymlink n) throws IOException {
            FsImageProto.INodeSection.INodeSymlink.Builder b = FsImageProto.INodeSection.INodeSymlink.newBuilder().setPermission(Saver.buildPermissionStatus(n)).setTarget(ByteString.copyFrom((byte[])n.getSymlink())).setModificationTime(n.getModificationTime()).setAccessTime(n.getAccessTime());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.SYMLINK).setSymlink(b).build();
            r.writeDelimitedTo(out);
        }

        private FsImageProto.INodeSection.INode.Builder buildINodeCommon(INode n) {
            return FsImageProto.INodeSection.INode.newBuilder().setId(n.getId()).setName(ByteString.copyFrom((byte[])n.getLocalNameBytes()));
        }

        public long getNumImageErrors() {
            return this.numImageErrors;
        }
    }

    public static final class Loader {
        private final FSDirectory dir;
        private final FSNamesystem fsn;
        private final FSImageFormatProtobuf.Loader parent;

        public static PermissionStatus loadPermission(long id, SerialNumberManager.StringTable stringTable) {
            return INodeWithAdditionalFields.PermissionStatusFormat.toPermissionStatus(id, stringTable);
        }

        public static ImmutableList<AclEntry> loadAclEntries(FsImageProto.INodeSection.AclFeatureProto proto, SerialNumberManager.StringTable stringTable) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int v : proto.getEntriesList()) {
                b.add((Object)AclEntryStatusFormat.toAclEntry(v, stringTable));
            }
            return b.build();
        }

        public static List<XAttr> loadXAttrs(FsImageProto.INodeSection.XAttrFeatureProto proto, SerialNumberManager.StringTable stringTable) {
            ArrayList<XAttr> b = new ArrayList<XAttr>();
            for (FsImageProto.INodeSection.XAttrCompactProto xAttrCompactProto : proto.getXAttrsList()) {
                int v = xAttrCompactProto.getName();
                byte[] value = null;
                if (xAttrCompactProto.getValue() != null) {
                    value = xAttrCompactProto.getValue().toByteArray();
                }
                b.add(XAttrFormat.toXAttr(v, value, stringTable));
            }
            return b;
        }

        public static ImmutableList<QuotaByStorageTypeEntry> loadQuotaByStorageTypeEntries(FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto proto) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (FsImageProto.INodeSection.QuotaByStorageTypeEntryProto quotaEntry : proto.getQuotasList()) {
                StorageType type = PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)quotaEntry.getStorageType());
                long quota = quotaEntry.getQuota();
                b.add((Object)new QuotaByStorageTypeEntry.Builder().setStorageType(type).setQuota(quota).build());
            }
            return b.build();
        }

        public static INodeDirectory loadINodeDirectory(FsImageProto.INodeSection.INode n, FSImageFormatProtobuf.LoaderContext state) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY);
            FsImageProto.INodeSection.INodeDirectory d = n.getDirectory();
            PermissionStatus permissions = Loader.loadPermission(d.getPermission(), state.getStringTable());
            INodeDirectory dir = new INodeDirectory(n.getId(), n.getName().toByteArray(), permissions, d.getModificationTime());
            long nsQuota = d.getNsQuota();
            long dsQuota = d.getDsQuota();
            if (nsQuota >= 0L || dsQuota >= 0L) {
                dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().nameSpaceQuota(nsQuota).storageSpaceQuota(dsQuota).build());
            }
            EnumCounters<StorageType> typeQuotas = null;
            if (d.hasTypeQuotas()) {
                ImmutableList<QuotaByStorageTypeEntry> qes = Loader.loadQuotaByStorageTypeEntries(d.getTypeQuotas());
                typeQuotas = new EnumCounters<StorageType>(StorageType.class, -1L);
                for (QuotaByStorageTypeEntry qe : qes) {
                    if (qe.getQuota() < 0L || qe.getStorageType() == null || !qe.getStorageType().supportTypeQuota()) continue;
                    typeQuotas.set(qe.getStorageType(), qe.getQuota());
                }
                if (typeQuotas.anyGreaterOrEqual(0L)) {
                    DirectoryWithQuotaFeature q = dir.getDirectoryWithQuotaFeature();
                    if (q == null) {
                        dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().typeQuotas(typeQuotas).build());
                    } else {
                        q.setQuota(typeQuotas);
                    }
                }
            }
            if (d.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(d.getAcl(), state.getStringTable()));
                dir.addAclFeature(new AclFeature(entries));
            }
            if (d.hasXAttrs()) {
                dir.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(d.getXAttrs(), state.getStringTable())));
            }
            return dir;
        }

        public static void updateBlocksMap(INodeFile file, BlockManager bm) {
            BlockInfo[] blocks = file.getBlocks();
            if (blocks != null) {
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollectionWithCheck(blocks[i], file));
                }
            }
        }

        Loader(FSNamesystem fsn, FSImageFormatProtobuf.Loader parent) {
            this.fsn = fsn;
            this.dir = fsn.dir;
            this.parent = parent;
        }

        void loadINodeDirectorySection(InputStream in) throws IOException {
            FsImageProto.INodeDirectorySection.DirEntry e;
            ArrayList<INodeReference> refList = this.parent.getLoaderContext().getRefList();
            while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
                INodeDirectory p = this.dir.getInode(e.getParent()).asDirectory();
                Iterator<Number> iterator = e.getChildrenList().iterator();
                while (iterator.hasNext()) {
                    long id = iterator.next();
                    INode child = this.dir.getInode(id);
                    this.addToParent(p, child);
                }
                iterator = e.getRefChildrenList().iterator();
                while (iterator.hasNext()) {
                    int refId = (Integer)iterator.next();
                    INodeReference ref = (INodeReference)refList.get(refId);
                    this.addToParent(p, ref);
                }
            }
        }

        void loadINodeSection(InputStream in, StartupProgress prog, Step currentStep) throws IOException {
            FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
            this.fsn.dir.resetLastInodeId(s.getLastInodeId());
            long numInodes = s.getNumInodes();
            LOG.info((Object)("Loading " + numInodes + " INodes."));
            prog.setTotal(Phase.LOADING_FSIMAGE, currentStep, numInodes);
            StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, currentStep);
            int i = 0;
            while ((long)i < numInodes) {
                FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
                if (p.getId() == 16385L) {
                    this.loadRootINode(p);
                } else {
                    INode n = this.loadINode(p);
                    this.dir.addToInodeMap(n);
                }
                counter.increment();
                ++i;
            }
        }

        void loadFilesUnderConstructionSection(InputStream in) throws IOException {
            FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry entry;
            while ((entry = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
            }
        }

        private void addToParent(INodeDirectory parent, INode child) {
            if (parent == this.dir.rootDir && FSDirectory.isReservedName(child)) {
                throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.dir.cacheName(child);
            if (child.isFile()) {
                Loader.updateBlocksMap(child.asFile(), this.fsn.getBlockManager());
            }
        }

        private INode loadINode(FsImageProto.INodeSection.INode n) {
            switch (n.getType()) {
                case FILE: {
                    return this.loadINodeFile(n);
                }
                case DIRECTORY: {
                    return Loader.loadINodeDirectory(n, this.parent.getLoaderContext());
                }
                case SYMLINK: {
                    return this.loadINodeSymlink(n);
                }
            }
            return null;
        }

        private INodeFile loadINodeFile(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.FILE);
            FsImageProto.INodeSection.INodeFile f = n.getFile();
            List<HdfsProtos.BlockProto> bp = f.getBlocksList();
            BlockType blockType = PBHelperClient.convert((HdfsProtos.BlockTypeProto)f.getBlockType());
            FSImageFormatProtobuf.LoaderContext state = this.parent.getLoaderContext();
            boolean isStriped = f.hasErasureCodingPolicyID();
            assert (!isStriped || isStriped && !f.hasReplication());
            Short replication = !isStriped ? Short.valueOf((short)f.getReplication()) : null;
            Byte ecPolicyID = isStriped ? Byte.valueOf((byte)f.getErasureCodingPolicyID()) : null;
            ErasureCodingPolicy ecPolicy = isStriped ? this.fsn.getErasureCodingPolicyManager().getByID(ecPolicyID) : null;
            BlockInfo[] blocks = new BlockInfo[bp.size()];
            for (int i = 0; i < bp.size(); ++i) {
                HdfsProtos.BlockProto b = bp.get(i);
                if (isStriped) {
                    Preconditions.checkState((ecPolicy.getId() > 0 ? 1 : 0) != 0, (Object)("File with ID " + n.getId() + " has an invalid erasure coding policy ID " + ecPolicy.getId()));
                    blocks[i] = new BlockInfoStriped(PBHelperClient.convert((HdfsProtos.BlockProto)b), ecPolicy);
                    continue;
                }
                blocks[i] = new BlockInfoContiguous(PBHelperClient.convert((HdfsProtos.BlockProto)b), replication);
            }
            PermissionStatus permissions = Loader.loadPermission(f.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeFile file = new INodeFile(n.getId(), n.getName().toByteArray(), permissions, f.getModificationTime(), f.getAccessTime(), blocks, replication, ecPolicyID, f.getPreferredBlockSize(), (byte)f.getStoragePolicyID(), blockType);
            if (f.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(f.getAcl(), state.getStringTable()));
                file.addAclFeature(new AclFeature(entries));
            }
            if (f.hasXAttrs()) {
                file.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(f.getXAttrs(), state.getStringTable())));
            }
            if (f.hasFileUC()) {
                FsImageProto.INodeSection.FileUnderConstructionFeature uc = f.getFileUC();
                file.toUnderConstruction(uc.getClientName(), uc.getClientMachine());
                this.fsn.leaseManager.addLease(uc.getClientName(), file.getId());
                if (blocks.length > 0) {
                    BlockInfo ucBlk;
                    BlockInfo lastBlk = file.getLastBlock();
                    if (isStriped) {
                        BlockInfoStriped striped = (BlockInfoStriped)lastBlk;
                        ucBlk = new BlockInfoStriped((Block)striped, ecPolicy);
                    } else {
                        ucBlk = new BlockInfoContiguous(lastBlk, replication);
                    }
                    ucBlk.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
                    file.setBlock(file.numBlocks() - 1, ucBlk);
                }
            }
            return file;
        }

        private INodeSymlink loadINodeSymlink(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.SYMLINK);
            FsImageProto.INodeSection.INodeSymlink s = n.getSymlink();
            PermissionStatus permissions = Loader.loadPermission(s.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeSymlink sym = new INodeSymlink(n.getId(), n.getName().toByteArray(), permissions, s.getModificationTime(), s.getAccessTime(), s.getTarget().toStringUtf8());
            return sym;
        }

        private void loadRootINode(FsImageProto.INodeSection.INode p) {
            XAttrFeature f;
            EnumCounters<StorageType> typeQuotas;
            INodeDirectory root = Loader.loadINodeDirectory(p, this.parent.getLoaderContext());
            QuotaCounts q = root.getQuotaCounts();
            long nsQuota = q.getNameSpace();
            long dsQuota = q.getStorageSpace();
            if (nsQuota != -1L || dsQuota != -1L) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(nsQuota, dsQuota);
            }
            if ((typeQuotas = q.getTypeSpaces()).anyGreaterOrEqual(0L)) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(typeQuotas);
            }
            this.dir.rootDir.cloneModificationTime(root);
            this.dir.rootDir.clonePermissionStatus(root);
            AclFeature af = (AclFeature)root.getFeature(AclFeature.class);
            if (af != null) {
                this.dir.rootDir.addAclFeature(af);
            }
            if ((f = root.getXAttrFeature()) != null) {
                this.dir.rootDir.addXAttrFeature(f);
            }
            this.dir.addRootDirToEncryptionZone(f);
        }
    }
}

