/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.event.Level;

public class TestStripedFileAppend {
    public static final Log LOG = LogFactory.getLog(TestStripedFileAppend.class);
    private static final int NUM_DATA_BLOCKS;
    private static final int CELL_SIZE;
    private static final int NUM_DN = 9;
    private static final int STRIPES_PER_BLOCK = 4;
    private static final int BLOCK_SIZE;
    private static final int BLOCK_GROUP_SIZE;
    private static final Random RANDOM;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private Path dir = new Path("/TestFileAppendStriped");
    private HdfsConfiguration conf = new HdfsConfiguration();

    @Before
    public void setup() throws IOException {
        this.conf.setLong("dfs.blocksize", (long)BLOCK_SIZE);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(9).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.mkdirs(this.dir);
        this.dfs.setErasureCodingPolicy(this.dir, null);
    }

    @After
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testAppendToNewBlock() throws IOException {
        int fileLength = 0;
        int totalSplit = 6;
        byte[] expected = StripedFileTestUtil.generateBytes(BLOCK_GROUP_SIZE * totalSplit);
        Path file = new Path(this.dir, "testAppendToNewBlock");
        for (int split = 0; split < totalSplit; ++split) {
            FSDataOutputStream out = split == 0 ? this.dfs.create(file) : this.dfs.append(file, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            int splitLength = RANDOM.nextInt(BLOCK_GROUP_SIZE);
            out.write(expected, fileLength, splitLength);
            fileLength += splitLength;
            out.close();
        }
        expected = Arrays.copyOf(expected, fileLength);
        LocatedBlocks lbs = this.dfs.getClient().getLocatedBlocks(file.toString(), 0L, Long.MAX_VALUE);
        Assert.assertEquals((long)totalSplit, (long)lbs.getLocatedBlocks().size());
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.dfs, file, fileLength, expected, new byte[4096]);
        StripedFileTestUtil.verifySeek((FileSystem)this.dfs, file, fileLength, StripedFileTestUtil.getDefaultECPolicy(), totalSplit);
    }

    @Test
    public void testAppendWithoutNewBlock() throws IOException {
        Path file = new Path(this.dir, "testAppendWithoutNewBlock");
        FSDataOutputStream out = this.dfs.create(file);
        out.write("testAppendWithoutNewBlock".getBytes());
        out.close();
        try {
            out = this.dfs.append(file, EnumSet.of(CreateFlag.APPEND), 4096, null);
            out.write("testAppendWithoutNewBlock".getBytes());
            Assert.fail((String)"Should throw unsupported operation");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Append on EC file without new block is not supported"));
        }
        ArrayList<OpenFilesIterator.OpenFilesType> types = new ArrayList<OpenFilesIterator.OpenFilesType>();
        types.add(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES);
        RemoteIterator listOpenFiles = this.dfs.listOpenFiles(EnumSet.copyOf(types), file.toString());
        Assert.assertFalse((String)"No file should be open after append failure", (boolean)listOpenFiles.hasNext());
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
        NUM_DATA_BLOCKS = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        CELL_SIZE = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
        BLOCK_SIZE = CELL_SIZE * 4;
        BLOCK_GROUP_SIZE = BLOCK_SIZE * NUM_DATA_BLOCKS;
        RANDOM = new Random();
    }
}

