/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWebHdfsFileSystemContract
extends FileSystemContractBaseTest {
    private static final Configuration conf = new Configuration();
    private static final MiniDFSCluster cluster;
    private String defaultWorkingDirectory;
    private UserGroupInformation ugi;

    @Before
    public void setUp() throws Exception {
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        this.ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        this.fs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.ugi, conf, "webhdfs");
        this.defaultWorkingDirectory = this.fs.getWorkingDirectory().toUri().getPath();
    }

    protected String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    protected int getGlobalTimeout() {
        return 60000;
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("/test/hadoop");
        Assert.assertFalse((boolean)this.fs.exists(testDir));
        Assert.assertTrue((boolean)this.fs.mkdirs(testDir));
        Assert.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("/test/hadoop/file"));
        Path testSubDir = this.path("/test/hadoop/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)this.fs.exists(testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.path("/test/hadoop/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)this.fs.exists(testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFileBlockLocations() throws IOException {
        String f = "/test/testGetFileBlockLocations";
        this.createFile(this.path("/test/testGetFileBlockLocations"));
        BlockLocation[] computed = this.fs.getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        BlockLocation[] expected = cluster.getFileSystem().getFileBlockLocations(new Path("/test/testGetFileBlockLocations"), 0L, 1L);
        Assert.assertEquals((long)expected.length, (long)computed.length);
        for (int i = 0; i < computed.length; ++i) {
            Assert.assertEquals((Object)expected[i].toString(), (Object)computed[i].toString());
            Object[] names1 = expected[i].getNames();
            Object[] names2 = computed[i].getNames();
            Arrays.sort(names1);
            Arrays.sort(names2);
            Assert.assertArrayEquals((String)"Names differ", (Object[])names1, (Object[])names2);
            Object[] topos1 = expected[i].getTopologyPaths();
            Object[] topos2 = computed[i].getTopologyPaths();
            Arrays.sort(topos1);
            Arrays.sort(topos2);
            Assert.assertArrayEquals((String)"Topology differs", (Object[])topos1, (Object[])topos2);
        }
    }

    @Test
    public void testCaseInsensitive() throws IOException {
        String line;
        Path p = new Path("/test/testCaseInsensitive");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, p, new Param[0]);
        WebHdfsFileSystem.LOG.info("url      = " + url);
        URL replaced = new URL(url.toString().replace(op.toQueryString(), "Op=mkDIrs"));
        WebHdfsFileSystem.LOG.info("replaced = " + replaced);
        HttpURLConnection conn = (HttpURLConnection)replaced.openConnection();
        conn.setRequestMethod(op.getType().toString());
        conn.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            WebHdfsFileSystem.LOG.info("> " + line);
        }
        Assert.assertTrue((boolean)this.fs.getFileStatus(p).isDirectory());
    }

    @Test
    public void testOpenNonExistFile() throws IOException {
        Path p = new Path("/test/testOpenNonExistFile");
        try {
            this.fs.open(p).read();
            Assert.fail((String)"Expected FileNotFoundException was not thrown");
        }
        catch (FileNotFoundException fnfe) {
            WebHdfsFileSystem.LOG.info("This is expected.", (Throwable)fnfe);
        }
    }

    @Test
    public void testSeek() throws IOException {
        int i;
        Path dir = new Path("/test/testSeek");
        Assert.assertTrue((boolean)this.fs.mkdirs(dir));
        Path zero = new Path(dir, "zero");
        this.fs.create(zero).close();
        int count = 0;
        FSDataInputStream in = this.fs.open(zero);
        while (in.read() != -1) {
            ++count;
        }
        in.close();
        Assert.assertEquals((long)0L, (long)count);
        byte[] mydata = new byte[0x100000];
        new Random().nextBytes(mydata);
        Path p = new Path(dir, "file");
        FSDataOutputStream out = this.fs.create(p, false, 4096, (short)3, 131072L);
        out.write(mydata, 0, mydata.length);
        out.close();
        int one_third = mydata.length / 3;
        int two_third = one_third * 2;
        int offset = one_third;
        int len = mydata.length - offset;
        byte[] buf = new byte[len];
        FSDataInputStream in2 = this.fs.open(p);
        in2.seek((long)offset);
        in2.readFully(buf);
        in2.close();
        for (i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (long)mydata[i + offset], (long)buf[i]);
        }
        offset = two_third;
        len = mydata.length - offset;
        buf = new byte[len];
        in2 = this.fs.open(p);
        in2.readFully((long)offset, buf);
        in2.close();
        for (i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i + ", offset=" + offset + ", length=" + len), (long)mydata[i + offset], (long)buf[i]);
        }
    }

    @Test
    public void testRootDir() throws IOException {
        Path root = new Path("/");
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.NULL, root, new Param[0]);
        WebHdfsFileSystem.LOG.info("null url=" + url);
        Assert.assertTrue((boolean)url.toString().contains("v1"));
        FileStatus status = this.fs.getFileStatus(root);
        Assert.assertTrue((status != null ? 1 : 0) != 0);
        Assert.assertEquals((long)511L, (long)status.getPermission().toShort());
        Assert.assertFalse((boolean)this.fs.delete(root, true));
        try {
            FSDataOutputStream out = this.fs.create(root);
            out.write(1);
            out.close();
            Assert.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info("This is expected.", (Throwable)e);
        }
        try {
            FSDataInputStream in = this.fs.open(root);
            in.read();
            Assert.fail();
        }
        catch (IOException e) {
            WebHdfsFileSystem.LOG.info("This is expected.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLengthParamLongerThanFile() throws IOException {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path dir = new Path("/test");
        Assert.assertTrue((boolean)webhdfs.mkdirs(dir));
        Path testFile = new Path("/test/testLengthParamLongerThanFile");
        String content = "testLengthParamLongerThanFile";
        FSDataOutputStream testFileOut = webhdfs.create(testFile);
        try {
            testFileOut.write(content.getBytes("US-ASCII"));
        }
        finally {
            IOUtils.closeStream((Closeable)testFileOut);
        }
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, testFile, new Param[]{new LengthParam(Long.valueOf(content.length() + 1))});
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setDoOutput(op.getDoOutput());
            conn.setInstanceFollowRedirects(true);
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)String.valueOf(content.length()), (Object)conn.getHeaderField("Content-Length"));
            byte[] respBody = new byte[content.length()];
            is = conn.getInputStream();
            IOUtils.readFully((InputStream)is, (byte[])respBody, (int)0, (int)content.length());
            Assert.assertEquals((Object)content, (Object)new String(respBody, "US-ASCII"));
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(is);
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeStream((Closeable)is);
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOffsetPlusLengthParamsLongerThanFile() throws IOException {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path dir = new Path("/test");
        Assert.assertTrue((boolean)webhdfs.mkdirs(dir));
        Path testFile = new Path("/test/testOffsetPlusLengthParamsLongerThanFile");
        String content = "testOffsetPlusLengthParamsLongerThanFile";
        FSDataOutputStream testFileOut = webhdfs.create(testFile);
        try {
            testFileOut.write(content.getBytes("US-ASCII"));
        }
        finally {
            IOUtils.closeStream((Closeable)testFileOut);
        }
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        URL url = webhdfs.toUrl((HttpOpParam.Op)op, testFile, new Param[]{new LengthParam(Long.valueOf(content.length())), new OffsetParam(Long.valueOf(1L))});
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setDoOutput(op.getDoOutput());
            conn.setInstanceFollowRedirects(true);
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)String.valueOf(content.length() - 1), (Object)conn.getHeaderField("Content-Length"));
            byte[] respBody = new byte[content.length() - 1];
            is = conn.getInputStream();
            IOUtils.readFully((InputStream)is, (byte[])respBody, (int)0, (int)(content.length() - 1));
            Assert.assertEquals((Object)content.substring(1), (Object)new String(respBody, "US-ASCII"));
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(is);
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        IOUtils.closeStream((Closeable)is);
        if (conn != null) {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseCode() throws IOException {
        String redirect;
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path root = new Path("/");
        Path dir = new Path("/test/testUrl");
        Assert.assertTrue((boolean)webhdfs.mkdirs(dir));
        Path file = new Path("/test/file");
        FSDataOutputStream out = webhdfs.create(file);
        out.write(1);
        out.close();
        URL url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[0]);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)WebHdfsTestUtil.sendRequest(conn), (long)200L);
        Map<?, ?> m = WebHdfsTestUtil.getAndParseResponse(conn);
        Assert.assertEquals((Object)webhdfs.getHomeDirectory().toUri().getPath(), m.get(Path.class.getSimpleName()));
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETHOMEDIRECTORY, root, new Param[]{new DoAsParam(this.ugi.getShortUserName() + "proxy")});
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
        conn.disconnect();
        url = webhdfs.toUrl((HttpOpParam.Op)PutOpParam.Op.SETOWNER, dir, new Param[0]);
        conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
        conn.disconnect();
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        URL url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        HttpURLConnection conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        Assert.assertEquals((long)200L, (long)conn2.getResponseCode());
        Assert.assertFalse((boolean)webhdfs.setReplication(dir, (short)1));
        conn2.disconnect();
        Path p = new Path(dir, "non-exist");
        url2 = webhdfs.toUrl((HttpOpParam.Op)GetOpParam.Op.GETFILESTATUS, p, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.connect();
        Assert.assertEquals((long)404L, (long)conn2.getResponseCode());
        conn2.disconnect();
        op = PutOpParam.Op.SETPERMISSION;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        Assert.assertEquals((long)200L, (long)conn2.getResponseCode());
        Assert.assertEquals((long)0L, (long)conn2.getContentLength());
        Assert.assertEquals((Object)"application/octet-stream", (Object)conn2.getContentType());
        Assert.assertEquals((long)493L, (long)webhdfs.getFileStatus(dir).getPermission().toShort());
        conn2.disconnect();
        AppendTestUtil.testAppend(this.fs, new Path(dir, "append"));
        op = PutOpParam.Op.CREATE;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, dir, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.setDoOutput(false);
        conn2.setInstanceFollowRedirects(false);
        conn2.connect();
        String redirect2 = conn2.getHeaderField("Location");
        conn2.disconnect();
        WebHdfsFileSystem.LOG.info("redirect = " + redirect2);
        int i = redirect2.indexOf("namenoderpcaddress");
        int j = redirect2.indexOf("&", i);
        String modified = redirect2.substring(0, i - 1) + redirect2.substring(j);
        WebHdfsFileSystem.LOG.info("modified = " + modified);
        conn2 = (HttpURLConnection)new URL(modified).openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.setDoOutput(op.getDoOutput());
        conn2.connect();
        Assert.assertEquals((long)400L, (long)conn2.getResponseCode());
        op = GetOpParam.Op.OPEN;
        url2 = webhdfs.toUrl((HttpOpParam.Op)op, file, new Param[0]);
        conn2 = (HttpURLConnection)url2.openConnection();
        conn2.setRequestMethod(op.getType().toString());
        conn2.connect();
        try {
            WebHdfsFileSystem.jsonParse((HttpURLConnection)conn2, (boolean)false);
            Assert.fail();
        }
        catch (IOException ioe) {
            WebHdfsFileSystem.LOG.info("GOOD", (Throwable)ioe);
        }
        conn2.disconnect();
        op = PutOpParam.Op.CREATE;
        Path path = new Path("/test/path with spaces");
        URL url3 = webhdfs.toUrl((HttpOpParam.Op)op, path, new Param[0]);
        HttpURLConnection conn3 = (HttpURLConnection)url3.openConnection();
        conn3.setRequestMethod(op.getType().toString());
        conn3.setDoOutput(false);
        conn3.setInstanceFollowRedirects(false);
        try {
            conn3.connect();
            Assert.assertEquals((long)307L, (long)conn3.getResponseCode());
            redirect = conn3.getHeaderField("Location");
        }
        finally {
            conn3.disconnect();
        }
        conn3 = (HttpURLConnection)new URL(redirect).openConnection();
        conn3.setRequestMethod(op.getType().toString());
        conn3.setDoOutput(op.getDoOutput());
        try {
            conn3.connect();
            Assert.assertEquals((long)201L, (long)conn3.getResponseCode());
        }
        finally {
            conn3.disconnect();
        }
    }

    @Test
    public void testDatanodeCreateMissingParameter() throws IOException {
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)this.fs;
        Path testDir = new Path(MessageFormat.format("/test/{0}/{1}", TestWebHdfsFileSystemContract.class, GenericTestUtils.getMethodName()));
        Assert.assertTrue((boolean)webhdfs.mkdirs(testDir));
        for (String dnCreateParam : new String[]{"createflag", "createparent", "overwrite"}) {
            PutOpParam.Op op = PutOpParam.Op.CREATE;
            Path newfile = new Path(testDir, "newfile_" + dnCreateParam);
            URL url = webhdfs.toUrl((HttpOpParam.Op)op, newfile, new Param[0]);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setDoOutput(false);
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            String redirect = conn.getHeaderField("Location");
            conn.disconnect();
            WebHdfsFileSystem.LOG.info("redirect = " + redirect);
            String re = "&" + dnCreateParam + "=[^&]*";
            String modified = redirect.replaceAll(re, "");
            WebHdfsFileSystem.LOG.info("modified = " + modified);
            conn = (HttpURLConnection)new URL(modified).openConnection();
            conn.setRequestMethod(op.getType().toString());
            conn.setDoOutput(op.getDoOutput());
            conn.connect();
            Assert.assertEquals((long)201L, (long)conn.getResponseCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccess() throws IOException, InterruptedException {
        Path p1 = new Path("/pathX");
        try {
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"alpha", (String[])new String[]{"beta"});
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, conf, "webhdfs");
            fs.mkdirs(p1);
            fs.setPermission(p1, new FsPermission(292));
            fs.access(p1, FsAction.READ);
            try {
                fs.access(p1, FsAction.WRITE);
                Assert.fail((String)"The access call should have failed.");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            Path badPath = new Path("/bad");
            try {
                fs.access(badPath, FsAction.READ);
                Assert.fail((String)"The access call should have failed");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        finally {
            this.fs.delete(p1, true);
        }
    }

    static {
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            cluster.getFileSystem().setPermission(new Path("/"), new FsPermission(511));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

