/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.util.concurrent.locks.Lock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.datanode.DataSetLockManager;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.StringUtils;

public class AutoCloseDataSetLock
extends AutoCloseableLock {
    private Lock lock;
    private AutoCloseDataSetLock parentLock;
    private DataNodeLockManager<AutoCloseDataSetLock> dataNodeLockManager;

    public AutoCloseDataSetLock(Lock lock) {
        this.lock = lock;
    }

    public void close() {
        if (this.lock != null) {
            this.lock.unlock();
            if (this.dataNodeLockManager != null) {
                this.dataNodeLockManager.hook();
            }
        } else {
            DataSetLockManager.LOG.error((Object)("Try to unlock null lock" + StringUtils.getStackTrace((Thread)Thread.currentThread())));
        }
        if (this.parentLock != null) {
            this.parentLock.close();
        }
    }

    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
            return;
        }
        DataSetLockManager.LOG.error((Object)("Try to lock null lock" + StringUtils.getStackTrace((Thread)Thread.currentThread())));
    }

    public void setParentLock(AutoCloseDataSetLock parent) {
        if (this.parentLock == null) {
            this.parentLock = parent;
        }
    }

    public void setDataNodeLockManager(DataNodeLockManager<AutoCloseDataSetLock> dataNodeLockManager) {
        this.dataNodeLockManager = dataNodeLockManager;
    }
}

