/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.AutoCloseDataSetLock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.common.NoLockManager;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.util.LightWeightResizableGSet;

class ReplicaMap {
    private DataNodeLockManager<AutoCloseDataSetLock> lockManager;
    private final Map<String, LightWeightResizableGSet<Block, ReplicaInfo>> map = new ConcurrentHashMap<String, LightWeightResizableGSet<Block, ReplicaInfo>>();

    ReplicaMap(DataNodeLockManager<AutoCloseDataSetLock> manager) {
        if (manager == null) {
            throw new HadoopIllegalArgumentException("Object to synchronize on cannot be null");
        }
        this.lockManager = manager;
    }

    ReplicaMap() {
        this.lockManager = new NoLockManager();
    }

    String[] getBlockPoolList() {
        Set<String> bpset = this.map.keySet();
        return bpset.toArray(new String[bpset.size()]);
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            ReplicaInfo replicaInfo = m != null ? (ReplicaInfo)m.get((Object)new Block(blockId)) : null;
            return replicaInfo;
        }
    }

    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                this.map.putIfAbsent(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)new LightWeightResizableGSet());
                m = this.map.get(bpid);
            }
            ReplicaInfo replicaInfo2 = (ReplicaInfo)m.put((Object)replicaInfo);
            return replicaInfo2;
        }
    }

    ReplicaInfo addAndGet(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            ReplicaInfo oldReplicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m == null) {
                this.map.putIfAbsent(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)new LightWeightResizableGSet());
                m = this.map.get(bpid);
            }
            if ((oldReplicaInfo = (ReplicaInfo)m.get((Object)replicaInfo)) != null) {
                ReplicaInfo replicaInfo2 = oldReplicaInfo;
                return replicaInfo2;
            }
            m.put((Object)replicaInfo);
            ReplicaInfo replicaInfo3 = replicaInfo;
            return replicaInfo3;
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    void mergeAll(ReplicaMap other) {
        Set<String> bplist = other.map.keySet();
        for (String bp : bplist) {
            this.checkBlockPool(bp);
            AutoCloseDataSetLock l = this.lockManager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bp);
            Throwable throwable = null;
            try {
                LightWeightResizableGSet<Block, ReplicaInfo> replicaInfos = other.map.get(bp);
                LightWeightResizableGSet curSet = this.map.get(bp);
                HashSet<ReplicaInfo> replicaSet = new HashSet<ReplicaInfo>();
                for (ReplicaInfo replicaInfo : replicaInfos) {
                    replicaSet.add(replicaInfo);
                }
                for (ReplicaInfo replicaInfo : replicaSet) {
                    this.checkBlock(replicaInfo);
                    if (curSet == null) {
                        curSet = new LightWeightResizableGSet();
                        this.map.put(bp, (LightWeightResizableGSet<Block, ReplicaInfo>)curSet);
                    }
                    curSet.put((Object)replicaInfo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (l == null) continue;
                if (throwable != null) {
                    try {
                        l.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                l.close();
            }
        }
    }

    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            ReplicaInfo replicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null && (replicaInfo = (ReplicaInfo)m.get((Object)block)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                ReplicaInfo replicaInfo2 = (ReplicaInfo)m.remove((Object)block);
                return replicaInfo2;
            }
        }
        return null;
    }

    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null) {
                ReplicaInfo replicaInfo = (ReplicaInfo)m.remove((Object)new Block(blockId));
                return replicaInfo;
            }
        }
        return null;
    }

    int size(String bpid) {
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            int n = m != null ? m.size() : 0;
            return n;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        m = this.map.get(bpid);
        return m != null ? m.values() : null;
    }

    void replicas(String bpid, Consumer<Iterator<ReplicaInfo>> consumer) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        try (AutoCloseDataSetLock l = this.lockManager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            m = this.map.get(bpid);
            if (m != null) {
                m.getIterator(consumer);
            }
        }
    }

    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseDataSetLock l = this.lockManager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            LightWeightResizableGSet m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)m);
            }
        }
    }

    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseDataSetLock l = this.lockManager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, bpid);){
            this.map.remove(bpid);
        }
    }
}

