/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.common.TokenVerifier;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FsckServlet;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.IsNameNodeActiveServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NetworkTopologyServlet;
import org.apache.hadoop.hdfs.server.namenode.StartupProgressServlet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.eclipse.jetty.servlet.ServletContextHandler;

@InterfaceAudience.Private
public class NameNodeHttpServer {
    private HttpServer2 httpServer;
    private final Configuration conf;
    private final NameNode nn;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private final InetSocketAddress bindAddress;
    public static final String NAMENODE_ADDRESS_ATTRIBUTE_KEY = "name.node.address";
    public static final String FSIMAGE_ATTRIBUTE_KEY = "name.system.image";
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";
    public static final String STARTUP_PROGRESS_ATTRIBUTE_KEY = "startup.progress";
    public static final String ALIASMAP_ATTRIBUTE_KEY = "name.system.aliasmap";

    NameNodeHttpServer(Configuration conf, NameNode nn, InetSocketAddress bindAddress) {
        this.conf = conf;
        this.nn = nn;
        this.bindAddress = bindAddress;
    }

    public static void initWebHdfs(Configuration conf, String hostname, String httpKeytab, HttpServer2 httpServer2, String jerseyResourcePackage) throws IOException {
        UserParam.setUserPattern((String)conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
        AclPermissionParam.setAclPermissionPattern((String)conf.get("dfs.webhdfs.acl.provider.permission.pattern", "^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$"));
        String pathSpec = "/webhdfs/v1/*";
        if (conf.getBoolean("dfs.webhdfs.rest-csrf.enabled", false)) {
            Map restCsrfParams = RestCsrfPreventionFilter.getFilterParams((Configuration)conf, (String)"dfs.webhdfs.rest-csrf.");
            String restCsrfClassName = RestCsrfPreventionFilter.class.getName();
            HttpServer2.defineFilter((ServletContextHandler)httpServer2.getWebAppContext(), (String)restCsrfClassName, (String)restCsrfClassName, (Map)restCsrfParams, (String[])new String[]{"/webhdfs/v1/*"});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("com.sun.jersey.config.feature.IgnoreMatrixParams", "true");
        httpServer2.addJerseyResourcePackage(jerseyResourcePackage + ";" + Param.class.getPackage().getName(), "/webhdfs/v1/*", params);
    }

    void start() throws IOException {
        String bindHost;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(this.conf);
        String infoHost = this.bindAddress.getHostName();
        InetSocketAddress httpAddr = this.bindAddress;
        String httpsAddrString = this.conf.getTrimmed("dfs.namenode.https-address", "0.0.0.0:9871");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr((String)httpsAddrString);
        if (httpsAddr != null && (bindHost = this.conf.getTrimmed("dfs.namenode.https-bind-host")) != null && !bindHost.isEmpty()) {
            httpsAddr = new InetSocketAddress(bindHost, httpsAddr.getPort());
        }
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, httpAddr, httpsAddr, "hdfs", "dfs.namenode.kerberos.internal.spnego.principal", "dfs.namenode.keytab.file");
        boolean xFrameEnabled = this.conf.getBoolean("dfs.xframe.enabled", true);
        String xFrameOptionValue = this.conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
        builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
        this.httpServer = builder.build();
        if (policy.isHttpsEnabled()) {
            InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr((String)this.conf.getTrimmed("dfs.datanode.https.address", infoHost + ":" + 9865));
            this.httpServer.setAttribute("datanode.https.port", (Object)datanodeSslPort.getPort());
        }
        String httpKeytab = this.conf.get(DFSUtil.getSpnegoKeytabKey(this.conf, "dfs.namenode.keytab.file"));
        NameNodeHttpServer.initWebHdfs(this.conf, this.bindAddress.getHostName(), httpKeytab, this.httpServer, NamenodeWebHdfsMethods.class.getPackage().getName());
        this.httpServer.setAttribute(NAMENODE_ATTRIBUTE_KEY, (Object)this.nn);
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        NameNodeHttpServer.setupServlets(this.httpServer);
        this.httpServer.start();
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            this.conf.set("dfs.namenode.http-address", NetUtils.getHostPortString((InetSocketAddress)this.httpAddress));
        }
        if (policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            this.conf.set("dfs.namenode.https-address", NetUtils.getHostPortString((InetSocketAddress)this.httpsAddress));
        }
    }

    public void join() throws InterruptedException {
        if (this.httpServer != null) {
            this.httpServer.join();
        }
    }

    void stop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }

    InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    void setFSImage(FSImage fsImage) {
        this.httpServer.setAttribute(FSIMAGE_ATTRIBUTE_KEY, (Object)fsImage);
    }

    void setNameNodeAddress(InetSocketAddress nameNodeAddress) {
        this.httpServer.setAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY, (Object)NetUtils.getConnectAddress((InetSocketAddress)nameNodeAddress));
    }

    void setStartupProgress(StartupProgress prog) {
        this.httpServer.setAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY, (Object)prog);
    }

    void setAliasMap(InMemoryAliasMap aliasMap) {
        this.httpServer.setAttribute(ALIASMAP_ATTRIBUTE_KEY, (Object)aliasMap);
    }

    private static void setupServlets(HttpServer2 httpServer) {
        httpServer.addInternalServlet("startupProgress", "/startupProgress", StartupProgressServlet.class);
        httpServer.addInternalServlet("fsck", "/fsck", FsckServlet.class, true);
        httpServer.addInternalServlet("imagetransfer", "/imagetransfer", ImageServlet.class, true);
        httpServer.addInternalServlet("isActive", "/isActive", IsNameNodeActiveServlet.class);
        httpServer.addInternalServlet("topology", "/topology", NetworkTopologyServlet.class);
    }

    static FSImage getFsImageFromContext(ServletContext context) {
        return (FSImage)context.getAttribute(FSIMAGE_ATTRIBUTE_KEY);
    }

    public static NameNode getNameNodeFromContext(ServletContext context) {
        return (NameNode)context.getAttribute(NAMENODE_ATTRIBUTE_KEY);
    }

    public static TokenVerifier getTokenVerifierFromContext(ServletContext context) {
        return (TokenVerifier)context.getAttribute(NAMENODE_ATTRIBUTE_KEY);
    }

    static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }

    static InMemoryAliasMap getAliasMapFromContext(ServletContext context) {
        return (InMemoryAliasMap)context.getAttribute(ALIASMAP_ATTRIBUTE_KEY);
    }

    public static InetSocketAddress getNameNodeAddressFromContext(ServletContext context) {
        return (InetSocketAddress)context.getAttribute(NAMENODE_ADDRESS_ATTRIBUTE_KEY);
    }

    static StartupProgress getStartupProgressFromContext(ServletContext context) {
        return (StartupProgress)context.getAttribute(STARTUP_PROGRESS_ATTRIBUTE_KEY);
    }

    public static HAServiceProtocol.HAServiceState getNameNodeStateFromContext(ServletContext context) {
        return NameNodeHttpServer.getNameNodeFromContext(context).getServiceState();
    }

    @VisibleForTesting
    public HttpServer2 getHttpServer() {
        return this.httpServer;
    }
}

