/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.util.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDFSFinalize {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestDFSFinalize");
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info("============================================================");
        LOG.info("***TEST " + this.testCounter++ + "*** " + label + ": numDirs=" + numDirs);
    }

    static void checkResult(String[] nameNodeDirs, String[] dataNodeDirs, String bpid) throws Exception {
        int i;
        ArrayList dirs = Lists.newArrayList();
        for (int i2 = 0; i2 < nameNodeDirs.length; ++i2) {
            File curDir = new File(nameNodeDirs[i2], "current");
            dirs.add(curDir);
            FSImageTestUtil.assertReasonableNameCurrentDir(curDir);
        }
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, Collections.emptySet());
        File[] dnCurDirs = new File[dataNodeDirs.length];
        for (i = 0; i < dataNodeDirs.length; ++i) {
            dnCurDirs[i] = new File(dataNodeDirs[i], "current");
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, dnCurDirs[i], false), (long)UpgradeUtilities.checksumMasterDataNodeContents());
        }
        for (i = 0; i < nameNodeDirs.length; ++i) {
            Assert.assertFalse((boolean)new File(nameNodeDirs[i], "previous").isDirectory());
        }
        if (bpid == null) {
            for (i = 0; i < dataNodeDirs.length; ++i) {
                Assert.assertFalse((boolean)new File(dataNodeDirs[i], "previous").isDirectory());
            }
        } else {
            for (i = 0; i < dataNodeDirs.length; ++i) {
                File bpRoot = BlockPoolSliceStorage.getBpRoot((String)bpid, (File)dnCurDirs[i]);
                Assert.assertFalse((boolean)new File(bpRoot, "previous").isDirectory());
                File bpCurFinalizeDir = new File(bpRoot, "current/finalized");
                Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpCurFinalizeDir, true), (long)UpgradeUtilities.checksumMasterBlockPoolFinalizedContents());
            }
        }
    }

    @Test
    public void testFinalize() throws Exception {
        UpgradeUtilities.initialize();
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", false);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            String[] nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.datanode.data.dir");
            this.log("Finalize NN & DN with existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            this.cluster.finalizeCluster(this.conf);
            this.cluster.triggerBlockReports();
            Thread.sleep(1000L);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs, null);
            this.log("Finalize NN & DN without existing previous dir", numDirs);
            this.cluster.finalizeCluster(this.conf);
            this.cluster.triggerBlockReports();
            Thread.sleep(1000L);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs, null);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("Finalize NN & BP with existing previous dir", numDirs);
            String bpid = UpgradeUtilities.getCurrentBlockPoolID(this.cluster);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createBlockPoolStorageDirs(dataNodeDirs, "current", bpid);
            UpgradeUtilities.createBlockPoolStorageDirs(dataNodeDirs, "previous", bpid);
            this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
            this.cluster.finalizeCluster(this.conf);
            this.cluster.triggerBlockReports();
            Thread.sleep(1000L);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs, bpid);
            this.log("Finalize NN & BP without existing previous dir", numDirs);
            this.cluster.finalizeCluster(this.conf);
            this.cluster.triggerBlockReports();
            Thread.sleep(1000L);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs, bpid);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSFinalize().testFinalize();
    }
}

