/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataSetLockManager;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImplBuilder;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaLruTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsDatasetImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestFsDatasetImpl.class);
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private String replicaCacheRootDir = BASE_DIR + "/" + "cache";
    private static final int NUM_INIT_VOLUMES = 2;
    private static final String CLUSTER_ID = "cluser-id";
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private FsDatasetImpl dataset;
    private DataSetLockManager manager = new DataSetLockManager();
    private static final String BLOCKPOOL = "BP-TEST";
    @Rule
    public TestName name = new TestName();

    private static Storage.StorageDirectory createStorageDirectory(File root, Configuration conf) throws SecurityException, IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(StorageLocation.parse((String)root.toURI().toString()));
        DataStorage.createStorageID((Storage.StorageDirectory)sd, (boolean)false, (Configuration)conf);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs) throws IOException {
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        FileUtils.deleteDirectory((File)new File(BASE_DIR));
        for (int i = 0; i < numDirs; ++i) {
            File loc = new File(BASE_DIR + "/data" + i);
            dirStrings.add(new Path(loc.toString()).toUri().toString());
            loc.mkdirs();
            dirs.add(TestFsDatasetImpl.createStorageDirectory(loc, conf));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn(dirs.get(i));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.dirIterator()).thenReturn(dirs.iterator());
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)numDirs);
    }

    private static StorageLocation createStorageWithStorageType(String subDir, StorageType storageType, Configuration conf, DataStorage storage, DataNode dataNode) throws IOException {
        String archiveStorageType = "[" + storageType + "]";
        String path = BASE_DIR + subDir;
        new File(path).mkdirs();
        String pathUri = new Path(path).toUri().toString();
        StorageLocation loc = StorageLocation.parse((String)(archiveStorageType + pathUri));
        Storage.StorageDirectory sd = new Storage.StorageDirectory(loc);
        DataStorage.createStorageID((Storage.StorageDirectory)sd, (boolean)false, (Configuration)conf);
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(storage, sd);
        Mockito.when((Object)storage.prepareVolume((DataNode)ArgumentMatchers.eq((Object)dataNode), (StorageLocation)ArgumentMatchers.eq((Object)loc), ArgumentMatchers.anyList())).thenReturn((Object)builder);
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNumVolumes() {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            int n = volumes.size();
            return n;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        this.conf.set("dfs.datanode.replica.cache.root.dir", this.replicaCacheRootDir);
        Mockito.when((Object)this.datanode.getDataSetLockManager()).thenReturn((Object)this.manager);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        DNConf dnConf = new DNConf((Configurable)this.datanode);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        DataNodeMetrics dataNodeMetrics = DataNodeMetrics.create((Configuration)this.conf, (String)"mockName");
        Mockito.when((Object)this.datanode.getMetrics()).thenReturn((Object)dataNodeMetrics);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 2);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
        Assert.assertEquals((long)2L, (long)this.getNumVolumes());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
    }

    @After
    public void checkDataSetLockManager() {
        this.manager.lockLeakCheck();
        Assert.assertNull((Object)this.manager.getLastException());
    }

    @Test
    public void testAddVolumes() throws IOException {
        int numNewVolumes = 3;
        int numExistingVolumes = this.getNumVolumes();
        int totalVolumes = 3 + numExistingVolumes;
        HashSet<String> expectedVolumes = new HashSet<String>();
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        for (int i = 0; i < 3; ++i) {
            String path = BASE_DIR + "/newData" + i;
            String pathUri = new Path(path).toUri().toString();
            expectedVolumes.add(new File(pathUri).getAbsolutePath());
            StorageLocation loc = StorageLocation.parse((String)pathUri);
            Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path), this.conf);
            DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
            Mockito.when((Object)this.storage.prepareVolume((DataNode)ArgumentMatchers.eq((Object)this.datanode), (StorageLocation)ArgumentMatchers.eq((Object)loc), ArgumentMatchers.anyList())).thenReturn((Object)builder);
            this.dataset.addVolume(loc, (List)nsInfos);
            LOG.info("expectedVolumes " + i + " is " + new File(pathUri).getAbsolutePath());
        }
        Assert.assertEquals((long)totalVolumes, (long)this.getNumVolumes());
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.storageMap.size());
        HashSet<String> actualVolumes = new HashSet<String>();
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            for (int i = 0; i < 3; ++i) {
                String volumeName = volumes.get(numExistingVolumes + i).toString();
                actualVolumes.add(volumeName);
                LOG.info("actualVolume " + i + " is " + volumeName);
            }
        }
        Assert.assertEquals((long)actualVolumes.size(), (long)expectedVolumes.size());
        Assert.assertTrue((boolean)actualVolumes.containsAll(expectedVolumes));
    }

    @Test
    public void testAddVolumeWithSameDiskTiering() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        this.conf.set("dfs.datanode.replica.cache.root.dir", this.replicaCacheRootDir);
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.4);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        DNConf dnConf = new DNConf((Configurable)this.datanode);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        Mockito.when((Object)this.datanode.getDataSetLockManager()).thenReturn((Object)this.manager);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 1);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        StorageLocation archive = TestFsDatasetImpl.createStorageWithStorageType("archive1", StorageType.ARCHIVE, this.conf, this.storage, this.datanode);
        this.dataset.addVolume(archive, (List)nsInfos);
        Assert.assertEquals((long)2L, (long)this.dataset.getVolumeCount());
        String mount = new DF(new File(archive.getUri()), this.conf).getMount();
        double archiveRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.ARCHIVE);
        double diskRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.DISK);
        Assert.assertEquals((double)0.4, (double)archiveRatio, (double)0.0);
        Assert.assertEquals((double)0.6, (double)diskRatio, (double)0.0);
        try {
            this.dataset.addVolume(TestFsDatasetImpl.createStorageWithStorageType("archive2", StorageType.ARCHIVE, this.conf, this.storage, this.datanode), (List)nsInfos);
            Assert.fail((String)"Should throw exception for same storage type already exists on same mount.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Storage type ARCHIVE already exists on same mount:"));
        }
    }

    @Test
    public void testAddVolumeWithCustomizedCapacityRatio() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        this.conf.set("dfs.datanode.replica.cache.root.dir", this.replicaCacheRootDir);
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
        String archivedir = "/archive1";
        String diskdir = "/disk1";
        String configStr = "[0.3]file:" + BASE_DIR + archivedir + ", [0.6]file:" + BASE_DIR + diskdir;
        this.conf.set("dfs.datanode.same-disk-tiering.capacity-ratio.percentage", configStr);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        DNConf dnConf = new DNConf((Configurable)this.datanode);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        Mockito.when((Object)this.datanode.getDataSetLockManager()).thenReturn((Object)this.manager);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 0);
        this.dataset = this.createStorageWithCapacityRatioConfig(configStr, archivedir, diskdir);
        Path p = new Path("file:" + BASE_DIR);
        String mount = new DF(new File(p.toUri()), this.conf).getMount();
        double archiveRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.ARCHIVE);
        double diskRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.DISK);
        Assert.assertEquals((double)0.3, (double)archiveRatio, (double)0.0);
        Assert.assertEquals((double)0.6, (double)diskRatio, (double)0.0);
        configStr = "[0.3]file:" + BASE_DIR + archivedir;
        this.dataset = this.createStorageWithCapacityRatioConfig(configStr, archivedir, diskdir);
        mount = new DF(new File(p.toUri()), this.conf).getMount();
        archiveRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.ARCHIVE);
        diskRatio = this.dataset.getMountVolumeMap().getCapacityRatioByMountAndStorageType(mount, StorageType.DISK);
        Assert.assertEquals((double)0.3, (double)archiveRatio, (double)0.0);
        Assert.assertEquals((double)0.7, (double)diskRatio, (double)0.0);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        configStr = "[0.3]file:" + BASE_DIR + archivedir + ", [0.8]file:" + BASE_DIR + diskdir;
        try {
            this.createStorageWithCapacityRatioConfig(configStr, archivedir, diskdir);
            Assert.fail((String)"Should fail add volume as capacity ratio sum is > 1");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity ratio left on mount"));
        }
    }

    private FsDatasetImpl createStorageWithCapacityRatioConfig(String configStr, String archivedir, String diskdir) throws IOException {
        this.conf.set("dfs.datanode.same-disk-tiering.capacity-ratio.percentage", configStr);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        StorageLocation archive = TestFsDatasetImpl.createStorageWithStorageType(archivedir, StorageType.ARCHIVE, this.conf, this.storage, this.datanode);
        StorageLocation disk = TestFsDatasetImpl.createStorageWithStorageType(diskdir, StorageType.DISK, this.conf, this.storage, this.datanode);
        this.dataset.addVolume(archive, (List)nsInfos);
        this.dataset.addVolume(disk, (List)nsInfos);
        Assert.assertEquals((long)2L, (long)this.dataset.getVolumeCount());
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddVolumeWithSameStorageUuid() throws IOException {
        HdfsConfiguration config = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
        try {
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.getDataNodes().get(0).isConnectedToNN(cluster.getNameNode().getServiceRpcAddress()));
            MiniDFSCluster.DataNodeProperties dn = cluster.stopDataNode(0);
            File vol0 = cluster.getStorageDir(0, 0);
            File vol1 = cluster.getStorageDir(0, 1);
            Storage.StorageDirectory sd0 = new Storage.StorageDirectory(vol0);
            Storage.StorageDirectory sd1 = new Storage.StorageDirectory(vol1);
            FileUtils.copyFile((File)sd0.getVersionFile(), (File)sd1.getVersionFile());
            cluster.restartDataNode(dn, true);
            cluster.waitActive();
            Assert.assertFalse((boolean)cluster.getDataNodes().get(0).isConnectedToNN(cluster.getNameNode().getServiceRpcAddress()));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRemoveOneVolume() throws IOException {
        int numBlocks = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            try (ReplicaHandler replica = null;){
                replica = this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);
                continue;
            }
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        String volumePathToRemove = dataDirs[0];
        HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
        volumesToRemove.add(StorageLocation.parse((String)volumePathToRemove));
        FsDatasetSpi.FsVolumeReferences volReferences = this.dataset.getFsVolumeReferences();
        FsVolumeImpl volumeToRemove = null;
        for (FsVolumeSpi vol : volReferences) {
            if (!vol.getStorageLocation().equals(volumesToRemove.iterator().next())) continue;
            volumeToRemove = (FsVolumeImpl)vol;
        }
        Assert.assertTrue((volumeToRemove != null ? 1 : 0) != 0);
        volReferences.close();
        this.dataset.removeVolumes(volumesToRemove, true);
        int expectedNumVolumes = dataDirs.length - 1;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.getNumVolumes());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        ((DataNode)Mockito.verify((Object)this.datanode, (VerificationMode)Mockito.times((int)50))).notifyNamenodeDeletedBlock((ExtendedBlock)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        try {
            this.dataset.asyncDiskService.execute(volumeToRemove, new Runnable(){

                @Override
                public void run() {
                }
            });
            Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find volume", (Throwable)e);
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)50L, (long)totalNumReplicas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRemoveTwoVolumes() throws IOException {
        int numBlocks = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            try (ReplicaHandler replica = null;){
                replica = this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);
                continue;
            }
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
        volumesToRemove.add(StorageLocation.parse((String)dataDirs[0]));
        volumesToRemove.add(StorageLocation.parse((String)dataDirs[1]));
        FsDatasetSpi.FsVolumeReferences volReferences = this.dataset.getFsVolumeReferences();
        HashSet<FsVolumeImpl> volumes = new HashSet<FsVolumeImpl>();
        for (Object vol : volReferences) {
            for (StorageLocation volume : volumesToRemove) {
                if (!vol.getStorageLocation().equals((Object)volume)) continue;
                volumes.add((FsVolumeImpl)vol);
            }
        }
        Assert.assertEquals((long)2L, (long)volumes.size());
        volReferences.close();
        this.dataset.removeVolumes(volumesToRemove, true);
        int expectedNumVolumes = dataDirs.length - 2;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.getNumVolumes());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        ((DataNode)Mockito.verify((Object)this.datanode, (VerificationMode)Mockito.times((int)100))).notifyNamenodeDeletedBlock((ExtendedBlock)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        for (FsVolumeImpl volume : volumes) {
            try {
                this.dataset.asyncDiskService.execute(volume, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
            }
            catch (RuntimeException e) {
                GenericTestUtils.assertExceptionContains((String)"Cannot find volume", (Throwable)e);
            }
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)0L, (long)totalNumReplicas);
    }

    @Test(timeout=30000L)
    public void testConcurrentWriteAndDeleteBlock() throws Exception {
        int numBlocks = 1000;
        int threadCount = 10;
        ExecutorService pool = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        final Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String bpid = BLOCK_POOL_IDS[random.nextInt(BLOCK_POOL_IDS.length)];
                        for (int blockId = 0; blockId < 1000; ++blockId) {
                            ExtendedBlock eb = new ExtendedBlock(bpid, (long)blockId);
                            try (ReplicaHandler replica = null;){
                                replica = TestFsDatasetImpl.this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);
                                if (blockId % 2 <= 0) continue;
                                TestFsDatasetImpl.this.dataset.invalidate(bpid, new Block[]{eb.getLocalBlock()});
                                continue;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.setName("AddBlock" + i);
            futureList.add(pool.submit(thread));
        }
        for (Future future : futureList) {
            future.get();
        }
        GenericTestUtils.waitFor(() -> this.dataset.asyncDiskService.countPendingDeletions() == 0L, (long)100L, (long)10000L);
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            Assert.assertEquals((long)500L, (long)this.dataset.volumeMap.size(bpid));
        }
    }

    @Test(timeout=5000L)
    public void testRemoveNewlyAddedVolume() throws IOException {
        int numExistingVolumes = this.getNumVolumes();
        ArrayList<NamespaceInfo> nsInfos = new ArrayList<NamespaceInfo>();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        String newVolumePath = BASE_DIR + "/newVolumeToRemoveLater";
        StorageLocation loc = StorageLocation.parse((String)newVolumePath);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(newVolumePath), this.conf);
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)ArgumentMatchers.eq((Object)this.datanode), (StorageLocation)ArgumentMatchers.eq((Object)loc), ArgumentMatchers.anyList())).thenReturn((Object)builder);
        this.dataset.addVolume(loc, nsInfos);
        Assert.assertEquals((long)(numExistingVolumes + 1), (long)this.getNumVolumes());
        Mockito.when((Object)this.storage.getNumStorageDirs()).thenReturn((Object)(numExistingVolumes + 1));
        Mockito.when((Object)this.storage.getStorageDir(numExistingVolumes)).thenReturn((Object)sd);
        HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
        volumesToRemove.add(loc);
        this.dataset.removeVolumes(volumesToRemove, true);
        Assert.assertEquals((long)numExistingVolumes, (long)this.getNumVolumes());
    }

    @Test
    public void testAddVolumeFailureReleasesInUseLock() throws IOException {
        FsDatasetImpl spyDataset = (FsDatasetImpl)Mockito.spy((Object)this.dataset);
        FsVolumeImpl mockVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File badDir = new File(BASE_DIR, "bad");
        Mockito.when((Object)mockVolume.getStorageID()).thenReturn((Object)"test");
        badDir.mkdirs();
        ((FsDatasetImpl)Mockito.doReturn((Object)mockVolume).when((Object)spyDataset)).createFsVolume(ArgumentMatchers.anyString(), (Storage.StorageDirectory)ArgumentMatchers.any(Storage.StorageDirectory.class), (StorageLocation)ArgumentMatchers.any(StorageLocation.class));
        ((FsVolumeImpl)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Failed to getVolumeMap()")}).when((Object)mockVolume)).getVolumeMap(ArgumentMatchers.anyString(), (ReplicaMap)ArgumentMatchers.any(ReplicaMap.class), (RamDiskReplicaTracker)ArgumentMatchers.any(RamDiskReplicaLruTracker.class));
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(badDir, this.conf);
        sd.lock();
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)ArgumentMatchers.eq((Object)this.datanode), (StorageLocation)ArgumentMatchers.eq((Object)StorageLocation.parse((String)badDir.toURI().toString())), ArgumentMatchers.anyList())).thenReturn((Object)builder);
        StorageLocation location = StorageLocation.parse((String)badDir.toString());
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        try {
            spyDataset.addVolume(location, (List)nsInfos);
            Assert.fail((String)"Expect to throw MultipleIOException");
        }
        catch (MultipleIOException multipleIOException) {
            // empty catch block
        }
        FsDatasetTestUtil.assertFileLockReleased(badDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeletingBlocks() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            ExtendedBlock eb;
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetSpi<?> ds = DataNodeTestUtils.getFSDataset(dn);
            ds.addBlockPool(BLOCKPOOL, (Configuration)conf);
            try (FsDatasetSpi.FsVolumeReferences volumes = ds.getFsVolumeReferences();){
                FsVolumeImpl vol = (FsVolumeImpl)volumes.get(0);
            }
            ArrayList<Block> blockList = new ArrayList<Block>();
            for (int i = 1; i <= 63; ++i) {
                eb = new ExtendedBlock(BLOCKPOOL, (long)i, 1L, (long)(1000 + i));
                cluster.getFsDatasetTestUtils(0).createFinalizedReplica(eb);
                blockList.add(eb.getLocalBlock());
            }
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
            blockList.clear();
            eb = new ExtendedBlock(BLOCKPOOL, 64L, 1L, 1064L);
            cluster.getFsDatasetTestUtils(0).createFinalizedReplica(eb);
            blockList.add(eb.getLocalBlock());
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testDuplicateReplicaResolution() throws IOException {
        FsVolumeImpl fsv1 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        FsVolumeImpl fsv2 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File f1 = new File("d1/block");
        File f2 = new File("d2/block");
        FinalizedReplica replicaOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replica = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaOtherOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv2, f2);
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaSame, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOlder, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaNewer, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherSame, (ReplicaInfo)replica));
        Assert.assertSame((Object)replicaOtherOlder, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherOlder, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherNewer, (ReplicaInfo)replica));
    }

    @Test
    public void testLoadingDfsUsedForVolumes() throws IOException, InterruptedException {
        long waitIntervalTime = 5000L;
        long cachedDfsUsedIntervalTime = waitIntervalTime + 1000L;
        this.conf.setLong("dfs.datanode.cached-dfsused.check.interval.ms", cachedDfsUsedIntervalTime);
        long cacheDfsUsed = 1024L;
        long dfsUsed = this.getDfsUsedValueOfNewVolume(cacheDfsUsed, waitIntervalTime);
        Assert.assertEquals((long)cacheDfsUsed, (long)dfsUsed);
    }

    @Test
    public void testLoadingDfsUsedForVolumesExpired() throws IOException, InterruptedException {
        long waitIntervalTime = 5000L;
        long cachedDfsUsedIntervalTime = waitIntervalTime - 1000L;
        this.conf.setLong("dfs.datanode.cached-dfsused.check.interval.ms", cachedDfsUsedIntervalTime);
        long cacheDfsUsed = 1024L;
        long dfsUsed = this.getDfsUsedValueOfNewVolume(cacheDfsUsed, waitIntervalTime);
        Assert.assertTrue((cacheDfsUsed != dfsUsed ? 1 : 0) != 0);
    }

    private long getDfsUsedValueOfNewVolume(long cacheDfsUsed, long waitIntervalTime) throws IOException, InterruptedException {
        FsVolumeImpl newVolume;
        ArrayList nsInfos = Lists.newArrayList();
        nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, BLOCK_POOL_IDS[0], 1L));
        String CURRENT_DIR = "current";
        String DU_CACHE_FILE = "dfsUsed";
        String path = BASE_DIR + "/newData0";
        String pathUri = new Path(path).toUri().toString();
        StorageLocation loc = StorageLocation.parse((String)pathUri);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path), this.conf);
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)ArgumentMatchers.eq((Object)this.datanode), (StorageLocation)ArgumentMatchers.eq((Object)loc), ArgumentMatchers.anyList())).thenReturn((Object)builder);
        String cacheFilePath = String.format("%s/%s/%s/%s/%s", path, CURRENT_DIR, BLOCK_POOL_IDS[0], CURRENT_DIR, DU_CACHE_FILE);
        File outFile = new File(cacheFilePath);
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        FakeTimer timer = new FakeTimer();
        try (OutputStreamWriter out2 = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            out2.write(Long.toString(cacheDfsUsed) + " " + Long.toString(timer.now()));
            ((Writer)out2).flush();
        }
        catch (IOException out2) {
            // empty catch block
        }
        this.dataset.setTimer((Timer)timer);
        timer.advance(waitIntervalTime);
        this.dataset.addVolume(loc, (List)nsInfos);
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            newVolume = (FsVolumeImpl)volumes.get(volumes.size() - 1);
        }
        long dfsUsed = newVolume.getDfsUsed();
        return dfsUsed;
    }

    @Test(timeout=60000L)
    public void testRemoveVolumeBeingWritten() throws Exception {
        final ExtendedBlock eb = new ExtendedBlock(BLOCK_POOL_IDS[0], 0L);
        final CountDownLatch startFinalizeLatch = new CountDownLatch(1);
        final CountDownLatch blockReportReceivedLatch = new CountDownLatch(1);
        final CountDownLatch volRemoveStartedLatch = new CountDownLatch(1);
        final CountDownLatch volRemoveCompletedLatch = new CountDownLatch(1);
        class ResponderThread
        extends Thread {
            ResponderThread() {
            }

            @Override
            public void run() {
                try (ReplicaHandler replica = TestFsDatasetImpl.this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);){
                    LOG.info("CreateRbw finished");
                    startFinalizeLatch.countDown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        LOG.info("Ignoring ", (Throwable)ie);
                    }
                    blockReportReceivedLatch.await();
                    TestFsDatasetImpl.this.dataset.finalizeBlock(eb, false);
                    LOG.info("FinalizeBlock finished");
                }
                catch (Exception e) {
                    LOG.warn("Exception caught. This should not affect the test", (Throwable)e);
                }
            }
        }
        ResponderThread responderThread = new ResponderThread();
        responderThread.start();
        startFinalizeLatch.await();
        class BlockReportThread
        extends Thread {
            BlockReportThread() {
            }

            @Override
            public void run() {
                try {
                    volRemoveStartedLatch.await();
                }
                catch (Exception e) {
                    LOG.info("Unexpected exception when waiting for vol removal:", (Throwable)e);
                }
                LOG.info("Getting block report");
                TestFsDatasetImpl.this.dataset.getBlockReports(eb.getBlockPoolId());
                LOG.info("Successfully received block report");
                blockReportReceivedLatch.countDown();
            }
        }
        BlockReportThread blockReportThread = new BlockReportThread();
        blockReportThread.start();
        class VolRemoveThread
        extends Thread {
            VolRemoveThread() {
            }

            @Override
            public void run() {
                HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
                try {
                    volumesToRemove.add(TestFsDatasetImpl.this.dataset.getVolume(eb).getStorageLocation());
                }
                catch (Exception e) {
                    LOG.info("Problem preparing volumes to remove: ", (Throwable)e);
                    Assert.fail((String)"Exception in remove volume thread, check log for details.");
                }
                LOG.info("Removing volume " + volumesToRemove);
                TestFsDatasetImpl.this.dataset.removeVolumes(volumesToRemove, true);
                volRemoveCompletedLatch.countDown();
                LOG.info("Removed volume " + volumesToRemove);
            }
        }
        VolRemoveThread volRemoveThread = new VolRemoveThread();
        volRemoveThread.start();
        Thread.sleep(2000L);
        volRemoveStartedLatch.countDown();
        blockReportReceivedLatch.await();
        volRemoveCompletedLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanShutdownOfVolume() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration config = new HdfsConfiguration();
            config.setLong("dfs.datanode.xceiver.stop.timeout.millis", 1000L);
            config.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
            config.setInt("dfs.datanode.failed.volumes.tolerated", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)config, GenericTestUtils.getRandomizedTestDir()).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path("test.dat");
            FSDataOutputStream out = fs.create(filePath, (short)1);
            out.write(1);
            out.hflush();
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            final FsVolumeImpl volume = (FsVolumeImpl)dataNode.getFSDataset().getVolume(block);
            File finalizedDir = volume.getFinalizedDir(cluster.getNamesystem().getBlockPoolId());
            LocatedBlock lb = DFSTestUtil.getAllBlocks((FileSystem)fs, filePath).get(0);
            DatanodeInfoWithStorage info = lb.getLocations()[0];
            if (finalizedDir.exists()) {
                finalizedDir.setExecutable(false);
                Assert.assertTrue((boolean)FileUtil.setWritable((File)finalizedDir, (boolean)false));
            }
            Assert.assertTrue((String)"Reference count for the volume should be greater than 0", (volume.getReferenceCount() > 0 ? 1 : 0) != 0);
            dataNode.checkDiskError();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return volume.getReferenceCount() == 0;
                }
            }, (long)100L, (long)1000L);
            Assert.assertThat((Object)dataNode.getFSDataset().getNumFailedVolumes(), (Matcher)Is.is((Object)1));
            try {
                out.close();
                Assert.fail((String)"This is not a valid code path. out.close should have thrown an exception.");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)info.getXferAddr(), (Throwable)ioe);
            }
            Assert.assertTrue((boolean)FileUtil.setWritable((File)finalizedDir, (boolean)true));
            finalizedDir.setExecutable(true);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testReportBadBlocks() throws Exception {
        boolean threwException = false;
        HdfsConfiguration config = new HdfsConfiguration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();){
            cluster.waitActive();
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
            DataNode dataNode = cluster.getDataNodes().get(0);
            ExtendedBlock block = new ExtendedBlock(cluster.getNamesystem().getBlockPoolId(), 0L);
            try {
                dataNode.reportBadBlocks(block);
            }
            catch (NullPointerException npe) {
                threwException = true;
            }
            Thread.sleep(3000L);
            Assert.assertFalse((boolean)threwException);
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
            DistributedFileSystem fs = cluster.getFileSystem();
            Path filePath = new Path(this.name.getMethodName());
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 0L);
            block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            dataNode.reportBadBlocks(block, dataNode.getFSDataset().getFsVolumeReferences().get(0));
            DataNodeTestUtils.triggerHeartbeat(dataNode);
            BlockManagerTestUtil.updateState(cluster.getNamesystem().getBlockManager());
            Assert.assertEquals((String)"Corrupt replica blocks could not be reflected with the heartbeat", (long)1L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
        }
    }

    @Test(timeout=30000L)
    public void testMoveBlockFailure() {
        this.testMoveBlockFailure(this.conf);
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
        this.testMoveBlockFailure(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMoveBlockFailure(Configuration config) {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            long fileLen = 100L;
            ExtendedBlock block = this.createTestFile((FileSystem)fs, fileLen, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo newReplicaInfo = this.createNewReplicaObjWithLink(block, fsDataSetImpl);
            FSDataOutputStream out = fs.append(filePath, 1);
            out.write(100);
            out.hflush();
            Assert.assertTrue((boolean)newReplicaInfo.blockDataExists());
            LOG.info("GenerationStamp of old replica: {}", (Object)block.getGenerationStamp());
            LOG.info("GenerationStamp of new replica: {}", (Object)fsDataSetImpl.getReplicaInfo(block.getBlockPoolId(), newReplicaInfo.getBlockId()).getGenerationStamp());
            LambdaTestUtils.intercept(IOException.class, (String)"Generation Stamp should be monotonically increased.", () -> fsDataSetImpl.finalizeNewReplica(newReplicaInfo, block));
            Assert.assertFalse((boolean)newReplicaInfo.blockDataExists());
            this.validateFileLen((FileSystem)fs, fileLen, filePath);
        }
        catch (Exception ex) {
            LOG.info("Exception in testMoveBlockFailure ", (Throwable)ex);
            Assert.fail((String)"Exception while testing testMoveBlockFailure ");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMoveBlockSuccess() {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            DFSTestUtil.createFile((FileSystem)fs, filePath, 100L, (short)1, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo newReplicaInfo = this.createNewReplicaObj(block, fsDataSetImpl);
            fsDataSetImpl.finalizeNewReplica(newReplicaInfo, block);
        }
        catch (Exception ex) {
            LOG.info("Exception in testMoveBlockSuccess ", (Throwable)ex);
            Assert.fail((String)"MoveBlock operation should succeed");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDnRestartWithHardLinkInTmp() {
        MiniDFSCluster cluster = null;
        try {
            this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
            this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            long fileLen = 100L;
            ExtendedBlock block = this.createTestFile((FileSystem)fs, fileLen, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo oldReplicaInfo = fsDataSetImpl.getReplicaInfo(block);
            ReplicaInfo newReplicaInfo = this.createNewReplicaObjWithLink(block, fsDataSetImpl);
            Assert.assertTrue((boolean)Files.exists(Paths.get(newReplicaInfo.getBlockURI()), new LinkOption[0]));
            cluster.restartDataNode(0);
            cluster.waitDatanodeFullyStarted(cluster.getDataNodes().get(0), 60000);
            cluster.triggerBlockReports();
            Assert.assertFalse((boolean)Files.exists(Paths.get(newReplicaInfo.getBlockURI()), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(Paths.get(oldReplicaInfo.getBlockURI()), new LinkOption[0]));
            this.validateFileLen((FileSystem)fs, fileLen, filePath);
        }
        catch (Exception ex) {
            LOG.info("Exception in testDnRestartWithHardLinkInTmp ", (Throwable)ex);
            Assert.fail((String)"Exception while testing testDnRestartWithHardLinkInTmp ");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDnRestartWithHardLink() throws Exception {
        MiniDFSCluster cluster = null;
        boolean isReplicaDeletionEnabled = this.conf.getBoolean("dfs.datanode.duplicate.replica.deletion", true);
        try {
            this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
            this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
            this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", false);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).storagesPerDatanode(2).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            long fileLen = 100L;
            ExtendedBlock block = this.createTestFile((FileSystem)fs, fileLen, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo oldReplicaInfo = fsDataSetImpl.getReplicaInfo(block);
            StorageType oldStorageType = oldReplicaInfo.getVolume().getStorageType();
            fsDataSetImpl.finalizeNewReplica(this.createNewReplicaObjWithLink(block, fsDataSetImpl), block);
            ReplicaInfo newReplicaInfo = fsDataSetImpl.getReplicaInfo(block);
            StorageType newStorageType = newReplicaInfo.getVolume().getStorageType();
            Assert.assertEquals((Object)StorageType.DISK, (Object)oldStorageType);
            Assert.assertEquals((Object)StorageType.ARCHIVE, (Object)newStorageType);
            cluster.restartDataNode(0);
            cluster.waitDatanodeFullyStarted(cluster.getDataNodes().get(0), 60000);
            cluster.triggerBlockReports();
            Assert.assertTrue((boolean)Files.exists(Paths.get(newReplicaInfo.getBlockURI()), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(Paths.get(oldReplicaInfo.getBlockURI()), new LinkOption[0]));
            FsDatasetSpi fsDataset = cluster.getDataNodes().get(0).getFSDataset();
            DirectoryScanner scanner = new DirectoryScanner(fsDataset, this.conf);
            FsVolumeImpl fsVolume = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
            fsVolume.getBlockPoolSlice(fsVolume.getBlockPoolList()[0]).setDeleteDuplicateReplicasForTests(true);
            scanner.start();
            scanner.run();
            GenericTestUtils.waitFor(() -> !Files.exists(Paths.get(oldReplicaInfo.getBlockURI()), new LinkOption[0]), (long)100L, (long)10000L, (String)"Old replica is not deleted by DirScanner even after 10s of waiting has elapsed");
            Assert.assertTrue((boolean)Files.exists(Paths.get(newReplicaInfo.getBlockURI()), new LinkOption[0]));
            this.validateFileLen((FileSystem)fs, fileLen, filePath);
            fs.delete(filePath, false);
            GenericTestUtils.waitFor(() -> !Files.exists(Paths.get(newReplicaInfo.getBlockURI()), new LinkOption[0]), (long)100L, (long)10000L);
        }
        finally {
            this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", isReplicaDeletionEnabled);
            if (cluster != null && cluster.isClusterUp()) {
                cluster.shutdown(true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMoveBlockSuccessWithSameMountMove() {
        MiniDFSCluster cluster = null;
        try {
            this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
            this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            long fileLen = 100L;
            ExtendedBlock block = this.createTestFile((FileSystem)fs, fileLen, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            Assert.assertEquals((Object)StorageType.DISK, (Object)fsDataSetImpl.getReplicaInfo(block).getVolume().getStorageType());
            FsDatasetImpl fsDataSetImplSpy = (FsDatasetImpl)Mockito.spy((Object)((FsDatasetImpl)dataNode.getFSDataset()));
            fsDataSetImplSpy.moveBlockAcrossStorage(block, StorageType.ARCHIVE, null);
            ((FsDatasetImpl)Mockito.verify((Object)fsDataSetImplSpy)).moveBlock((ExtendedBlock)ArgumentMatchers.any(), (ReplicaInfo)ArgumentMatchers.any(), (FsVolumeReference)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            Assert.assertEquals((Object)StorageType.ARCHIVE, (Object)fsDataSetImpl.getReplicaInfo(block).getVolume().getStorageType());
            this.validateFileLen((FileSystem)fs, fileLen, filePath);
        }
        catch (Exception ex) {
            LOG.info("Exception in testMoveBlockSuccessWithSameMountMove ", (Throwable)ex);
            Assert.fail((String)"testMoveBlockSuccessWithSameMountMove operation should succeed");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMoveBlockWithSameMountMoveWithoutSpace() {
        MiniDFSCluster cluster = null;
        try {
            this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
            this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.0);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            long fileLen = 100L;
            ExtendedBlock block = this.createTestFile((FileSystem)fs, fileLen, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            Assert.assertEquals((Object)StorageType.DISK, (Object)fsDataSetImpl.getReplicaInfo(block).getVolume().getStorageType());
            FsDatasetImpl fsDataSetImplSpy = (FsDatasetImpl)Mockito.spy((Object)((FsDatasetImpl)dataNode.getFSDataset()));
            fsDataSetImplSpy.moveBlockAcrossStorage(block, StorageType.ARCHIVE, null);
            Assert.fail((String)"testMoveBlockWithSameMountMoveWithoutSpace operation should failed");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof DiskChecker.DiskOutOfSpaceException));
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=10000L)
    public void testShouldConsiderSameMountVolume() throws IOException {
        FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)BASE_DIR))).build();
        Assert.assertFalse((boolean)this.dataset.shouldConsiderSameMountVolume((FsVolumeSpi)volume, StorageType.ARCHIVE, null));
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.5);
        volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)BASE_DIR))).build();
        Assert.assertTrue((boolean)this.dataset.shouldConsiderSameMountVolume((FsVolumeSpi)volume, StorageType.ARCHIVE, null));
        Assert.assertTrue((boolean)this.dataset.shouldConsiderSameMountVolume((FsVolumeSpi)volume, StorageType.ARCHIVE, ""));
        Assert.assertFalse((boolean)this.dataset.shouldConsiderSameMountVolume((FsVolumeSpi)volume, StorageType.DISK, null));
        Assert.assertFalse((boolean)this.dataset.shouldConsiderSameMountVolume((FsVolumeSpi)volume, StorageType.ARCHIVE, "target"));
    }

    private ReplicaInfo createNewReplicaObj(ExtendedBlock block, FsDatasetImpl fsDataSetImpl) throws IOException {
        ReplicaInfo replicaInfo = fsDataSetImpl.getReplicaInfo(block);
        FsVolumeSpi destVolume = this.getDestinationVolume(block, fsDataSetImpl);
        return fsDataSetImpl.copyReplicaToVolume(block, replicaInfo, destVolume.obtainReference());
    }

    private ReplicaInfo createNewReplicaObjWithLink(ExtendedBlock block, FsDatasetImpl fsDataSetImpl) throws IOException {
        ReplicaInfo replicaInfo = fsDataSetImpl.getReplicaInfo(block);
        FsVolumeSpi destVolume = this.getDestinationVolume(block, fsDataSetImpl);
        return fsDataSetImpl.moveReplicaToVolumeOnSameMount(block, replicaInfo, destVolume.obtainReference());
    }

    private ExtendedBlock createTestFile(FileSystem fs, long fileLen, Path filePath) throws IOException {
        DFSTestUtil.createFile(fs, filePath, fileLen, (short)1, 0L);
        return DFSTestUtil.getFirstBlock(fs, filePath);
    }

    private void validateFileLen(FileSystem fs, long fileLen, Path filePath) throws IOException {
        FSDataInputStream in = fs.open(filePath);
        int bytesCount = 0;
        while (in.read() != -1) {
            ++bytesCount;
        }
        Assert.assertTrue((fileLen <= (long)bytesCount ? 1 : 0) != 0);
    }

    private FsVolumeSpi getDestinationVolume(ExtendedBlock block, FsDatasetImpl fsDataSetImpl) throws IOException {
        FsVolumeSpi destVolume = null;
        String srcStorageId = fsDataSetImpl.getVolume(block).getStorageID();
        try (FsDatasetSpi.FsVolumeReferences volumeReferences = fsDataSetImpl.getFsVolumeReferences();){
            for (int i = 0; i < volumeReferences.size(); ++i) {
                if (volumeReferences.get(i).getStorageID().equals(srcStorageId)) continue;
                destVolume = volumeReferences.get(i);
                break;
            }
        }
        return destVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000000L)
    public void testBlockReadOpWhileMovingBlock() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            this.conf.setInt("dfs.replication", 1);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path("/tmp/testData");
            String blockData = RandomStringUtils.randomAscii((int)2048);
            FSDataOutputStream fout = fs.create(filePath);
            fout.writeBytes(blockData);
            fout.close();
            Assert.assertEquals((Object)blockData, (Object)DFSTestUtil.readFile((FileSystem)fs, filePath));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            BlockReaderTestUtil util = new BlockReaderTestUtil(cluster, new HdfsConfiguration(this.conf));
            LocatedBlock blk = util.getFileBlocks(filePath, 1024).get(0);
            File[] blkFiles = cluster.getAllBlockFiles(block);
            LOG.info("Reading partial data for block {} before moving it: ", (Object)blk.getBlock().toString());
            BlockReader blkReader = BlockReaderTestUtil.getBlockReader(fs, blk, 0, 1024L);
            byte[] buf = new byte[1024];
            blkReader.read(buf, 0, 512);
            Assert.assertEquals((Object)blockData.substring(0, 512), (Object)new String(buf, StandardCharsets.US_ASCII).substring(0, 512));
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo replicaInfo = fsDataSetImpl.getReplicaInfo(block);
            FsVolumeSpi destVolume = this.getDestinationVolume(block, fsDataSetImpl);
            Assert.assertNotNull((String)"Destination volume should not be null.", (Object)destVolume);
            fsDataSetImpl.moveBlock(block, replicaInfo, destVolume.obtainReference(), false);
            cluster.triggerBlockReports();
            blkReader.read(buf, 512, 512);
            Assert.assertEquals((Object)blockData.substring(0, 1024), (Object)new String(buf, StandardCharsets.US_ASCII).substring(0, 1024));
            blkReader = BlockReaderTestUtil.getBlockReader(fs, blk, 0, blockData.length());
            buf = new byte[2048];
            blkReader.read(buf, 0, 2048);
            Assert.assertEquals((Object)blockData, (Object)new String(buf, StandardCharsets.US_ASCII));
            blkReader.close();
            ExtendedBlock block2 = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            File[] blkFiles2 = cluster.getAllBlockFiles(block2);
            blk = util.getFileBlocks(filePath, 2048).get(0);
            blkReader = BlockReaderTestUtil.getBlockReader(fs, blk, 0, blockData.length());
            blkReader.read(buf, 0, 2048);
            Assert.assertFalse((boolean)Files.exists(Paths.get(blkFiles[0].getAbsolutePath(), new String[0]), new LinkOption[0]));
            Assert.assertNotEquals((Object)blkFiles[0], (Object)blkFiles2[0]);
            Assert.assertEquals((Object)blockData, (Object)new String(buf, StandardCharsets.US_ASCII));
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=30000L)
    public void testDataDirWithPercent() throws IOException {
        String baseDir = new FileSystemTestHelper().getTestRootDir();
        File dataDir = new File(baseDir, "invalidFormatString-%z");
        dataDir.mkdirs();
        FsVolumeImpl volumeFixed = new FsVolumeImplBuilder().setConf((Configuration)new HdfsConfiguration()).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)dataDir.getPath()))).build();
    }

    @Test
    public void testReplicaCacheFileToOtherPlace() throws IOException {
        String bpid = "bpid-0";
        for (int i = 0; i < 5; ++i) {
            ExtendedBlock eb = new ExtendedBlock("bpid-0", (long)i);
            this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);
        }
        ArrayList<File> cacheFiles = new ArrayList<File>();
        for (FsVolumeSpi vol : this.dataset.getFsVolumeReferences()) {
            BlockPoolSlice bpSlice = ((FsVolumeImpl)vol).getBlockPoolSlice("bpid-0");
            File cacheFile = new File(this.replicaCacheRootDir + "/" + bpSlice.getDirectory().getCanonicalPath() + "/" + "current" + "/" + "replicas");
            cacheFiles.add(cacheFile);
        }
        this.dataset.shutdownBlockPool("bpid-0");
        for (File f : cacheFiles) {
            Assert.assertTrue((boolean)f.exists());
        }
    }

    @Test
    public void testGetMetadataLengthOfFinalizedReplica() throws IOException {
        FsVolumeImpl fsv1 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File blockDir = new File(BASE_DIR, "testFinalizedReplica/block");
        if (!blockDir.exists()) {
            Assert.assertTrue((boolean)blockDir.mkdirs());
        }
        long blockID = 1L;
        long genStamp = 2L;
        File metaFile = new File(blockDir, "blk_" + blockID + "_" + genStamp + ".meta");
        FileOutputStream os = new FileOutputStream(metaFile);
        ((OutputStream)os).write("TEST_META_SIZE".getBytes());
        ((OutputStream)os).close();
        long fileLength = metaFile.length();
        FinalizedReplica replica = new FinalizedReplica(blockID, 2L, genStamp, (FsVolumeSpi)fsv1, blockDir);
        long metaLength = replica.getMetadataLength();
        Assert.assertEquals((long)fileLength, (long)metaLength);
        metaFile.delete();
        metaLength = replica.getMetadataLength();
        Assert.assertEquals((long)fileLength, (long)metaLength);
        if (!blockDir.exists()) {
            Assert.assertTrue((boolean)blockDir.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotifyNamenodeMissingOrNewBlock() throws Exception {
        long blockSize = 1024L;
        int heatbeatInterval = 1;
        HdfsConfiguration c = new HdfsConfiguration();
        c.setInt("dfs.heartbeat.interval", heatbeatInterval);
        c.setLong("dfs.blocksize", blockSize);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)c).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/f1"), blockSize, (short)1, 0L);
            String bpid = cluster.getNameNode().getNamesystem().getBlockPoolId();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetSpi fsdataset = dn.getFSDataset();
            List replicaInfos = fsdataset.getFinalizedBlocks(bpid);
            Assert.assertEquals((long)1L, (long)replicaInfos.size());
            ReplicaInfo replicaInfo = (ReplicaInfo)replicaInfos.get(0);
            String blockPath = replicaInfo.getBlockURI().getPath();
            String metaPath = replicaInfo.getMetadataURI().getPath();
            String blockTempPath = blockPath + ".tmp";
            String metaTempPath = metaPath + ".tmp";
            File blockFile = new File(blockPath);
            File blockTempFile = new File(blockTempPath);
            File metaFile = new File(metaPath);
            File metaTempFile = new File(metaTempPath);
            blockFile.renameTo(blockTempFile);
            metaFile.renameTo(metaTempFile);
            Assert.assertFalse((boolean)blockFile.exists());
            Assert.assertFalse((boolean)metaFile.exists());
            FsVolumeSpi.ScanInfo info = new FsVolumeSpi.ScanInfo(replicaInfo.getBlockId(), blockFile.getParentFile().getAbsoluteFile(), blockFile.getName(), metaFile.getName(), replicaInfo.getVolume());
            fsdataset.checkAndUpdate(bpid, info);
            BlockManager blockManager = cluster.getNameNode().getNamesystem().getBlockManager();
            GenericTestUtils.waitFor(() -> blockManager.getLowRedundancyBlocksCount() == 1L, (long)100L, (long)5000L);
            blockTempFile.renameTo(blockFile);
            metaTempFile.renameTo(metaFile);
            fsdataset.checkAndUpdate(bpid, info);
            GenericTestUtils.waitFor(() -> blockManager.getLowRedundancyBlocksCount() == 0L, (long)100L, (long)5000L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testReleaseVolumeRefIfExceptionThrown() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        cluster.waitActive();
        FsVolumeImpl vol = (FsVolumeImpl)this.dataset.getFsVolumeReferences().get(0);
        int beforeCnt = 0;
        try {
            ArrayList<FinalizedReplica> blockList = new ArrayList<FinalizedReplica>();
            ExtendedBlock eb = new ExtendedBlock(BLOCKPOOL, 1L, 1L, 1001L);
            FinalizedReplica info = new FinalizedReplica(eb.getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
            this.dataset.volumeMap.add(BLOCKPOOL, (ReplicaInfo)info);
            ((LocalReplica)info).getBlockFile().createNewFile();
            ((LocalReplica)info).getMetaFile().createNewFile();
            blockList.add(info);
            this.dataset.asyncDiskService.shutdown();
            beforeCnt = vol.getReferenceCount();
            this.dataset.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
        }
        catch (RuntimeException re) {
            int afterCnt = vol.getReferenceCount();
            Assert.assertEquals((long)beforeCnt, (long)afterCnt);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testTransferAndNativeCopyMetrics() throws IOException {
        HdfsConfiguration config = new HdfsConfiguration();
        config.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        config.set("dfs.metrics.percentiles.intervals", "60,300,1500");
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path(this.name.getMethodName());
            DFSTestUtil.createFile((FileSystem)fs, filePath, 100L, (short)1, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo newReplicaInfo = this.createNewReplicaObj(block, fsDataSetImpl);
            fsDataSetImpl.finalizeNewReplica(newReplicaInfo, block);
            FsVolumeSpi volume = null;
            for (FsVolumeSpi fsVolumeReference : fsDataSetImpl.getFsVolumeReferences()) {
                if (fsVolumeReference.getStorageID().equals(newReplicaInfo.getStorageUuid())) continue;
                volume = fsVolumeReference;
            }
            DataNodeVolumeMetrics metrics = volume.getMetrics();
            Assert.assertEquals((long)2L, (long)metrics.getTransferIoSampleCount());
            Assert.assertEquals((long)3L, (long)metrics.getTransferIoQuantiles().length);
            Assert.assertEquals((long)2L, (long)metrics.getNativeCopyIoSampleCount());
            Assert.assertEquals((long)3L, (long)metrics.getNativeCopyIoQuantiles().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAysncDiskServiceDeleteReplica() throws IOException, InterruptedException, TimeoutException {
        HdfsConfiguration config = new HdfsConfiguration();
        config.setInt("dfs.namenode.redundancy.interval.seconds", 10);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        String bpid = cluster.getNamesystem().getBlockPoolId();
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        final Semaphore semaphore = new Semaphore(0);
        try {
            cluster.waitActive();
            DataNodeFaultInjector injector = new DataNodeFaultInjector(){

                public void delayDeleteReplica() {
                    try {
                        semaphore.acquire(1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            DataNodeFaultInjector.set((DataNodeFaultInjector)injector);
            Path path = new Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, path, (short)3);
            LocatedBlock lb = DFSTestUtil.getAllBlocks((FileSystem)fs, path).get(0);
            ExtendedBlock extendedBlock = lb.getBlock();
            DatanodeInfoWithStorage[] loc = lb.getLocations();
            Assert.assertEquals((long)3L, (long)loc.length);
            DataNode dn = cluster.getDataNode(loc[0].getIpcPort());
            FsDatasetImpl ds = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            ArrayList blockList = Lists.newArrayList((Object[])new Block[]{extendedBlock.getLocalBlock()});
            Assert.assertNotNull((Object)ds.getStoredBlock(bpid, extendedBlock.getBlockId()));
            ds.invalidate(bpid, blockList.toArray(new Block[0]));
            loc = DFSTestUtil.getAllBlocks((FileSystem)fs, path).get(0).getLocations();
            Assert.assertEquals((long)3L, (long)loc.length);
            ArrayList uuids = Lists.newArrayList();
            for (DatanodeInfoWithStorage datanodeInfo : loc) {
                uuids.add(datanodeInfo.getDatanodeUuid());
            }
            Assert.assertTrue((boolean)uuids.contains(dn.getDatanodeUuid()));
            Assert.assertNotNull((Object)ds.getStoredBlock(bpid, extendedBlock.getBlockId()));
            semaphore.release(1);
            GenericTestUtils.waitFor(() -> ds.asyncDiskService.countPendingDeletions() == 0L, (long)100L, (long)1000L);
            Thread.sleep(config.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS) * 2L);
            loc = DFSTestUtil.getAllBlocks((FileSystem)fs, path).get(0).getLocations();
            Assert.assertEquals((long)2L, (long)loc.length);
            uuids = Lists.newArrayList();
            for (DatanodeInfoWithStorage datanodeInfo : loc) {
                uuids.add(datanodeInfo.getDatanodeUuid());
            }
            Assert.assertFalse((boolean)uuids.contains(dn.getDatanodeUuid()));
            Assert.assertNull((Object)ds.getStoredBlock(bpid, extendedBlock.getBlockId()));
        }
        finally {
            cluster.shutdown();
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }
}

