/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReservedSpaceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReservedSpaceCalculator {
    private Configuration conf;
    private DF usage;
    private ReservedSpaceCalculator reserved;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.usage = (DF)Mockito.mock(DF.class);
    }

    @Test
    public void testReservedSpaceAbsolute() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorAbsolute.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved", 900L);
        this.checkReserved(StorageType.DISK, 10000L, 900L);
        this.checkReserved(StorageType.SSD, 10000L, 900L);
        this.checkReserved(StorageType.ARCHIVE, 10000L, 900L);
        this.checkReserved(StorageType.NVDIMM, 10000L, 900L);
    }

    @Test
    public void testReservedSpaceAbsolutePerStorageType() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorAbsolute.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.disk", 500L);
        this.checkReserved(StorageType.DISK, 2300L, 500L);
        this.conf.setLong("dfs.datanode.du.reserved.ssd", 750L);
        this.checkReserved(StorageType.SSD, 1550L, 750L);
        this.conf.setLong("dfs.datanode.du.reserved.nvdimm", 300L);
        this.checkReserved(StorageType.NVDIMM, 1000L, 300L);
    }

    @Test
    public void testReservedSpacePercentage() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorPercentage.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.pct", 10L);
        this.checkReserved(StorageType.DISK, 10000L, 1000L);
        this.checkReserved(StorageType.SSD, 10000L, 1000L);
        this.checkReserved(StorageType.ARCHIVE, 10000L, 1000L);
        this.checkReserved(StorageType.NVDIMM, 10000L, 1000L);
        this.conf.setLong("dfs.datanode.du.reserved.pct", 50L);
        this.checkReserved(StorageType.DISK, 4000L, 2000L);
        this.checkReserved(StorageType.SSD, 4000L, 2000L);
        this.checkReserved(StorageType.ARCHIVE, 4000L, 2000L);
        this.checkReserved(StorageType.NVDIMM, 4000L, 2000L);
    }

    @Test
    public void testReservedSpacePercentagePerStorageType() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorPercentage.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.pct.disk", 20L);
        this.checkReserved(StorageType.DISK, 1600L, 320L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.ssd", 50L);
        this.checkReserved(StorageType.SSD, 8001L, 4000L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.nvdimm", 30L);
        this.checkReserved(StorageType.NVDIMM, 1000L, 300L);
    }

    @Test
    public void testReservedSpaceConservativePerStorageType() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorConservative.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.disk", 800L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.disk", 20L);
        this.checkReserved(StorageType.DISK, 1600L, 800L);
        this.conf.setLong("dfs.datanode.du.reserved.archive", 1300L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.archive", 50L);
        this.checkReserved(StorageType.ARCHIVE, 6200L, 3100L);
        this.conf.setLong("dfs.datanode.du.reserved.nvdimm", 500L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.nvdimm", 20L);
        this.checkReserved(StorageType.NVDIMM, 3000L, 600L);
    }

    @Test
    public void testReservedSpaceAggresivePerStorageType() {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorAggressive.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.ram_disk", 100L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.ram_disk", 10L);
        this.checkReserved(StorageType.RAM_DISK, 1600L, 100L);
        this.conf.setLong("dfs.datanode.du.reserved.archive", 20000L);
        this.conf.setLong("dfs.datanode.du.reserved.pct.archive", 5L);
        this.checkReserved(StorageType.ARCHIVE, 100000L, 5000L);
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidCalculator() {
        this.conf.set("dfs.datanode.du.reserved.calculator", "INVALIDTYPE");
        this.reserved = new ReservedSpaceCalculator.Builder(this.conf).setUsage(this.usage).setStorageType(StorageType.DISK).build();
    }

    private void checkReserved(StorageType storageType, long totalCapacity, long reservedExpected) {
        Mockito.when((Object)this.usage.getCapacity()).thenReturn((Object)totalCapacity);
        this.reserved = new ReservedSpaceCalculator.Builder(this.conf).setUsage(this.usage).setStorageType(storageType).build();
        Assert.assertEquals((long)reservedExpected, (long)this.reserved.getReserved());
    }
}

