/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminBackoffMonitor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorInterface;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfyManager;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeReconfigure {
    public static final Logger LOG = LoggerFactory.getLogger(TestNameNodeReconfigure.class);
    private MiniDFSCluster cluster;
    private final int customizedBlockInvalidateLimit = 500;

    @Before
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.block.invalidate.limit", 500);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
    }

    @Test
    public void testReconfigureCallerContextEnabled() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        FSNamesystem nameSystem = nameNode.getNamesystem();
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "text");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "true");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, true);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "false");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", null);
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)false, (Object)nameSystem.getCallerContextEnabled());
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", null, (Object)nameNode.getConf().get("hadoop.caller.context.enabled"));
    }

    void verifyReconfigureCallerContextEnabled(NameNode nameNode, FSNamesystem nameSystem, boolean expected) {
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)expected, (Object)nameNode.getNamesystem().getCallerContextEnabled());
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)expected, (Object)nameNode.getConf().getBoolean("hadoop.caller.context.enabled", false));
    }

    @Test
    public void testReconfigureIPCBackoff() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeRpcServer nnrs = (NameNodeRpcServer)nameNode.getRpcServer();
        String ipcClientRPCBackoffEnable = NameNode.buildBackoffEnableKey((int)nnrs.getClientRpcServer().getPort());
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "true");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, true);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "false");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, null);
        Assert.assertEquals((String)(ipcClientRPCBackoffEnable + " has wrong value"), (Object)false, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled());
        Assert.assertEquals((String)(ipcClientRPCBackoffEnable + " has wrong value"), null, (Object)nameNode.getConf().get(ipcClientRPCBackoffEnable));
    }

    void verifyReconfigureIPCBackoff(NameNode nameNode, NameNodeRpcServer nnrs, String property, boolean expected) {
        Assert.assertEquals((String)(property + " has wrong value"), (Object)expected, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled());
        Assert.assertEquals((String)(property + " has wrong value"), (Object)expected, (Object)nameNode.getConf().getBoolean(property, false));
    }

    @Test
    public void testReconfigureHearbeatCheck() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "6");
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "600000");
        try {
            nameNode.reconfigureProperty("dfs.heartbeat.interval", "text");
            Assert.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        try {
            nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "text");
            Assert.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)nameNode.getConf().getLong("dfs.heartbeat.interval", 3L));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)datanodeManager.getHeartbeatInterval());
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)600000L, (long)nameNode.getConf().getInt("dfs.namenode.heartbeat.recheck-interval", 300000));
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)600000L, (long)datanodeManager.getHeartbeatRecheckInterval());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "1m");
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)60L, (long)nameNode.getConf().getLong("dfs.heartbeat.interval", 3L));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)60L, (long)datanodeManager.getHeartbeatInterval());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", null);
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", null);
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", null, (Object)nameNode.getConf().get("dfs.heartbeat.interval"));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)3L, (long)datanodeManager.getHeartbeatInterval());
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", null, (Object)nameNode.getConf().get("dfs.namenode.heartbeat.recheck-interval"));
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)300000L, (long)datanodeManager.getHeartbeatRecheckInterval());
    }

    @Test(timeout=30000L)
    public void testReconfigureSPSWithStoragePolicyDisabled() throws ReconfigurationException, IOException {
        this.cluster.shutdown();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.storage.policy.enabled", false);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        NameNode nameNode = this.cluster.getNameNode();
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        Assert.assertNull((String)"SPS shouldn't start as dfs.storage.policy.enabled is disabled", (Object)nameNode.getNamesystem().getBlockManager().getSPSManager());
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL, false);
        Assert.assertEquals((String)"dfs.storage.policy.satisfier.mode has wrong value", (Object)HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString(), (Object)nameNode.getConf().get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT));
    }

    @Test(timeout=30000L)
    public void testReconfigureStoragePolicySatisfierEnabled() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        try {
            nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", "text");
            Assert.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException e) {
            GenericTestUtils.assertExceptionContains((String)"For enabling or disabling storage policy satisfier, must pass either internal/external/none string value only", (Throwable)e.getCause());
        }
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        Assert.assertEquals((String)"dfs.storage.policy.satisfier.mode has wrong value", (Object)false, (Object)nameNode.getNamesystem().getBlockManager().getSPSManager().isSatisfierRunning());
        Assert.assertEquals((String)"dfs.storage.policy.satisfier.mode has wrong value", (Object)HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString(), (Object)nameNode.getConf().get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT));
        Assert.assertNotNull((String)"SPS Manager should be created", (Object)nameNode.getNamesystem().getBlockManager().getSPSManager());
    }

    @Test(timeout=30000L)
    public void testSatisfyStoragePolicyAfterSatisfierDisabled() throws ReconfigurationException, IOException {
        NameNode nameNode = this.cluster.getNameNode();
        nameNode.reconfigureProperty("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        this.verifySPSEnabled(nameNode, "dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE, false);
        Assert.assertNull((String)"SPS Manager should be null", (Object)nameNode.getNamesystem().getBlockManager().getSPSManager());
        Path filePath = new Path("/testSPS");
        DistributedFileSystem fileSystem = this.cluster.getFileSystem();
        fileSystem.create(filePath);
        fileSystem.setStoragePolicy(filePath, "COLD");
        try {
            fileSystem.satisfyStoragePolicy(filePath);
            Assert.fail((String)"Expected to fail, as storage policy feature has disabled.");
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot request to satisfy storage policy when storage policy satisfier feature has been disabled by admin. Seek for an admin help to enable it or use Mover tool.", (Throwable)e);
        }
    }

    void verifySPSEnabled(NameNode nameNode, String property, HdfsConstants.StoragePolicySatisfierMode expected, boolean isSatisfierRunning) {
        StoragePolicySatisfyManager spsMgr = nameNode.getNamesystem().getBlockManager().getSPSManager();
        boolean isSPSRunning = spsMgr != null ? spsMgr.isSatisfierRunning() : false;
        Assert.assertEquals((String)(property + " has wrong value"), (Object)isSatisfierRunning, (Object)isSPSRunning);
        String actual = nameNode.getConf().get(property, DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT);
        Assert.assertEquals((String)(property + " has wrong value"), (Object)expected, (Object)HdfsConstants.StoragePolicySatisfierMode.fromString((String)actual));
    }

    @Test
    public void testBlockInvalidateLimitAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not correctly set", (long)500L, (long)datanodeManager.getBlockInvalidateLimit());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(6));
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not honored after reconfiguration", (long)500L, (long)datanodeManager.getBlockInvalidateLimit());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(50));
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not reconfigured correctly", (long)1000L, (long)datanodeManager.getBlockInvalidateLimit());
    }

    @Test
    public void testEnableParallelLoadAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        Assert.assertEquals((Object)false, (Object)FSImageFormatProtobuf.getEnableParallelLoad());
        nameNode.reconfigureProperty("dfs.image.parallel.load", Boolean.toString(true));
        Assert.assertEquals((Object)true, (Object)FSImageFormatProtobuf.getEnableParallelLoad());
    }

    @Test
    public void testEnableSlowNodesParametersAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        BlockManager blockManager = nameNode.namesystem.getBlockManager();
        DatanodeManager datanodeManager = blockManager.getDatanodeManager();
        Assert.assertEquals((Object)false, (Object)datanodeManager.getEnableAvoidSlowDataNodesForRead());
        nameNode.reconfigureProperty("dfs.namenode.avoid.read.slow.datanode", Boolean.toString(true));
        Assert.assertEquals((Object)true, (Object)datanodeManager.getEnableAvoidSlowDataNodesForRead());
        Assert.assertEquals((Object)false, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.CONTIGUOUS));
        Assert.assertEquals((Object)false, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.STRIPED));
        nameNode.reconfigureProperty("dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", Boolean.toString(true));
        Assert.assertEquals((Object)true, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.CONTIGUOUS));
        Assert.assertEquals((Object)true, (Object)blockManager.getExcludeSlowNodesEnabled(BlockType.STRIPED));
    }

    @Test
    public void testReconfigureMaxSlowpeerCollectNodes() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertEquals((long)5L, (long)datanodeManager.getMaxSlowpeerCollectNodes());
        nameNode.reconfigureProperty("dfs.namenode.max.slowpeer.collect.nodes", Integer.toString(10));
        Assert.assertEquals((long)10L, (long)datanodeManager.getMaxSlowpeerCollectNodes());
    }

    @Test
    public void testBlockInvalidateLimit() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not correctly set", (long)500L, (long)datanodeManager.getBlockInvalidateLimit());
        try {
            nameNode.reconfigureProperty("dfs.block.invalidate.limit", "non-numeric");
            Assert.fail((String)"Should not reach here");
        }
        catch (ReconfigurationException e) {
            Assert.assertEquals((Object)"Could not change property dfs.block.invalidate.limit from '500' to 'non-numeric'", (Object)e.getMessage());
        }
        nameNode.reconfigureProperty("dfs.block.invalidate.limit", "2500");
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not honored after reconfiguration", (long)2500L, (long)datanodeManager.getBlockInvalidateLimit());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "500");
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not reconfigured correctly", (long)10000L, (long)datanodeManager.getBlockInvalidateLimit());
    }

    @Test
    public void testSlowPeerTrackerEnabled() throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertFalse((String)"SlowNode tracker is already enabled. It should be disabled by default", (boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled());
        Assert.assertTrue((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        try {
            nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "non-boolean");
            Assert.fail((String)"should not reach here");
        }
        catch (ReconfigurationException e) {
            Assert.assertEquals((Object)"Could not change property dfs.datanode.peer.stats.enabled from 'false' to 'non-boolean'", (Object)e.getMessage());
        }
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "True");
        Assert.assertTrue((String)"SlowNode tracker is still disabled. Reconfiguration could not be successful", (boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled());
        Assert.assertFalse((boolean)datanodeManager.isSlowPeerCollectorInitialized());
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", null);
        Assert.assertFalse((String)"SlowNode tracker is still enabled. Reconfiguration could not be successful", (boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled());
    }

    @Test
    public void testSlowPeerMaxNodesToReportReconf() throws Exception {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        nameNode.reconfigurePropertyImpl("dfs.datanode.peer.stats.enabled", "true");
        Assert.assertTrue((String)"SlowNode tracker is still disabled. Reconfiguration could not be successful", (boolean)datanodeManager.getSlowPeerTracker().isSlowPeerTrackerEnabled());
        SlowPeerTracker tracker = datanodeManager.getSlowPeerTracker();
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.1));
        tracker.addReport("node1", "node70", outlierMetrics1);
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.23));
        tracker.addReport("node2", "node71", outlierMetrics2);
        OutlierMetrics outlierMetrics3 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(2.13));
        tracker.addReport("node3", "node72", outlierMetrics3);
        OutlierMetrics outlierMetrics4 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.244));
        tracker.addReport("node4", "node73", outlierMetrics4);
        OutlierMetrics outlierMetrics5 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.2));
        tracker.addReport("node5", "node74", outlierMetrics4);
        OutlierMetrics outlierMetrics6 = new OutlierMetrics(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.244));
        tracker.addReport("node6", "node75", outlierMetrics4);
        String jsonReport = tracker.getJson();
        LOG.info("Retrieved slow peer json report: {}", (Object)jsonReport);
        List<Boolean> containReport = this.validatePeerReport(jsonReport);
        Assert.assertEquals((long)1L, (long)containReport.stream().filter(reportVal -> reportVal == false).count());
        nameNode.reconfigurePropertyImpl("dfs.datanode.max.nodes.to.report", "2");
        jsonReport = tracker.getJson();
        LOG.info("Retrieved slow peer json report: {}", (Object)jsonReport);
        containReport = this.validatePeerReport(jsonReport);
        Assert.assertEquals((long)4L, (long)containReport.stream().filter(reportVal -> reportVal == false).count());
    }

    private List<Boolean> validatePeerReport(String jsonReport) {
        ArrayList<Boolean> containReport = new ArrayList<Boolean>();
        containReport.add(jsonReport.contains("node1"));
        containReport.add(jsonReport.contains("node2"));
        containReport.add(jsonReport.contains("node3"));
        containReport.add(jsonReport.contains("node4"));
        containReport.add(jsonReport.contains("node5"));
        containReport.add(jsonReport.contains("node6"));
        return containReport;
    }

    @Test
    public void testReconfigureDecommissionBackoffMonitorParameters() throws ReconfigurationException, IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setClass("dfs.namenode.decommission.monitor.class", DatanodeAdminBackoffMonitor.class, DatanodeAdminMonitorInterface.class);
        int defaultPendingRepLimit = 1000;
        conf.setInt("dfs.namenode.decommission.backoff.monitor.pending.limit", defaultPendingRepLimit);
        int defaultBlocksPerLock = 1000;
        conf.setInt("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", defaultBlocksPerLock);
        try (MiniDFSCluster newCluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            newCluster.waitActive();
            NameNode nameNode = newCluster.getNameNode();
            DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
            Assert.assertEquals((long)datanodeManager.getDatanodeAdminManager().getPendingRepLimit(), (long)defaultPendingRepLimit);
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "non-numeric");
                Assert.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assert.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.limit from '" + defaultPendingRepLimit + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "-1");
                Assert.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assert.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.limit from '" + defaultPendingRepLimit + "' to '-1'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.limit", "20000");
            Assert.assertEquals((long)datanodeManager.getDatanodeAdminManager().getPendingRepLimit(), (long)20000L);
            Assert.assertEquals((long)datanodeManager.getDatanodeAdminManager().getBlocksPerLock(), (long)defaultBlocksPerLock);
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "non-numeric");
                Assert.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assert.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock from '" + defaultBlocksPerLock + "' to 'non-numeric'"), (Object)e.getMessage());
            }
            try {
                nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "-1");
                Assert.fail((String)"Should not reach here");
            }
            catch (ReconfigurationException e) {
                Assert.assertEquals((Object)("Could not change property dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock from '" + defaultBlocksPerLock + "' to '-1'"), (Object)e.getMessage());
            }
            nameNode.reconfigureProperty("dfs.namenode.decommission.backoff.monitor.pending.blocks.per.lock", "10000");
            Assert.assertEquals((long)datanodeManager.getDatanodeAdminManager().getBlocksPerLock(), (long)10000L);
        }
    }

    @After
    public void shutDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }
}

