/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestSnapshot {
    private static final long seed = Time.now();
    private static final Random random = new Random(seed);
    protected static final short REPLICATION = 3;
    protected static final int BLOCKSIZE = 1024;
    public static final int SNAPSHOT_ITERATION_NUMBER = 20;
    public static final int DIRECTORY_TREE_LEVEL = 5;
    protected Configuration conf;
    protected static MiniDFSCluster cluster;
    protected static FSNamesystem fsn;
    protected static FSDirectory fsdir;
    protected DistributedFileSystem hdfs;
    private static final String testDir;
    @Rule
    public ExpectedException exception;
    protected static final ArrayList<Path> snapshotList;
    private SnapshotTestHelper.TestDirectoryTree dirTree;
    static int modificationCount;
    private static int snapshotCount;

    public TestSnapshot() {
        GenericTestUtils.setLogLevel((Logger)INode.LOG, (Level)Level.TRACE);
        SnapshotTestHelper.disableLogs();
        this.exception = ExpectedException.none();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fsdir = fsn.getFSDirectory();
        this.hdfs = cluster.getFileSystem();
        this.dirTree = new SnapshotTestHelper.TestDirectoryTree(5, (FileSystem)this.hdfs);
    }

    @After
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    private void modifyCurrentDirAndCheckSnapshots(Modification[] modifications) throws Exception {
        for (Modification modification : modifications) {
            System.out.println(++modificationCount + ") " + modification);
            modification.loadSnapshots();
            modification.modify();
            modification.checkSnapshots();
        }
    }

    protected SnapshotTestHelper.TestDirectoryTree.Node[] createSnapshots() throws Exception {
        SnapshotTestHelper.TestDirectoryTree.Node[] nodes = new SnapshotTestHelper.TestDirectoryTree.Node[2];
        Path root = SnapshotTestHelper.createSnapshot(this.hdfs, this.dirTree.topNode.nodePath, TestSnapshot.nextSnapshotName());
        snapshotList.add(root);
        nodes[0] = this.dirTree.topNode;
        SnapshotTestHelper.checkSnapshotCreation(this.hdfs, root, nodes[0].nodePath);
        ArrayList<SnapshotTestHelper.TestDirectoryTree.Node> excludedList = new ArrayList<SnapshotTestHelper.TestDirectoryTree.Node>();
        excludedList.add(nodes[0]);
        nodes[1] = this.dirTree.getRandomDirNode(random, excludedList);
        root = SnapshotTestHelper.createSnapshot(this.hdfs, nodes[1].nodePath, TestSnapshot.nextSnapshotName());
        snapshotList.add(root);
        SnapshotTestHelper.checkSnapshotCreation(this.hdfs, root, nodes[1].nodePath);
        return nodes;
    }

    private File getDumpTreeFile(String dir, String suffix) {
        return new File(dir, String.format("dumptree_%s", suffix));
    }

    private void checkFSImage() throws Exception {
        File fsnBefore = this.getDumpTreeFile(testDir, "before");
        File fsnMiddle = this.getDumpTreeFile(testDir, "middle");
        File fsnAfter = this.getDumpTreeFile(testDir, "after");
        SnapshotTestHelper.dumpTree2File(fsdir, fsnBefore);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        this.hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnMiddle);
        this.hdfs.setSafeMode(SafeModeAction.ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(SafeModeAction.LEAVE);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(3).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        this.hdfs = cluster.getFileSystem();
        SnapshotTestHelper.dumpTree2File(fsdir, fsnAfter);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnMiddle, true);
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnAfter, true);
    }

    @Test
    public void testSnapshot() throws Throwable {
        try {
            this.runTestSnapshot(20);
        }
        catch (Throwable t) {
            SnapshotTestHelper.LOG.info("FAILED", t);
            SnapshotTestHelper.dumpTree("FAILED", cluster);
            throw t;
        }
    }

    @Test
    public void testOfflineImageViewer() throws Exception {
        this.runTestSnapshot(1);
        File originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
        Assert.assertNotNull((String)"Didn't generate or can't find fsimage", (Object)originalFsimage);
        PrintStream o = new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
    }

    private void runTestSnapshot(int iteration) throws Exception {
        for (int i = 0; i < iteration; ++i) {
            cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
            SnapshotTestHelper.TestDirectoryTree.Node[] ssNodes = this.createSnapshots();
            ArrayList<SnapshotTestHelper.TestDirectoryTree.Node> excludedList = new ArrayList<SnapshotTestHelper.TestDirectoryTree.Node>();
            SnapshotTestHelper.TestDirectoryTree.Node[] modNodes = new SnapshotTestHelper.TestDirectoryTree.Node[ssNodes.length + 1];
            for (int n = 0; n < ssNodes.length; ++n) {
                modNodes[n] = ssNodes[n];
                excludedList.add(ssNodes[n]);
            }
            modNodes[modNodes.length - 1] = this.dirTree.getRandomDirNode(random, excludedList);
            Modification[] mods = this.prepareModifications(modNodes);
            this.modifyCurrentDirAndCheckSnapshots(mods);
            SnapshotTestHelper.TestDirectoryTree.Node chmodDir = this.dirTree.getRandomDirNode(random, null);
            FileChangePermission chmod = new FileChangePermission(chmodDir.nodePath, (FileSystem)this.hdfs, this.genRandomPermission());
            String[] userGroup = this.genRandomOwner();
            SnapshotTestHelper.TestDirectoryTree.Node chownDir = this.dirTree.getRandomDirNode(random, Arrays.asList(chmodDir));
            FileChown chown = new FileChown(chownDir.nodePath, (FileSystem)this.hdfs, userGroup[0], userGroup[1]);
            this.modifyCurrentDirAndCheckSnapshots(new Modification[]{chmod, chown});
            this.checkFSImage();
        }
    }

    @Test(timeout=60000L)
    public void testUpdateDirectory() throws Exception {
        Path dir = new Path("/dir");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        FileStatus oldStatus = this.hdfs.getFileStatus(sub);
        this.hdfs.allowSnapshot(dir);
        this.hdfs.createSnapshot(dir, "s1");
        this.hdfs.setTimes(sub, 100L, 100L);
        Path snapshotPath = SnapshotTestHelper.getSnapshotPath(dir, "s1", "sub");
        FileStatus snapshotStatus = this.hdfs.getFileStatus(snapshotPath);
        Assert.assertEquals((long)oldStatus.getModificationTime(), (long)snapshotStatus.getModificationTime());
        Assert.assertEquals((long)oldStatus.getAccessTime(), (long)snapshotStatus.getAccessTime());
    }

    @Test
    public void testCreateSnapshotWithIllegalName() throws Exception {
        String[] badNames;
        Path dir = new Path("/dir");
        this.hdfs.mkdirs(dir);
        String name1 = ".snapshot";
        try {
            this.hdfs.createSnapshot(dir, ".snapshot");
            Assert.fail((String)"Exception expected when an illegal name is given");
        }
        catch (RemoteException e) {
            String errorMsg = "Invalid path name Invalid snapshot name: .snapshot";
            GenericTestUtils.assertExceptionContains((String)errorMsg, (Throwable)e);
        }
        for (String badName : badNames = new String[]{"foo/", "/foo", "/", "foo/bar"}) {
            try {
                this.hdfs.createSnapshot(dir, badName);
                Assert.fail((String)"Exception expected when an illegal name is given");
            }
            catch (RemoteException e) {
                String errorMsg = "Invalid path name Invalid snapshot name: " + badName;
                GenericTestUtils.assertExceptionContains((String)errorMsg, (Throwable)e);
            }
        }
    }

    @Test(timeout=60000L)
    public void testSnapshottableDirectory() throws Exception {
        Path dir = new Path("/TestSnapshot/sub");
        Path file0 = new Path(dir, "file0");
        Path file1 = new Path(dir, "file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file0, 1024L, (short)3, seed);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)3, seed);
        try {
            this.hdfs.createSnapshot(dir, "s1");
            Assert.fail((String)("Exception expected: " + dir + " is not snapshottable"));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + dir), (Throwable)e);
        }
        try {
            this.hdfs.deleteSnapshot(dir, "s1");
            Assert.fail((String)("Exception expected: " + dir + " is not a snapshottale dir"));
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + dir), (Throwable)e);
        }
        try {
            this.hdfs.renameSnapshot(dir, "s1", "s2");
            Assert.fail((String)("Exception expected: " + dir + " is not a snapshottale dir"));
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)("Directory is not a snapshottable directory: " + dir), (Throwable)e);
        }
    }

    @Test
    public void testAllowAndDisallowSnapshot() throws Exception {
        Path dir = new Path("/dir");
        Path file0 = new Path(dir, "file0");
        Path file1 = new Path(dir, "file1");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file0, 1024L, (short)3, seed);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file1, 1024L, (short)3, seed);
        INodeDirectory dirNode = fsdir.getINode4Write(dir.toString()).asDirectory();
        Assert.assertFalse((boolean)dirNode.isSnapshottable());
        this.hdfs.allowSnapshot(dir);
        dirNode = fsdir.getINode4Write(dir.toString()).asDirectory();
        Assert.assertTrue((boolean)dirNode.isSnapshottable());
        this.hdfs.allowSnapshot(dir);
        dirNode = fsdir.getINode4Write(dir.toString()).asDirectory();
        Assert.assertTrue((boolean)dirNode.isSnapshottable());
        this.hdfs.disallowSnapshot(dir);
        dirNode = fsdir.getINode4Write(dir.toString()).asDirectory();
        Assert.assertFalse((boolean)dirNode.isSnapshottable());
        this.hdfs.disallowSnapshot(dir);
        dirNode = fsdir.getINode4Write(dir.toString()).asDirectory();
        Assert.assertFalse((boolean)dirNode.isSnapshottable());
        Path root = new Path("/");
        INodeDirectory rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((boolean)rootNode.isSnapshottable());
        Assert.assertEquals((long)0L, (long)rootNode.getDirectorySnapshottableFeature().getSnapshotQuota());
        this.hdfs.allowSnapshot(root);
        rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((boolean)rootNode.isSnapshottable());
        Assert.assertEquals((long)65536L, (long)rootNode.getDirectorySnapshottableFeature().getSnapshotQuota());
        this.hdfs.allowSnapshot(root);
        rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((boolean)rootNode.isSnapshottable());
        Assert.assertEquals((long)65536L, (long)rootNode.getDirectorySnapshottableFeature().getSnapshotQuota());
        this.hdfs.disallowSnapshot(root);
        rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((boolean)rootNode.isSnapshottable());
        Assert.assertEquals((long)0L, (long)rootNode.getDirectorySnapshottableFeature().getSnapshotQuota());
        this.hdfs.disallowSnapshot(root);
        rootNode = fsdir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((boolean)rootNode.isSnapshottable());
        Assert.assertEquals((long)0L, (long)rootNode.getDirectorySnapshottableFeature().getSnapshotQuota());
    }

    @Test(timeout=60000L)
    public void testSnapshotMtime() throws Exception {
        Path dir = new Path("/dir");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        this.hdfs.allowSnapshot(dir);
        Path snapshotPath = this.hdfs.createSnapshot(dir, "s1");
        FileStatus oldSnapshotStatus = this.hdfs.getFileStatus(snapshotPath);
        cluster.restartNameNodes();
        FileStatus newSnapshotStatus = this.hdfs.getFileStatus(snapshotPath);
        Assert.assertEquals((long)oldSnapshotStatus.getModificationTime(), (long)newSnapshotStatus.getModificationTime());
    }

    @Test(timeout=60000L)
    public void testRenameSnapshotMtime() throws Exception {
        Path dir = new Path("/dir");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        this.hdfs.allowSnapshot(dir);
        Path snapshotPath = this.hdfs.createSnapshot(dir, "s1");
        FileStatus oldSnapshotStatus = this.hdfs.getFileStatus(snapshotPath);
        this.hdfs.renameSnapshot(dir, "s1", "s2");
        Path snapshotRenamePath = new Path("/dir/.snapshot/s2");
        FileStatus newSnapshotStatus = this.hdfs.getFileStatus(snapshotRenamePath);
        Assert.assertNotEquals((long)oldSnapshotStatus.getModificationTime(), (long)newSnapshotStatus.getModificationTime());
    }

    @Test(timeout=60000L)
    public void testDeletionSnapshotMtime() throws Exception {
        Path dir = new Path("/dir");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        this.hdfs.allowSnapshot(dir);
        Path snapshotPath = this.hdfs.createSnapshot(dir, "s1");
        FileStatus oldSnapshotStatus = this.hdfs.getFileStatus(snapshotPath);
        this.hdfs.deleteSnapshot(dir, "s1");
        FileStatus dirStatus = this.hdfs.getFileStatus(dir);
        Assert.assertNotEquals((long)dirStatus.getModificationTime(), (long)oldSnapshotStatus.getModificationTime());
        cluster.restartNameNodes();
        FileStatus newSnapshotStatus = this.hdfs.getFileStatus(dir);
        Assert.assertEquals((long)dirStatus.getModificationTime(), (long)newSnapshotStatus.getModificationTime());
    }

    @Test(timeout=60000L)
    public void testSnapshotOpsOnReservedPath() throws Exception {
        Path dir = new Path("/dir");
        Path nestedDir = new Path("/nested/dir");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        Path nestedFile = new Path(nestedDir, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        DFSTestUtil.createFile((FileSystem)this.hdfs, nestedFile, 1024L, (short)3, seed);
        this.hdfs.allowSnapshot(dir);
        this.hdfs.allowSnapshot(nestedDir);
        Path reservedDir = new Path("/.reserved/raw/dir");
        Path reservedNestedDir = new Path("/.reserved/raw/nested/dir");
        this.hdfs.createSnapshot(reservedDir, "s1");
        this.hdfs.createSnapshot(reservedNestedDir, "s1");
        this.hdfs.renameSnapshot(reservedDir, "s1", "s2");
        this.hdfs.renameSnapshot(reservedNestedDir, "s1", "s2");
        this.hdfs.deleteSnapshot(reservedDir, "s2");
        this.hdfs.deleteSnapshot(reservedNestedDir, "s2");
        cluster.restartNameNode(true);
    }

    @Test(timeout=120000L)
    public void testSnapshotOpsOnRootReservedPath() throws Exception {
        Path dir = new Path("/");
        Path sub = new Path(dir, "sub");
        Path subFile = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, subFile, 1024L, (short)3, seed);
        this.hdfs.allowSnapshot(dir);
        Path reservedDir = new Path("/.reserved/raw");
        this.hdfs.createSnapshot(reservedDir, "s1");
        this.hdfs.renameSnapshot(reservedDir, "s1", "s2");
        this.hdfs.deleteSnapshot(reservedDir, "s2");
        cluster.restartNameNode(true);
    }

    private Modification[] prepareModifications(SnapshotTestHelper.TestDirectoryTree.Node[] nodes) throws Exception {
        ArrayList<Modification> mList = new ArrayList<Modification>();
        for (SnapshotTestHelper.TestDirectoryTree.Node node : nodes) {
            if (node.fileList == null) {
                node.initFileList((FileSystem)this.hdfs, node.nodePath.getName(), 1024L, (short)3, seed, 6);
            }
            FileCreation create = new FileCreation(node.fileList.get(node.nullFileIndex), (FileSystem)this.hdfs, 1024);
            FileDeletion delete = new FileDeletion(node.fileList.get((node.nullFileIndex + 1) % node.fileList.size()), (FileSystem)this.hdfs);
            Path f = node.fileList.get((node.nullFileIndex + 2) % node.fileList.size());
            FileAppend append = new FileAppend(f, (FileSystem)this.hdfs, 1024);
            FileAppendNotClose appendNotClose = new FileAppendNotClose(f, (FileSystem)this.hdfs, 1024);
            FileAppendClose appendClose = new FileAppendClose(f, (FileSystem)this.hdfs, 1024, appendNotClose);
            FileChangePermission chmod = new FileChangePermission(node.fileList.get((node.nullFileIndex + 3) % node.fileList.size()), (FileSystem)this.hdfs, this.genRandomPermission());
            String[] userGroup = this.genRandomOwner();
            FileChown chown = new FileChown(node.fileList.get((node.nullFileIndex + 4) % node.fileList.size()), (FileSystem)this.hdfs, userGroup[0], userGroup[1]);
            FileChangeReplication replication = new FileChangeReplication(node.fileList.get((node.nullFileIndex + 5) % node.fileList.size()), (FileSystem)this.hdfs, (short)(random.nextInt(3) + 1));
            node.nullFileIndex = (node.nullFileIndex + 1) % node.fileList.size();
            DirCreationOrDeletion dirChange = new DirCreationOrDeletion(node.nodePath, (FileSystem)this.hdfs, node, random.nextBoolean());
            SnapshotTestHelper.TestDirectoryTree.Node dstParent = this.dirTree.getRandomDirNode(random, Arrays.asList(nodes));
            DirRename dirRename = new DirRename(node.nodePath, (FileSystem)this.hdfs, node, dstParent);
            mList.add(create);
            mList.add(delete);
            mList.add(append);
            mList.add(appendNotClose);
            mList.add(appendClose);
            mList.add(chmod);
            mList.add(chown);
            mList.add(replication);
            mList.add(dirChange);
            mList.add(dirRename);
        }
        return mList.toArray(new Modification[mList.size()]);
    }

    private FsPermission genRandomPermission() {
        FsAction u = random.nextBoolean() ? FsAction.ALL : FsAction.READ_WRITE;
        FsAction g = random.nextBoolean() ? FsAction.ALL : FsAction.READ_WRITE;
        FsAction o = random.nextBoolean() ? FsAction.ALL : FsAction.READ_WRITE;
        return new FsPermission(u, g, o);
    }

    private String[] genRandomOwner() {
        String[] userGroup = new String[]{"dr.who", "unknown"};
        return userGroup;
    }

    static String nextSnapshotName() {
        return String.format("s-%d", ++snapshotCount);
    }

    static {
        System.out.println("Random seed: " + seed);
        testDir = GenericTestUtils.getTestDir().getAbsolutePath();
        snapshotList = new ArrayList();
        modificationCount = 0;
        snapshotCount = 0;
    }

    class DirRename
    extends Modification {
        private final SnapshotTestHelper.TestDirectoryTree.Node srcParent;
        private final SnapshotTestHelper.TestDirectoryTree.Node dstParent;
        private final Path srcPath;
        private final Path dstPath;
        private final HashMap<Path, FileStatus> statusMap;

        DirRename(Path file, FileSystem fs, SnapshotTestHelper.TestDirectoryTree.Node src, SnapshotTestHelper.TestDirectoryTree.Node dst) throws Exception {
            super(file, fs, "dirrename");
            this.srcParent = src;
            this.dstParent = dst;
            this.dstPath = new Path(this.dstParent.nodePath, "sub" + this.dstParent.nonSnapshotChildren.size());
            if (this.srcParent.nonSnapshotChildren.isEmpty()) {
                this.srcPath = new Path(this.srcParent.nodePath, "sub" + this.srcParent.nonSnapshotChildren.size());
                SnapshotTestHelper.TestDirectoryTree.Node newChild = new SnapshotTestHelper.TestDirectoryTree.Node(this.srcPath, this.srcParent.level + 1, this.srcParent, (FileSystem)TestSnapshot.this.hdfs);
                newChild.initFileList((FileSystem)TestSnapshot.this.hdfs, this.srcParent.nodePath.getName(), 1024L, (short)3, seed, 2);
                this.srcParent.nonSnapshotChildren.add(newChild);
            } else {
                this.srcPath = new Path(this.srcParent.nodePath, "sub" + (this.srcParent.nonSnapshotChildren.size() - 1));
            }
            this.statusMap = new HashMap();
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotDir = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.srcPath);
                if (snapshotDir == null) continue;
                FileStatus status = this.fs.exists(snapshotDir) ? this.fs.getFileStatus(snapshotDir) : null;
                this.statusMap.put(snapshotDir, status);
                Path snapshotFile = new Path(snapshotDir, "file0");
                status = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile) : null;
                this.statusMap.put(snapshotFile, status);
            }
        }

        @Override
        void modify() throws Exception {
            TestSnapshot.this.hdfs.rename(this.srcPath, this.dstPath);
            SnapshotTestHelper.TestDirectoryTree.Node newDstChild = new SnapshotTestHelper.TestDirectoryTree.Node(this.dstPath, this.dstParent.level + 1, this.dstParent, (FileSystem)TestSnapshot.this.hdfs);
            this.dstParent.nonSnapshotChildren.add(newDstChild);
        }

        @Override
        void checkSnapshots() throws Exception {
            for (Path snapshot : this.statusMap.keySet()) {
                FileStatus currentStatus = this.fs.exists(snapshot) ? this.fs.getFileStatus(snapshot) : null;
                FileStatus originalStatus = this.statusMap.get(snapshot);
                Assert.assertEquals((Object)currentStatus, (Object)originalStatus);
                if (currentStatus == null) continue;
                Assert.assertEquals((Object)currentStatus.toString(), (Object)originalStatus.toString());
            }
        }
    }

    class DirCreationOrDeletion
    extends Modification {
        private final SnapshotTestHelper.TestDirectoryTree.Node node;
        private final boolean isCreation;
        private final Path changedPath;
        private final HashMap<Path, FileStatus> statusMap;

        DirCreationOrDeletion(Path file, FileSystem fs, SnapshotTestHelper.TestDirectoryTree.Node node, boolean isCreation) {
            super(file, fs, "dircreation");
            this.node = node;
            this.isCreation = isCreation || node.nonSnapshotChildren.isEmpty();
            this.changedPath = this.isCreation ? new Path(node.nodePath, "sub" + node.nonSnapshotChildren.size()) : node.nonSnapshotChildren.get((int)(node.nonSnapshotChildren.size() - 1)).nodePath;
            this.statusMap = new HashMap();
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotDir = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.changedPath);
                if (snapshotDir == null) continue;
                FileStatus status = this.fs.exists(snapshotDir) ? this.fs.getFileStatus(snapshotDir) : null;
                this.statusMap.put(snapshotDir, status);
                Path snapshotFile = new Path(snapshotDir, "file0");
                status = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile) : null;
                this.statusMap.put(snapshotFile, status);
            }
        }

        @Override
        void modify() throws Exception {
            if (this.isCreation) {
                SnapshotTestHelper.TestDirectoryTree.Node newChild = new SnapshotTestHelper.TestDirectoryTree.Node(this.changedPath, this.node.level + 1, this.node, (FileSystem)TestSnapshot.this.hdfs);
                newChild.initFileList((FileSystem)TestSnapshot.this.hdfs, this.node.nodePath.getName(), 1024L, (short)3, seed, 2);
                this.node.nonSnapshotChildren.add(newChild);
            } else {
                SnapshotTestHelper.TestDirectoryTree.Node childToDelete = this.node.nonSnapshotChildren.remove(this.node.nonSnapshotChildren.size() - 1);
                TestSnapshot.this.hdfs.delete(childToDelete.nodePath, true);
            }
        }

        @Override
        void checkSnapshots() throws Exception {
            for (Path snapshot : this.statusMap.keySet()) {
                FileStatus currentStatus = this.fs.exists(snapshot) ? this.fs.getFileStatus(snapshot) : null;
                FileStatus originalStatus = this.statusMap.get(snapshot);
                Assert.assertEquals((Object)currentStatus, (Object)originalStatus);
                if (currentStatus == null) continue;
                Assert.assertEquals((Object)currentStatus.toString(), (Object)originalStatus.toString());
            }
        }
    }

    static class FileDeletion
    extends Modification {
        private final HashMap<Path, Boolean> snapshotFileExistenceMap = new HashMap();

        FileDeletion(Path file, FileSystem fs) {
            super(file, fs, "deletion");
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                boolean existence = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file) != null;
                this.snapshotFileExistenceMap.put(snapshotRoot, existence);
            }
        }

        @Override
        void modify() throws Exception {
            this.fs.delete(this.file, true);
        }

        @Override
        void checkSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                boolean currentSnapshotFileExist = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file) != null;
                boolean originalSnapshotFileExist = this.snapshotFileExistenceMap.get(snapshotRoot);
                Assert.assertEquals((Object)currentSnapshotFileExist, (Object)originalSnapshotFileExist);
            }
        }
    }

    static class FileCreation
    extends Modification {
        final int fileLen;
        private final HashMap<Path, FileStatus> fileStatusMap;

        FileCreation(Path file, FileSystem fs, int len) {
            super(file, fs, "creation");
            assert (len >= 0);
            this.fileLen = len;
            this.fileStatusMap = new HashMap();
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotFile = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file);
                if (snapshotFile == null) continue;
                FileStatus status = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile) : null;
                this.fileStatusMap.put(snapshotFile, status);
            }
        }

        @Override
        void modify() throws Exception {
            DFSTestUtil.createFile(this.fs, this.file, this.fileLen, this.fileLen, 1024L, (short)3, seed);
        }

        @Override
        void checkSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotFile = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file);
                if (snapshotFile == null) continue;
                boolean computed = this.fs.exists(snapshotFile);
                boolean expected = this.fileStatusMap.get(snapshotFile) != null;
                Assert.assertEquals((Object)expected, (Object)computed);
                if (!computed) continue;
                FileStatus currentSnapshotStatus = this.fs.getFileStatus(snapshotFile);
                FileStatus originalStatus = this.fileStatusMap.get(snapshotFile);
                Assert.assertEquals((Object)currentSnapshotStatus.toString(), (Object)originalStatus.toString());
            }
        }
    }

    static class FileAppendClose
    extends FileAppend {
        final FileAppendNotClose fileAppendNotClose;

        FileAppendClose(Path file, FileSystem fs, int len, FileAppendNotClose fileAppendNotClose) {
            super(file, fs, len);
            this.fileAppendNotClose = fileAppendNotClose;
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            byte[] toAppend = new byte[this.appendLen];
            random.nextBytes(toAppend);
            this.fileAppendNotClose.out.write(toAppend);
            this.fileAppendNotClose.out.close();
        }
    }

    static class FileAppendNotClose
    extends FileAppend {
        HdfsDataOutputStream out;

        FileAppendNotClose(Path file, FileSystem fs, int len) {
            super(file, fs, len);
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            byte[] toAppend = new byte[this.appendLen];
            random.nextBytes(toAppend);
            this.out = (HdfsDataOutputStream)this.fs.append(this.file);
            this.out.write(toAppend);
            this.out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        }
    }

    static class FileAppend
    extends Modification {
        final int appendLen;
        private final HashMap<Path, Long> snapshotFileLengthMap;

        FileAppend(Path file, FileSystem fs, int len) {
            super(file, fs, "append");
            this.appendLen = len;
            this.snapshotFileLengthMap = new HashMap();
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotFile = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file);
                if (snapshotFile == null) continue;
                long snapshotFileLen = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile).getLen() : -1L;
                this.snapshotFileLengthMap.put(snapshotFile, snapshotFileLen);
            }
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            DFSTestUtil.appendFile(this.fs, this.file, this.appendLen);
        }

        @Override
        void checkSnapshots() throws Exception {
            byte[] buffer = new byte[32];
            for (Path snapshotFile : this.snapshotFileLengthMap.keySet()) {
                long currentSnapshotFileLen = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile).getLen() : -1L;
                long originalSnapshotFileLen = this.snapshotFileLengthMap.get(snapshotFile);
                String s = null;
                if (currentSnapshotFileLen != originalSnapshotFileLen) {
                    s = "FAILED: " + this.getClass().getSimpleName() + ": file=" + this.file + ", snapshotFile" + snapshotFile + "\n\n currentSnapshotFileLen = " + currentSnapshotFileLen + "\noriginalSnapshotFileLen = " + originalSnapshotFileLen + "\n\nfile        : " + fsdir.getINode(this.file.toString()).toDetailString() + "\n\nsnapshotFile: " + fsdir.getINode(snapshotFile.toString()).toDetailString();
                    SnapshotTestHelper.dumpTree(s, cluster);
                }
                Assert.assertEquals(s, (long)originalSnapshotFileLen, (long)currentSnapshotFileLen);
                if (currentSnapshotFileLen == -1L || this instanceof FileAppendNotClose) continue;
                FSDataInputStream input = this.fs.open(snapshotFile);
                int readLen = input.read(currentSnapshotFileLen, buffer, 0, 1);
                if (readLen != -1) {
                    s = "FAILED: " + this.getClass().getSimpleName() + ": file=" + this.file + ", snapshotFile" + snapshotFile + "\n\n currentSnapshotFileLen = " + currentSnapshotFileLen + "\n                readLen = " + readLen + "\n\nfile        : " + fsdir.getINode(this.file.toString()).toDetailString() + "\n\nsnapshotFile: " + fsdir.getINode(snapshotFile.toString()).toDetailString();
                    SnapshotTestHelper.dumpTree(s, cluster);
                }
                Assert.assertEquals(s, (long)-1L, (long)readLen);
                input.close();
            }
        }
    }

    static class FileChown
    extends FileStatusChange {
        private final String newUser;
        private final String newGroup;

        FileChown(Path file, FileSystem fs, String user, String group) {
            super(file, fs, "chown");
            this.newUser = user;
            this.newGroup = group;
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            this.fs.setOwner(this.file, this.newUser, this.newGroup);
        }
    }

    static class FileChangeReplication
    extends FileStatusChange {
        private final short newReplication;

        FileChangeReplication(Path file, FileSystem fs, short replication) {
            super(file, fs, "replication");
            this.newReplication = replication;
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            this.fs.setReplication(this.file, this.newReplication);
        }
    }

    static class FileChangePermission
    extends FileStatusChange {
        private final FsPermission newPermission;

        FileChangePermission(Path file, FileSystem fs, FsPermission newPermission) {
            super(file, fs, "chmod");
            this.newPermission = newPermission;
        }

        @Override
        void modify() throws Exception {
            Assert.assertTrue((boolean)this.fs.exists(this.file));
            this.fs.setPermission(this.file, this.newPermission);
        }
    }

    static abstract class FileStatusChange
    extends Modification {
        protected final HashMap<Path, FileStatus> statusMap = new HashMap();

        FileStatusChange(Path file, FileSystem fs, String type) {
            super(file, fs, type);
        }

        @Override
        void loadSnapshots() throws Exception {
            for (Path snapshotRoot : snapshotList) {
                Path snapshotFile = SnapshotTestHelper.getSnapshotFile(snapshotRoot, this.file);
                if (snapshotFile == null) continue;
                if (this.fs.exists(snapshotFile)) {
                    FileStatus status = this.fs.getFileStatus(snapshotFile);
                    this.statusMap.put(snapshotFile, status);
                    continue;
                }
                this.statusMap.put(snapshotFile, null);
            }
        }

        @Override
        void checkSnapshots() throws Exception {
            for (Path snapshotFile : this.statusMap.keySet()) {
                FileStatus currentStatus = this.fs.exists(snapshotFile) ? this.fs.getFileStatus(snapshotFile) : null;
                FileStatus originalStatus = this.statusMap.get(snapshotFile);
                Assert.assertEquals((Object)currentStatus, (Object)originalStatus);
                if (currentStatus == null) continue;
                String s = null;
                if (!currentStatus.toString().equals(originalStatus.toString())) {
                    s = "FAILED: " + this.getClass().getSimpleName() + ": file=" + this.file + ", snapshotFile" + snapshotFile + "\n\n currentStatus = " + currentStatus + "\noriginalStatus = " + originalStatus + "\n\nfile        : " + fsdir.getINode(this.file.toString()).toDetailString() + "\n\nsnapshotFile: " + fsdir.getINode(snapshotFile.toString()).toDetailString();
                    SnapshotTestHelper.dumpTree(s, cluster);
                }
                Assert.assertEquals(s, (Object)currentStatus.toString(), (Object)originalStatus.toString());
            }
        }
    }

    static abstract class Modification {
        protected final Path file;
        protected final FileSystem fs;
        final String type;

        Modification(Path file, FileSystem fs, String type) {
            this.file = file;
            this.fs = fs;
            this.type = type;
        }

        abstract void loadSnapshots() throws Exception;

        abstract void modify() throws Exception;

        abstract void checkSnapshots() throws Exception;

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.type + ":" + this.file;
        }
    }
}

