/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;

public class TaskHeartbeatHandler
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(TaskHeartbeatHandler.class);
    private Thread lostTaskCheckerThread;
    private volatile boolean stopped;
    private long taskTimeOut;
    private int taskTimeOutCheckInterval = 30000;
    private final EventHandler eventHandler;
    private final Clock clock;
    private ConcurrentMap<TaskAttemptId, ReportTime> runningAttempts;

    public TaskHeartbeatHandler(EventHandler eventHandler, Clock clock, int numThreads) {
        super("TaskHeartbeatHandler");
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.runningAttempts = new ConcurrentHashMap(16, 0.75f, numThreads);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.taskTimeOut = conf.getLong("mapreduce.task.timeout", 300000L);
        long taskProgressReportIntervalMillis = MRJobConfUtil.getTaskProgressReportInterval((Configuration)conf);
        long minimumTaskTimeoutAllowed = taskProgressReportIntervalMillis * 2L;
        if (this.taskTimeOut < minimumTaskTimeoutAllowed) {
            this.taskTimeOut = minimumTaskTimeoutAllowed;
            LOG.info((Object)("Task timeout must be as least twice as long as the task status report interval. Setting task timeout to " + this.taskTimeOut));
        }
        this.taskTimeOutCheckInterval = conf.getInt("mapreduce.task.timeout.check-interval-ms", 30000);
    }

    protected void serviceStart() throws Exception {
        this.lostTaskCheckerThread = new Thread((Runnable)new PingChecker(this, null));
        this.lostTaskCheckerThread.setName("TaskHeartbeatHandler PingChecker");
        this.lostTaskCheckerThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.lostTaskCheckerThread != null) {
            this.lostTaskCheckerThread.interrupt();
        }
        super.serviceStop();
    }

    public void progressing(TaskAttemptId attemptID) {
        ReportTime time = (ReportTime)this.runningAttempts.get(attemptID);
        if (time != null) {
            time.setLastProgress(this.clock.getTime());
        }
    }

    public void register(TaskAttemptId attemptID) {
        this.runningAttempts.put(attemptID, new ReportTime(this.clock.getTime()));
    }

    public void unregister(TaskAttemptId attemptID) {
        this.runningAttempts.remove(attemptID);
    }

    @VisibleForTesting
    public long getTaskTimeOut() {
        return this.taskTimeOut;
    }

    static /* synthetic */ boolean access$100(TaskHeartbeatHandler x0) {
        return x0.stopped;
    }

    static /* synthetic */ ConcurrentMap access$200(TaskHeartbeatHandler x0) {
        return x0.runningAttempts;
    }

    static /* synthetic */ Clock access$300(TaskHeartbeatHandler x0) {
        return x0.clock;
    }

    static /* synthetic */ long access$400(TaskHeartbeatHandler x0) {
        return x0.taskTimeOut;
    }

    static /* synthetic */ EventHandler access$500(TaskHeartbeatHandler x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ int access$600(TaskHeartbeatHandler x0) {
        return x0.taskTimeOutCheckInterval;
    }

    static /* synthetic */ Log access$700() {
        return LOG;
    }
}

