/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterJobCommitEvent;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobImpl
implements Job,
EventHandler<JobEvent> {
    private static final TaskAttemptCompletionEvent[] EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS = new TaskAttemptCompletionEvent[0];
    private static final TaskCompletionEvent[] EMPTY_TASK_COMPLETION_EVENTS = new TaskCompletionEvent[0];
    private static final Log LOG = LogFactory.getLog(JobImpl.class);
    private float maxAllowedFetchFailuresFraction;
    private int maxFetchFailuresNotifications;
    public static final String JOB_KILLED_DIAG = "Job received Kill while in RUNNING state.";
    private final ApplicationAttemptId applicationAttemptId;
    private final Clock clock;
    private final JobACLsManager aclsManager;
    private final String reporterUserName;
    private final Map<JobACL, AccessControlList> jobACLs;
    private float setupWeight = 0.05f;
    private float cleanupWeight = 0.05f;
    private float mapWeight = 0.0f;
    private float reduceWeight = 0.0f;
    private final Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private final List<AMInfo> amInfos;
    private final Lock readLock;
    private final Lock writeLock;
    private final JobId jobId;
    private final String jobName;
    private final OutputCommitter committer;
    private final boolean newApiCommitter;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Object tasksSyncHandle = new Object();
    private final Set<TaskId> mapTasks = new LinkedHashSet();
    private final Set<TaskId> reduceTasks = new LinkedHashSet();
    private final HashMap<NodeId, List<TaskAttemptId>> nodesToSucceededTaskAttempts = new HashMap();
    private final EventHandler eventHandler;
    private final MRAppMetrics metrics;
    private final String userName;
    private String queueName;
    private final long appSubmitTime;
    private final AppContext appContext;
    private boolean lazyTasksCopyNeeded = false;
    volatile Map<TaskId, Task> tasks = new LinkedHashMap();
    private Counters jobCounters = new Counters();
    private Object fullCountersLock = new Object();
    private Counters fullCounters = null;
    private Counters finalMapCounters = null;
    private Counters finalReduceCounters = null;
    public JobConf conf;
    private FileSystem fs;
    private Path remoteJobSubmitDir;
    public Path remoteJobConfFile;
    private JobContext jobContext;
    private int allowedMapFailuresPercent = 0;
    private int allowedReduceFailuresPercent = 0;
    private List<TaskAttemptCompletionEvent> taskAttemptCompletionEvents;
    private List<TaskCompletionEvent> mapAttemptCompletionEvents;
    private List<Integer> taskCompletionIdxToMapCompletionIdx;
    private final List<String> diagnostics = new ArrayList();
    private final Map<TaskId, Integer> successAttemptCompletionEventNoMap = new HashMap();
    private final Map<TaskAttemptId, Integer> fetchFailuresMapping = new HashMap();
    private static final DiagnosticsUpdateTransition DIAGNOSTIC_UPDATE_TRANSITION = new DiagnosticsUpdateTransition(null);
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition();
    private static final InternalRebootTransition INTERNAL_REBOOT_TRANSITION = new InternalRebootTransition();
    private static final TaskAttemptCompletedEventTransition TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new TaskAttemptCompletedEventTransition(null);
    private static final CounterUpdateTransition COUNTER_UPDATE_TRANSITION = new CounterUpdateTransition(null);
    private static final UpdatedNodesTransition UPDATED_NODES_TRANSITION = new UpdatedNodesTransition(null);
    protected static final StateMachineFactory<JobImpl, JobStateInternal, JobEventType, JobEvent> stateMachineFactory = new StateMachineFactory((Enum)JobStateInternal.NEW).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.NEW, EnumSet.of(JobStateInternal.INITED, JobStateInternal.NEW), (Enum)JobEventType.JOB_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_INIT_FAILED, (SingleArcTransition)new InitFailedTransition(null)).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillNewJobTransition(null)).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillInitedJobTransition(null)).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_SETUP_COMPLETED, (SingleArcTransition)new SetupCompletedTransition(null)).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_SETUP_FAILED, (SingleArcTransition)new SetupFailedTransition(null)).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringSetupTransition(null)).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, EnumSet.of(JobStateInternal.RUNNING, JobStateInternal.COMMITTING, JobStateInternal.FAIL_WAIT, JobStateInternal.FAIL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition(null)).addTransition((Enum)JobStateInternal.RUNNING, EnumSet.of(JobStateInternal.RUNNING, JobStateInternal.COMMITTING), (Enum)JobEventType.JOB_COMPLETED, (MultipleArcTransition)new JobNoTasksCompletedTransition(null)).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillTasksTransition(null)).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_UPDATED_NODES, (SingleArcTransition)UPDATED_NODES_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_MAP_TASK_RESCHEDULED, (SingleArcTransition)new MapTaskRescheduledTransition(null)).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, (SingleArcTransition)new TaskAttemptFetchFailureTransition(null)).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, EnumSet.of(JobStateInternal.KILL_WAIT, JobStateInternal.KILL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new KillWaitTaskCompletedTransition(null)).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT)).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_COMMIT_COMPLETED, (SingleArcTransition)new CommitSucceededTransition(null)).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_COMMIT_FAILED, (SingleArcTransition)new CommitFailedTransition(null)).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringCommitTransition(null)).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, EnumSet.of(JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED)).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED})).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, EnumSet.of(JobStateInternal.FAIL_WAIT, JobStateInternal.FAIL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new JobFailWaitTransition(null)).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_FAIL_WAIT_TIMEDOUT, (SingleArcTransition)new JobFailWaitTimedOutTransition(null)).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition(null)).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT)).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_ABORT_COMPLETED, (SingleArcTransition)new JobAbortCompletedTransition(null)).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition(null)).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, new JobEventType[]{JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_AM_REBOOT, JobEventType.JOB_FAIL_WAIT_TIMEDOUT})).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_ABORT_COMPLETED, (SingleArcTransition)new JobAbortCompletedTransition(null)).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition(null)).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, new JobEventType[]{JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_START, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.ERROR, (Enum)JobStateInternal.ERROR, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.INTERNAL_ERROR, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.ERROR, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.REBOOT, (Enum)JobStateInternal.REBOOT, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.INTERNAL_ERROR, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.REBOOT, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).installTopology();
    private final StateMachine<JobStateInternal, JobEventType, JobEvent> stateMachine;
    private int numMapTasks;
    private int numReduceTasks;
    private int completedTaskCount = 0;
    private int succeededMapTaskCount = 0;
    private int succeededReduceTaskCount = 0;
    private int failedMapTaskCount = 0;
    private int failedReduceTaskCount = 0;
    private int killedMapTaskCount = 0;
    private int killedReduceTaskCount = 0;
    private long startTime;
    private long finishTime;
    private float setupProgress;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private boolean isUber = false;
    private Credentials jobCredentials;
    private Token<JobTokenIdentifier> jobToken;
    private JobTokenSecretManager jobTokenSecretManager;
    private JobStateInternal forcedState = null;
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture failWaitTriggerScheduledFuture;
    private JobState lastNonFinalState = JobState.NEW;
    private volatile Priority jobPriority = Priority.newInstance((int)0);

    public JobImpl(JobId jobId, ApplicationAttemptId applicationAttemptId, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, JobTokenSecretManager jobTokenSecretManager, Credentials jobCredentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, MRAppMetrics metrics, OutputCommitter committer, boolean newApiCommitter, String userName, long appSubmitTime, List<AMInfo> amInfos, AppContext appContext, JobStateInternal forcedState, String forcedDiagnostic) {
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = jobId;
        this.jobName = conf.get("mapreduce.job.name", "<missing job name>");
        this.conf = new JobConf(conf);
        this.metrics = metrics;
        this.clock = clock;
        this.completedTasksFromPreviousRun = completedTasksFromPreviousRun;
        this.amInfos = amInfos;
        this.appContext = appContext;
        this.userName = userName;
        this.queueName = conf.get("mapreduce.job.queuename", "default");
        this.appSubmitTime = appSubmitTime;
        this.oldJobId = TypeConverter.fromYarn((JobId)jobId);
        this.committer = committer;
        this.newApiCommitter = newApiCommitter;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.jobCredentials = jobCredentials;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.aclsManager = new JobACLsManager(conf);
        this.reporterUserName = System.getProperty("user.name");
        this.jobACLs = this.aclsManager.constructJobACLs(conf);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Job Fail Wait Timeout Monitor #%d").setDaemon(true).build();
        this.executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.forcedState = forcedState;
        if (forcedDiagnostic != null) {
            this.diagnostics.add(forcedDiagnostic);
        }
        this.maxAllowedFetchFailuresFraction = conf.getFloat("mapreduce.reduce.shuffle.max-fetch-failures-fraction", 0.5f);
        this.maxFetchFailuresNotifications = conf.getInt("mapreduce.reduce.shuffle.max-fetch-failures-notifications", 3);
    }

    protected StateMachine<JobStateInternal, JobEventType, JobEvent> getStateMachine() {
        return this.stateMachine;
    }

    public JobId getID() {
        return this.jobId;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    JobContext getJobContext() {
        return this.jobContext;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        AccessControlList jobACL = (AccessControlList)this.jobACLs.get(jobOperation);
        if (jobACL == null) {
            return true;
        }
        return this.aclsManager.checkAccess(callerUGI, jobOperation, this.userName, jobACL);
    }

    public Task getTask(TaskId taskID) {
        this.readLock.lock();
        try {
            Task task = (Task)this.tasks.get(taskID);
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getCompletedMaps() {
        this.readLock.lock();
        try {
            int n = this.succeededMapTaskCount + this.failedMapTaskCount + this.killedMapTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getCompletedReduces() {
        this.readLock.lock();
        try {
            int n = this.succeededReduceTaskCount + this.failedReduceTaskCount + this.killedReduceTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isUber() {
        return this.isUber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counters getAllCounters() {
        this.readLock.lock();
        try {
            JobStateInternal state = this.getInternalState();
            if (state == JobStateInternal.ERROR || state == JobStateInternal.FAILED || state == JobStateInternal.KILLED || state == JobStateInternal.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                Counters counters = this.fullCounters;
                return counters;
            }
            Counters counters = new Counters();
            counters.incrAllCounters((AbstractCounters)this.jobCounters);
            Counters counters2 = JobImpl.incrTaskCounters((Counters)counters, this.tasks.values());
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Counters incrTaskCounters(Counters counters, Collection<Task> tasks) {
        for (Task task : tasks) {
            counters.incrAllCounters((AbstractCounters)task.getCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        TaskAttemptCompletionEvent[] events = EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.taskAttemptCompletionEvents.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.taskAttemptCompletionEvents.size() - fromEventId);
                events = this.taskAttemptCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
            }
            TaskAttemptCompletionEvent[] taskAttemptCompletionEventArray = events;
            return taskAttemptCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        TaskCompletionEvent[] events = EMPTY_TASK_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.mapAttemptCompletionEvents.size() > startIndex) {
                int actualMax = Math.min(maxEvents, this.mapAttemptCompletionEvents.size() - startIndex);
                events = this.mapAttemptCompletionEvents.subList(startIndex, actualMax + startIndex).toArray(events);
            }
            TaskCompletionEvent[] taskCompletionEventArray = events;
            return taskCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobReport getReport() {
        this.readLock.lock();
        try {
            JobReport report;
            JobState state = this.getState();
            String jobFile = this.remoteJobConfFile == null ? "" : this.remoteJobConfFile.toString();
            StringBuilder diagsb = new StringBuilder();
            for (String s : this.getDiagnostics()) {
                diagsb.append(s).append("\n");
            }
            if (this.getInternalState() == JobStateInternal.NEW) {
                JobReport jobReport = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.reporterUserName, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)0.0f, (float)0.0f, (float)this.cleanupProgress, (String)jobFile, (List)this.amInfos, (boolean)this.isUber, (String)diagsb.toString());
                return jobReport;
            }
            this.computeProgress();
            JobReport jobReport = report = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.reporterUserName, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)this.mapProgress, (float)this.reduceProgress, (float)this.cleanupProgress, (String)jobFile, (List)this.amInfos, (boolean)this.isUber, (String)diagsb.toString(), (Priority)this.jobPriority);
            return jobReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public float getProgress() {
        this.readLock.lock();
        try {
            this.computeProgress();
            float f = this.setupProgress * this.setupWeight + this.cleanupProgress * this.cleanupWeight + this.mapProgress * this.mapWeight + this.reduceProgress * this.reduceWeight;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeProgress() {
        this.readLock.lock();
        try {
            float mapProgress = 0.0f;
            float reduceProgress = 0.0f;
            for (Task task : this.tasks.values()) {
                if (task.getType() == TaskType.MAP) {
                    mapProgress += task.isFinished() ? 1.0f : task.getProgress();
                    continue;
                }
                reduceProgress += task.isFinished() ? 1.0f : task.getProgress();
            }
            if (this.numMapTasks != 0) {
                mapProgress /= (float)this.numMapTasks;
            }
            if (this.numReduceTasks != 0) {
                reduceProgress /= (float)this.numReduceTasks;
            }
            this.mapProgress = mapProgress;
            this.reduceProgress = reduceProgress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskId, Task> getTasks() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            this.lazyTasksCopyNeeded = true;
            return Collections.unmodifiableMap(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskId, Task> getTasks(TaskType taskType) {
        Map localTasksCopy = this.tasks;
        HashMap result = new HashMap();
        Set tasksOfGivenType = null;
        this.readLock.lock();
        try {
            tasksOfGivenType = TaskType.MAP == taskType ? this.mapTasks : this.reduceTasks;
            for (TaskId taskID : tasksOfGivenType) {
                result.put(taskID, localTasksCopy.get(taskID));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public JobState getState() {
        this.readLock.lock();
        try {
            JobState state = this.getExternalState(this.getInternalState());
            if (!(this.appContext.hasSuccessfullyUnregistered() || state != JobState.SUCCEEDED && state != JobState.FAILED && state != JobState.KILLED && state != JobState.ERROR)) {
                JobState jobState = this.lastNonFinalState;
                return jobState;
            }
            JobState jobState = state;
            return jobState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void scheduleTasks(Set<TaskId> taskIDs, boolean recoverTaskOutput) {
        for (TaskId taskID : taskIDs) {
            JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)this.completedTasksFromPreviousRun.remove(taskID);
            if (taskInfo != null) {
                this.eventHandler.handle((Event)new TaskRecoverEvent(taskID, taskInfo, this.committer, recoverTaskOutput));
                continue;
            }
            this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(JobEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getJobId() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            JobStateInternal oldState = this.getInternalState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                this.addDiagnostic("Invalid event " + event.getType() + " on Job " + this.jobId);
                this.eventHandler.handle((Event)new JobEvent(this.jobId, JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.jobId + "Job Transitioned from " + oldState + " to " + this.getInternalState()));
                this.rememberLastNonFinalState(oldState);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void rememberLastNonFinalState(JobStateInternal stateInternal) {
        JobState state = this.getExternalState(stateInternal);
        if (state != JobState.SUCCEEDED && state != JobState.FAILED && state != JobState.KILLED && state != JobState.ERROR) {
            this.lastNonFinalState = state;
        }
    }

    @InterfaceAudience.Private
    public JobStateInternal getInternalState() {
        this.readLock.lock();
        try {
            if (this.forcedState != null) {
                JobStateInternal jobStateInternal = this.forcedState;
                return jobStateInternal;
            }
            JobStateInternal jobStateInternal = (JobStateInternal)this.getStateMachine().getCurrentState();
            return jobStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private JobState getExternalState(JobStateInternal smState) {
        switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$job$JobStateInternal[smState.ordinal()]) {
            case 1: 
            case 2: {
                return JobState.KILLED;
            }
            case 3: 
            case 4: {
                return JobState.RUNNING;
            }
            case 5: 
            case 6: {
                return JobState.FAILED;
            }
            case 7: {
                if (this.appContext.isLastAMRetry()) {
                    return JobState.ERROR;
                }
                return JobState.RUNNING;
            }
        }
        return JobState.valueOf((String)smState.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            if (this.lazyTasksCopyNeeded) {
                LinkedHashMap newTasks = new LinkedHashMap();
                newTasks.putAll(this.tasks);
                this.tasks = newTasks;
                this.lazyTasksCopyNeeded = false;
            }
        }
        this.tasks.put(task.getID(), task);
        if (task.getType() == TaskType.MAP) {
            this.mapTasks.add(task.getID());
        } else if (task.getType() == TaskType.REDUCE) {
            this.reduceTasks.add(task.getID());
        }
        this.metrics.waitingTask(task);
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryFinishedEvent() {
        this.setFinishTime();
        JobFinishedEvent jfe = JobImpl.createJobFinishedEvent((JobImpl)this);
        LOG.info((Object)"Calling handler for JobFinishedEvent ");
        this.getEventHandler().handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jfe));
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    protected JobStateInternal checkReadyForCommit() {
        JobStateInternal currentState = this.getInternalState();
        if (this.completedTaskCount == this.tasks.size() && currentState == JobStateInternal.RUNNING) {
            this.eventHandler.handle((Event)new CommitterJobCommitEvent(this.jobId, this.getJobContext()));
            return JobStateInternal.COMMITTING;
        }
        return this.getInternalState();
    }

    JobStateInternal finished(JobStateInternal finalState) {
        if (this.getInternalState() == JobStateInternal.RUNNING) {
            this.metrics.endRunningJob((Job)this);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.eventHandler.handle((Event)new JobFinishEvent(this.jobId));
        switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$job$JobStateInternal[finalState.ordinal()]) {
            case 8: {
                this.metrics.killedJob((Job)this);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                this.metrics.failedJob((Job)this);
                break;
            }
            case 11: {
                this.metrics.completedJob((Job)this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal job state: " + finalState);
            }
        }
        return finalState;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
        JobQueueChangeEvent jqce = new JobQueueChangeEvent(this.oldJobId, queueName);
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jqce));
    }

    public Path getConfFile() {
        return this.remoteJobConfFile;
    }

    public String getName() {
        return this.jobName;
    }

    public int getTotalMaps() {
        return this.mapTasks.size();
    }

    public int getTotalReduces() {
        return this.reduceTasks.size();
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        return Collections.unmodifiableMap(this.jobACLs);
    }

    public List<AMInfo> getAMInfos() {
        return this.amInfos;
    }

    private void makeUberDecision(long dataInputLength) {
        int sysMaxMaps = this.conf.getInt("mapreduce.job.ubertask.maxmaps", 9);
        int sysMaxReduces = this.conf.getInt("mapreduce.job.ubertask.maxreduces", 1);
        long sysMaxBytes = this.conf.getLong("mapreduce.job.ubertask.maxbytes", this.fs.getDefaultBlockSize(this.remoteJobSubmitDir));
        long sysMemSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        long sysCPUSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.cpu-vcores", 1);
        boolean uberEnabled = this.conf.getBoolean("mapreduce.job.ubertask.enable", false);
        boolean smallNumMapTasks = this.numMapTasks <= sysMaxMaps;
        boolean smallNumReduceTasks = this.numReduceTasks <= sysMaxReduces;
        boolean smallInput = dataInputLength <= sysMaxBytes;
        long requiredMapMB = this.conf.getLong("mapreduce.map.memory.mb", 0L);
        long requiredReduceMB = this.conf.getLong("mapreduce.reduce.memory.mb", 0L);
        long requiredMB = Math.max(requiredMapMB, requiredReduceMB);
        int requiredMapCores = this.conf.getInt("mapreduce.map.cpu.vcores", 1);
        int requiredReduceCores = this.conf.getInt("mapreduce.reduce.cpu.vcores", 1);
        int requiredCores = Math.max(requiredMapCores, requiredReduceCores);
        if (this.numReduceTasks == 0) {
            requiredMB = requiredMapMB;
            requiredCores = requiredMapCores;
        }
        boolean smallMemory = requiredMB <= sysMemSizeForUberSlot || sysMemSizeForUberSlot == -1L;
        boolean smallCpu = (long)requiredCores <= sysCPUSizeForUberSlot;
        boolean notChainJob = !this.isChainJob((Configuration)this.conf);
        boolean bl = this.isUber = uberEnabled && smallNumMapTasks && smallNumReduceTasks && smallInput && smallMemory && smallCpu && notChainJob;
        if (this.isUber) {
            LOG.info((Object)("Uberizing job " + this.jobId + ": " + this.numMapTasks + "m+" + this.numReduceTasks + "r tasks (" + dataInputLength + " input bytes) will run sequentially on single node."));
            this.conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
            this.conf.setInt("mapreduce.map.maxattempts", 1);
            this.conf.setInt("mapreduce.reduce.maxattempts", 1);
            this.conf.setBoolean("mapreduce.map.speculative", false);
            this.conf.setBoolean("mapreduce.reduce.speculative", false);
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("Not uberizing ").append(this.jobId).append(" because:");
            if (!uberEnabled) {
                msg.append(" not enabled;");
            }
            if (!smallNumMapTasks) {
                msg.append(" too many maps;");
            }
            if (!smallNumReduceTasks) {
                msg.append(" too many reduces;");
            }
            if (!smallInput) {
                msg.append(" too much input;");
            }
            if (!smallCpu) {
                msg.append(" too much CPU;");
            }
            if (!smallMemory) {
                msg.append(" too much RAM;");
            }
            if (!notChainJob) {
                msg.append(" chainjob;");
            }
            LOG.info((Object)msg.toString());
        }
    }

    private boolean isChainJob(Configuration conf) {
        boolean isChainJob = false;
        try {
            Class<?> mapClass;
            String mapClassName = conf.get("mapreduce.job.map.class");
            if (mapClassName != null && ChainMapper.class.isAssignableFrom(mapClass = Class.forName(mapClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException mapClassName) {
        }
        catch (NoClassDefFoundError mapClassName) {
            // empty catch block
        }
        try {
            Class<?> reduceClass;
            String reduceClassName = conf.get("mapreduce.job.reduce.class");
            if (reduceClassName != null && ChainReducer.class.isAssignableFrom(reduceClass = Class.forName(reduceClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return isChainJob;
    }

    private void actOnUnusableNode(NodeId nodeId, NodeState nodeState) {
        List taskAttemptIdList;
        if (this.getInternalState() == JobStateInternal.RUNNING && !this.allReducersComplete() && (taskAttemptIdList = (List)this.nodesToSucceededTaskAttempts.get(nodeId)) != null) {
            String mesg = "TaskAttempt killed because it ran on unusable node " + nodeId;
            for (TaskAttemptId id : taskAttemptIdList) {
                if (TaskType.MAP != id.getTaskId().getTaskType()) continue;
                LOG.info((Object)(mesg + ". AttemptId:" + id));
                this.eventHandler.handle((Event)new TaskAttemptKillEvent(id, mesg, true));
            }
        }
    }

    private boolean allReducersComplete() {
        return this.numReduceTasks == 0 || this.numReduceTasks == this.getCompletedReduces();
    }

    private static String getWorkflowAdjacencies(Configuration conf) {
        int prefixLen = "mapreduce.workflow.adjacency.".length();
        Map adjacencies = conf.getValByRegex("^mapreduce\\.workflow\\.adjacency\\..+");
        if (adjacencies.isEmpty()) {
            return "";
        }
        int size = 0;
        for (Map.Entry entry : adjacencies.entrySet()) {
            int keyLen = ((String)entry.getKey()).length();
            size += keyLen - prefixLen;
            size += ((String)entry.getValue()).length() + 6;
        }
        StringBuilder sb = new StringBuilder(size);
        for (Map.Entry entry : adjacencies.entrySet()) {
            int keyLen = ((String)entry.getKey()).length();
            sb.append("\"");
            sb.append(JobImpl.escapeString((String)((String)entry.getKey()).substring(prefixLen, keyLen)));
            sb.append("\"=\"");
            sb.append(JobImpl.escapeString((String)((String)entry.getValue())));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static String escapeString(String data) {
        return StringUtils.escapeString((String)data, (char)'\\', (char[])new char[]{'\"', '=', '.'});
    }

    private void unsuccessfulFinish(JobStateInternal finalState) {
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.cleanupProgress = 1.0f;
        JobUnsuccessfulCompletionEvent unsuccessfulJobEvent = new JobUnsuccessfulCompletionEvent(this.oldJobId, this.finishTime, this.succeededMapTaskCount, this.succeededReduceTaskCount, finalState.toString(), (Iterable)this.diagnostics);
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)unsuccessfulJobEvent));
        this.finished(finalState);
    }

    private static JobFinishedEvent createJobFinishedEvent(JobImpl job) {
        job.mayBeConstructFinalFullCounters();
        JobFinishedEvent jfe = new JobFinishedEvent(job.oldJobId, job.finishTime, job.succeededMapTaskCount, job.succeededReduceTaskCount, job.failedMapTaskCount, job.failedReduceTaskCount, job.finalMapCounters, job.finalReduceCounters, job.fullCounters);
        return jfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new Counters();
        this.finalMapCounters = new Counters();
        this.finalReduceCounters = new Counters();
        this.fullCounters.incrAllCounters((AbstractCounters)this.jobCounters);
        for (Task t : this.tasks.values()) {
            Counters counters = t.getCounters();
            switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$TaskType[t.getType().ordinal()]) {
                case 1: {
                    this.finalMapCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                case 2: {
                    this.finalReduceCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                default: {
                    throw new IllegalStateException("Task type neither map nor reduce: " + t.getType());
                }
            }
            this.fullCounters.incrAllCounters((AbstractCounters)counters);
        }
    }

    @VisibleForTesting
    void decrementSucceededMapperCount() {
        --this.completedTaskCount;
        --this.succeededMapTaskCount;
    }

    protected void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    public Configuration loadConfFile() throws IOException {
        Path confPath = this.getConfFile();
        FileContext fc = FileContext.getFileContext((URI)confPath.toUri(), (Configuration)this.conf);
        Configuration jobConf = new Configuration(false);
        jobConf.addResource((InputStream)fc.open(confPath), confPath.toString());
        return jobConf;
    }

    public float getMaxAllowedFetchFailuresFraction() {
        return this.maxAllowedFetchFailuresFraction;
    }

    public int getMaxFetchFailuresNotifications() {
        return this.maxFetchFailuresNotifications;
    }

    public void setJobPriority(Priority priority) {
        this.jobPriority = priority;
    }

    static /* synthetic */ MRAppMetrics access$2300(JobImpl x0) {
        return x0.metrics;
    }

    static /* synthetic */ boolean access$2400(JobImpl x0) {
        return x0.newApiCommitter;
    }

    static /* synthetic */ JobContext access$2502(JobImpl x0, JobContext x1) {
        x0.jobContext = x1;
        return x0.jobContext;
    }

    static /* synthetic */ JobID access$2600(JobImpl x0) {
        return x0.oldJobId;
    }

    static /* synthetic */ FileSystem access$2702(JobImpl x0, FileSystem x1) {
        x0.fs = x1;
        return x0.fs;
    }

    static /* synthetic */ long access$2800(JobImpl x0) {
        return x0.appSubmitTime;
    }

    static /* synthetic */ Map access$2900(JobImpl x0) {
        return x0.jobACLs;
    }

    static /* synthetic */ String access$3000(JobImpl x0) {
        return x0.queueName;
    }

    static /* synthetic */ String access$3100(Configuration x0) {
        return JobImpl.getWorkflowAdjacencies((Configuration)x0);
    }

    static /* synthetic */ JobId access$3200(JobImpl x0) {
        return x0.jobId;
    }

    static /* synthetic */ EventHandler access$3300(JobImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ int access$3402(JobImpl x0, int x1) {
        x0.numMapTasks = x1;
        return x0.numMapTasks;
    }

    static /* synthetic */ int access$3502(JobImpl x0, int x1) {
        x0.numReduceTasks = x1;
        return x0.numReduceTasks;
    }

    static /* synthetic */ int access$3400(JobImpl x0) {
        return x0.numMapTasks;
    }

    static /* synthetic */ int access$3500(JobImpl x0) {
        return x0.numReduceTasks;
    }

    static /* synthetic */ float access$3602(JobImpl x0, float x1) {
        x0.reduceWeight = x1;
        return x0.reduceWeight;
    }

    static /* synthetic */ float access$3702(JobImpl x0, float x1) {
        x0.mapWeight = x1;
        return x0.mapWeight;
    }

    static /* synthetic */ void access$3800(JobImpl x0, long x1) {
        x0.makeUberDecision(x1);
    }

    static /* synthetic */ List access$3902(JobImpl x0, List x1) {
        x0.taskAttemptCompletionEvents = x1;
        return x0.taskAttemptCompletionEvents;
    }

    static /* synthetic */ List access$4002(JobImpl x0, List x1) {
        x0.mapAttemptCompletionEvents = x1;
        return x0.mapAttemptCompletionEvents;
    }

    static /* synthetic */ List access$4102(JobImpl x0, List x1) {
        x0.taskCompletionIdxToMapCompletionIdx = x1;
        return x0.taskCompletionIdxToMapCompletionIdx;
    }

    static /* synthetic */ int access$4202(JobImpl x0, int x1) {
        x0.allowedMapFailuresPercent = x1;
        return x0.allowedMapFailuresPercent;
    }

    static /* synthetic */ int access$4302(JobImpl x0, int x1) {
        x0.allowedReduceFailuresPercent = x1;
        return x0.allowedReduceFailuresPercent;
    }

    static /* synthetic */ Log access$4400() {
        return LOG;
    }

    static /* synthetic */ Path access$4502(JobImpl x0, Path x1) {
        x0.remoteJobSubmitDir = x1;
        return x0.remoteJobSubmitDir;
    }

    static /* synthetic */ Path access$4500(JobImpl x0) {
        return x0.remoteJobSubmitDir;
    }

    static /* synthetic */ Token access$4602(JobImpl x0, Token x1) {
        x0.jobToken = x1;
        return x0.jobToken;
    }

    static /* synthetic */ JobTokenSecretManager access$4700(JobImpl x0) {
        return x0.jobTokenSecretManager;
    }

    static /* synthetic */ Token access$4600(JobImpl x0) {
        return x0.jobToken;
    }

    static /* synthetic */ Credentials access$4800(JobImpl x0) {
        return x0.jobCredentials;
    }

    static /* synthetic */ TaskAttemptListener access$4900(JobImpl x0) {
        return x0.taskAttemptListener;
    }

    static /* synthetic */ Clock access$5000(JobImpl x0) {
        return x0.clock;
    }

    static /* synthetic */ ApplicationAttemptId access$5100(JobImpl x0) {
        return x0.applicationAttemptId;
    }

    static /* synthetic */ AppContext access$5200(JobImpl x0) {
        return x0.appContext;
    }

    static /* synthetic */ FileSystem access$2700(JobImpl x0) {
        return x0.fs;
    }

    static /* synthetic */ JobContext access$2500(JobImpl x0) {
        return x0.jobContext;
    }

    static /* synthetic */ float access$5302(JobImpl x0, float x1) {
        x0.setupProgress = x1;
        return x0.setupProgress;
    }

    static /* synthetic */ Set access$5400(JobImpl x0) {
        return x0.mapTasks;
    }

    static /* synthetic */ Set access$5500(JobImpl x0) {
        return x0.reduceTasks;
    }

    static /* synthetic */ long access$5602(JobImpl x0, long x1) {
        x0.startTime = x1;
        return x0.startTime;
    }

    static /* synthetic */ long access$5600(JobImpl x0) {
        return x0.startTime;
    }

    static /* synthetic */ void access$5700(JobImpl x0, JobStateInternal x1) {
        x0.unsuccessfulFinish(x1);
    }

    static /* synthetic */ ScheduledFuture access$5800(JobImpl x0) {
        return x0.failWaitTriggerScheduledFuture;
    }

    static /* synthetic */ long access$5900(JobImpl x0) {
        return x0.finishTime;
    }

    static /* synthetic */ List access$6000(JobImpl x0) {
        return x0.diagnostics;
    }

    static /* synthetic */ List access$3900(JobImpl x0) {
        return x0.taskAttemptCompletionEvents;
    }

    static /* synthetic */ List access$4000(JobImpl x0) {
        return x0.mapAttemptCompletionEvents;
    }

    static /* synthetic */ List access$4100(JobImpl x0) {
        return x0.taskCompletionIdxToMapCompletionIdx;
    }

    static /* synthetic */ Map access$6100(JobImpl x0) {
        return x0.successAttemptCompletionEventNoMap;
    }

    static /* synthetic */ HashMap access$6200(JobImpl x0) {
        return x0.nodesToSucceededTaskAttempts;
    }

    static /* synthetic */ Map access$6300(JobImpl x0) {
        return x0.fetchFailuresMapping;
    }

    static /* synthetic */ int access$6408(JobImpl x0) {
        return x0.completedTaskCount++;
    }

    static /* synthetic */ int access$6400(JobImpl x0) {
        return x0.completedTaskCount;
    }

    static /* synthetic */ int access$6500(JobImpl x0) {
        return x0.failedMapTaskCount;
    }

    static /* synthetic */ int access$4200(JobImpl x0) {
        return x0.allowedMapFailuresPercent;
    }

    static /* synthetic */ int access$6600(JobImpl x0) {
        return x0.failedReduceTaskCount;
    }

    static /* synthetic */ int access$4300(JobImpl x0) {
        return x0.allowedReduceFailuresPercent;
    }

    static /* synthetic */ ScheduledFuture access$5802(JobImpl x0, ScheduledFuture x1) {
        x0.failWaitTriggerScheduledFuture = x1;
        return x0.failWaitTriggerScheduledFuture;
    }

    static /* synthetic */ ScheduledThreadPoolExecutor access$6700(JobImpl x0) {
        return x0.executor;
    }

    static /* synthetic */ int access$6808(JobImpl x0) {
        return x0.succeededMapTaskCount++;
    }

    static /* synthetic */ int access$6908(JobImpl x0) {
        return x0.succeededReduceTaskCount++;
    }

    static /* synthetic */ int access$6508(JobImpl x0) {
        return x0.failedMapTaskCount++;
    }

    static /* synthetic */ int access$6608(JobImpl x0) {
        return x0.failedReduceTaskCount++;
    }

    static /* synthetic */ int access$7008(JobImpl x0) {
        return x0.killedMapTaskCount++;
    }

    static /* synthetic */ int access$7108(JobImpl x0) {
        return x0.killedReduceTaskCount++;
    }

    static /* synthetic */ Counters access$7200(JobImpl x0) {
        return x0.jobCounters;
    }

    static /* synthetic */ void access$7300(JobImpl x0, NodeId x1, NodeState x2) {
        x0.actOnUnusableNode(x1, x2);
    }
}

