/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocationException;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.mapreduce.v2.app.rm.ResourceCalculatorUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidLabelResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMContainerAllocator
extends RMContainerRequestor
implements ContainerAllocator {
    static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    public static final float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    static final Priority PRIORITY_FAST_FAIL_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
    static final Priority PRIORITY_REDUCE;
    static final Priority PRIORITY_MAP;
    @VisibleForTesting
    public static final String RAMPDOWN_DIAGNOSTIC = "Reducer preempted to make room for pending map attempts";
    private Thread eventHandlingThread;
    private final AtomicBoolean stopped;
    private final LinkedList<RMContainerRequestor.ContainerRequest> pendingReduces = new LinkedList();
    private final AssignedRequests assignedRequests;
    private final ScheduledRequests scheduledRequests = new ScheduledRequests(this);
    private int containersAllocated = 0;
    private int containersReleased = 0;
    private int hostLocalAssigned = 0;
    private int rackLocalAssigned = 0;
    private int lastCompletedTasks = 0;
    private boolean recalculateReduceSchedule = false;
    private Resource mapResourceRequest = Resources.none();
    private Resource reduceResourceRequest = Resources.none();
    private boolean reduceStarted = false;
    private float maxReduceRampupLimit = 0.0f;
    private float maxReducePreemptionLimit = 0.0f;
    private long reducerUnconditionalPreemptionDelayMs;
    private long reducerNoHeadroomPreemptionDelayMs = 0L;
    private float reduceSlowStart = 0.0f;
    private int maxRunningMaps = 0;
    private int maxRunningReduces = 0;
    private long retryInterval;
    private long retrystartTime;
    private Clock clock;
    @VisibleForTesting
    protected BlockingQueue<ContainerAllocatorEvent> eventQueue = new LinkedBlockingQueue();
    private ScheduleStats scheduleStats = new ScheduleStats(this, null);
    private String mapNodeLabelExpression;
    private String reduceNodeLabelExpression;

    public RMContainerAllocator(ClientService clientService, AppContext context) {
        super(clientService, context);
        this.stopped = new AtomicBoolean(false);
        this.clock = context.getClock();
        this.assignedRequests = this.createAssignedRequests();
    }

    protected AssignedRequests createAssignedRequests() {
        return new AssignedRequests(this);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.reduceSlowStart = conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f);
        this.maxReduceRampupLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.rampup.limit", 0.5f);
        this.maxReducePreemptionLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.preemption.limit", 0.5f);
        this.reducerUnconditionalPreemptionDelayMs = 1000 * conf.getInt("mapreduce.job.reducer.unconditional-preempt.delay.sec", 300);
        this.reducerNoHeadroomPreemptionDelayMs = conf.getInt("mapreduce.job.reducer.preempt.delay.sec", 0) * 1000;
        this.maxRunningMaps = conf.getInt("mapreduce.job.running.map.limit", 0);
        this.maxRunningReduces = conf.getInt("mapreduce.job.running.reduce.limit", 0);
        RackResolver.init((Configuration)conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.mapNodeLabelExpression = conf.get("mapreduce.map.node-label-expression");
        this.reduceNodeLabelExpression = conf.get("mapreduce.reduce.node-label-expression");
        this.retrystartTime = System.currentTimeMillis();
    }

    protected void serviceStart() throws Exception {
        this.eventHandlingThread = new /* Unavailable Anonymous Inner Class!! */;
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    protected synchronized void heartbeat() throws Exception {
        int completedMaps;
        int completedTasks;
        this.scheduleStats.updateAndLogIfChanged("Before Scheduling: ");
        List allocatedContainers = this.getResources();
        if (allocatedContainers != null && allocatedContainers.size() > 0) {
            ScheduledRequests.access$200((ScheduledRequests)this.scheduledRequests, (List)allocatedContainers);
        }
        if (this.lastCompletedTasks != (completedTasks = (completedMaps = this.getJob().getCompletedMaps()) + this.getJob().getCompletedReduces()) || this.scheduledRequests.maps.size() > 0) {
            this.lastCompletedTasks = completedTasks;
            this.recalculateReduceSchedule = true;
        }
        if (this.recalculateReduceSchedule) {
            boolean reducerPreempted = this.preemptReducesIfNeeded();
            if (!reducerPreempted) {
                this.scheduleReduces(this.getJob().getTotalMaps(), completedMaps, this.scheduledRequests.maps.size(), this.scheduledRequests.reduces.size(), this.assignedRequests.maps.size(), this.assignedRequests.reduces.size(), this.mapResourceRequest, this.reduceResourceRequest, this.pendingReduces.size(), this.maxReduceRampupLimit, this.reduceSlowStart);
            }
            this.recalculateReduceSchedule = false;
        }
        this.scheduleStats.updateAndLogIfChanged("After Scheduling: ");
    }

    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        super.serviceStop();
        this.scheduleStats.log("Final Stats: ");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    AssignedRequests getAssignedRequests() {
        return this.assignedRequests;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ScheduledRequests getScheduledRequests() {
        return this.scheduledRequests;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    int getNumOfPendingReduces() {
        return this.pendingReduces.size();
    }

    public boolean getIsReduceStarted() {
        return this.reduceStarted;
    }

    public void setIsReduceStarted(boolean reduceStarted) {
        this.reduceStarted = reduceStarted;
    }

    public void handle(ContainerAllocatorEvent event) {
        int remCapacity;
        int qSize = this.eventQueue.size();
        if (qSize != 0 && qSize % 1000 == 0) {
            LOG.info((Object)("Size of event-queue in RMContainerAllocator is " + qSize));
        }
        if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
            LOG.warn((Object)("Very low remaining capacity in the event-queue of RMContainerAllocator: " + remCapacity));
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected synchronized void handleEvent(ContainerAllocatorEvent event) {
        this.recalculateReduceSchedule = true;
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            ContainerRequestEvent reqEvent = (ContainerRequestEvent)event;
            JobId jobId = this.getJob().getID();
            Resource supportedMaxContainerCapability = this.getMaxContainerCapability();
            if (reqEvent.getAttemptID().getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                if (this.mapResourceRequest.equals((Object)Resources.none())) {
                    this.mapResourceRequest = reqEvent.getCapability();
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.MAP, this.mapResourceRequest.getMemorySize())));
                    LOG.info((Object)("mapResourceRequest:" + this.mapResourceRequest));
                    if (this.mapResourceRequest.getMemorySize() > supportedMaxContainerCapability.getMemorySize() || this.mapResourceRequest.getVirtualCores() > supportedMaxContainerCapability.getVirtualCores()) {
                        String diagMsg = "MAP capability required is more than the supported max container capability in the cluster. Killing the Job. mapResourceRequest: " + this.mapResourceRequest + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemorySize(this.mapResourceRequest.getMemorySize());
                reqEvent.getCapability().setVirtualCores(this.mapResourceRequest.getVirtualCores());
                this.scheduledRequests.addMap(reqEvent);
            } else {
                if (this.reduceResourceRequest.equals((Object)Resources.none())) {
                    this.reduceResourceRequest = reqEvent.getCapability();
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.REDUCE, this.reduceResourceRequest.getMemorySize())));
                    LOG.info((Object)("reduceResourceRequest:" + this.reduceResourceRequest));
                    if (this.reduceResourceRequest.getMemorySize() > supportedMaxContainerCapability.getMemorySize() || this.reduceResourceRequest.getVirtualCores() > supportedMaxContainerCapability.getVirtualCores()) {
                        String diagMsg = "REDUCE capability required is more than the supported max container capability in the cluster. Killing the Job. reduceResourceRequest: " + this.reduceResourceRequest + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemorySize(this.reduceResourceRequest.getMemorySize());
                reqEvent.getCapability().setVirtualCores(this.reduceResourceRequest.getVirtualCores());
                if (reqEvent.getEarlierAttemptFailed()) {
                    this.pendingReduces.addFirst(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE, this.reduceNodeLabelExpression));
                } else {
                    this.pendingReduces.add(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE, this.reduceNodeLabelExpression));
                }
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_DEALLOCATE) {
            ContainerId containerId;
            LOG.info((Object)("Processing the event " + event.toString()));
            TaskAttemptId aId = event.getAttemptID();
            boolean removed = this.scheduledRequests.remove(aId);
            if (!removed && (containerId = this.assignedRequests.get(aId)) != null) {
                removed = true;
                this.assignedRequests.remove(aId);
                ++this.containersReleased;
                this.pendingRelease.add(containerId);
                this.release(containerId);
            }
            if (!removed) {
                LOG.error((Object)("Could not deallocate container for task attemptId " + aId));
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_FAILED) {
            ContainerFailedEvent fEv = (ContainerFailedEvent)event;
            String host = RMContainerAllocator.getHost((String)fEv.getContMgrAddress());
            this.containerFailedOnHost(host);
        }
    }

    private static String getHost(String contMgrAddress) {
        String host = contMgrAddress;
        String[] hostport = host.split(":");
        if (hostport.length == 2) {
            host = hostport[0];
        }
        return host;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    synchronized void setReduceResourceRequest(Resource res) {
        this.reduceResourceRequest = res;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    synchronized void setMapResourceRequest(Resource res) {
        this.mapResourceRequest = res;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean preemptReducesIfNeeded() {
        if (this.reduceResourceRequest.equals((Object)Resources.none())) {
            return false;
        }
        if (this.assignedRequests.maps.size() > 0) {
            return false;
        }
        if (this.scheduledRequests.maps.size() <= 0) {
            return false;
        }
        if (this.reducerUnconditionalPreemptionDelayMs >= 0L && this.preemptReducersForHangingMapRequests(this.reducerUnconditionalPreemptionDelayMs)) {
            return true;
        }
        Resource scheduledReducesResource = Resources.multiply((Resource)this.reduceResourceRequest, (double)this.scheduledRequests.reduces.size());
        Resource availableResourceForMap = Resources.subtract((Resource)this.getAvailableResources(), (Resource)scheduledReducesResource);
        if (ResourceCalculatorUtils.computeAvailableContainers((Resource)availableResourceForMap, (Resource)this.mapResourceRequest, (EnumSet)this.getSchedulerResourceTypes()) > 0) {
            return false;
        }
        return this.preemptReducersForHangingMapRequests(this.reducerNoHeadroomPreemptionDelayMs);
    }

    private boolean preemptReducersForHangingMapRequests(long pendingThreshold) {
        int hangingMapRequests = this.getNumHangingRequests(pendingThreshold, this.scheduledRequests.maps);
        if (hangingMapRequests > 0) {
            this.preemptReducer(hangingMapRequests);
            return true;
        }
        return false;
    }

    private void clearAllPendingReduceRequests() {
        this.rampDownReduces(Integer.MAX_VALUE);
    }

    private void preemptReducer(int hangingMapRequests) {
        this.clearAllPendingReduceRequests();
        int preemptionReduceNumForOneMap = ResourceCalculatorUtils.divideAndCeilContainers((Resource)this.mapResourceRequest, (Resource)this.reduceResourceRequest, (EnumSet)this.getSchedulerResourceTypes());
        int preemptionReduceNumForPreemptionLimit = ResourceCalculatorUtils.divideAndCeilContainers((Resource)Resources.multiply((Resource)this.getResourceLimit(), (double)this.maxReducePreemptionLimit), (Resource)this.reduceResourceRequest, (EnumSet)this.getSchedulerResourceTypes());
        int preemptionReduceNumForAllMaps = ResourceCalculatorUtils.divideAndCeilContainers((Resource)Resources.multiply((Resource)this.mapResourceRequest, (double)hangingMapRequests), (Resource)this.reduceResourceRequest, (EnumSet)this.getSchedulerResourceTypes());
        int toPreempt = Math.min(Math.max(preemptionReduceNumForOneMap, preemptionReduceNumForPreemptionLimit), preemptionReduceNumForAllMaps);
        LOG.info((Object)("Going to preempt " + toPreempt + " due to lack of space for maps"));
        this.assignedRequests.preemptReduce(toPreempt);
    }

    private int getNumHangingRequests(long allocationDelayThresholdMs, Map<TaskAttemptId, RMContainerRequestor.ContainerRequest> requestMap) {
        if (allocationDelayThresholdMs <= 0L) {
            return requestMap.size();
        }
        int hangingRequests = 0;
        long currTime = this.clock.getTime();
        for (RMContainerRequestor.ContainerRequest request : requestMap.values()) {
            long delay = currTime - request.requestTimeMs;
            if (delay <= allocationDelayThresholdMs) continue;
            ++hangingRequests;
        }
        return hangingRequests;
    }

    @InterfaceAudience.Private
    public void scheduleReduces(int totalMaps, int completedMaps, int scheduledMaps, int scheduledReduces, int assignedMaps, int assignedReduces, Resource mapResourceReqt, Resource reduceResourceReqt, int numPendingReduces, float maxReduceRampupLimit, float reduceSlowStart) {
        Resource finalMapResourceLimit;
        Resource finalReduceResourceLimit;
        Resource idealReduceResourceLimit;
        if (numPendingReduces == 0) {
            return;
        }
        Resource headRoom = this.getAvailableResources();
        LOG.info((Object)("Recalculating schedule, headroom=" + headRoom));
        if (!this.getIsReduceStarted()) {
            int completedMapsForReduceSlowstart = (int)Math.ceil(reduceSlowStart * (float)totalMaps);
            if (completedMaps < completedMapsForReduceSlowstart) {
                LOG.info((Object)("Reduce slow start threshold not met. completedMapsForReduceSlowstart " + completedMapsForReduceSlowstart));
                return;
            }
            LOG.info((Object)"Reduce slow start threshold reached. Scheduling reduces.");
            this.setIsReduceStarted(true);
        }
        if (scheduledMaps == 0 && numPendingReduces > 0) {
            LOG.info((Object)("All maps assigned. Ramping up all remaining reduces:" + numPendingReduces));
            this.scheduleAllReduces();
            return;
        }
        float completedMapPercent = 0.0f;
        completedMapPercent = totalMaps != 0 ? (float)completedMaps / (float)totalMaps : 1.0f;
        Resource netScheduledMapResource = Resources.multiply((Resource)mapResourceReqt, (double)(scheduledMaps + assignedMaps));
        Resource netScheduledReduceResource = Resources.multiply((Resource)reduceResourceReqt, (double)(scheduledReduces + assignedReduces));
        Resource totalResourceLimit = this.getResourceLimit();
        Resource ideaMapResourceLimit = Resources.subtract((Resource)totalResourceLimit, (Resource)(idealReduceResourceLimit = Resources.multiply((Resource)totalResourceLimit, (double)Math.min(completedMapPercent, maxReduceRampupLimit))));
        if (ResourceCalculatorUtils.computeAvailableContainers((Resource)ideaMapResourceLimit, (Resource)mapResourceReqt, (EnumSet)this.getSchedulerResourceTypes()) >= scheduledMaps + assignedMaps) {
            Resource unusedMapResourceLimit = Resources.subtract((Resource)ideaMapResourceLimit, (Resource)netScheduledMapResource);
            finalReduceResourceLimit = Resources.add((Resource)idealReduceResourceLimit, (Resource)unusedMapResourceLimit);
            finalMapResourceLimit = Resources.subtract((Resource)totalResourceLimit, (Resource)finalReduceResourceLimit);
        } else {
            finalMapResourceLimit = ideaMapResourceLimit;
            finalReduceResourceLimit = idealReduceResourceLimit;
        }
        LOG.info((Object)("completedMapPercent " + completedMapPercent + " totalResourceLimit:" + totalResourceLimit + " finalMapResourceLimit:" + finalMapResourceLimit + " finalReduceResourceLimit:" + finalReduceResourceLimit + " netScheduledMapResource:" + netScheduledMapResource + " netScheduledReduceResource:" + netScheduledReduceResource));
        int rampUp = ResourceCalculatorUtils.computeAvailableContainers((Resource)Resources.subtract((Resource)finalReduceResourceLimit, (Resource)netScheduledReduceResource), (Resource)reduceResourceReqt, (EnumSet)this.getSchedulerResourceTypes());
        if (rampUp > 0) {
            rampUp = Math.min(rampUp, numPendingReduces);
            LOG.info((Object)("Ramping up " + rampUp));
            this.rampUpReduces(rampUp);
        } else if (rampUp < 0) {
            int rampDown = -1 * rampUp;
            rampDown = Math.min(rampDown, scheduledReduces);
            LOG.info((Object)("Ramping down " + rampDown));
            this.rampDownReduces(rampDown);
        }
    }

    @InterfaceAudience.Private
    public void scheduleAllReduces() {
        for (RMContainerRequestor.ContainerRequest req : this.pendingReduces) {
            this.scheduledRequests.addReduce(req);
        }
        this.pendingReduces.clear();
    }

    @InterfaceAudience.Private
    public void rampUpReduces(int rampUp) {
        for (int i = 0; i < rampUp; ++i) {
            RMContainerRequestor.ContainerRequest request = (RMContainerRequestor.ContainerRequest)this.pendingReduces.removeFirst();
            this.scheduledRequests.addReduce(request);
        }
    }

    @InterfaceAudience.Private
    public void rampDownReduces(int rampDown) {
        while (rampDown > 0) {
            RMContainerRequestor.ContainerRequest request = this.scheduledRequests.removeReduce();
            if (request == null) {
                return;
            }
            this.pendingReduces.add(request);
            --rampDown;
        }
    }

    private List<Container> getResources() throws Exception {
        AllocateResponse response;
        this.applyConcurrentTaskLimits();
        Resource headRoom = Resources.clone((Resource)this.getAvailableResources());
        try {
            response = this.makeRemoteRequest();
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
            throw new RMContainerAllocationException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationAttemptId(), (Throwable)e);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.info((Object)"ApplicationMaster is out of sync with ResourceManager, hence resync and send outstanding requests.");
            this.lastResponseID = 0;
            this.register();
            this.addOutstandingRequestOnResync();
            return null;
        }
        catch (InvalidLabelResourceRequestException e) {
            String diagMsg = "Requested node-label-expression is invalid: " + StringUtils.stringifyException((Throwable)e);
            LOG.info((Object)diagMsg);
            JobId jobId = this.getJob().getID();
            this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
            this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
            throw e;
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
                throw new RMContainerAllocationException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        Resource newHeadRoom = this.getAvailableResources();
        List newContainers = response.getAllocatedContainers();
        if (response.getNMTokens() != null) {
            for (NMToken nmToken : response.getNMTokens()) {
                NMTokenCache.setNMToken((String)nmToken.getNodeId().toString(), (org.apache.hadoop.yarn.api.records.Token)nmToken.getToken());
            }
        }
        if (response.getAMRMToken() != null) {
            this.updateAMRMToken(response.getAMRMToken());
        }
        List finishedContainers = response.getCompletedContainersStatuses();
        if (newContainers.size() + finishedContainers.size() > 0 || !headRoom.equals((Object)newHeadRoom)) {
            this.recalculateReduceSchedule = true;
            if (LOG.isDebugEnabled() && !headRoom.equals((Object)newHeadRoom)) {
                LOG.debug((Object)("headroom=" + newHeadRoom));
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Container cont : newContainers) {
                LOG.debug((Object)("Received new Container :" + cont));
            }
        }
        this.computeIgnoreBlacklisting();
        this.handleUpdatedNodes(response);
        this.handleJobPriorityChange(response);
        for (Container cont : finishedContainers) {
            this.processFinishedContainer((ContainerStatus)cont);
        }
        return newContainers;
    }

    @VisibleForTesting
    void processFinishedContainer(ContainerStatus container) {
        LOG.info((Object)("Received completed container " + container.getContainerId()));
        TaskAttemptId attemptID = this.assignedRequests.get(container.getContainerId());
        if (attemptID == null) {
            LOG.error((Object)("Container complete event for unknown container " + container.getContainerId()));
        } else {
            this.pendingRelease.remove(container.getContainerId());
            this.assignedRequests.remove(attemptID);
            String diagnostic = StringInterner.weakIntern((String)container.getDiagnostics());
            this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnostic));
            this.eventHandler.handle((Event)this.createContainerFinishedEvent(container, attemptID));
        }
    }

    private void applyConcurrentTaskLimits() {
        int numScheduledMaps = this.scheduledRequests.maps.size();
        if (this.maxRunningMaps > 0 && numScheduledMaps > 0) {
            int maxRequestedMaps = Math.max(0, this.maxRunningMaps - this.assignedRequests.maps.size());
            int numScheduledFailMaps = ScheduledRequests.access$300((ScheduledRequests)this.scheduledRequests).size();
            int failedMapRequestLimit = Math.min(maxRequestedMaps, numScheduledFailMaps);
            int normalMapRequestLimit = Math.min(maxRequestedMaps - failedMapRequestLimit, numScheduledMaps - numScheduledFailMaps);
            this.setRequestLimit(PRIORITY_FAST_FAIL_MAP, this.mapResourceRequest, failedMapRequestLimit);
            this.setRequestLimit(PRIORITY_MAP, this.mapResourceRequest, normalMapRequestLimit);
        }
        int numScheduledReduces = this.scheduledRequests.reduces.size();
        if (this.maxRunningReduces > 0 && numScheduledReduces > 0) {
            int maxRequestedReduces = Math.max(0, this.maxRunningReduces - this.assignedRequests.reduces.size());
            int reduceRequestLimit = Math.min(maxRequestedReduces, numScheduledReduces);
            this.setRequestLimit(PRIORITY_REDUCE, this.reduceResourceRequest, reduceRequestLimit);
        }
    }

    private boolean canAssignMaps() {
        return this.maxRunningMaps <= 0 || this.assignedRequests.maps.size() < this.maxRunningMaps;
    }

    private boolean canAssignReduces() {
        return this.maxRunningReduces <= 0 || this.assignedRequests.reduces.size() < this.maxRunningReduces;
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService((Configuration)this.getConfig()));
    }

    @VisibleForTesting
    public TaskAttemptEvent createContainerFinishedEvent(ContainerStatus cont, TaskAttemptId attemptID) {
        if (cont.getExitStatus() == -100 || cont.getExitStatus() == -102) {
            return new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_KILL);
        }
        return new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_CONTAINER_COMPLETED);
    }

    private void handleUpdatedNodes(AllocateResponse response) {
        List updatedNodes = response.getUpdatedNodes();
        if (!updatedNodes.isEmpty()) {
            this.eventHandler.handle((Event)new JobUpdatedNodesEvent(this.getJob().getID(), updatedNodes));
            HashSet<NodeId> unusableNodes = new HashSet<NodeId>();
            for (NodeReport nr : updatedNodes) {
                NodeState nodeState = nr.getNodeState();
                if (!nodeState.isUnusable()) continue;
                unusableNodes.add(nr.getNodeId());
            }
            for (int i = 0; i < 2; ++i) {
                LinkedHashMap taskSet = i == 0 ? this.assignedRequests.maps : this.assignedRequests.reduces;
                for (Map.Entry entry : ((HashMap)taskSet).entrySet()) {
                    TaskAttemptId tid = (TaskAttemptId)entry.getKey();
                    NodeId taskAttemptNodeId = ((Container)entry.getValue()).getNodeId();
                    if (!unusableNodes.contains(taskAttemptNodeId)) continue;
                    LOG.info((Object)("Killing taskAttempt:" + tid + " because it is running on unusable node:" + taskAttemptNodeId));
                    boolean rescheduleNextAttempt = i == 0;
                    this.eventHandler.handle((Event)new TaskAttemptKillEvent(tid, "TaskAttempt killed because it ran on unusable node" + taskAttemptNodeId, rescheduleNextAttempt));
                }
            }
        }
    }

    private void handleJobPriorityChange(AllocateResponse response) {
        Priority priorityFromResponse = Priority.newInstance((int)response.getApplicationPriority().getPriority());
        this.getJob().setJobPriority(priorityFromResponse);
    }

    @InterfaceAudience.Private
    public Resource getResourceLimit() {
        Resource headRoom = this.getAvailableResources();
        Resource assignedMapResource = Resources.multiply((Resource)this.mapResourceRequest, (double)this.assignedRequests.maps.size());
        Resource assignedReduceResource = Resources.multiply((Resource)this.reduceResourceRequest, (double)this.assignedRequests.reduces.size());
        return Resources.add((Resource)headRoom, (Resource)Resources.add((Resource)assignedMapResource, (Resource)assignedReduceResource));
    }

    static /* synthetic */ AtomicBoolean access$100(RMContainerAllocator x0) {
        return x0.stopped;
    }

    static /* synthetic */ String access$400(RMContainerAllocator x0) {
        return x0.mapNodeLabelExpression;
    }

    static /* synthetic */ int access$500(RMContainerAllocator x0) {
        return x0.containersAllocated;
    }

    static /* synthetic */ int access$502(RMContainerAllocator x0, int x1) {
        x0.containersAllocated = x1;
        return x0.containersAllocated;
    }

    static /* synthetic */ Resource access$600(RMContainerAllocator x0) {
        return x0.mapResourceRequest;
    }

    static /* synthetic */ Resource access$700(RMContainerAllocator x0) {
        return x0.reduceResourceRequest;
    }

    static /* synthetic */ AssignedRequests access$800(RMContainerAllocator x0) {
        return x0.assignedRequests;
    }

    static /* synthetic */ int access$908(RMContainerAllocator x0) {
        return x0.containersReleased++;
    }

    static /* synthetic */ boolean access$1000(RMContainerAllocator x0) {
        return x0.canAssignMaps();
    }

    static /* synthetic */ boolean access$1100(RMContainerAllocator x0) {
        return x0.canAssignReduces();
    }

    static /* synthetic */ int access$1208(RMContainerAllocator x0) {
        return x0.hostLocalAssigned++;
    }

    static /* synthetic */ int access$1308(RMContainerAllocator x0) {
        return x0.rackLocalAssigned++;
    }

    static /* synthetic */ LinkedList access$1400(RMContainerAllocator x0) {
        return x0.pendingReduces;
    }

    static /* synthetic */ ScheduledRequests access$1500(RMContainerAllocator x0) {
        return x0.scheduledRequests;
    }

    static /* synthetic */ int access$900(RMContainerAllocator x0) {
        return x0.containersReleased;
    }

    static /* synthetic */ int access$1200(RMContainerAllocator x0) {
        return x0.hostLocalAssigned;
    }

    static /* synthetic */ int access$1300(RMContainerAllocator x0) {
        return x0.rackLocalAssigned;
    }

    static {
        PRIORITY_FAST_FAIL_MAP.setPriority(5);
        PRIORITY_REDUCE = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_REDUCE.setPriority(10);
        PRIORITY_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_MAP.setPriority(20);
    }
}

