/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebServicesAttempts;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesAttempts
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestAMWebServicesAttempts() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testTaskAttempts() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts/").accept(new String[]{"application/json"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                this.verifyAMTaskAttempts(json, task);
            }
        }
    }

    @Test
    public void testTaskAttemptsXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").accept(new String[]{"application/xml"}).get(ClientResponse.class);
                Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                String xml = (String)response.getEntity(String.class);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(xml));
                Document dom = db.parse(is);
                NodeList attempts = dom.getElementsByTagName("taskAttempts");
                Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempts.getLength());
                NodeList nodes = dom.getElementsByTagName("taskAttempt");
                this.verifyAMTaskAttemptsXML(nodes, task);
            }
        }
    }

    @Test
    public void testTaskAttemptId() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).accept(new String[]{"application/json"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid + "/").accept(new String[]{"application/json"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    JSONObject info = json.getJSONObject("taskAttempt");
                    this.verifyAMTaskAttempt(info, att, task.getType());
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).accept(new String[]{"application/xml"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                    String xml = (String)response.getEntity(String.class);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("taskAttempt");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element element = (Element)nodes.item(i);
                        this.verifyAMTaskAttemptXML(element, att, task.getType());
                    }
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdBogus() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("bogusid", "java.lang.Exception: TaskAttemptId string : bogusid is not properly formed");
    }

    @Test
    public void testTaskAttemptIdNonExist() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_m_000000_0", "java.lang.Exception: Error getting info on task attempt id attempt_0_12345_m_000000_0");
    }

    @Test
    public void testTaskAttemptIdInvalid() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_d_000000_0", "java.lang.Exception: Bad TaskType identifier. TaskAttemptId string : attempt_0_12345_d_000000_0 is not properly formed.");
    }

    @Test
    public void testTaskAttemptIdInvalid2() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_12345_m_000000_0", "java.lang.Exception: TaskAttemptId string : attempt_12345_m_000000_0 is not properly formed");
    }

    @Test
    public void testTaskAttemptIdInvalid3() throws JSONException, Exception {
        this.testTaskAttemptIdErrorGeneric("attempt_0_12345_m_000000", "java.lang.Exception: TaskAttemptId string : attempt_0_12345_m_000000 is not properly formed");
    }

    private void testTaskAttemptIdErrorGeneric(String attid, String error) throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                try {
                    r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).accept(new String[]{"application/json"}).get(JSONObject.class);
                    Assert.fail((String)"should have thrown exception on invalid uri");
                }
                catch (UniformInterfaceException ue) {
                    ClientResponse response = ue.getResponse();
                    Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
                    JSONObject exception = msg.getJSONObject("RemoteException");
                    Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                    String message = exception.getString("message");
                    String type = exception.getString("exception");
                    String classname = exception.getString("javaClassName");
                    WebServicesTestUtils.checkStringMatch((String)"exception message", (String)error, (String)message);
                    WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                    WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
                }
            }
        }
    }

    public void verifyAMTaskAttemptXML(Element element, TaskAttempt att, TaskType ttype) {
        this.verifyTaskAttemptGeneric(att, ttype, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"type"), WebServicesTestUtils.getXmlString((Element)element, (String)"rack"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), WebServicesTestUtils.getXmlString((Element)element, (String)"assignedContainerId"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"));
        if (ttype == TaskType.REDUCE) {
            this.verifyReduceTaskAttemptGeneric(att, WebServicesTestUtils.getXmlLong((Element)element, (String)"shuffleFinishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"mergeFinishTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedShuffleTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedMergeTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedReduceTime"));
        }
    }

    public void verifyAMTaskAttempt(JSONObject info, TaskAttempt att, TaskType ttype) throws JSONException {
        if (ttype == TaskType.REDUCE) {
            Assert.assertEquals((String)"incorrect number of elements", (long)17L, (long)info.length());
        } else {
            Assert.assertEquals((String)"incorrect number of elements", (long)12L, (long)info.length());
        }
        this.verifyTaskAttemptGeneric(att, ttype, info.getString("id"), info.getString("state"), info.getString("type"), info.getString("rack"), info.getString("nodeHttpAddress"), info.getString("diagnostics"), info.getString("assignedContainerId"), info.getLong("startTime"), info.getLong("finishTime"), info.getLong("elapsedTime"), (float)info.getDouble("progress"));
        if (ttype == TaskType.REDUCE) {
            this.verifyReduceTaskAttemptGeneric(att, info.getLong("shuffleFinishTime"), info.getLong("mergeFinishTime"), info.getLong("elapsedShuffleTime"), info.getLong("elapsedMergeTime"), info.getLong("elapsedReduceTime"));
        }
    }

    public void verifyAMTaskAttempts(JSONObject json, Task task) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject attempts = json.getJSONObject("taskAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONArray arr = attempts.getJSONArray("taskAttempt");
        for (TaskAttempt att : task.getAttempts().values()) {
            TaskAttemptId id = att.getID();
            String attid = MRApps.toString((TaskAttemptId)id);
            Boolean found = false;
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject info = arr.getJSONObject(i);
                if (!attid.matches(info.getString("id"))) continue;
                found = true;
                this.verifyAMTaskAttempt(info, att, task.getType());
            }
            Assert.assertTrue((String)("task attempt with id: " + attid + " not in web service output"), (boolean)found);
        }
    }

    public void verifyAMTaskAttemptsXML(NodeList nodes, Task task) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (TaskAttempt att : task.getAttempts().values()) {
            TaskAttemptId id = att.getID();
            String attid = MRApps.toString((TaskAttemptId)id);
            Boolean found = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if (!attid.matches(WebServicesTestUtils.getXmlString((Element)element, (String)"id"))) continue;
                found = true;
                this.verifyAMTaskAttemptXML(element, att, task.getType());
            }
            Assert.assertTrue((String)("task with id: " + attid + " not in web service output"), (boolean)found);
        }
    }

    public void verifyTaskAttemptGeneric(TaskAttempt ta, TaskType ttype, String id, String state, String type, String rack, String nodeHttpAddress, String diagnostics, String assignedContainerId, long startTime, long finishTime, long elapsedTime, float progress) {
        TaskAttemptId attid = ta.getID();
        String attemptId = MRApps.toString((TaskAttemptId)attid);
        WebServicesTestUtils.checkStringMatch((String)"id", (String)attemptId, (String)id);
        WebServicesTestUtils.checkStringMatch((String)"type", (String)ttype.toString(), (String)type);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)ta.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"rack", (String)ta.getNodeRackName(), (String)rack);
        WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)ta.getNodeHttpAddress(), (String)nodeHttpAddress);
        String expectDiag = "";
        List diagnosticsList = ta.getDiagnostics();
        if (diagnosticsList != null && !diagnostics.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagnosticsList) {
                b.append(diag);
            }
            expectDiag = b.toString();
        }
        WebServicesTestUtils.checkStringMatch((String)"diagnostics", (String)expectDiag, (String)diagnostics);
        WebServicesTestUtils.checkStringMatch((String)"assignedContainerId", (String)ta.getAssignedContainerID().toString(), (String)assignedContainerId);
        Assert.assertEquals((String)"startTime wrong", (long)ta.getLaunchTime(), (long)startTime);
        Assert.assertEquals((String)"finishTime wrong", (long)ta.getFinishTime(), (long)finishTime);
        Assert.assertEquals((String)"elapsedTime wrong", (long)(finishTime - startTime), (long)elapsedTime);
        Assert.assertEquals((String)"progress wrong", (float)(ta.getProgress() * 100.0f), (float)progress, (float)0.001f);
    }

    public void verifyReduceTaskAttemptGeneric(TaskAttempt ta, long shuffleFinishTime, long mergeFinishTime, long elapsedShuffleTime, long elapsedMergeTime, long elapsedReduceTime) {
        Assert.assertEquals((String)"shuffleFinishTime wrong", (long)ta.getShuffleFinishTime(), (long)shuffleFinishTime);
        Assert.assertEquals((String)"mergeFinishTime wrong", (long)ta.getSortFinishTime(), (long)mergeFinishTime);
        Assert.assertEquals((String)"elapsedShuffleTime wrong", (long)(ta.getShuffleFinishTime() - ta.getLaunchTime()), (long)elapsedShuffleTime);
        Assert.assertEquals((String)"elapsedMergeTime wrong", (long)(ta.getSortFinishTime() - ta.getShuffleFinishTime()), (long)elapsedMergeTime);
        Assert.assertEquals((String)"elapsedReduceTime wrong", (long)(ta.getFinishTime() - ta.getSortFinishTime()), (long)elapsedReduceTime);
    }

    @Test
    public void testTaskAttemptIdCounters() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("counters").accept(new String[]{"application/json"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    JSONObject info = json.getJSONObject("jobTaskAttemptCounters");
                    this.verifyAMJobTaskAttemptCounters(info, att);
                }
            }
        }
    }

    @Test
    public void testTaskAttemptIdXMLCounters() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("counters").accept(new String[]{"application/xml"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                    String xml = (String)response.getEntity(String.class);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptCounters");
                    this.verifyAMTaskCountersXML(nodes, att);
                }
            }
        }
    }

    public void verifyAMJobTaskAttemptCounters(JSONObject info, TaskAttempt att) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskAttemptId)att.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("taskAttemptCounterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assert.assertTrue((String)"name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                long value = counter.getLong("value");
                Assert.assertTrue((String)"value  >= 0", (value >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void verifyAMTaskCountersXML(NodeList nodes, TaskAttempt att) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((TaskAttemptId)att.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("taskAttemptCounterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)counters);
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                    long value = WebServicesTestUtils.getXmlLong((Element)counter, (String)"value");
                    Assert.assertTrue((String)"value not >= 0", (value >= 0L ? 1 : 0) != 0);
                }
            }
        }
    }

    static /* synthetic */ AppContext access$002(AppContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ AppContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static /* synthetic */ Injector access$200(TestAMWebServicesAttempts x0) {
        return x0.injector;
    }
}

