/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

public class SYMLINK3Request
extends RequestWithHandle {
    private final String name;
    private final SetAttr3 symAttr;
    private final String symData;

    public static SYMLINK3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = SYMLINK3Request.readHandle(xdr);
        String name = xdr.readString();
        SetAttr3 symAttr = new SetAttr3();
        symAttr.deserialize(xdr);
        String symData = xdr.readString();
        return new SYMLINK3Request(handle, name, symAttr, symData);
    }

    public SYMLINK3Request(FileHandle handle, String name, SetAttr3 symAttr, String symData) {
        super(handle);
        this.name = name;
        this.symAttr = symAttr;
        this.symData = symData;
    }

    public String getName() {
        return this.name;
    }

    public SetAttr3 getSymAttr() {
        return this.symAttr;
    }

    public String getSymData() {
        return this.symData;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeInt(this.name.getBytes().length);
        xdr.writeFixedOpaque(this.name.getBytes());
        this.symAttr.serialize(xdr);
        xdr.writeInt(this.symData.getBytes().length);
        xdr.writeFixedOpaque(this.symData.getBytes());
    }
}

