/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.tools.rumen.JhCounters;
import org.apache.hadoop.tools.rumen.JobHistoryUtils;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.ParsedTaskAttempt;

public class ParsedTask
extends LoggedTask {
    private static final Log LOG = LogFactory.getLog(ParsedTask.class);
    private String diagnosticInfo;
    private String failedDueToAttempt;
    private Map<String, Long> countersMap = new HashMap<String, Long>();

    ParsedTask() {
    }

    @Override
    public void incorporateCounters(JhCounters counters) {
        Map<String, Long> countersMap = JobHistoryUtils.extractCounters(counters);
        this.putCounters(countersMap);
        super.incorporateCounters(counters);
    }

    public void putCounters(Map<String, Long> counters) {
        this.countersMap = counters;
    }

    public Map<String, Long> obtainCounters() {
        return this.countersMap;
    }

    public void putDiagnosticInfo(String msg) {
        this.diagnosticInfo = msg;
    }

    public String obtainDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    public void putFailedDueToAttemptId(String attempt) {
        this.failedDueToAttempt = attempt;
    }

    public String obtainFailedDueToAttemptId() {
        return this.failedDueToAttempt;
    }

    public List<ParsedTaskAttempt> obtainTaskAttempts() {
        List<LoggedTaskAttempt> attempts = this.getAttempts();
        return this.convertTaskAttempts(attempts);
    }

    List<ParsedTaskAttempt> convertTaskAttempts(List<LoggedTaskAttempt> attempts) {
        ArrayList<ParsedTaskAttempt> result = new ArrayList<ParsedTaskAttempt>();
        for (LoggedTaskAttempt t : attempts) {
            if (t instanceof ParsedTaskAttempt) {
                result.add((ParsedTaskAttempt)t);
                continue;
            }
            throw new RuntimeException("Unexpected type of taskAttempts in the list...");
        }
        return result;
    }

    void dumpParsedTask() {
        LOG.info((Object)("ParsedTask details:" + this.obtainCounters() + "\n" + this.obtainFailedDueToAttemptId() + "\nPreferred Locations are:"));
        List<LoggedLocation> loc = this.getPreferredLocations();
        for (LoggedLocation l : loc) {
            LOG.info((Object)(l.getLayers() + ";" + l.toString()));
        }
        List<ParsedTaskAttempt> attempts = this.obtainTaskAttempts();
        for (ParsedTaskAttempt attempt : attempts) {
            attempt.dumpParsedTaskAttempt();
        }
    }
}

