/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AllocateResponse {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens) {
        return AllocateResponse.newBuilder().numClusterNodes(numClusterNodes).responseId(responseId).completedContainersStatuses(completedContainers).allocatedContainers(allocatedContainers).updatedNodes(updatedNodes).availableResources(availResources).amCommand(command).preemptionMessage(preempt).nmTokens(nmTokens).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, List<UpdatedContainer> updatedContainers) {
        return AllocateResponse.newBuilder().numClusterNodes(numClusterNodes).responseId(responseId).completedContainersStatuses(completedContainers).allocatedContainers(allocatedContainers).updatedNodes(updatedNodes).availableResources(availResources).amCommand(command).preemptionMessage(preempt).nmTokens(nmTokens).updatedContainers(updatedContainers).build();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, Token amRMToken, List<UpdatedContainer> updatedContainers) {
        return AllocateResponse.newBuilder().numClusterNodes(numClusterNodes).responseId(responseId).completedContainersStatuses(completedContainers).allocatedContainers(allocatedContainers).updatedNodes(updatedNodes).availableResources(availResources).amCommand(command).preemptionMessage(preempt).nmTokens(nmTokens).updatedContainers(updatedContainers).amRmToken(amRMToken).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static AllocateResponse newInstance(int responseId, List<ContainerStatus> completedContainers, List<Container> allocatedContainers, List<NodeReport> updatedNodes, Resource availResources, AMCommand command, int numClusterNodes, PreemptionMessage preempt, List<NMToken> nmTokens, Token amRMToken, List<UpdatedContainer> updatedContainers, String collectorAddr) {
        return AllocateResponse.newBuilder().numClusterNodes(numClusterNodes).responseId(responseId).completedContainersStatuses(completedContainers).allocatedContainers(allocatedContainers).updatedNodes(updatedNodes).availableResources(availResources).amCommand(command).preemptionMessage(preempt).nmTokens(nmTokens).updatedContainers(updatedContainers).amRmToken(amRMToken).collectorAddr(collectorAddr).build();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract AMCommand getAMCommand();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAMCommand(AMCommand var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getResponseId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResponseId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<Container> getAllocatedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAllocatedContainers(List<Container> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getAvailableResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAvailableResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<ContainerStatus> getCompletedContainersStatuses();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCompletedContainersStatuses(List<ContainerStatus> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<NodeReport> getUpdatedNodes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUpdatedNodes(List<NodeReport> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumClusterNodes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumClusterNodes(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public abstract PreemptionMessage getPreemptionMessage();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptionMessage(PreemptionMessage var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<NMToken> getNMTokens();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNMTokens(List<NMToken> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<UpdatedContainer> getUpdatedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUpdatedContainers(List<UpdatedContainer> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Token getAMRMToken();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAMRMToken(Token var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Priority getApplicationPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getCollectorAddr();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCollectorAddr(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public List<UpdateContainerError> getUpdateErrors() {
        return new ArrayList<UpdateContainerError>();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setUpdateErrors(List<UpdateContainerError> updateErrors) {
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static AllocateResponseBuilder newBuilder() {
        return new AllocateResponseBuilder();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final class AllocateResponseBuilder {
        private AllocateResponse allocateResponse = Records.newRecord(AllocateResponse.class);

        private AllocateResponseBuilder() {
            this.allocateResponse.setApplicationPriority(Priority.newInstance(0));
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder amCommand(AMCommand amCommand) {
            this.allocateResponse.setAMCommand(amCommand);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder responseId(int responseId) {
            this.allocateResponse.setResponseId(responseId);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder allocatedContainers(List<Container> allocatedContainers) {
            this.allocateResponse.setAllocatedContainers(allocatedContainers);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder availableResources(Resource availableResources) {
            this.allocateResponse.setAvailableResources(availableResources);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder completedContainersStatuses(List<ContainerStatus> completedContainersStatuses) {
            this.allocateResponse.setCompletedContainersStatuses(completedContainersStatuses);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder updatedNodes(List<NodeReport> updatedNodes) {
            this.allocateResponse.setUpdatedNodes(updatedNodes);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder numClusterNodes(int numClusterNodes) {
            this.allocateResponse.setNumClusterNodes(numClusterNodes);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder preemptionMessage(PreemptionMessage preemptionMessage) {
            this.allocateResponse.setPreemptionMessage(preemptionMessage);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder nmTokens(List<NMToken> nmTokens) {
            this.allocateResponse.setNMTokens(nmTokens);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder updatedContainers(List<UpdatedContainer> updatedContainers) {
            this.allocateResponse.setUpdatedContainers(updatedContainers);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder amRmToken(Token amRmToken) {
            this.allocateResponse.setAMRMToken(amRmToken);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder applicationPriority(Priority applicationPriority) {
            this.allocateResponse.setApplicationPriority(applicationPriority);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder collectorAddr(String collectorAddr) {
            this.allocateResponse.setCollectorAddr(collectorAddr);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponseBuilder updateErrors(List<UpdateContainerError> updateErrors) {
            this.allocateResponse.setUpdateErrors(updateErrors);
            return this;
        }

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        public AllocateResponse build() {
            return this.allocateResponse;
        }
    }
}

