/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.HierarchicalTimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationEntity
extends HierarchicalTimelineEntity {
    public static final String QUEUE_INFO_KEY = "SYSTEM_INFO_QUEUE";

    public ApplicationEntity() {
        super(TimelineEntityType.YARN_APPLICATION.toString());
    }

    public ApplicationEntity(TimelineEntity entity) {
        super(entity);
        if (!entity.getType().equals(TimelineEntityType.YARN_APPLICATION.toString())) {
            throw new IllegalArgumentException("Incompatible entity type: " + this.getId());
        }
    }

    public String getQueue() {
        return this.getInfo().get(QUEUE_INFO_KEY).toString();
    }

    public void setQueue(String queue) {
        this.addInfo(QUEUE_INFO_KEY, queue);
    }
}

