/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGetApplicationsRequestPBImpl {
    @Parameterized.Parameter
    public GetApplicationsRequestPBImpl impl;

    @Test
    public void testAppTagsLowerCaseConversionDefault() {
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Test
    public void testAppTagsLowerCaseConversionDisabled() {
        GetApplicationsRequestPBImpl.setForceLowerCaseTags((boolean)false);
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertNotEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Test
    public void testAppTagsLowerCaseConversionEnabled() {
        GetApplicationsRequestPBImpl.setForceLowerCaseTags((boolean)true);
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{new GetApplicationsRequestPBImpl()});
        list.add(new Object[]{new GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto.newBuilder().build())});
        return list;
    }
}

